import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAppEnvironmentStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Storage Account Access Key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#access_key ContainerAppEnvironmentStorage#access_key}
    */
    readonly accessKey: string;
    /**
    * The access mode to connect this storage to the Container App. Possible values include `ReadOnly` and `ReadWrite`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#access_mode ContainerAppEnvironmentStorage#access_mode}
    */
    readonly accessMode: string;
    /**
    * The Azure Storage Account in which the Share to be used is located.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#account_name ContainerAppEnvironmentStorage#account_name}
    */
    readonly accountName: string;
    /**
    * The ID of the Container App Environment to which this storage belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#container_app_environment_id ContainerAppEnvironmentStorage#container_app_environment_id}
    */
    readonly containerAppEnvironmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#id ContainerAppEnvironmentStorage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for this Storage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#name ContainerAppEnvironmentStorage#name}
    */
    readonly name: string;
    /**
    * The name of the Azure Storage Share to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#share_name ContainerAppEnvironmentStorage#share_name}
    */
    readonly shareName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#timeouts ContainerAppEnvironmentStorage#timeouts}
    */
    readonly timeouts?: ContainerAppEnvironmentStorageTimeouts;
}
export interface ContainerAppEnvironmentStorageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#create ContainerAppEnvironmentStorage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#delete ContainerAppEnvironmentStorage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#read ContainerAppEnvironmentStorage#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage#update ContainerAppEnvironmentStorage#update}
    */
    readonly update?: string;
}
export declare function containerAppEnvironmentStorageTimeoutsToTerraform(struct?: ContainerAppEnvironmentStorageTimeoutsOutputReference | ContainerAppEnvironmentStorageTimeouts | cdktf.IResolvable): any;
export declare class ContainerAppEnvironmentStorageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppEnvironmentStorageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppEnvironmentStorageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage azurerm_container_app_environment_storage}
*/
export declare class ContainerAppEnvironmentStorage extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_app_environment_storage";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/container_app_environment_storage azurerm_container_app_environment_storage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAppEnvironmentStorageConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAppEnvironmentStorageConfig);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    get accessModeInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _containerAppEnvironmentId?;
    get containerAppEnvironmentId(): string;
    set containerAppEnvironmentId(value: string);
    get containerAppEnvironmentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ContainerAppEnvironmentStorageTimeoutsOutputReference;
    putTimeouts(value: ContainerAppEnvironmentStorageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAppEnvironmentStorageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
