"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpressRouteCircuitPeering = exports.ExpressRouteCircuitPeeringTimeoutsOutputReference = exports.expressRouteCircuitPeeringTimeoutsToTerraform = exports.ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference = exports.expressRouteCircuitPeeringMicrosoftPeeringConfigToTerraform = exports.ExpressRouteCircuitPeeringIpv6OutputReference = exports.expressRouteCircuitPeeringIpv6ToTerraform = exports.ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference = exports.expressRouteCircuitPeeringIpv6MicrosoftPeeringToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function expressRouteCircuitPeeringIpv6MicrosoftPeeringToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        advertised_communities: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.advertisedCommunities),
        advertised_public_prefixes: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.advertisedPublicPrefixes),
        customer_asn: cdktf.numberToTerraform(struct.customerAsn),
        routing_registry_name: cdktf.stringToTerraform(struct.routingRegistryName),
    };
}
exports.expressRouteCircuitPeeringIpv6MicrosoftPeeringToTerraform = expressRouteCircuitPeeringIpv6MicrosoftPeeringToTerraform;
class ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._advertisedCommunities !== undefined) {
            hasAnyValues = true;
            internalValueResult.advertisedCommunities = this._advertisedCommunities;
        }
        if (this._advertisedPublicPrefixes !== undefined) {
            hasAnyValues = true;
            internalValueResult.advertisedPublicPrefixes = this._advertisedPublicPrefixes;
        }
        if (this._customerAsn !== undefined) {
            hasAnyValues = true;
            internalValueResult.customerAsn = this._customerAsn;
        }
        if (this._routingRegistryName !== undefined) {
            hasAnyValues = true;
            internalValueResult.routingRegistryName = this._routingRegistryName;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._advertisedCommunities = undefined;
            this._advertisedPublicPrefixes = undefined;
            this._customerAsn = undefined;
            this._routingRegistryName = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._advertisedCommunities = value.advertisedCommunities;
            this._advertisedPublicPrefixes = value.advertisedPublicPrefixes;
            this._customerAsn = value.customerAsn;
            this._routingRegistryName = value.routingRegistryName;
        }
    }
    get advertisedCommunities() {
        return this.getListAttribute('advertised_communities');
    }
    set advertisedCommunities(value) {
        this._advertisedCommunities = value;
    }
    resetAdvertisedCommunities() {
        this._advertisedCommunities = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get advertisedCommunitiesInput() {
        return this._advertisedCommunities;
    }
    get advertisedPublicPrefixes() {
        return this.getListAttribute('advertised_public_prefixes');
    }
    set advertisedPublicPrefixes(value) {
        this._advertisedPublicPrefixes = value;
    }
    resetAdvertisedPublicPrefixes() {
        this._advertisedPublicPrefixes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get advertisedPublicPrefixesInput() {
        return this._advertisedPublicPrefixes;
    }
    get customerAsn() {
        return this.getNumberAttribute('customer_asn');
    }
    set customerAsn(value) {
        this._customerAsn = value;
    }
    resetCustomerAsn() {
        this._customerAsn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customerAsnInput() {
        return this._customerAsn;
    }
    get routingRegistryName() {
        return this.getStringAttribute('routing_registry_name');
    }
    set routingRegistryName(value) {
        this._routingRegistryName = value;
    }
    resetRoutingRegistryName() {
        this._routingRegistryName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get routingRegistryNameInput() {
        return this._routingRegistryName;
    }
}
exports.ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference = ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.expressRouteCircuitPeering.ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference", version: "5.0.8" };
function expressRouteCircuitPeeringIpv6ToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enabled: cdktf.booleanToTerraform(struct.enabled),
        primary_peer_address_prefix: cdktf.stringToTerraform(struct.primaryPeerAddressPrefix),
        route_filter_id: cdktf.stringToTerraform(struct.routeFilterId),
        secondary_peer_address_prefix: cdktf.stringToTerraform(struct.secondaryPeerAddressPrefix),
        microsoft_peering: expressRouteCircuitPeeringIpv6MicrosoftPeeringToTerraform(struct.microsoftPeering),
    };
}
exports.expressRouteCircuitPeeringIpv6ToTerraform = expressRouteCircuitPeeringIpv6ToTerraform;
class ExpressRouteCircuitPeeringIpv6OutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // microsoft_peering - computed: false, optional: true, required: false
        this._microsoftPeering = new ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference(this, "microsoft_peering");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._enabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.enabled = this._enabled;
        }
        if (this._primaryPeerAddressPrefix !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryPeerAddressPrefix = this._primaryPeerAddressPrefix;
        }
        if (this._routeFilterId !== undefined) {
            hasAnyValues = true;
            internalValueResult.routeFilterId = this._routeFilterId;
        }
        if (this._secondaryPeerAddressPrefix !== undefined) {
            hasAnyValues = true;
            internalValueResult.secondaryPeerAddressPrefix = this._secondaryPeerAddressPrefix;
        }
        if (this._microsoftPeering?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.microsoftPeering = this._microsoftPeering?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._enabled = undefined;
            this._primaryPeerAddressPrefix = undefined;
            this._routeFilterId = undefined;
            this._secondaryPeerAddressPrefix = undefined;
            this._microsoftPeering.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._enabled = value.enabled;
            this._primaryPeerAddressPrefix = value.primaryPeerAddressPrefix;
            this._routeFilterId = value.routeFilterId;
            this._secondaryPeerAddressPrefix = value.secondaryPeerAddressPrefix;
            this._microsoftPeering.internalValue = value.microsoftPeering;
        }
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get primaryPeerAddressPrefix() {
        return this.getStringAttribute('primary_peer_address_prefix');
    }
    set primaryPeerAddressPrefix(value) {
        this._primaryPeerAddressPrefix = value;
    }
    // Temporarily expose input value. Use with caution.
    get primaryPeerAddressPrefixInput() {
        return this._primaryPeerAddressPrefix;
    }
    get routeFilterId() {
        return this.getStringAttribute('route_filter_id');
    }
    set routeFilterId(value) {
        this._routeFilterId = value;
    }
    resetRouteFilterId() {
        this._routeFilterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get routeFilterIdInput() {
        return this._routeFilterId;
    }
    get secondaryPeerAddressPrefix() {
        return this.getStringAttribute('secondary_peer_address_prefix');
    }
    set secondaryPeerAddressPrefix(value) {
        this._secondaryPeerAddressPrefix = value;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryPeerAddressPrefixInput() {
        return this._secondaryPeerAddressPrefix;
    }
    get microsoftPeering() {
        return this._microsoftPeering;
    }
    putMicrosoftPeering(value) {
        this._microsoftPeering.internalValue = value;
    }
    resetMicrosoftPeering() {
        this._microsoftPeering.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get microsoftPeeringInput() {
        return this._microsoftPeering.internalValue;
    }
}
exports.ExpressRouteCircuitPeeringIpv6OutputReference = ExpressRouteCircuitPeeringIpv6OutputReference;
_b = JSII_RTTI_SYMBOL_1;
ExpressRouteCircuitPeeringIpv6OutputReference[_b] = { fqn: "@cdktf/provider-azurerm.expressRouteCircuitPeering.ExpressRouteCircuitPeeringIpv6OutputReference", version: "5.0.8" };
function expressRouteCircuitPeeringMicrosoftPeeringConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        advertised_communities: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.advertisedCommunities),
        advertised_public_prefixes: cdktf.listMapper(cdktf.stringToTerraform, false)(struct.advertisedPublicPrefixes),
        customer_asn: cdktf.numberToTerraform(struct.customerAsn),
        routing_registry_name: cdktf.stringToTerraform(struct.routingRegistryName),
    };
}
exports.expressRouteCircuitPeeringMicrosoftPeeringConfigToTerraform = expressRouteCircuitPeeringMicrosoftPeeringConfigToTerraform;
class ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._advertisedCommunities !== undefined) {
            hasAnyValues = true;
            internalValueResult.advertisedCommunities = this._advertisedCommunities;
        }
        if (this._advertisedPublicPrefixes !== undefined) {
            hasAnyValues = true;
            internalValueResult.advertisedPublicPrefixes = this._advertisedPublicPrefixes;
        }
        if (this._customerAsn !== undefined) {
            hasAnyValues = true;
            internalValueResult.customerAsn = this._customerAsn;
        }
        if (this._routingRegistryName !== undefined) {
            hasAnyValues = true;
            internalValueResult.routingRegistryName = this._routingRegistryName;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._advertisedCommunities = undefined;
            this._advertisedPublicPrefixes = undefined;
            this._customerAsn = undefined;
            this._routingRegistryName = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._advertisedCommunities = value.advertisedCommunities;
            this._advertisedPublicPrefixes = value.advertisedPublicPrefixes;
            this._customerAsn = value.customerAsn;
            this._routingRegistryName = value.routingRegistryName;
        }
    }
    get advertisedCommunities() {
        return this.getListAttribute('advertised_communities');
    }
    set advertisedCommunities(value) {
        this._advertisedCommunities = value;
    }
    resetAdvertisedCommunities() {
        this._advertisedCommunities = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get advertisedCommunitiesInput() {
        return this._advertisedCommunities;
    }
    get advertisedPublicPrefixes() {
        return this.getListAttribute('advertised_public_prefixes');
    }
    set advertisedPublicPrefixes(value) {
        this._advertisedPublicPrefixes = value;
    }
    // Temporarily expose input value. Use with caution.
    get advertisedPublicPrefixesInput() {
        return this._advertisedPublicPrefixes;
    }
    get customerAsn() {
        return this.getNumberAttribute('customer_asn');
    }
    set customerAsn(value) {
        this._customerAsn = value;
    }
    resetCustomerAsn() {
        this._customerAsn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customerAsnInput() {
        return this._customerAsn;
    }
    get routingRegistryName() {
        return this.getStringAttribute('routing_registry_name');
    }
    set routingRegistryName(value) {
        this._routingRegistryName = value;
    }
    resetRoutingRegistryName() {
        this._routingRegistryName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get routingRegistryNameInput() {
        return this._routingRegistryName;
    }
}
exports.ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference = ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference;
_c = JSII_RTTI_SYMBOL_1;
ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.expressRouteCircuitPeering.ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference", version: "5.0.8" };
function expressRouteCircuitPeeringTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.expressRouteCircuitPeeringTimeoutsToTerraform = expressRouteCircuitPeeringTimeoutsToTerraform;
class ExpressRouteCircuitPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.ExpressRouteCircuitPeeringTimeoutsOutputReference = ExpressRouteCircuitPeeringTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
ExpressRouteCircuitPeeringTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.expressRouteCircuitPeering.ExpressRouteCircuitPeeringTimeoutsOutputReference", version: "5.0.8" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering azurerm_express_route_circuit_peering}
*/
class ExpressRouteCircuitPeering extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering azurerm_express_route_circuit_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExpressRouteCircuitPeeringConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_express_route_circuit_peering',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.46.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // ipv6 - computed: false, optional: true, required: false
        this._ipv6 = new ExpressRouteCircuitPeeringIpv6OutputReference(this, "ipv6");
        // microsoft_peering_config - computed: false, optional: true, required: false
        this._microsoftPeeringConfig = new ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference(this, "microsoft_peering_config");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new ExpressRouteCircuitPeeringTimeoutsOutputReference(this, "timeouts");
        this._expressRouteCircuitName = config.expressRouteCircuitName;
        this._id = config.id;
        this._ipv4Enabled = config.ipv4Enabled;
        this._peerAsn = config.peerAsn;
        this._peeringType = config.peeringType;
        this._primaryPeerAddressPrefix = config.primaryPeerAddressPrefix;
        this._resourceGroupName = config.resourceGroupName;
        this._routeFilterId = config.routeFilterId;
        this._secondaryPeerAddressPrefix = config.secondaryPeerAddressPrefix;
        this._sharedKey = config.sharedKey;
        this._vlanId = config.vlanId;
        this._ipv6.internalValue = config.ipv6;
        this._microsoftPeeringConfig.internalValue = config.microsoftPeeringConfig;
        this._timeouts.internalValue = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // azure_asn - computed: true, optional: false, required: false
    get azureAsn() {
        return this.getNumberAttribute('azure_asn');
    }
    get expressRouteCircuitName() {
        return this.getStringAttribute('express_route_circuit_name');
    }
    set expressRouteCircuitName(value) {
        this._expressRouteCircuitName = value;
    }
    // Temporarily expose input value. Use with caution.
    get expressRouteCircuitNameInput() {
        return this._expressRouteCircuitName;
    }
    // gateway_manager_etag - computed: true, optional: false, required: false
    get gatewayManagerEtag() {
        return this.getStringAttribute('gateway_manager_etag');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ipv4Enabled() {
        return this.getBooleanAttribute('ipv4_enabled');
    }
    set ipv4Enabled(value) {
        this._ipv4Enabled = value;
    }
    resetIpv4Enabled() {
        this._ipv4Enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipv4EnabledInput() {
        return this._ipv4Enabled;
    }
    get peerAsn() {
        return this.getNumberAttribute('peer_asn');
    }
    set peerAsn(value) {
        this._peerAsn = value;
    }
    resetPeerAsn() {
        this._peerAsn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get peerAsnInput() {
        return this._peerAsn;
    }
    get peeringType() {
        return this.getStringAttribute('peering_type');
    }
    set peeringType(value) {
        this._peeringType = value;
    }
    // Temporarily expose input value. Use with caution.
    get peeringTypeInput() {
        return this._peeringType;
    }
    // primary_azure_port - computed: true, optional: false, required: false
    get primaryAzurePort() {
        return this.getStringAttribute('primary_azure_port');
    }
    get primaryPeerAddressPrefix() {
        return this.getStringAttribute('primary_peer_address_prefix');
    }
    set primaryPeerAddressPrefix(value) {
        this._primaryPeerAddressPrefix = value;
    }
    resetPrimaryPeerAddressPrefix() {
        this._primaryPeerAddressPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryPeerAddressPrefixInput() {
        return this._primaryPeerAddressPrefix;
    }
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    get routeFilterId() {
        return this.getStringAttribute('route_filter_id');
    }
    set routeFilterId(value) {
        this._routeFilterId = value;
    }
    resetRouteFilterId() {
        this._routeFilterId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get routeFilterIdInput() {
        return this._routeFilterId;
    }
    // secondary_azure_port - computed: true, optional: false, required: false
    get secondaryAzurePort() {
        return this.getStringAttribute('secondary_azure_port');
    }
    get secondaryPeerAddressPrefix() {
        return this.getStringAttribute('secondary_peer_address_prefix');
    }
    set secondaryPeerAddressPrefix(value) {
        this._secondaryPeerAddressPrefix = value;
    }
    resetSecondaryPeerAddressPrefix() {
        this._secondaryPeerAddressPrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secondaryPeerAddressPrefixInput() {
        return this._secondaryPeerAddressPrefix;
    }
    get sharedKey() {
        return this.getStringAttribute('shared_key');
    }
    set sharedKey(value) {
        this._sharedKey = value;
    }
    resetSharedKey() {
        this._sharedKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedKeyInput() {
        return this._sharedKey;
    }
    get vlanId() {
        return this.getNumberAttribute('vlan_id');
    }
    set vlanId(value) {
        this._vlanId = value;
    }
    // Temporarily expose input value. Use with caution.
    get vlanIdInput() {
        return this._vlanId;
    }
    get ipv6() {
        return this._ipv6;
    }
    putIpv6(value) {
        this._ipv6.internalValue = value;
    }
    resetIpv6() {
        this._ipv6.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipv6Input() {
        return this._ipv6.internalValue;
    }
    get microsoftPeeringConfig() {
        return this._microsoftPeeringConfig;
    }
    putMicrosoftPeeringConfig(value) {
        this._microsoftPeeringConfig.internalValue = value;
    }
    resetMicrosoftPeeringConfig() {
        this._microsoftPeeringConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get microsoftPeeringConfigInput() {
        return this._microsoftPeeringConfig.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            express_route_circuit_name: cdktf.stringToTerraform(this._expressRouteCircuitName),
            id: cdktf.stringToTerraform(this._id),
            ipv4_enabled: cdktf.booleanToTerraform(this._ipv4Enabled),
            peer_asn: cdktf.numberToTerraform(this._peerAsn),
            peering_type: cdktf.stringToTerraform(this._peeringType),
            primary_peer_address_prefix: cdktf.stringToTerraform(this._primaryPeerAddressPrefix),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            route_filter_id: cdktf.stringToTerraform(this._routeFilterId),
            secondary_peer_address_prefix: cdktf.stringToTerraform(this._secondaryPeerAddressPrefix),
            shared_key: cdktf.stringToTerraform(this._sharedKey),
            vlan_id: cdktf.numberToTerraform(this._vlanId),
            ipv6: expressRouteCircuitPeeringIpv6ToTerraform(this._ipv6.internalValue),
            microsoft_peering_config: expressRouteCircuitPeeringMicrosoftPeeringConfigToTerraform(this._microsoftPeeringConfig.internalValue),
            timeouts: expressRouteCircuitPeeringTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.ExpressRouteCircuitPeering = ExpressRouteCircuitPeering;
_e = JSII_RTTI_SYMBOL_1;
ExpressRouteCircuitPeering[_e] = { fqn: "@cdktf/provider-azurerm.expressRouteCircuitPeering.ExpressRouteCircuitPeering", version: "5.0.8" };
// =================
// STATIC PROPERTIES
// =================
ExpressRouteCircuitPeering.tfResourceType = "azurerm_express_route_circuit_peering";
//# sourceMappingURL=data:application/json;base64,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