"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontdoorCustomHttpsConfiguration = exports.FrontdoorCustomHttpsConfigurationTimeoutsOutputReference = exports.frontdoorCustomHttpsConfigurationTimeoutsToTerraform = exports.FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference = exports.frontdoorCustomHttpsConfigurationCustomHttpsConfigurationToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function frontdoorCustomHttpsConfigurationCustomHttpsConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        azure_key_vault_certificate_secret_name: cdktf.stringToTerraform(struct.azureKeyVaultCertificateSecretName),
        azure_key_vault_certificate_secret_version: cdktf.stringToTerraform(struct.azureKeyVaultCertificateSecretVersion),
        azure_key_vault_certificate_vault_id: cdktf.stringToTerraform(struct.azureKeyVaultCertificateVaultId),
        certificate_source: cdktf.stringToTerraform(struct.certificateSource),
    };
}
exports.frontdoorCustomHttpsConfigurationCustomHttpsConfigurationToTerraform = frontdoorCustomHttpsConfigurationCustomHttpsConfigurationToTerraform;
class FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._azureKeyVaultCertificateSecretName !== undefined) {
            hasAnyValues = true;
            internalValueResult.azureKeyVaultCertificateSecretName = this._azureKeyVaultCertificateSecretName;
        }
        if (this._azureKeyVaultCertificateSecretVersion !== undefined) {
            hasAnyValues = true;
            internalValueResult.azureKeyVaultCertificateSecretVersion = this._azureKeyVaultCertificateSecretVersion;
        }
        if (this._azureKeyVaultCertificateVaultId !== undefined) {
            hasAnyValues = true;
            internalValueResult.azureKeyVaultCertificateVaultId = this._azureKeyVaultCertificateVaultId;
        }
        if (this._certificateSource !== undefined) {
            hasAnyValues = true;
            internalValueResult.certificateSource = this._certificateSource;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._azureKeyVaultCertificateSecretName = undefined;
            this._azureKeyVaultCertificateSecretVersion = undefined;
            this._azureKeyVaultCertificateVaultId = undefined;
            this._certificateSource = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._azureKeyVaultCertificateSecretName = value.azureKeyVaultCertificateSecretName;
            this._azureKeyVaultCertificateSecretVersion = value.azureKeyVaultCertificateSecretVersion;
            this._azureKeyVaultCertificateVaultId = value.azureKeyVaultCertificateVaultId;
            this._certificateSource = value.certificateSource;
        }
    }
    get azureKeyVaultCertificateSecretName() {
        return this.getStringAttribute('azure_key_vault_certificate_secret_name');
    }
    set azureKeyVaultCertificateSecretName(value) {
        this._azureKeyVaultCertificateSecretName = value;
    }
    resetAzureKeyVaultCertificateSecretName() {
        this._azureKeyVaultCertificateSecretName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureKeyVaultCertificateSecretNameInput() {
        return this._azureKeyVaultCertificateSecretName;
    }
    get azureKeyVaultCertificateSecretVersion() {
        return this.getStringAttribute('azure_key_vault_certificate_secret_version');
    }
    set azureKeyVaultCertificateSecretVersion(value) {
        this._azureKeyVaultCertificateSecretVersion = value;
    }
    resetAzureKeyVaultCertificateSecretVersion() {
        this._azureKeyVaultCertificateSecretVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureKeyVaultCertificateSecretVersionInput() {
        return this._azureKeyVaultCertificateSecretVersion;
    }
    get azureKeyVaultCertificateVaultId() {
        return this.getStringAttribute('azure_key_vault_certificate_vault_id');
    }
    set azureKeyVaultCertificateVaultId(value) {
        this._azureKeyVaultCertificateVaultId = value;
    }
    resetAzureKeyVaultCertificateVaultId() {
        this._azureKeyVaultCertificateVaultId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get azureKeyVaultCertificateVaultIdInput() {
        return this._azureKeyVaultCertificateVaultId;
    }
    get certificateSource() {
        return this.getStringAttribute('certificate_source');
    }
    set certificateSource(value) {
        this._certificateSource = value;
    }
    resetCertificateSource() {
        this._certificateSource = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certificateSourceInput() {
        return this._certificateSource;
    }
    // minimum_tls_version - computed: true, optional: false, required: false
    get minimumTlsVersion() {
        return this.getStringAttribute('minimum_tls_version');
    }
    // provisioning_state - computed: true, optional: false, required: false
    get provisioningState() {
        return this.getStringAttribute('provisioning_state');
    }
    // provisioning_substate - computed: true, optional: false, required: false
    get provisioningSubstate() {
        return this.getStringAttribute('provisioning_substate');
    }
}
exports.FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference = FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference;
_a = JSII_RTTI_SYMBOL_1;
FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.frontdoorCustomHttpsConfiguration.FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference", version: "5.0.8" };
function frontdoorCustomHttpsConfigurationTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.frontdoorCustomHttpsConfigurationTimeoutsToTerraform = frontdoorCustomHttpsConfigurationTimeoutsToTerraform;
class FrontdoorCustomHttpsConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.FrontdoorCustomHttpsConfigurationTimeoutsOutputReference = FrontdoorCustomHttpsConfigurationTimeoutsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
FrontdoorCustomHttpsConfigurationTimeoutsOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.frontdoorCustomHttpsConfiguration.FrontdoorCustomHttpsConfigurationTimeoutsOutputReference", version: "5.0.8" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration azurerm_frontdoor_custom_https_configuration}
*/
class FrontdoorCustomHttpsConfiguration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_custom_https_configuration azurerm_frontdoor_custom_https_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FrontdoorCustomHttpsConfigurationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_frontdoor_custom_https_configuration',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.46.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // custom_https_configuration - computed: false, optional: true, required: false
        this._customHttpsConfiguration = new FrontdoorCustomHttpsConfigurationCustomHttpsConfigurationOutputReference(this, "custom_https_configuration");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new FrontdoorCustomHttpsConfigurationTimeoutsOutputReference(this, "timeouts");
        this._customHttpsProvisioningEnabled = config.customHttpsProvisioningEnabled;
        this._frontendEndpointId = config.frontendEndpointId;
        this._id = config.id;
        this._customHttpsConfiguration.internalValue = config.customHttpsConfiguration;
        this._timeouts.internalValue = config.timeouts;
    }
    get customHttpsProvisioningEnabled() {
        return this.getBooleanAttribute('custom_https_provisioning_enabled');
    }
    set customHttpsProvisioningEnabled(value) {
        this._customHttpsProvisioningEnabled = value;
    }
    // Temporarily expose input value. Use with caution.
    get customHttpsProvisioningEnabledInput() {
        return this._customHttpsProvisioningEnabled;
    }
    get frontendEndpointId() {
        return this.getStringAttribute('frontend_endpoint_id');
    }
    set frontendEndpointId(value) {
        this._frontendEndpointId = value;
    }
    // Temporarily expose input value. Use with caution.
    get frontendEndpointIdInput() {
        return this._frontendEndpointId;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get customHttpsConfiguration() {
        return this._customHttpsConfiguration;
    }
    putCustomHttpsConfiguration(value) {
        this._customHttpsConfiguration.internalValue = value;
    }
    resetCustomHttpsConfiguration() {
        this._customHttpsConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customHttpsConfigurationInput() {
        return this._customHttpsConfiguration.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_https_provisioning_enabled: cdktf.booleanToTerraform(this._customHttpsProvisioningEnabled),
            frontend_endpoint_id: cdktf.stringToTerraform(this._frontendEndpointId),
            id: cdktf.stringToTerraform(this._id),
            custom_https_configuration: frontdoorCustomHttpsConfigurationCustomHttpsConfigurationToTerraform(this._customHttpsConfiguration.internalValue),
            timeouts: frontdoorCustomHttpsConfigurationTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.FrontdoorCustomHttpsConfiguration = FrontdoorCustomHttpsConfiguration;
_c = JSII_RTTI_SYMBOL_1;
FrontdoorCustomHttpsConfiguration[_c] = { fqn: "@cdktf/provider-azurerm.frontdoorCustomHttpsConfiguration.FrontdoorCustomHttpsConfiguration", version: "5.0.8" };
// =================
// STATIC PROPERTIES
// =================
FrontdoorCustomHttpsConfiguration.tfResourceType = "azurerm_frontdoor_custom_https_configuration";
//# sourceMappingURL=data:application/json;base64,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