# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from kalshi_python_sync.models.percentile_point import PercentilePoint
from typing import Optional, Set
from typing_extensions import Self

class ForecastPercentilesPoint(BaseModel):
    """
    ForecastPercentilesPoint
    """ # noqa: E501
    event_ticker: StrictStr = Field(description="The event ticker this forecast is for.")
    end_period_ts: StrictInt = Field(description="Unix timestamp for the inclusive end of the forecast period.")
    period_interval: StrictInt = Field(description="Length of the forecast period in minutes.")
    percentile_points: List[PercentilePoint] = Field(description="Array of forecast values at different percentiles.")
    __properties: ClassVar[List[str]] = ["event_ticker", "end_period_ts", "period_interval", "percentile_points"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ForecastPercentilesPoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in percentile_points (list)
        _items = []
        if self.percentile_points:
            for _item_percentile_points in self.percentile_points:
                if _item_percentile_points:
                    _items.append(_item_percentile_points.to_dict())
            _dict['percentile_points'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ForecastPercentilesPoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "event_ticker": obj.get("event_ticker"),
            "end_period_ts": obj.get("end_period_ts"),
            "period_interval": obj.get("period_interval"),
            "percentile_points": [PercentilePoint.from_dict(_item) for _item in obj["percentile_points"]] if obj.get("percentile_points") is not None else None
        })
        return _obj


