# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class IncentiveProgram(BaseModel):
    """
    IncentiveProgram
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the incentive program")
    market_ticker: StrictStr = Field(description="The ticker symbol of the market associated with this incentive program")
    incentive_type: StrictStr = Field(description="Type of incentive program")
    start_date: datetime = Field(description="Start date of the incentive program")
    end_date: datetime = Field(description="End date of the incentive program")
    period_reward: StrictInt = Field(description="Total reward for the period in centi-cents")
    paid_out: StrictBool = Field(description="Whether the incentive has been paid out")
    discount_factor_bps: Optional[StrictInt] = Field(default=None, description="Discount factor in basis points (optional)")
    target_size: Optional[StrictInt] = Field(default=None, description="Target size for the incentive program (optional)")
    __properties: ClassVar[List[str]] = ["id", "market_ticker", "incentive_type", "start_date", "end_date", "period_reward", "paid_out", "discount_factor_bps", "target_size"]

    @field_validator('incentive_type')
    def incentive_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['liquidity', 'volume']):
            raise ValueError("must be one of enum values ('liquidity', 'volume')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IncentiveProgram from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if discount_factor_bps (nullable) is None
        # and model_fields_set contains the field
        if self.discount_factor_bps is None and "discount_factor_bps" in self.model_fields_set:
            _dict['discount_factor_bps'] = None

        # set to None if target_size (nullable) is None
        # and model_fields_set contains the field
        if self.target_size is None and "target_size" in self.model_fields_set:
            _dict['target_size'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IncentiveProgram from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "market_ticker": obj.get("market_ticker"),
            "incentive_type": obj.get("incentive_type"),
            "start_date": obj.get("start_date"),
            "end_date": obj.get("end_date"),
            "period_reward": obj.get("period_reward"),
            "paid_out": obj.get("paid_out"),
            "discount_factor_bps": obj.get("discount_factor_bps"),
            "target_size": obj.get("target_size")
        })
        return _obj


