"""
    StreetAccount News API

    The StreetAccount News API provides access to FactSet's proprietary news provider, StreetAccount. StreetAccount, is a premium real-time market intelligence news service that delivers comprehensive U.S., Canadian, and European coverage (and expanding Asia coverage). All possible sources for corporate news are scanned and key story facts are highlighted and presented in an easy-to-read format.  **StreetAccount Filters, Headlines, and Views:**  These endpoints allow for the retrieval of news headlines using filters such as Watchlists/Indices/Tickers, Company Filters, Market Topics, Regions, and Sectors.  Headlines can also be retrieved based on saved views within the Workstation.  **StreetAccount Historical Stories:**  These endpoints provide access to historical StreetAccount (SA) news. The API delivers SA stories in XML format based on user-specified date input parameters. Output files are securely available to users through a URL. This API has three endpoints: Request Files, Check Status, and Get Files.  Please note that this API only supports adhoc requests for historical files and does not support real-time files. If real-time push is required, consider using other methods such as SFTP, QNT account, or Azure Storage. Both historical and real-time Street Account news can be delivered via SFTP, QNT account, or Azure Storage.  The files delivered contain both metadata and content body, eliminating the need for multiple requests through multiple services to retrieve all the information.  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.StreetAccountNews.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.StreetAccountNews.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.StreetAccountNews.exceptions import ApiException
from fds.sdk.StreetAccountNews.model.checkstatus_response import CheckstatusResponse
from fds.sdk.StreetAccountNews.model.getfiles_response import GetfilesResponse
from fds.sdk.StreetAccountNews.model.requestfiles_response import RequestfilesResponse
from fds.sdk.StreetAccountNews.model.street_account_status import StreetAccountStatus





class StreetAccountHistoricalStoriesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.streetaccount_historical_check_status_get_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (CheckstatusResponse,), 400: (StreetAccountStatus,), 401: (StreetAccountStatus,), 403: (StreetAccountStatus,), 500: (StreetAccountStatus,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/streetaccount/historical/check-status',
                'operation_id': 'streetaccount_historical_check_status_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (str,),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'job_id': 'jobID',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'job_id': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.streetaccount_historical_get_files_get_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (GetfilesResponse,), 400: (StreetAccountStatus,), 401: (StreetAccountStatus,), 403: (StreetAccountStatus,), 500: (StreetAccountStatus,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/streetaccount/historical/get-files',
                'operation_id': 'streetaccount_historical_get_files_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'job_id',
                    'pagination_limit',
                    'pagination_offset',
                ],
                'required': [
                    'job_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'job_id':
                        (str,),
                    'pagination_limit':
                        (int,),
                    'pagination_offset':
                        (int,),
                },
                'attribute_map': {
                    'job_id': 'jobID',
                    'pagination_limit': '_paginationLimit',
                    'pagination_offset': '_paginationOffset',
                },
                'location_map': {
                    'job_id': 'query',
                    'pagination_limit': 'query',
                    'pagination_offset': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.streetaccount_historical_request_files_get_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (RequestfilesResponse,), 400: (StreetAccountStatus,), 401: (StreetAccountStatus,), 403: (StreetAccountStatus,), 500: (StreetAccountStatus,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/streetaccount/historical/request-files',
                'operation_id': 'streetaccount_historical_request_files_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                },
                'attribute_map': {
                    'start_date': 'startDate',
                    'end_date': 'endDate',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def streetaccount_historical_check_status_get(
        self,
        job_id,
        **kwargs
    ) -> CheckstatusResponse:
        """Returns the status and percentage of completion for the requested jobID  # noqa: E501

        Need to plug-in the jobID from /request-files into /check-status endpoint  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            job_id (str): jobID returned by the request-files endpoint to know the status and percentDone

        Keyword Args:
            pagination_limit (int): Specifies the maximum number of results to return per result. [optional]
            pagination_offset (int): Specifies the starting point for pagination. This parameter is used to identify the   beginning of next set of results. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            CheckstatusResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['job_id'] = \
            job_id
        return self.streetaccount_historical_check_status_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_check_status_get_with_http_info(
        self,
        job_id,
        **kwargs
    ) -> typing.Tuple[CheckstatusResponse, int, typing.MutableMapping]:
        """Returns the status and percentage of completion for the requested jobID  # noqa: E501

        Need to plug-in the jobID from /request-files into /check-status endpoint  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            job_id (str): jobID returned by the request-files endpoint to know the status and percentDone

        Keyword Args:
            pagination_limit (int): Specifies the maximum number of results to return per result. [optional]
            pagination_offset (int): Specifies the starting point for pagination. This parameter is used to identify the   beginning of next set of results. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            CheckstatusResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['job_id'] = \
            job_id
        return self.streetaccount_historical_check_status_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_check_status_get_async(
        self,
        job_id,
        **kwargs
    ) -> "ApplyResult[CheckstatusResponse]":
        """Returns the status and percentage of completion for the requested jobID  # noqa: E501

        Need to plug-in the jobID from /request-files into /check-status endpoint  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            job_id (str): jobID returned by the request-files endpoint to know the status and percentDone

        Keyword Args:
            pagination_limit (int): Specifies the maximum number of results to return per result. [optional]
            pagination_offset (int): Specifies the starting point for pagination. This parameter is used to identify the   beginning of next set of results. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[CheckstatusResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['job_id'] = \
            job_id
        return self.streetaccount_historical_check_status_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_check_status_get_with_http_info_async(
        self,
        job_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[CheckstatusResponse, int, typing.MutableMapping]]":
        """Returns the status and percentage of completion for the requested jobID  # noqa: E501

        Need to plug-in the jobID from /request-files into /check-status endpoint  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            job_id (str): jobID returned by the request-files endpoint to know the status and percentDone

        Keyword Args:
            pagination_limit (int): Specifies the maximum number of results to return per result. [optional]
            pagination_offset (int): Specifies the starting point for pagination. This parameter is used to identify the   beginning of next set of results. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(CheckstatusResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['job_id'] = \
            job_id
        return self.streetaccount_historical_check_status_get_endpoint.call_with_http_info(**kwargs)


    def streetaccount_historical_get_files_get(
        self,
        job_id,
        **kwargs
    ) -> GetfilesResponse:
        """Returns the StreetAccount XML files for the specified date range  # noqa: E501

        Need to plug-in the jobID from /check-status into /get-files endpoint  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            job_id (str): jobID returned by the request-files endpoint to collect the results of the query

        Keyword Args:
            pagination_limit (int): Specifies the maximum number of results to return per result. [optional]
            pagination_offset (int): Specifies the starting point for pagination. This parameter is used to identify the   beginning of next set of results. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            GetfilesResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['job_id'] = \
            job_id
        return self.streetaccount_historical_get_files_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_get_files_get_with_http_info(
        self,
        job_id,
        **kwargs
    ) -> typing.Tuple[GetfilesResponse, int, typing.MutableMapping]:
        """Returns the StreetAccount XML files for the specified date range  # noqa: E501

        Need to plug-in the jobID from /check-status into /get-files endpoint  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            job_id (str): jobID returned by the request-files endpoint to collect the results of the query

        Keyword Args:
            pagination_limit (int): Specifies the maximum number of results to return per result. [optional]
            pagination_offset (int): Specifies the starting point for pagination. This parameter is used to identify the   beginning of next set of results. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            GetfilesResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['job_id'] = \
            job_id
        return self.streetaccount_historical_get_files_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_get_files_get_async(
        self,
        job_id,
        **kwargs
    ) -> "ApplyResult[GetfilesResponse]":
        """Returns the StreetAccount XML files for the specified date range  # noqa: E501

        Need to plug-in the jobID from /check-status into /get-files endpoint  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            job_id (str): jobID returned by the request-files endpoint to collect the results of the query

        Keyword Args:
            pagination_limit (int): Specifies the maximum number of results to return per result. [optional]
            pagination_offset (int): Specifies the starting point for pagination. This parameter is used to identify the   beginning of next set of results. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[GetfilesResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['job_id'] = \
            job_id
        return self.streetaccount_historical_get_files_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_get_files_get_with_http_info_async(
        self,
        job_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[GetfilesResponse, int, typing.MutableMapping]]":
        """Returns the StreetAccount XML files for the specified date range  # noqa: E501

        Need to plug-in the jobID from /check-status into /get-files endpoint  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            job_id (str): jobID returned by the request-files endpoint to collect the results of the query

        Keyword Args:
            pagination_limit (int): Specifies the maximum number of results to return per result. [optional]
            pagination_offset (int): Specifies the starting point for pagination. This parameter is used to identify the   beginning of next set of results. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(GetfilesResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['job_id'] = \
            job_id
        return self.streetaccount_historical_get_files_get_endpoint.call_with_http_info(**kwargs)


    def streetaccount_historical_request_files_get(
        self,
        start_date,
        end_date,
        **kwargs
    ) -> RequestfilesResponse:
        """Returns the jobID  # noqa: E501

        Give the startDate and endDate parameters as request parameters in the /request-files endpoint, it returns the jobID. startDate and endDate should be in YYYY-MM-DDTHH:MM:SSZ format. This API only supports adhoc requests to retrieve historical files and does not support real-time files and if you interested in require real-time push should consider the other three methods (pushed via SFTP, to QNT account, or your Azure Storage). Per API request able to query till 2 years of data  # noqa: E501
        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            start_date (datetime): Date from which data is required. Should be YYYY-MM-DDTHH:MM:SSZ format
            end_date (datetime): The date until which the data is to be fetched. Should be YYYY-MM-DDTHH:MM:SSZ format

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            RequestfilesResponse
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.streetaccount_historical_request_files_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_request_files_get_with_http_info(
        self,
        start_date,
        end_date,
        **kwargs
    ) -> typing.Tuple[RequestfilesResponse, int, typing.MutableMapping]:
        """Returns the jobID  # noqa: E501

        Give the startDate and endDate parameters as request parameters in the /request-files endpoint, it returns the jobID. startDate and endDate should be in YYYY-MM-DDTHH:MM:SSZ format. This API only supports adhoc requests to retrieve historical files and does not support real-time files and if you interested in require real-time push should consider the other three methods (pushed via SFTP, to QNT account, or your Azure Storage). Per API request able to query till 2 years of data  # noqa: E501
        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            start_date (datetime): Date from which data is required. Should be YYYY-MM-DDTHH:MM:SSZ format
            end_date (datetime): The date until which the data is to be fetched. Should be YYYY-MM-DDTHH:MM:SSZ format

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            RequestfilesResponse
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.streetaccount_historical_request_files_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_request_files_get_async(
        self,
        start_date,
        end_date,
        **kwargs
    ) -> "ApplyResult[RequestfilesResponse]":
        """Returns the jobID  # noqa: E501

        Give the startDate and endDate parameters as request parameters in the /request-files endpoint, it returns the jobID. startDate and endDate should be in YYYY-MM-DDTHH:MM:SSZ format. This API only supports adhoc requests to retrieve historical files and does not support real-time files and if you interested in require real-time push should consider the other three methods (pushed via SFTP, to QNT account, or your Azure Storage). Per API request able to query till 2 years of data  # noqa: E501
        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            start_date (datetime): Date from which data is required. Should be YYYY-MM-DDTHH:MM:SSZ format
            end_date (datetime): The date until which the data is to be fetched. Should be YYYY-MM-DDTHH:MM:SSZ format

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[RequestfilesResponse]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.streetaccount_historical_request_files_get_endpoint.call_with_http_info(**kwargs)

    def streetaccount_historical_request_files_get_with_http_info_async(
        self,
        start_date,
        end_date,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[RequestfilesResponse, int, typing.MutableMapping]]":
        """Returns the jobID  # noqa: E501

        Give the startDate and endDate parameters as request parameters in the /request-files endpoint, it returns the jobID. startDate and endDate should be in YYYY-MM-DDTHH:MM:SSZ format. This API only supports adhoc requests to retrieve historical files and does not support real-time files and if you interested in require real-time push should consider the other three methods (pushed via SFTP, to QNT account, or your Azure Storage). Per API request able to query till 2 years of data  # noqa: E501
        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            start_date (datetime): Date from which data is required. Should be YYYY-MM-DDTHH:MM:SSZ format
            end_date (datetime): The date until which the data is to be fetched. Should be YYYY-MM-DDTHH:MM:SSZ format

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(RequestfilesResponse, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.streetaccount_historical_request_files_get_endpoint.call_with_http_info(**kwargs)


