from sqlalchemy import (
    Column, Integer, BigInteger, Boolean, DateTime, Time, String, JSON,
    Text, Identity, SmallInteger, VARCHAR, ForeignKey, Numeric, NVARCHAR
)
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.sql import func

Base = declarative_base()


class MstBrands(Base):
    __tablename__ = 'mstBrands'

    BrandID = Column(Integer, primary_key=True, autoincrement=True)
    CategoryID = Column(Integer, nullable=False)
    OldBrandID = Column(Integer)
    OldCategoryID = Column(Integer)
    BrandName = Column(String(50), nullable=False)
    BrandFriendlyName = Column(String(150), nullable=False)
    FBPageID = Column(BigInteger)
    FBAccessToken = Column(String)
    TwitterSearch = Column(String)
    Settings = Column(String)
    IsBrandActive = Column(Boolean)
    IsSentimentsNotification = Column(Boolean)
    EscalationSettings = Column(String)
    BrandGroup = Column(String(150))
    ClockInTime = Column(Time)
    ClockOutTime = Column(Time)
    IsSundayHoliday = Column(Boolean)
    IsSaturdayHoliday = Column(Boolean)
    AutoSentimentSettings = Column(String)
    InfluencerSettings = Column(String)
    SMSAPI = Column(String(1000))
    TwitterSearchJson = Column(String)
    RImageURL = Column(String(500))
    RSmallImageURL = Column(String(500))
    Color = Column(String(50))
    BrandSmallFriendlyName = Column(String(500))
    countryfipscode = Column(String(5))
    ZoomInfo = Column(String(50))
    CategoryGroupID = Column(BigInteger)
    Overduetime = Column(Integer)
    AutoQueuingEnabled = Column(Boolean)
    MaxAssignmentLimit = Column(BigInteger)
    LogicalGroup = Column(String(150))
    ServerID = Column(BigInteger)
    FeedbackIcon = Column(String(500))
    IsScheduleWorkflowEnabled = Column(Boolean, default=0)
    IsFeedbackEnabled = Column(Boolean)
    BrandCreatedDate = Column(DateTime, server_default=func.utc_timestamp())
    CSDClockInTime = Column(Time)
    CSDClockOutTime = Column(Time)
    IsBrandworkFlowEnabled = Column(Boolean)
    IsCSDApprove = Column(Boolean)
    IsCSDReject = Column(Boolean)
    isUGCSettingEnabled = Column(Boolean)
    UGCSettingBrandIcon = Column(String(1000))
    CSDTimeOffSet = Column(Integer)
    AgentTimeOffSet = Column(Integer)
    CSDTimeOffSetText = Column(String(100))
    AgentTimeOffSetText = Column(String(100))
    IsAutoReplyEnabled = Column(Boolean, default=0)
    IsFoulKeywordEnabled = Column(Boolean, default=0)
    IsAutoSuggestionEnabled = Column(Boolean)
    IsEscalationMailSettingEnable = Column(Boolean)
    IsPriorityEnabled = Column(Boolean, default=0)
    IsActionableMailEnable = Column(Boolean, default=0)
    IsLogoDetectionEnable = Column(Boolean)
    MailForwardForEmail = Column(String(100))
    UserNameForEmail = Column(String(100))
    FLRBreachTime = Column(BigInteger, default=15)
    TATBreachTime = Column(BigInteger, default=240)
    IsBrandPostAlertEnable = Column(Boolean, default=0)
    IsMaskingEmailEnabled = Column(Boolean, default=0)
    IsMaskingPhoneNumberEnabled = Column(Boolean, default=0)
    IsShortenUrlEnabled = Column(Boolean)
    IsScheduleReplyEnabled = Column(Boolean)
    ScheduleReplyTimeInMinute = Column(BigInteger)
    TimeOfset = Column(Integer)
    TimeOffSetText = Column(String(200))
    IsFeedbackUrlEnabled = Column(Boolean)
    FeedbackUrlExpireInMinute = Column(BigInteger)
    FLRTATJson = Column(JSON,
                        default='{"BreachTime":{"Hours":0,"Minutes":15,"TotalMinutes":15},"lstChannelBreach":null,"lstPriority":null,"Influencer":{"Hours":0,"Minutes":0,"TotalMinutes":0}}')
    TicketTATJson = Column(JSON,
                           default='{"BreachTime":{"Hours":4,"Minutes":0,"TotalMinutes":240},"lstChannelBreach":null,"lstPriority":null,"Influencer":{"Hours":0,"Minutes":0,"TotalMinutes":0}}')
    FLRTime = Column(BigInteger, default=15)
    TicketResolutionTime = Column(BigInteger, default=240)
    SelfQueuingEnabled = Column(Boolean, default=0)
    ManualQueuingEnabled = Column(Boolean, default=0)
    BotEnableJson = Column(String(2000))
    ChatBotGUID = Column(String(50))
    AutoSuggestionChannels = Column(String(200))
    IsNoTickets = Column(Boolean, default=0)
    SkillbasedroutingStatus = Column(Integer)
    SLAFLRBreachTime = Column(BigInteger)
    isSLAFLRBreachEnable = Column(Boolean, default=0)
    IsEnableReplyApprovalWorkFlow = Column(Boolean, default=0)
    IsMakerCheckerFKEnabled = Column(Boolean)
    SLACounterStartInSecond = Column(BigInteger, default=180)
    TypeOfShowTimeInSecond = Column(Integer, default=0)
    IsEnableShowTimeInSecond = Column(Boolean, default=0)
    isSendForApprovalSchedulePost = Column(Boolean)
    ReqUsersApprovalforSchedulePost = Column(String)
    ChatLayout = Column(Integer)
    LayoutTheme = Column(Integer)
    TATBreachSettingsUpdatedOn = Column(DateTime)


class MstCategoriesMetadataInfo(Base):
    __tablename__ = 'mstCategories_MetadataInfo'

    # Define columns as per the existing SQL schema
    CategoryID = Column(BigInteger, primary_key=True)
    TotalUserLimit = Column(BigInteger, default=0)
    TotalUserCreated = Column(BigInteger, default=0)
    SocialMediaProfileLimit = Column(BigInteger, default=0)
    SocialMediaProfileLimitUsed = Column(BigInteger, default=0)
    TotalBrands = Column(BigInteger, default=0)
    TotalbrandsUsed = Column(BigInteger, default=0)
    TotalMention = Column(BigInteger, default=0)
    TotalMentionUsed = Column(BigInteger, default=0)
    TotalGMBLocation = Column(BigInteger, default=0)
    TotalGMBLocationUsed = Column(BigInteger, default=0)
    CreatedDate = Column(DateTime, nullable=False)
    CreatedBy = Column(BigInteger, nullable=False)
    UpdatedDate = Column(DateTime)
    UpdatedBy = Column(BigInteger)
    CommandCenterLimit = Column(Integer)
    ImageRecognitionLimit = Column(Integer)
    CommandCenterLimitUsed = Column(BigInteger)
    ImageRecognitionLimitUsed = Column(BigInteger)
    FBLocationLimit = Column(BigInteger)
    FBLocationLimitUsed = Column(BigInteger)
    UrlLinkLimit = Column(Integer, default=0)
    UrlLinkLimitUsed = Column(Integer, default=0)
    TotalKeyWordLimit = Column(Integer)
    TotalKeyWordLimitUsed = Column(Integer)
    PlanType = Column(String(10))
    PrimaryBrandIDs = Column(String(500))
    IsBrandRelated = Column(Boolean)
    EmailIdsForAlert = Column(String(1000))
    isDataLimitReached = Column(Boolean)
    AgreementStartDate = Column(DateTime)
    AgreementEndDate = Column(DateTime)
    DataLimitReachedDate = Column(DateTime)
    timeoffset = Column(Integer)
    LBContactDetail = Column(Text)
    ClientContactDetail = Column(Text)
    IsBulkReply = Column(Boolean)
    ClientDailyAlertContacts = Column(Text)
    FirstAlertTime = Column(Time)
    LastAlertTime = Column(Time)
    IsActiveDataLimitAlert = Column(Boolean, default=0)
    IsEnable2FAuthentication = Column(Boolean, default=0)
    TypeOf2FAuthentication = Column(Integer)
    IsRealTimeBulkDataProcess = Column(Boolean, default=0)
    AssignmentAffinity = Column(Integer, default=0)
    isScheduledBreakApplicable = Column(Boolean, default=0)
    isScheduledBreakEnabled = Column(Boolean, default=0)
    IsMobileAPPEnable = Column(Boolean)
    IsAWAAuthenticationEnable = Column(Boolean)
    AWSMentionLimit = Column(BigInteger)
    ChatLayot = Column(BigInteger)
    ChatSequenceJson = Column(Text)
    IsPremiumKeywordConfigurationEnabled = Column(Boolean)
    PremiumKeywordConfigurationLimit = Column(BigInteger)
    PremiumKeywordConfigurationLimitConsumed = Column(BigInteger)
    PremiumKeywordConfigurationEnabledDate = Column(DateTime)
    PremiumKeywordConfigurationEnabledBy = Column(BigInteger)
    IsTicketDispositionFeatureEnabled = Column(Boolean)
    TicketDispositionFeatureEnabledBy = Column(BigInteger)
    TicketDispositionFeatureEnabledDate = Column(DateTime)
    IsAISuggestedFeatureEnabled = Column(Boolean)
    AISuggestedFeatureEnabledDate = Column(DateTime)
    AISuggestedFeatureEnabledBy = Column(BigInteger)
    IsRephraseFeatureEnabled = Column(Boolean)
    RephraseFeatureEnabledDate = Column(DateTime)
    RephraseFeatureEnabledBy = Column(BigInteger)
    IsTranslateFeatureEnabled = Column(Boolean)
    TranslateFeatureEnabledDate = Column(DateTime)
    TranslateFeatureEnabledBy = Column(BigInteger)
    IsInsightsFeatureEnabled = Column(Boolean)
    InsightsFeatureEnabledDate = Column(DateTime)
    InsightsFeatureEnabledBy = Column(BigInteger)
    AISuggestedFeatureDisabledDate = Column(DateTime)
    RephraseFeatureDisabledDate = Column(DateTime)
    TranslateFeatureDisabledDate = Column(DateTime)
    InsightsFeatureDisabledDate = Column(DateTime)
    AISuggestedFeatureDisabledBy = Column(BigInteger)
    RephraseFeatureDisabledBy = Column(BigInteger)
    TranslateFeatureDisabledBy = Column(BigInteger)
    InsightsFeatureDisabledBy = Column(BigInteger)
    RephraseActionJson = Column(Text)
    CustomFeatureLastModified = Column(DateTime)
    IsCustomFeature = Column(Boolean)
    AISuggestedCredit = Column(BigInteger)
    AISuggestedUsedCredit = Column(BigInteger)
    IsListening = Column(Boolean, default=1)
    IsORM = Column(Boolean, default=1)
    AgreementMessageToShow = Column(Text)
    IsAgreementEnded = Column(Boolean, default=0)
    IsShowTwitterHandleEnable = Column(Boolean, default=1, nullable=False)
    IsTicketSummarizationEnabled = Column(Boolean)
    TicketSummarizationEnabledDate = Column(DateTime)
    TicketSummarizationEnabledBy = Column(BigInteger)
    TicketSummarizationDisabledDate = Column(DateTime)
    TicketSummarizationDisabledBy = Column(BigInteger)
    Ai_ABSA_Enabled = Column(Boolean)
    Ai_ABSA_Enable_At = Column(DateTime)
    Ai_ABSA_Updated_at = Column(DateTime)
    SSOUserEnable = Column(Boolean)
    IsSSOUserActive = Column(BigInteger, default=0)
    ISOverrideAllUser = Column(Boolean)
    TotalCRM_UserLimit = Column(BigInteger, default=0)
    TotalCRM_UserCreated = Column(BigInteger, default=0)
    SurveyLocationLimit = Column(BigInteger)
    SurveyLocationLimitConsumed = Column(BigInteger)
    TotalFormCount = Column(BigInteger)
    ActiveFormCount = Column(BigInteger)
    WorkflowLimit = Column(BigInteger)
    WorkflowLimit_Used = Column(BigInteger)
    ProductType = Column(Integer)
    IsORMRequestSent = Column(Integer)


class MstCategories(Base):
    __tablename__ = 'mstCategories'

    # Define columns based on the table schema
    ID = Column(Integer, Identity(start=1, cycle=True), primary_key=True)
    OldID = Column(Integer)
    CategoryName = Column(String(50))
    Brands = Column(Text)
    CatCondition = Column(Text)
    IsCategoryActive = Column(Boolean)
    CategoryType = Column(String(50))
    CategoryCreatedDate = Column(DateTime, server_default="getutcdate()")
    IsTicketEnabled = Column(Boolean)
    IsEMTabEnabled = Column(Boolean)
    Credit = Column(BigInteger, default=0)
    UsedCredit = Column(BigInteger, default=0)
    Threshold = Column(BigInteger, default=500000)
    isPushCRMEnabled = Column(Boolean, default=0)
    TicketingVersion = Column(Integer)
    IsMakerCheckerEnable = Column(Integer)
    CategoryFriendlyName = Column(String(500))
    IsNewCategoryMapping = Column(Boolean, default=1)
    DataLimit = Column(String(100))
    AnnualThreshold = Column(BigInteger)
    LanguageTranslationLimit = Column(BigInteger, default=1000)
    IsActiveDataLimitAlert = Column(Boolean, default=0)
    CategoryAccountType = Column(BigInteger)
    Azurestatus = Column(SmallInteger)
    IsTmpDataDisabled = Column(SmallInteger)
    BaseLimit = Column(Integer)
    MonthlyExtension = Column(Boolean)
    IsAgentTicketviewSettingEnable = Column(Boolean, default=0)
    IsTakeoverTicketEnabled = Column(Boolean, default=0)
    IsViewUnassignedTicketEnabled = Column(Boolean, default=0)
    MonthlyExtensionLimit = Column(BigInteger)
    DBDeletionDate = Column(DateTime)
    ProductType = Column(String(50))
    IsClickhouseEnabled = Column(SmallInteger)
    IsOpenSearchLikeQuery = Column(Boolean)
    TenantDetails = Column(Text)


class MstTikTokSettings(Base):
    __tablename__ = 'mstTikTokSettings'

    # Define columns based on the table schema
    TikTokId = Column(BigInteger, Identity(start=1, cycle=True), primary_key=True)
    BrandId = Column(Integer)
    CategoryId = Column(Integer)
    Inserteddate = Column(DateTime)
    InsertedBy = Column(BigInteger)
    IsActive = Column(Boolean)
    AccessToken = Column(String(500))
    RefreshToken = Column(String(500))
    BusinessId = Column(String(500))
    Scope = Column(String(500))
    TikTokUserName = Column(String(500))
    TikTokDisplayName = Column(String(500))
    IsBusinessAccount = Column(Boolean)
    Code = Column(String(500))
    Updateddate = Column(DateTime)
    UpdatedBy = Column(BigInteger)
    IsTokenExpired = Column(Boolean)
    IsAuthorized = Column(Boolean)
    TokenExpiryDate = Column(DateTime)
    ClientId = Column(String(500))
    ClientSecret = Column(String(500))
    InactiveInnerChannels = Column(Text)
    DataProcessStatus = Column(Boolean)
    ProfileImageURL = Column(Text)
    AccountUrl = Column(Text)
    DataProcessJson = Column(Text)
    Posts_LastFetchedDate = Column(DateTime)
    Comments_LastFetchedDate = Column(DateTime)
    IsCommentRepliesFetchEnabled = Column(Boolean)
    CommentReplies_LastFetchedDate = Column(DateTime)


class MstBrandTwitterAccounts(Base):
    __tablename__ = 'mstBrandTwitterAccounts'

    # Define columns based on the table schema
    BTAID = Column(BigInteger, Identity(start=1, cycle=True), primary_key=True)
    OldBTAID = Column(BigInteger)
    BrandID = Column(BigInteger, nullable=False)
    OldBrandID = Column(BigInteger)
    BrandName = Column(String(50), nullable=False)
    TwitterUID = Column(BigInteger, nullable=False)
    ScreenName = Column(String(150), nullable=False)
    Token = Column(String(150))
    TokenSecret = Column(String(150))
    TwitterUsername = Column(String(150))
    IsActive = Column(Boolean)
    CategoryID = Column(BigInteger)
    OldCategoryID = Column(BigInteger)
    CategoryName = Column(String(50))
    IsVerified = Column(Boolean)
    profileimageurl = Column(String(500))
    LastFetchUTCTime = Column(DateTime)
    AppToken = Column(String(250))
    AppTokenSecret = Column(String(250))
    InsertedRecordDate = Column(DateTime, server_default="getutcdate()")
    ServerID = Column(BigInteger)
    FollowerIDCursor = Column(String(50))
    IsCursorActive = Column(Boolean)
    LimitExceedAt = Column(DateTime)
    DataProcessStatus = Column(Integer, default=0)
    InsertedBy = Column(BigInteger)
    UpdatedBy = Column(BigInteger)
    UpdatedDate = Column(DateTime)
    ProfileCoverImage = Column(String(2000))
    Bio = Column(Text)
    ProfileJson = Column(Text)
    ToFetchQuotedTweetsRT = Column(Integer)
    InactiveInnerChannels = Column(Text)
    IsSubscribe = Column(Boolean)
    SubscribeDate = Column(DateTime)
    GnipStreamTypeEnum = Column(Integer)


class MstTwitterAccounts(Base):
    __tablename__ = 'mstTwitterAccounts'

    # Define columns based on the table schema
    AccountID = Column(BigInteger, Identity(start=1, cycle=True), primary_key=True)
    OldAccountID = Column(BigInteger)
    UID = Column(BigInteger)
    OldUID = Column(BigInteger)
    UserName = Column(String(120))
    ScreenName = Column(String(120))
    Token = Column(String(500))
    TokenSecret = Column(String(500))
    Location = Column(String(250))
    TwitterUID = Column(BigInteger)
    CreatedDate = Column(DateTime)
    IsPrimary = Column(Boolean)
    BrandID = Column(BigInteger)
    OldBrandID = Column(BigInteger)
    IsTokenExpired = Column(Boolean, default=False)
    IsDeleted = Column(Boolean, default=False)
    profileimageurl = Column(String(500))
    IsMentionsFetch = Column(Boolean)
    LastFetchUTCTime = Column(DateTime)
    ServerID = Column(Integer)
    SortOrder = Column(Integer)
    FetchMarketingInsights = Column(Boolean)
    InactiveInnerChannels = Column(Text)


class MstFacebookGroups(Base):
    __tablename__ = 'MstFacebookGroups'

    # Define columns based on the table schema
    ID = Column(BigInteger, primary_key=True, autoincrement=True)
    GroupID = Column(String(500))
    GroupName = Column(String(500))
    Categoryid = Column(BigInteger)
    CategoryName = Column(String(100))
    BrandID = Column(BigInteger)
    BrandName = Column(String(150))
    SocialJoinDate = Column(DateTime)
    MemberCount = Column(BigInteger)
    InsertedDate = Column(DateTime)
    InsertedBy = Column(BigInteger)
    Description = Column(Text)
    Url = Column(String(1000))
    UpdatedDate = Column(DateTime)
    UpdatedBy = Column(BigInteger)
    IsDeleted = Column(Boolean)
    DeletedDate = Column(DateTime)
    Deletedby = Column(BigInteger)
    ErrorMessage = Column(Text)
    ProfileImageUrl = Column(String(4000))
    CoverPhotoUrl = Column(String(4000))
    GroupType = Column(String(100))
    IsPrivate = Column(Boolean)
    IsHidden = Column(Boolean)
    DataProcessStatus = Column(Integer)
    DataProcessJson = Column(Text)
    Posts_LastFetchedDate = Column(DateTime)
    Comments_LastFetchedDate = Column(DateTime)
    LastUpdatedAt = Column(DateTime)
    LastNotificationReadAt = Column(DateTime)
    LastCommentReadAt = Column(DateTime)
    LastMessageReadAt = Column(DateTime)
    InactiveInnerChannels = Column(Text)


class MstFacebookGroupsLog(Base):
    __tablename__ = 'MstFacebookGroups_log'

    # Define columns based on the table schema
    LogID = Column(BigInteger, primary_key=True, autoincrement=True)
    ID = Column(BigInteger)
    GroupID = Column(String(500))
    GroupName = Column(String(500))
    Categoryid = Column(BigInteger)
    CategoryName = Column(String(100))
    BrandID = Column(BigInteger)
    BrandName = Column(String(150))
    SocialJoinDate = Column(DateTime)
    MemberCount = Column(BigInteger)
    InsertedDate = Column(DateTime)
    InsertedBy = Column(BigInteger)
    Description = Column(Text)
    Url = Column(String(1000))
    UpdatedDate = Column(DateTime)
    UpdatedBy = Column(BigInteger)
    IsDeleted = Column(Boolean)
    DeletedDate = Column(DateTime)
    Deletedby = Column(BigInteger)
    ErrorMessage = Column(Text)
    ProfileImageUrl = Column(String(4000))
    CoverPhotoUrl = Column(String(4000))
    GroupType = Column(String(100))
    IsPrivate = Column(Boolean)
    IsHidden = Column(Boolean)
    DataProcessStatus = Column(Integer)
    DataProcessJson = Column(Text)
    Posts_LastFetchedDate = Column(DateTime)
    Comments_LastFetchedDate = Column(DateTime)
    LastUpdatedAt = Column(DateTime)
    LastNotificationReadAt = Column(DateTime)
    LastCommentReadAt = Column(DateTime)
    LastMessageReadAt = Column(DateTime)
    InactiveInnerChannels = Column(Text)


class MstTikTokSettingsLog(Base):
    __tablename__ = 'mstTikTokSettings_log'

    LogID = Column(BigInteger, primary_key=True, autoincrement=True)
    TikTokId = Column(BigInteger)
    BrandId = Column(Integer)
    CategoryId = Column(Integer)
    Inserteddate = Column(DateTime)
    InsertedBy = Column(BigInteger)
    IsActive = Column(Boolean)
    AccessToken = Column(String(500))
    RefreshToken = Column(String(500))
    BusinessId = Column(String(500))
    Scope = Column(String(500))
    TikTokUserName = Column(String(500))
    TikTokDisplayName = Column(String(500))
    IsBusinessAccount = Column(Boolean)
    Code = Column(String(500))
    Updateddate = Column(DateTime)
    UpdatedBy = Column(BigInteger)
    LogDate = Column(DateTime, nullable=False)
    LoggedBy = Column(BigInteger, nullable=False)
    IsTokenExpired = Column(Boolean)
    IsAuthorized = Column(Boolean)
    TokenExpiryDate = Column(DateTime)
    ClientId = Column(String(500))
    ClientSecret = Column(String(500))
    InactiveInnerChannels = Column(Text)
    DataProcessStatus = Column(Boolean)
    ProfileImageURL = Column(Text)
    AccountUrl = Column(Text)
    DataProcessJson = Column(Text)
    Posts_LastFetchedDate = Column(DateTime)
    Comments_LastFetchedDate = Column(DateTime)
    IsCommentRepliesFetchEnabled = Column(Boolean)
    CommentReplies_LastFetchedDate = Column(DateTime)


class MstCMOPages(Base):
    __tablename__ = "MstCMOPages"

    # Columns
    ID = Column(BigInteger, primary_key=True, autoincrement=True)
    PageID = Column(String(100), nullable=False)
    BrandID = Column(BigInteger, nullable=False)
    SectorID = Column(BigInteger, nullable=False)
    ChannelGroupID = Column(BigInteger, nullable=False)
    PageName = Column(String(250), nullable=False)
    PageScreenName = Column(String(250), nullable=True)
    PageDescription = Column(Text, nullable=True)
    PageLink = Column(String(500), nullable=True)
    IsPageActive = Column(Boolean, default=True, nullable=True)
    InsertedDate = Column(DateTime, default=func.getutcdate(), nullable=True)
    PageCoverImage = Column(String(500), nullable=True)
    PageImageJson = Column(Text, nullable=True)
    PageProfileImageUrl = Column(String(500), nullable=True)
    DateOfSocialJoin = Column(DateTime, nullable=True)
    FollowersCount = Column(BigInteger, default=0, nullable=True)
    FollowingCount = Column(BigInteger, default=0, nullable=True)
    PostsCount = Column(BigInteger, default=0, nullable=True)
    DataFetchStartDate = Column(DateTime, nullable=True)
    IsLastOneYearDataFetched = Column(Boolean, default=False, nullable=True)
    LastFetchedStartDate = Column(DateTime, nullable=True)
    LastFetchedEndDate = Column(DateTime, nullable=True)
    LastFetchedMentionCount = Column(Integer, default=0, nullable=True)
    DataProcessStatus = Column(Boolean, default=False, nullable=True)
    LastUpdatedDate = Column(DateTime, nullable=True)
    LastPickedAt = Column(DateTime, nullable=True)
    IsVerified = Column(Boolean, default=False, nullable=True)
    DaysRemainingToFetch = Column(Integer, nullable=True)
    IsSocial = Column(Boolean, default=True, nullable=True)
    Website = Column(String(150), nullable=True)
    HistoricGnipQuery = Column(Text, nullable=True)
    IsHistoricDataFetched = Column(Boolean, nullable=True)
    HistoricfetchedmentionCount = Column(BigInteger, nullable=True)
    pagecount_of_commentsfetch = Column(Integer, nullable=True)


class MstCMOBrandSectorsLog(Base):
    __tablename__ = 'MstCMOBrandSectors_log'

    # Define columns based on the table schema
    LOGID = Column(BigInteger, primary_key=True, autoincrement=True)
    LOGDate = Column(DateTime, server_default="getutcdate()", nullable=False)
    ID = Column(BigInteger)
    Sector = Column(String(250))
    SubSector = Column(Text)
    TotalBrands = Column(BigInteger)
    TotalCategories = Column(BigInteger)
    InsertedDate = Column(DateTime)


class MstCMObrands(Base):
    __tablename__ = 'MstCMObrands'

    # Define columns based on the table schema
    BrandID = Column(BigInteger, primary_key=True, autoincrement=True)
    BrandName = Column(String(250), nullable=False)
    BrandFriendlyName = Column(String(250))
    BrandDescription = Column(Text)
    SectorID = Column(BigInteger, nullable=False)
    Region = Column(String(250))
    InsertedDate = Column(DateTime, server_default="getutcdate()")
    UpdatedDate = Column(DateTime)
    IsBrandActive = Column(Boolean, default=True)
    RImageURL = Column(String(500))
    RSmallImageURL = Column(String(500))
    Color = Column(String(50))
    CountryFIPSCode = Column(String(10))
    TimeOffset = Column(Integer)
    TimeOffsetText = Column(String(50))


class MstAuthorizedTokens(Base):
    __tablename__ = "MstAuthorizedTokens"

    ID = Column(Integer, primary_key=True, autoincrement=True, nullable=False)
    ChannelGroupID = Column(Integer, nullable=True)
    UID = Column(String(150), nullable=True)
    AccessToken = Column(String(500), nullable=True)
    InsertedDate = Column(DateTime, server_default=func.getutcdate(), nullable=True)
    IsTokenExpired = Column(Boolean, nullable=True)
    TokenExpiredDate = Column(DateTime, nullable=True)
    Updateddate = Column(DateTime, nullable=True)
    TokenSecret = Column(String(150), nullable=True)
    AppToken = Column(String(250), nullable=True)
    AppTokenSecret = Column(String(250), nullable=True)


class MstCMOBrandSectors(Base):
    __tablename__ = 'MstCMOBrandSectors'

    ID = Column(BigInteger, primary_key=True, autoincrement=True)
    Sector = Column(VARCHAR(250, collation="SQL_Latin1_General_CP1_CI_AS"), nullable=True)
    SubSector = Column(VARCHAR(None, collation="SQL_Latin1_General_CP1_CI_AS"),
                       nullable=True)  # Use VARCHAR with None for MAX length
    TotalBrands = Column(BigInteger, nullable=True)
    TotalCategories = Column(BigInteger, nullable=True)
    InsertedDate = Column(DateTime, nullable=True)


class MstGoogleMyBusinessAccounts(Base):
    __tablename__ = 'mstGoogleMyBusinessAccounts'

    # Define columns based on the table schema
    GoogleMyBusinessAccountID = Column(BigInteger, primary_key=True, autoincrement=True)
    GoogleMyBusinessTokenID = Column(BigInteger, ForeignKey('mstGoogleMyBusinessTokens.GoogleMyBusinessTokenID'),
                                     nullable=False)
    AccountID = Column(String(1000), nullable=False)
    AccountName = Column(String(1000))
    SettingJson = Column(Text)
    UserID = Column(BigInteger, nullable=False)
    InsertedDate = Column(DateTime, server_default="getutcdate()", nullable=False)
    IsActive = Column(Boolean, nullable=False)
    DataProcessStatus = Column(Integer, default=0)
    UpdatedBy = Column(BigInteger)
    UpdatedDate = Column(DateTime)
    InactiveInnerChannels = Column(Text)
    IsDummyRecord = Column(Boolean)
    iswebhookenabled = Column(Boolean)
    webhookenableddate = Column(DateTime)


class MstGoogleMyBusinessTokens(Base):
    __tablename__ = 'mstGoogleMyBusinessTokens'

    # Define columns based on the table schema
    GoogleMyBusinessTokenID = Column(BigInteger, primary_key=True, autoincrement=True)
    ClientID = Column(Text, nullable=False)
    ClientSecret = Column(Text, nullable=False)
    accessToken = Column(Text, nullable=False)
    refreshToken = Column(Text, nullable=False)
    GoogleUserID = Column(String(250))
    GoogleUserName = Column(String(500))
    ImageUrl = Column(String(1000))
    BrandID = Column(BigInteger, nullable=False)
    BrandName = Column(String(50), nullable=False)
    CategoryID = Column(BigInteger, nullable=False)
    CategoryName = Column(String(50), nullable=False)
    InsertedDate = Column(DateTime, server_default="getutcdate()", nullable=False)
    LastUpdatedOn = Column(DateTime)
    UserID = Column(BigInteger, nullable=False)
    IsActive = Column(Boolean, nullable=False)
    SettingsJson = Column(Text)
    UpdatedBy = Column(BigInteger)
    UpdatedDate = Column(DateTime)
    IsTokenExpired = Column(Boolean, default=False)
    InactiveInnerChannels = Column(Text)
    IsDummyRecord = Column(Boolean)


class MstGoogleMyBusinessLocations(Base):
    __tablename__ = 'mstGoogleMyBusinessLocations'

    # Define columns based on the table schema
    GoogleMyBusinessLocationID = Column(BigInteger, primary_key=True, autoincrement=True)
    GoogleMyBusinessAccountID = Column(BigInteger, ForeignKey('mstGoogleMyBusinessAccounts.GoogleMyBusinessAccountID'),
                                       nullable=False)
    LocationID = Column(String(1000), nullable=False)
    LocationName = Column(String(1000), nullable=False)
    Locality = Column(String(500))
    SettingLocationName = Column(String(1000))
    latitude = Column(Numeric(18, 10))
    longitude = Column(Numeric(18, 10))
    SettingsJson = Column(Text)
    UserID = Column(BigInteger, nullable=False)
    InsertedDate = Column(DateTime, server_default="getutcdate()", nullable=False)
    IsActive = Column(Boolean, nullable=False)
    StoreCode = Column(String(70))
    StoreURL = Column(String(2000))
    DataProcessStatus = Column(Integer, default=0)
    StoreAddress = Column(Text)
    UpdatedBy = Column(BigInteger)
    UpdatedDate = Column(DateTime)
    LocationStatus = Column(SmallInteger, default=0)
    LocationGroupName = Column(String(500))
    IsDummyRecord = Column(Boolean)
    LastFetchedDate = Column(DateTime)


class MstWorkFlowAlertSettings(Base):
    __tablename__ = 'MstWorkFlowAlertSettings'

    AlertSettingID = Column(BigInteger, primary_key=True, autoincrement=True)
    CategoryID = Column(BigInteger, nullable=False)
    CategoryName = Column(String(150))
    BrandID = Column(BigInteger, nullable=False)
    BrandName = Column(String(300))
    AlertName = Column(String(500), nullable=False)
    AlertSubject = Column(String(500), nullable=False)
    AlertType = Column(Integer, nullable=False)  # tinyint corresponds to Integer in SQLAlchemy
    CreatedDate = Column(DateTime, nullable=False)
    CreatedBy = Column(BigInteger, nullable=False)
    IsDeleted = Column(Boolean, default=False)
    IsActive = Column(Boolean)
    FilterJSON = Column(Text)
    FilterQuery = Column(Text)
    StartDate = Column(DateTime)
    EndDate = Column(DateTime)
    AlertStartTime = Column(Time)
    AlertEndTime = Column(Time)
    RepeatedDays = Column(String(500))
    ErrorMessage = Column(Text)
    EmailIds = Column(Text)
    EmailAlertSubject = Column(String(1000))
    LastAlertSentAt = Column(DateTime)
    NextAlertTime = Column(DateTime)
    ActionType = Column(Integer)
    DailyDigestTime = Column(Time)
    LastSentrecorddate = Column(DateTime)
    ModifiedDate = Column(DateTime)
    ModifiedBy = Column(BigInteger)
    IsScheduled = Column(Boolean, default=False)
    From_Offset = Column(BigInteger)
    To_Offset = Column(BigInteger)
    LatestTagid = Column(BigInteger)
    TriggerCount = Column(BigInteger)
    LastEditedBy = Column(BigInteger)
    LastEditedDate = Column(DateTime)
    TimeZone = Column(SmallInteger)
    Next_StartDate = Column(DateTime)
    Next_EndDate = Column(DateTime)
    TaskName = Column(String(150))
    StreamName = Column(String(150))
    ScheduledStartDate = Column(DateTime)
    ScheduledEndDate = Column(DateTime)
    TimeZone_Region = Column(String(50))
    DisplayStartdate = Column(DateTime)
    DisplayEnddate = Column(DateTime)
    DisplayStartTime = Column(Time)
    DisplayEndTime = Column(Time)
    displayDailydigesttime = Column(Time)


class MstCMOPagesLog(Base):
    __tablename__ = "MstCMOPages_log"

    LOGID = Column(BigInteger, primary_key=True, autoincrement=True, nullable=False)
    LOGDate = Column(DateTime, server_default=func.getutcdate(), nullable=False)
    ID = Column(BigInteger, nullable=True)
    PageID = Column(String(100), nullable=True)
    BrandID = Column(BigInteger, nullable=True)
    SectorID = Column(BigInteger, nullable=True)
    ChannelGroupID = Column(BigInteger, nullable=True)
    PageName = Column(String(250), nullable=True)
    PageScreenName = Column(String(250), nullable=True)
    PageDescription = Column(Text, nullable=True)
    PageLink = Column(String(500), nullable=True)
    IsPageActive = Column(Boolean, nullable=True)
    InsertedDate = Column(DateTime, nullable=True)
    PageCoverImage = Column(String(500), nullable=True)
    PageImageJson = Column(Text, nullable=True)
    PageProfileImageUrl = Column(String(500), nullable=True)
    DateOfSocialJoin = Column(DateTime, nullable=True)
    FollowersCount = Column(BigInteger, nullable=True)
    FollowingCount = Column(BigInteger, nullable=True)
    PostsCount = Column(BigInteger, nullable=True)
    DataFetchStartDate = Column(DateTime, nullable=True)
    IsLastOneYearDataFetched = Column(Boolean, nullable=True)
    LastFetchedStartDate = Column(DateTime, nullable=True)
    LastFetchedEndDate = Column(DateTime, nullable=True)
    LastFetchedMentionCount = Column(Integer, nullable=True)
    DataProcessStatus = Column(Boolean, nullable=True)
    LastUpdatedDate = Column(DateTime, nullable=True)
    LastPickedAt = Column(DateTime, nullable=True)
    IsVerified = Column(Boolean, nullable=True)
    DaysRemainingToFetch = Column(Integer, nullable=True)
    IsSocial = Column(Boolean, server_default="1", nullable=True)
    Website = Column(String(150), nullable=True)
    HistoricGnipQuery = Column(Text, nullable=True)
    IsHistoricDataFetched = Column(Boolean, nullable=True)
    HistoricfetchedmentionCount = Column(BigInteger, nullable=True)
    pagecount_of_commentsfetch = Column(Integer, nullable=True)


class MstKeywordAdditionSettings(Base):
    __tablename__ = "mstKeywordAdditionSettings"

    ID = Column(BigInteger, primary_key=True, autoincrement=True)
    BrandID = Column(BigInteger, nullable=True)
    CategoryID = Column(BigInteger, nullable=True)
    Query = Column(Text, nullable=True)
    JsonQuery = Column(Text, nullable=True)
    GnipQuery = Column(Text, nullable=True)
    GnipTagID = Column(String(100), nullable=True)
    GnipReturnID = Column(String(50), nullable=True)
    ChannelGroupIDs = Column(String(50), nullable=True)
    StartDate = Column(DateTime, nullable=True)
    EndDate = Column(DateTime, nullable=True)
    IsDeleted = Column(Boolean, default=False, nullable=False)
    FetchStatus = Column(Integer, nullable=True)
    OrderID = Column(BigInteger, nullable=True)
    InsertedDate = Column(DateTime, nullable=True, default='getutcdate()')
    FetchCount = Column(BigInteger, nullable=True)
    ServerConfigID = Column(BigInteger, nullable=True)
    BrandName = Column(String(50), nullable=True)
    UserName = Column(String(50), nullable=True)
    CategoryName = Column(String(50), nullable=True)
    Userid = Column(BigInteger, nullable=True)
    lastfetcheddate = Column(DateTime, nullable=True)
    lastfetchedstatus = Column(Integer, nullable=True)
    LastFetchedFB = Column(DateTime, nullable=True)
    lastFetchedNews = Column(DateTime, nullable=True)
    lastFetchedInsta = Column(DateTime, nullable=True)
    lastFetchedYoutube = Column(DateTime, nullable=True)
    ActualTweetCount = Column(BigInteger, default=0, nullable=True)
    ActualTweetFetchCount = Column(BigInteger, default=0, nullable=True)
    ActualFetch_LastUpdatedAt = Column(DateTime, nullable=True)
    IsChannelPicked = Column(Integer, nullable=True)
    IsChannelDataFetched = Column(Integer, nullable=True)
    ChannelPickedAt = Column(DateTime, nullable=True)
    ApprovalStatus = Column(Integer, nullable=True)
    LastFetchedPage = Column(String(500), nullable=True)
    QueryType = Column(Integer, nullable=True)
    InactiveInnerChannels = Column(Text, nullable=True)
    IsPremium = Column(Boolean, nullable=True)
    GNIPStreamTypeEnum = Column(Integer, nullable=True)
    IsCommentRepliesFetchEnabled = Column(Boolean, nullable=True)
    VaultJson = Column(Text, nullable=True)


class TwitterHistoricalDataOrderInfo(Base):
    __tablename__ = "Twitter_HistoricalData_OrderInfo"

    ID = Column(BigInteger, primary_key=True, autoincrement=True)
    BrandID = Column(BigInteger, nullable=True)
    CategoryID = Column(BigInteger, nullable=True)
    OrderID = Column(String(100), nullable=True)
    StartDate = Column(DateTime, nullable=True)
    EndDate = Column(DateTime, nullable=True)
    Amount = Column(Numeric(18, 2), nullable=True)
    Amount_Paid = Column(Numeric(18, 2), nullable=True)
    Amount_Due = Column(Numeric(18, 2), nullable=True)
    Currency = Column(String(3), nullable=True)
    Status = Column(String(100), nullable=True)
    Attempts = Column(BigInteger, nullable=True)
    UserID = Column(BigInteger, nullable=False)
    OrderDate = Column(DateTime, nullable=False, default="getutcdate()")  # Adjust default as needed
    Query = Column(Text, nullable=True)
    JsonQuery = Column(Text, nullable=True)
    GnipQuery = Column(Text, nullable=True)
    isPicked = Column(Boolean, nullable=False, default=False)
    isDataFetched = Column(Boolean, nullable=False, default=False)
    ActualAmount = Column(BigInteger, nullable=True, default=0)
    isdeleted = Column(Boolean, nullable=False, default=False)
    MentionCount = Column(BigInteger, nullable=True, default=0)
    IsRealTimeDataRequested = Column(Boolean, nullable=False, default=False)
    IsMentionFetched = Column(Boolean, nullable=False, default=False)
    IsAllDataFetched = Column(Boolean, nullable=False, default=False)
    isAllPicked = Column(Boolean, nullable=False, default=False)
    isDataDeleted = Column(Boolean, nullable=False, default=False)
    AllPickedAt = Column(DateTime, nullable=True)
    DataProcessStatus = Column(Integer, nullable=True, default=0)
    UpdatedBy = Column(BigInteger, nullable=True)
    UpdatedDate = Column(DateTime, nullable=True)
    RelationOrderID = Column(BigInteger, nullable=True)
    IsAmountDeducted = Column(Boolean, nullable=True)
    IsAmountDeductedDate = Column(DateTime, nullable=True)
    KeywordGroupName = Column(String(250), nullable=True)
    GnipStreamTypeEnum = Column(Integer, nullable=True)


class MstGoogleAlertSettings(Base):
    __tablename__ = "mstGoogleAlertSettings"

    SettingId = Column(BigInteger, primary_key=True, autoincrement=True)
    OldSettingId = Column(BigInteger, nullable=True)
    BrandID = Column(BigInteger, nullable=False)
    OldBrandID = Column(BigInteger, nullable=True)
    BrandName = Column(String(50), nullable=True)
    CategoryID = Column(BigInteger, nullable=True)
    OldCategoryID = Column(BigInteger, nullable=True)
    CategoryName = Column(String(50), nullable=True)
    SettingUrl = Column(String(500), nullable=True)
    CreatedDate = Column(DateTime, nullable=True)
    isactive = Column(Boolean, nullable=True)
    ServerID = Column(Integer, nullable=True)
    DataProcessStatus = Column(Integer, nullable=True, default=0)
    CreatedBy = Column(BigInteger, nullable=True)
    UpdatedBy = Column(BigInteger, nullable=True)
    Updateddate = Column(DateTime, nullable=True)
    InactiveInnerChannels = Column(Text, nullable=True)


class IAppStoreSetting(Base):
    __tablename__ = "IAppStoreSetting"

    AppStoreID = Column(BigInteger, primary_key=True, autoincrement=True)
    BrandID = Column(BigInteger, nullable=True)
    CategoryID = Column(BigInteger, nullable=True)
    CreatedDate = Column(DateTime, nullable=True)
    IAppStoreID = Column(BigInteger, nullable=True)
    Name = Column(String(2000), nullable=True)
    Description = Column(Text, nullable=True)
    AppStoreURL = Column(String(2000), nullable=True)
    Inserteddate = Column(DateTime, nullable=True)
    InsertedBy = Column(BigInteger, nullable=True)
    Updateddate = Column(DateTime, nullable=True)
    UpdatedBy = Column(BigInteger, nullable=True)
    IsActive = Column(Boolean, nullable=True)
    Countries = Column(Text, nullable=True)
    DataProcessStatus = Column(Boolean, nullable=True)
    AccessToken = Column(String(1000), nullable=True)
    IsTokenExpired = Column(Boolean, nullable=True)
    TokenExpiryDate = Column(DateTime, nullable=True)
    IsAuthorized = Column(Boolean, nullable=True)
    RefreshToken = Column(String(1000), nullable=True)
    PrivateKey = Column(String(1000), nullable=True)
    IssuerID = Column(String(1000), nullable=True)
    KeyID = Column(String(1000), nullable=True)
    AppStoreBundleID = Column(String(500), nullable=True)
    AppStoreImageURL = Column(String(1000), nullable=True)
    IsPublic = Column(Boolean, nullable=True)


class GooglePlayStoreClientPackages(Base):
    __tablename__ = 'GooglePlayStoreClientPackages'

    GooglePlayStorePackageID = Column(BigInteger, primary_key=True, autoincrement=True)
    GooglePlayStoreTokenID = Column(BigInteger, nullable=False)
    ClientID = Column(NVARCHAR, nullable=True)  # Equivalent to nvarchar(MAX)
    PackageName = Column(NVARCHAR(2000), nullable=True)
    BrandID = Column(BigInteger, nullable=False)
    BrandName = Column(String(150), nullable=False)
    CategoryID = Column(BigInteger, nullable=False)
    CategoryName = Column(String(150), nullable=False)
    InsertedDate = Column(DateTime, nullable=True)
    InsertedBy = Column(BigInteger, nullable=True)
    LastFetchedOn = Column(DateTime, nullable=True)
    IsActive = Column(Boolean, nullable=True)
    PackageFriendlyName = Column(NVARCHAR(100), nullable=True)
    ServerID = Column(Integer, nullable=True)
    UpdatedBy = Column(BigInteger, nullable=True)
    UpdatedDate = Column(DateTime, nullable=True)
    PackageURL = Column(NVARCHAR, nullable=True)  # Equivalent to nvarchar(MAX)
    ActionStatus = Column(Integer, nullable=True)  # Assuming tinyint maps to Integer
    IsDummy = Column(Boolean, nullable=True)
    DataProcessStatus = Column(Integer, nullable=True)


class MstExcludeBrandList(Base):
    __tablename__ = 'mstExcludeBrandList'

    Id = Column(BigInteger, primary_key=True, autoincrement=True)
    OldId = Column(BigInteger, nullable=True)
    BrandID = Column(BigInteger, nullable=True)
    OldBrandID = Column(BigInteger, nullable=True)
    BrandName = Column(String(100), nullable=True)  # Matches varchar(100)
    CategoryID = Column(BigInteger, nullable=True)
    OldCategoryID = Column(BigInteger, nullable=True)
    CategoryName = Column(String(100), nullable=True)  # Matches varchar(100)
    ServerID = Column(Integer, nullable=True)


class MstGooglePlayStoreTokens(Base):
    __tablename__ = 'mstGooglePlayStoreTokens'

    GooglePlayStoreTokenID = Column(BigInteger, primary_key=True, autoincrement=True)
    OldGooglePlayStoreTokenID = Column(BigInteger, nullable=True)
    ClientID = Column(NVARCHAR, nullable=True)  # Equivalent to nvarchar(MAX)
    ClientSecret = Column(NVARCHAR, nullable=False)  # Equivalent to nvarchar(MAX)
    accessToken = Column(NVARCHAR, nullable=False)  # Equivalent to nvarchar(MAX)
    refreshToken = Column(NVARCHAR, nullable=True)  # Equivalent to nvarchar(MAX)
    tokenType = Column(String(100), nullable=True)
    BrandID = Column(BigInteger, nullable=False)
    OldBrandID = Column(BigInteger, nullable=True)
    BrandName = Column(String(150), nullable=True)
    CategoryID = Column(BigInteger, nullable=False)
    OldCategoryID = Column(BigInteger, nullable=True)
    CategoryName = Column(String(150), nullable=True)
    InsertedDate = Column(DateTime, nullable=True)
    LastUpdatedOn = Column(DateTime, nullable=True)
    UserID = Column(BigInteger, nullable=True)
    OldUserID = Column(BigInteger, nullable=True)
    IsActive = Column(Boolean, nullable=True)
    ServerID = Column(Integer, nullable=True)
    AdminJson = Column(NVARCHAR, nullable=True)  # Equivalent to nvarchar(MAX)
    FileName = Column(String(2000), nullable=True)
    DataProcessStatus = Column(Integer, default=0, nullable=True)
    UpdatedBy = Column(Integer, nullable=True)
    UpdatedDate = Column(DateTime, nullable=True)
    ProjectID = Column(NVARCHAR(300), nullable=True)  # Equivalent to nvarchar(300)
    IsTokenExpired = Column(Boolean, default=False, nullable=True)
    IsDummy = Column(Boolean, nullable=True)


class MstComplaintsSettings(Base):
    __tablename__ = 'mstComplaintsSettings'

    CCID = Column(BigInteger, primary_key=True, autoincrement=True)
    OldCCID = Column(BigInteger, nullable=True)
    BrandID = Column(BigInteger, nullable=False)
    OldBrandID = Column(BigInteger, nullable=True)
    CategoryID = Column(BigInteger, nullable=False)
    OldCategoryID = Column(BigInteger, nullable=True)
    SearchKeyword = Column(Text, nullable=False)  # Matches nvarchar(MAX)
    IsActive = Column(Boolean, nullable=True)
    CollectDataAfter = Column(Integer, nullable=False)
    LastPickedAt = Column(DateTime, nullable=True)
    RequestCount = Column(BigInteger, nullable=True)
    SiteGroupID = Column(String(500), nullable=True)  # Matches nvarchar(500)
    BrandName = Column(String(50), nullable=True)  # Matches varchar(50)
    categoryName = Column(String(50), nullable=True)  # Matches varchar(50)
    IsDeleted = Column(Boolean, nullable=True)
    Jsonkeywords = Column(Text, nullable=True)  # Matches nvarchar(MAX)
    createdate = Column(DateTime, nullable=True)
    SolrQuery = Column(Text, nullable=True)  # Matches nvarchar(MAX)
    RecordDeleteFlg = Column(Boolean, nullable=True)
    ServerID = Column(BigInteger, nullable=True)
    DataProcessStatus = Column(Integer, default=0, nullable=True)
    CreatedBy = Column(BigInteger, nullable=True)
    UpdatedBy = Column(BigInteger, nullable=True)
    UpdatedDate = Column(DateTime, nullable=True)


class MstReachImpressionFormula(Base):
    __tablename__ = 'MstReachImpressionFormula'

    FormulaID = Column(BigInteger, primary_key=True, autoincrement=True)
    CategoryID = Column(BigInteger, nullable=True)
    BrandID = Column(BigInteger, nullable=True)
    ChannelGroupID = Column(Integer, nullable=True)
    ImpressionFomula = Column(String(1000), nullable=True)  # Matches varchar(1000)
    ReachFomula = Column(String(1000), nullable=True)  # Matches varchar(1000)
    IsBrandpost = Column(Boolean, nullable=True)  # Matches bit
    IsActive = Column(Boolean, nullable=True)  # Matches bit
    IsOlddataUpdate = Column(Boolean, nullable=True)  # Matches bit
    CreatedBy = Column(BigInteger, nullable=True)
    CreatedDate = Column(DateTime, nullable=True)
    UpdatedBY = Column(BigInteger, nullable=True)
    UpdatedDate = Column(DateTime, nullable=True)
    FollowersCount = Column(BigInteger, nullable=True)
    VideoViews = Column(String(10), nullable=True)  # Matches varchar(10)
    BatchID = Column(String(50), nullable=True)  # Matches varchar(50)
    EngagementFormula = Column(String(1000), nullable=True)  # Matches varchar(1000)
    EngagementRate = Column(String(1000), nullable=True)  # Matches varchar(1000)
    IsFormulaDeleted = Column(Boolean, default=False, nullable=True)  # Matches bit with default
    CategoryGroupID = Column(BigInteger, nullable=True)


class MstCategoryBrandGroups(Base):
    __tablename__ = 'mstCategoryBrandGroups'

    ID = Column(Integer, primary_key=True, autoincrement=True)  # Primary key with auto-increment
    categoryid = Column(BigInteger, nullable=True)  # Matches bigint type in SQL
    categoryname = Column(String(50), nullable=True)  # Matches varchar(50)
    brandid = Column(BigInteger, nullable=True)  # Matches bigint
    brandname = Column(String(50), nullable=True)  # Matches varchar(50)
    categoryGroupid = Column(Integer, nullable=True)  # Matches int


class MstCategoryGroupDetails(Base):
    __tablename__ = 'mstCategoryGroupDetails'

    ID = Column(BigInteger, primary_key=True, autoincrement=True)
    CategoryID = Column(BigInteger, nullable=True)
    CategoryGroupID = Column(BigInteger, nullable=True)
    CategoryGroupName = Column(String(120), nullable=True)  # Matches nvarchar(120)
    CreatedDate = Column(DateTime, nullable=True, default=func.getutcdate())  # Matches datetime DEFAULT getutcdate()
    UserID = Column(BigInteger, nullable=True)
    IsUpperCategoryEnable = Column(Boolean, nullable=False, default=False)  # Matches bit DEFAULT 0
    CategoryMapOrderColumn = Column(String(100), nullable=True)  # Matches varchar(100)
    CategoryMapOrderType = Column(String(100), nullable=True)  # Matches varchar(100)
    IsAutoTicketCategorizationEnabled = Column(Boolean, nullable=False, default=True)  # Matches bit DEFAULT 1
    CategoryMapOrderUpdatedDate = Column(DateTime, nullable=True)
    CategoryMapOrderUpdatedBy = Column(BigInteger, nullable=True)
    IsPersonalDetailsEnabled = Column(Boolean, nullable=True)  # Matches bit
    IsAIEnabledForUpperCategory = Column(Boolean, nullable=True)  # Matches bit


class MstDefaultReachAndImpressionFormula(Base):
    __tablename__ = 'MstDefaultReachAndImpressionFormula'

    ID = Column(Integer, primary_key=True, autoincrement=True)  # Primary key with auto-increment
    ChannelGroupID = Column(Integer, nullable=True)  # Matches int type in SQL
    isBrandPost = Column(Boolean, nullable=True)  # Matches bit type in SQL
    ImpressionFomula = Column(String(1000), nullable=True)  # Matches nvarchar(1000)
    ReachFormula = Column(String(1000), nullable=True)  # Matches nvarchar(1000)
    EngagementFormula = Column(String(100), nullable=True, default='[Like] + comment + share')  # Matches varchar(100) with default
    EngagementRate = Column(String(100), nullable=True, default='[Engagement] / [Reach]')  # Matches varchar(100) with default


class MstECommerceSettings(Base):
    __tablename__ = 'mstECommerceSettings'

    Id = Column(BigInteger, primary_key=True, autoincrement=True)
    OldId = Column(BigInteger)
    CategoryName = Column(String(50), nullable=True)
    CategoryId = Column(BigInteger, nullable=True)
    OldCategoryId = Column(BigInteger, nullable=True)
    BrandName = Column(String(50), nullable=True)
    BrandId = Column(BigInteger, nullable=True)
    OldBrandId = Column(BigInteger, nullable=True)
    SearchURL = Column(Text, nullable=True)  # Using Text for nvarchar(MAX)
    ContainWord = Column(Text, nullable=True)
    LastUpdatedDate = Column(DateTime, nullable=True)
    IsActive = Column(Boolean, nullable=True)
    ServerID = Column(Integer, nullable=True)
    LastFetchedDate = Column(DateTime, nullable=True)
    PageNo = Column(Integer, nullable=True)
    TotalPages = Column(Integer, nullable=True)
    DataProcessStatus = Column(Integer, default=0, nullable=True)
    CreatedBy = Column(BigInteger, nullable=True)
    CreatedDate = Column(DateTime, nullable=True)
    UpdatedBy = Column(BigInteger, nullable=True)
    Updateddate = Column(DateTime, nullable=True)


class MstTripAdvisorAccounts(Base):
    __tablename__ = 'mstTripAdvisorAccounts'

    TAID = Column(BigInteger, primary_key=True, autoincrement=True)
    OldTAID = Column(BigInteger)
    HotelID = Column(BigInteger, nullable=False)
    BrandID = Column(Integer, nullable=False)
    OldBrandID = Column(BigInteger)
    CategoryID = Column(Integer, nullable=False)
    OldCategoryID = Column(BigInteger)
    BrandName = Column(String(500), nullable=False)
    CategoryName = Column(String(500), nullable=False)
    TripAdvisorURL = Column(String(800), nullable=False)
    TripAdvisorShortUrl = Column(String(800), nullable=False)
    LastUpdatedAt = Column(DateTime, nullable=True)
    CreatedDate = Column(DateTime, nullable=True)
    UserID = Column(BigInteger, nullable=True)
    OldUserID = Column(BigInteger, nullable=True)
    IsDeleted = Column(Boolean, nullable=True)
    Hotelname = Column(String(500), nullable=True)
    ServerID = Column(Integer, nullable=True)
    DataProcessStatus = Column(Integer, default=0, nullable=True)
    LastUpdatedBy = Column(BigInteger, nullable=True)
    LastUpdatedDate = Column(DateTime, nullable=True)


class MstBookingSettings(Base):
    __tablename__ = 'mstbookingSettings'

    # Columns
    BTID = Column(BigInteger, primary_key=True, autoincrement=True)
    OldBTID = Column(BigInteger, nullable=True)
    OldBrandID = Column(BigInteger, nullable=True)
    BrandID = Column(BigInteger, nullable=False)
    OldCategoryID = Column(BigInteger, nullable=True)
    CategoryID = Column(BigInteger, nullable=False)
    BrandName = Column(Text, nullable=False)
    CategoryName = Column(Text, nullable=False)
    BrandFriendlyName = Column(Text, nullable=True)
    BrandUrl = Column(String, nullable=True)
    IsActive = Column(Boolean, nullable=True)
    Priority = Column(Integer, nullable=True)
    LastPickedAt = Column(DateTime, nullable=True)
    CollectDataAfter = Column(Integer, default=8, nullable=True)
    HotelID = Column(String(150), nullable=True)
    HotelName = Column(String(150), nullable=True)
    Ccid = Column(String(5), nullable=True)
    ServerID = Column(Integer, nullable=True)
    DataProcessStatus = Column(Integer, default=0, nullable=True)
    CreatedBy = Column(BigInteger, nullable=True)
    CreatedDate = Column(DateTime, nullable=True)
    UpdatedBy = Column(BigInteger, nullable=True)
    UpdatedDate = Column(DateTime, nullable=True)


class MstBookingSettingsLog(Base):
    __tablename__ = 'mstbookingSettings_LOG'

    # Columns
    Log = Column(BigInteger, primary_key=True, autoincrement=True)
    BTID = Column(BigInteger, nullable=False)
    OldBTID = Column(BigInteger, nullable=True)
    OldBrandID = Column(BigInteger, nullable=True)
    BrandID = Column(BigInteger, nullable=False)
    OldCategoryID = Column(BigInteger, nullable=True)
    CategoryID = Column(BigInteger, nullable=False)
    BrandName = Column(Text, nullable=False)
    CategoryName = Column(Text, nullable=False)
    BrandFriendlyName = Column(Text, nullable=True)
    BrandUrl = Column(String, nullable=True)
    IsActive = Column(Boolean, nullable=True)
    Priority = Column(Integer, nullable=True)
    LastPickedAt = Column(DateTime, nullable=True)
    CollectDataAfter = Column(Integer, nullable=True)
    HotelID = Column(String(150), nullable=True)
    HotelName = Column(String(150), nullable=True)
    Ccid = Column(String(5), nullable=True)
    ServerID = Column(Integer, nullable=True)
    UserID = Column(BigInteger, nullable=False)
    InsertionDate = Column(DateTime, default=func.getutcdate(), nullable=True)
    DataProcessStatus = Column(Integer, default=0, nullable=True)
    CreatedBy = Column(BigInteger, nullable=True)
    CreatedDate = Column(DateTime, nullable=True)
    UpdatedBy = Column(BigInteger, nullable=True)
    UpdatedDate = Column(DateTime, nullable=True)


class TwitterGnipRules(Base):
    __tablename__ = 'TwitterGnipRules'

    # Columns
    ID = Column(BigInteger, primary_key=True, autoincrement=True)
    SettingID = Column(BigInteger, nullable=False)
    GnipQuery = Column(Text, nullable=True)
    GnipTagID = Column(String(100), nullable=True)
    GnipReturnID = Column(String(100), nullable=True)
    InsertedDate = Column(DateTime, default=func.getutcdate(), nullable=False)
    UpdatedDate = Column(DateTime, nullable=True)
    RuleType = Column(Integer, nullable=True)


class InfluencerDetails(Base):
    __tablename__ = 'InfluencerDetails'

    ID = Column(BigInteger, primary_key=True, autoincrement=True)
    InfluencerName = Column(String(100), nullable=False)
    InfluencerHandle = Column(String(100), nullable=False)
    Influencercategory = Column(String(200), nullable=True)
    FollowersCount = Column(String(15), nullable=True)
    IsDeleted = Column(Boolean, default=False, nullable=True)
    InsertionDate = Column(DateTime, default=func.utc_timestamp(), nullable=True)
    TwitterUID = Column(String(50), nullable=True)
