from enum import Enum


class ElType(Enum):
	"""Enumeration of the element types in Archicad."""

	WALL = "Wall"
	COLUMN = "Column"
	BEAM = "Beam"
	WINDOW = "Window"
	DOOR = "Door"
	OBJECT = "Object"
	LAMP = "Lamp"
	SLAB = "Slab"
	ROOF = "Roof"
	MESH = "Mesh"
	DIMENSION = "Dimension"
	RADIALDIMENSION = "RadialDimension"
	LEVELDIMENSION = "LevelDimension"
	ANGLEDIMENSION = "AngleDimension"
	TEXT = "Text"
	LABEL = "Label"
	ZONE = "Zone"
	HATCH = "Hatch"
	LINE = "Line"
	POLYLINE = "PolyLine"
	ARC = "Arc"
	CIRCLE = "Circle"
	SPLINE = "Spline"
	HOTSPOT = "Hotspot"
	CUTPLANE = "CutPlane"
	CAMERA = "Camera"
	CAMSET = "CamSet"
	GROUP = "Group"
	SECTELEM = "SectElem"
	DRAWING = "Drawing"
	PICTURE = "Picture"
	DETAIL = "Detail"
	ELEVATION = "Elevation"
	INTERIORELEVATION = "InteriorElevation"
	WORKSHEET = "Worksheet"
	HOTLINK = "Hotlink"
	CURTAINWALL = "CurtainWall"
	CURTAINWALLSEGMENT = "CurtainWallSegment"
	CURTAINWALLFRAME = "CurtainWallFrame"
	CURTAINWALLPANEL = "CurtainWallPanel"
	CURTAINWALLJUNCTION = "CurtainWallJunction"
	CURTAINWALLACCESSORY = "CurtainWallAccessory"
	SHELL = "Shell"
	SKYLIGHT = "Skylight"
	MORPH = "Morph"
	CHANGEMARKER = "ChangeMarker"
	STAIR = "Stair"
	RISER = "Riser"
	TREAD = "Tread"
	STAIRSTRUCTURE = "StairStructure"
	RAILING = "Railing"
	RAILINGTOPRAIL = "RailingToprail"
	RAILINGHANDRAIL = "RailingHandrail"
	RAILINGRAIL = "RailingRail"
	RAILINGPOST = "RailingPost"
	RAILINGINNERPOST = "RailingInnerPost"
	RAILINGBALUSTER = "RailingBaluster"
	RAILINGPANEL = "RailingPanel"
	RAILINGSEGMENT = "RailingSegment"
	RAILINGNODE = "RailingNode"
	RAILINGBALUSTERSET = "RailingBalusterSet"
	RAILINGPATTERN = "RailingPattern"
	RAILINGTOPRAILEND = "RailingToprailEnd"
	RAILINGHANDRAILEND = "RailingHandrailEnd"
	RAILINGRAILEND = "RailingRailEnd"
	RAILINGTOPRAILCONNECTION = "RailingToprailConnection"
	RAILINGHANDRAILCONNECTION = "RailingHandrailConnection"
	RAILINGRAILCONNECTION = "RailingRailConnection"
	RAILINGENDFINISH = "RailingEndFinish"
	BEAMSEGMENT = "BeamSegment"
	COLUMNSEGMENT = "ColumnSegment"
	OPENING = "Opening"
	UNKNOWN = "Unknown"


class Filter(Enum):
	"""Enumeration of supported filter fields."""

	# built-ins
	ID = "ID"
	PARENT_ID = "parent_ID"
	HL_ID = "HL_ID"
	HLE_ID = "HLE_ID"
	LAYER = "layer"
	GUID = "GUID"
	ELEMENT_TYPE = "element_type"

	PROPERTY = "property"

	# geometry
	# LENGTH = "length"
	# HEIGHT = "heigth"
