# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-05-10 20:33
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import oscar.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ('wellsfargo', '0002_transfermetadata_credentials'),
    ]

    operations = [
        migrations.CreateModel(
            name='AccountInquiryResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('I0', 'Account Inquiry Succeeded'), ('I1', 'Could Not Find Requested Account'), ('I2', 'Wells Fargo System Error')], max_length=2, verbose_name='Status')),
                ('last4_account_number', models.CharField(max_length=4, verbose_name='Last 4 digits of account number')),
                ('first_name', models.CharField(max_length=50, verbose_name='First Name')),
                ('middle_initial', models.CharField(max_length=1, verbose_name='Middle Initial')),
                ('last_name', models.CharField(max_length=50, verbose_name='Last Name')),
                ('phone_number', oscar.models.fields.PhoneNumberField(verbose_name='Phone Number')),
                ('address', models.CharField(max_length=100, verbose_name='Last 4 digits of account number')),
                ('credit_limit', models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Account Credit Limit')),
                ('balance', models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Current Account Balance')),
                ('open_to_buy', models.DecimalField(decimal_places=2, max_digits=12, verbose_name='Current Available Credit')),
                ('last_payment_date', models.DateField(null=True, verbose_name='Last Payment Date')),
                ('last_payment_amount', models.DecimalField(decimal_places=2, max_digits=12, null=True, verbose_name='Last Payment Amount')),
                ('payment_due_date', models.DateField(null=True, verbose_name='Payment Due Date')),
                ('payment_due_amount', models.DecimalField(decimal_places=2, max_digits=12, null=True, verbose_name='Payment Due on Account')),
                ('created_datetime', models.DateTimeField(auto_now_add=True)),
                ('modified_datetime', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ('-created_datetime', '-id'),
            },
        ),
        migrations.AlterModelOptions(
            name='cacreditapp',
            options={},
        ),
        migrations.AlterModelOptions(
            name='cajointcreditapp',
            options={},
        ),
        migrations.AlterModelOptions(
            name='uscreditapp',
            options={},
        ),
        migrations.AlterModelOptions(
            name='usjointcreditapp',
            options={},
        ),
        migrations.AddField(
            model_name='apicredentials',
            name='name',
            field=models.CharField(default='Default', max_length=200, verbose_name='Merchant Name'),
        ),
        migrations.AddField(
            model_name='cacreditapp',
            name='application_source',
            field=models.CharField(default='Website', help_text='Where/how is user applying? E.g. Website, Call Center, In-Store, etc.', max_length=25, verbose_name='Application Source'),
        ),
        migrations.AddField(
            model_name='cacreditapp',
            name='credentials',
            field=models.ForeignKey(blank=True, help_text='Which merchant account submitted this application?', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wellsfargo.APICredentials', verbose_name='Merchant'),
        ),
        migrations.AddField(
            model_name='cajointcreditapp',
            name='application_source',
            field=models.CharField(default='Website', help_text='Where/how is user applying? E.g. Website, Call Center, In-Store, etc.', max_length=25, verbose_name='Application Source'),
        ),
        migrations.AddField(
            model_name='cajointcreditapp',
            name='credentials',
            field=models.ForeignKey(blank=True, help_text='Which merchant account submitted this application?', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wellsfargo.APICredentials', verbose_name='Merchant'),
        ),
        migrations.AddField(
            model_name='uscreditapp',
            name='application_source',
            field=models.CharField(default='Website', help_text='Where/how is user applying? E.g. Website, Call Center, In-Store, etc.', max_length=25, verbose_name='Application Source'),
        ),
        migrations.AddField(
            model_name='uscreditapp',
            name='credentials',
            field=models.ForeignKey(blank=True, help_text='Which merchant account submitted this application?', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wellsfargo.APICredentials', verbose_name='Merchant'),
        ),
        migrations.AddField(
            model_name='usjointcreditapp',
            name='application_source',
            field=models.CharField(default='Website', help_text='Where/how is user applying? E.g. Website, Call Center, In-Store, etc.', max_length=25, verbose_name='Application Source'),
        ),
        migrations.AddField(
            model_name='usjointcreditapp',
            name='credentials',
            field=models.ForeignKey(blank=True, help_text='Which merchant account submitted this application?', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wellsfargo.APICredentials', verbose_name='Merchant'),
        ),
        migrations.AlterField(
            model_name='cacreditapp',
            name='user',
            field=models.ForeignKey(blank=True, help_text='Select the user user who is applying and who will own (be the primary user of) this account.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Owner'),
        ),
        migrations.AlterField(
            model_name='cajointcreditapp',
            name='user',
            field=models.ForeignKey(blank=True, help_text='Select the user user who is applying and who will own (be the primary user of) this account.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Owner'),
        ),
        migrations.AlterField(
            model_name='uscreditapp',
            name='user',
            field=models.ForeignKey(blank=True, help_text='Select the user user who is applying and who will own (be the primary user of) this account.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Owner'),
        ),
        migrations.AlterField(
            model_name='usjointcreditapp',
            name='user',
            field=models.ForeignKey(blank=True, help_text='Select the user user who is applying and who will own (be the primary user of) this account.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='Owner'),
        ),
        migrations.AddField(
            model_name='cacreditapp',
            name='inquiries',
            field=models.ManyToManyField(related_name='_cacreditapp_inquiries_+', to='wellsfargo.AccountInquiryResult', verbose_name='Account Inquiries'),
        ),
        migrations.AddField(
            model_name='cajointcreditapp',
            name='inquiries',
            field=models.ManyToManyField(related_name='_cajointcreditapp_inquiries_+', to='wellsfargo.AccountInquiryResult', verbose_name='Account Inquiries'),
        ),
        migrations.AddField(
            model_name='uscreditapp',
            name='inquiries',
            field=models.ManyToManyField(related_name='_uscreditapp_inquiries_+', to='wellsfargo.AccountInquiryResult', verbose_name='Account Inquiries'),
        ),
        migrations.AddField(
            model_name='usjointcreditapp',
            name='inquiries',
            field=models.ManyToManyField(related_name='_usjointcreditapp_inquiries_+', to='wellsfargo.AccountInquiryResult', verbose_name='Account Inquiries'),
        ),
    ]
