
# import statement needed on some systems
import sys
import os.path
import inspect
try: 
  _filename = inspect.getframeinfo(inspect.currentframe()).filename
except:
  _filename = __file__
_path = os.path.dirname(os.path.abspath(_filename))
if not _path in sys.path:
  sys.path.append(_path)

# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _libnuml
else:
    import _libnuml

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class ModelCreatorList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libnuml.ModelCreatorList_swiginit(self, _libnuml.new_ModelCreatorList())
    __swig_destroy__ = _libnuml.delete_ModelCreatorList

    def add(self, item):
        return _libnuml.ModelCreatorList_add(self, item)

    def get(self, n):
        return _libnuml.ModelCreatorList_get(self, n)

    def prepend(self, item):
        return _libnuml.ModelCreatorList_prepend(self, item)

    def remove(self, n):
        return _libnuml.ModelCreatorList_remove(self, n)

    def getSize(self):
        return _libnuml.ModelCreatorList_getSize(self)

# Register ModelCreatorList in _libnuml:
_libnuml.ModelCreatorList_swigregister(ModelCreatorList)
class DateList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libnuml.DateList_swiginit(self, _libnuml.new_DateList())
    __swig_destroy__ = _libnuml.delete_DateList

    def add(self, item):
        return _libnuml.DateList_add(self, item)

    def get(self, n):
        return _libnuml.DateList_get(self, n)

    def prepend(self, item):
        return _libnuml.DateList_prepend(self, item)

    def remove(self, n):
        return _libnuml.DateList_remove(self, n)

    def getSize(self):
        return _libnuml.DateList_getSize(self)

# Register DateList in _libnuml:
_libnuml.DateList_swigregister(DateList)
class CVTermList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libnuml.CVTermList_swiginit(self, _libnuml.new_CVTermList())
    __swig_destroy__ = _libnuml.delete_CVTermList

    def add(self, item):
        return _libnuml.CVTermList_add(self, item)

    def get(self, n):
        return _libnuml.CVTermList_get(self, n)

    def prepend(self, item):
        return _libnuml.CVTermList_prepend(self, item)

    def remove(self, n):
        return _libnuml.CVTermList_remove(self, n)

    def getSize(self):
        return _libnuml.CVTermList_getSize(self)

# Register CVTermList in _libnuml:
_libnuml.CVTermList_swigregister(CVTermList)
class ASTNodeList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _libnuml.ASTNodeList_swiginit(self, _libnuml.new_ASTNodeList())
    __swig_destroy__ = _libnuml.delete_ASTNodeList

    def add(self, item):
        return _libnuml.ASTNodeList_add(self, item)

    def get(self, n):
        return _libnuml.ASTNodeList_get(self, n)

    def prepend(self, item):
        return _libnuml.ASTNodeList_prepend(self, item)

    def remove(self, n):
        return _libnuml.ASTNodeList_remove(self, n)

    def getSize(self):
        return _libnuml.ASTNodeList_getSize(self)

# Register ASTNodeList in _libnuml:
_libnuml.ASTNodeList_swigregister(ASTNodeList)


class AutoProperty(type):
    """
    Auto-detect Python class getX/setX methods.

    This class is attached to SBase and automatically applies for all classes
    which inherit from it.  Its purpose is to make libNUML more convenient to
    use from Python.  It works by analyzing classes at class creation time
    (not at instantiation) and adding corresponding properties (directly
    calling C methods where possible) to the class dictionary.

    @note The code should work for python 2.6 upwards, however for python 3 it 
          needs to be attached via constructors.
    """
    def __new__(cls, classname, bases, classdict):
        """
        Iterate over the items in the classdict looking for get/set pairs
        and declaring them as properties.
        """

        import re
        import keyword
        import inspect

        re_mangle = re.compile(r'[A-Za-z][a-z]+|[A-Z]+(?=$|[A-Z0-9])|\d+')
        re_id = re.compile(r'^[A-Za-z_][A-Za-z0-9_]*$')
        re_getdoc = re.compile(r'^\s*[A-Za-z_][A-Za-z0-9_]*\(self\)')
        re_setdoc = re.compile(r'^\s*[A-Za-z_][A-Za-z0-9_]*\(self,[^,)]+\)')

#convert ACapitalCasedStringXYZ123 -> a_capital_cased_string_xyz_123
        mangle_name = lambda x: ('_'.join(re_mangle.findall(x))).lower()

        get_methods = set()
        set_methods = set()
        swig_setter = classdict.get('__swig_setmethods__', {})

        allowed_methods = [
                           'Annotation', 
                           'AnnotationString', 
                           'Notes', 
                           'NotesString', 
                           ]

#only search for get/set methods
#we assume that any unset method also has either get or set
#a small number of set without get cases exist so we can't only
#search for get methods
        for k, v in classdict.items():
            name = k[3:]
            prefix = k[:3]
            mangled = mangle_name(name)
            if name:
                if callable(v):
                    if re_id.match(mangled) and mangled not in keyword.kwlist:
                        if prefix == 'get':
                            get_methods.add(name)
                        elif prefix == 'set':
                            set_methods.add(name)

        for name in get_methods | set_methods:

            mangled = mangle_name(name)

#ListOfFoobars -> foobars
            if mangled.startswith('list_of_'):
                mangled = mangled[8:]

            getter = setter = deleter = None
            if name in get_methods:
                getter = classdict['get'+name]

#this is a very dirty way of checking if the get method
#requires extra arguments (and hence cannot be a property)
#it should be possible to do this properly in SWIG?
                try:
                  argspec = inspect.getargspec(getter)
                  numargs = len(argspec.args)
                  if numargs > 1 or (numargs == 1 and argspec.args[0] != 'self')  \
                    or (argspec.varargs!=None and name not in allowed_methods and not name.startswith('ListOf') ):
                    continue
                except:
                  continue

#use the c-level get function if the python function
#only consists of a call to it
                cname = classname + '_get' + name
#test if function is "return _libnuml.CLASS_getNAME(__args__)"
                try:
                  if getter.func_code.co_names == ('_libnuml', cname):
                    getter = getattr(_libnuml, cname)
                except:
                  if getter.__code__.co_names == ('_libnuml', cname):
                    getter = getattr(_libnuml, cname)

            if name in set_methods:
                setter = classdict['set'+name]
                try:
                 argspec = inspect.getargspec(getter)
                 numargs = len(argspec.args)
                 if numargs > 1 and argspec.args[0] == 'self':
                   cname = classname + '_set' + name
                   try:
                     if setter.func_code.co_names == ('_libnuml', cname):
                         setter = getattr(_libnuml, cname)
                   except:
                     if setter.__code__.co_names == ('_libnuml', cname):
                         setter = getattr(_libnuml, cname)

#property fget does not get intercepted by __getattr__
#but fset does, so we implement property setting via
#the __swig_setmethods__ dict
                   swig_setter[mangled] = setter
                   continue
                except:
                  pass

            if 'unset' + name in classdict:
                deleter = classdict['unset'+name]

                try:
                  argspec = inspect.getargspec(getter)
                  numargs = len(argspec.args)
                  if numargs == 1 and argspec.args[0] == 'self' and \
                    (argspec.varargs==None or name in allowed_methods):
                    cname = classname + '_unset' + name
                    try:
                      if deleter.func_code.co_names == ('_libnuml', cname):
                          deleter = getattr(_libnuml, cname)                    
                    except:
                      if deleter.__code__.co_names == ('_libnuml', cname):
                          deleter = getattr(_libnuml, cname)                    
                except:
                  pass

            if getter or setter or deleter:
#fset is technically redundant since the method is dispatched
#via _swig_setattr rather than through the property due to that
#function not delegating to object.__setattr__ which properly
#handles properties
                classdict[mangled] = property(fget=getter, fset=setter, fdel=deleter)

            def __repr__(self):
                desc = self.__class__.__name__
                if hasattr(self, '__len__'):
                    desc += '[%s]' % self.__len__()
                if hasattr(self, 'id') and self.id:
                    desc += ' %s' % self.id
                if hasattr(self, 'name') and self.name:
                    desc += ' "%s"' % self.name
                return '<' + desc + '>'

            if classdict.get('__repr__', None) in (_swig_repr, None):
                classdict['__repr__'] = __repr__


        return type.__new__(cls, classname, bases, classdict)


class SwigPyIterator(object):
    r"""Proxy of C++ swig::SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_SwigPyIterator

    def value(self):
        r"""value(SwigPyIterator self) -> PyObject *"""
        return _libnuml.SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _libnuml.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _libnuml.SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _libnuml.SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _libnuml.SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(SwigPyIterator self) -> SwigPyIterator"""
        return _libnuml.SwigPyIterator_copy(self)

    def next(self):
        r"""next(SwigPyIterator self) -> PyObject *"""
        return _libnuml.SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(SwigPyIterator self) -> PyObject *"""
        return _libnuml.SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(SwigPyIterator self) -> PyObject *"""
        return _libnuml.SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _libnuml.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _libnuml.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _libnuml.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _libnuml.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _libnuml.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _libnuml.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _libnuml.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _libnuml:
_libnuml.SwigPyIterator_swigregister(SwigPyIterator)
class string(object):
    r"""Proxy of C++ std::basic_string< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def length(self):
        r"""length(string self) -> std::basic_string< char >::size_type"""
        return _libnuml.string_length(self)

    def max_size(self):
        r"""max_size(string self) -> std::basic_string< char >::size_type"""
        return _libnuml.string_max_size(self)

    def shrink_to_fit(self):
        r"""shrink_to_fit(string self)"""
        return _libnuml.string_shrink_to_fit(self)

    def copy(self, __s, __n, __pos=0):
        r"""copy(string self, char * __s, std::basic_string< char >::size_type __n, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type"""
        return _libnuml.string_copy(self, __s, __n, __pos)

    def c_str(self):
        r"""c_str(string self) -> char const *"""
        return _libnuml.string_c_str(self)

    def find(self, *args):
        r"""
        find(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libnuml.string_find(self, *args)

    def rfind(self, *args):
        r"""
        rfind(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        rfind(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        rfind(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libnuml.string_rfind(self, *args)

    def find_first_of(self, *args):
        r"""
        find_first_of(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find_first_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_first_of(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libnuml.string_find_first_of(self, *args)

    def find_last_of(self, *args):
        r"""
        find_last_of(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        find_last_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_last_of(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libnuml.string_find_last_of(self, *args)

    def find_first_not_of(self, *args):
        r"""
        find_first_not_of(string self, string __str, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        find_first_not_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_first_not_of(string self, char __c, std::basic_string< char >::size_type __pos=0) -> std::basic_string< char >::size_type
        """
        return _libnuml.string_find_first_not_of(self, *args)

    def find_last_not_of(self, *args):
        r"""
        find_last_not_of(string self, string __str, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        find_last_not_of(string self, char const * __s, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> std::basic_string< char >::size_type
        find_last_not_of(string self, char __c, std::basic_string< char >::size_type __pos=std::basic_string< char >::npos) -> std::basic_string< char >::size_type
        """
        return _libnuml.string_find_last_not_of(self, *args)

    def substr(self, *args):
        r"""substr(string self, std::basic_string< char >::size_type __pos=0, std::basic_string< char >::size_type __n=std::basic_string< char >::npos) -> string"""
        return _libnuml.string_substr(self, *args)

    def empty(self):
        r"""empty(string self) -> bool"""
        return _libnuml.string_empty(self)

    def size(self):
        r"""size(string self) -> std::basic_string< char >::size_type"""
        return _libnuml.string_size(self)

    def swap(self, v):
        r"""swap(string self, string v)"""
        return _libnuml.string_swap(self, v)

    def erase(self, *args):
        r"""
        erase(string self, std::basic_string< char >::size_type __pos=0, std::basic_string< char >::size_type __n=std::basic_string< char >::npos) -> string
        erase(string self, std::basic_string< char >::iterator pos) -> std::basic_string< char >::iterator
        erase(string self, std::basic_string< char >::iterator first, std::basic_string< char >::iterator last) -> std::basic_string< char >::iterator
        """
        return _libnuml.string_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(string self, char const * __s, std::basic_string< char >::size_type __n) -> string
        __init__(string self) -> string
        __init__(string self, string other) -> string
        __init__(string self, std::basic_string< char >::size_type size, std::basic_string< char >::value_type value) -> string
        """
        _libnuml.string_swiginit(self, _libnuml.new_string(*args))

    def assign(self, *args):
        r"""
        assign(string self, string __str) -> string
        assign(string self, string __str, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n) -> string
        assign(string self, char const * __s, std::basic_string< char >::size_type __n) -> string
        assign(string self, std::basic_string< char >::size_type n, std::basic_string< char >::value_type x)
        """
        return _libnuml.string_assign(self, *args)

    def resize(self, *args):
        r"""
        resize(string self, std::basic_string< char >::size_type new_size)
        resize(string self, std::basic_string< char >::size_type new_size, std::basic_string< char >::value_type x)
        """
        return _libnuml.string_resize(self, *args)

    def iterator(self):
        r"""iterator(string self) -> SwigPyIterator"""
        return _libnuml.string_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(string self) -> bool"""
        return _libnuml.string___nonzero__(self)

    def __bool__(self):
        r"""__bool__(string self) -> bool"""
        return _libnuml.string___bool__(self)

    def __len__(self):
        r"""__len__(string self) -> std::basic_string< char >::size_type"""
        return _libnuml.string___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j) -> string"""
        return _libnuml.string___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j)
        __setslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j, string v)
        """
        return _libnuml.string___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::difference_type j)"""
        return _libnuml.string___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(string self, std::basic_string< char >::difference_type i)
        __delitem__(string self, SWIGPY_SLICEOBJECT * slice)
        """
        return _libnuml.string___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(string self, SWIGPY_SLICEOBJECT * slice) -> string
        __getitem__(string self, std::basic_string< char >::difference_type i) -> std::basic_string< char >::value_type
        """
        return _libnuml.string___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(string self, SWIGPY_SLICEOBJECT * slice, string v)
        __setitem__(string self, SWIGPY_SLICEOBJECT * slice)
        __setitem__(string self, std::basic_string< char >::difference_type i, std::basic_string< char >::value_type x)
        """
        return _libnuml.string___setitem__(self, *args)

    def insert(self, *args):
        r"""
        insert(string self, std::basic_string< char >::size_type __pos1, string __str) -> string
        insert(string self, std::basic_string< char >::size_type __pos1, string __str, std::basic_string< char >::size_type __pos2, std::basic_string< char >::size_type __n) -> string
        insert(string self, std::basic_string< char >::size_type __pos, char const * __s, std::basic_string< char >::size_type __n) -> string
        insert(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n, char __c) -> string
        insert(string self, std::basic_string< char >::iterator pos, std::basic_string< char >::value_type x) -> std::basic_string< char >::iterator
        insert(string self, std::basic_string< char >::iterator pos, std::basic_string< char >::size_type n, std::basic_string< char >::value_type x)
        insert(string self, std::basic_string< char >::iterator __p, std::basic_string< char >::size_type __n, char __c)
        """
        return _libnuml.string_insert(self, *args)

    def replace(self, *args):
        r"""
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n, string __str) -> string
        replace(string self, std::basic_string< char >::size_type __pos1, std::basic_string< char >::size_type __n1, string __str, std::basic_string< char >::size_type __pos2, std::basic_string< char >::size_type __n2) -> string
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n1, char const * __s, std::basic_string< char >::size_type __n2) -> string
        replace(string self, std::basic_string< char >::size_type __pos, std::basic_string< char >::size_type __n1, std::basic_string< char >::size_type __n2, char __c) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, string __str) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, char const * __s, std::basic_string< char >::size_type __n) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, std::basic_string< char >::size_type __n, char __c) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, char const * __k1, char const * __k2) -> string
        replace(string self, std::basic_string< char >::iterator __i1, std::basic_string< char >::iterator __i2, std::basic_string< char >::const_iterator __k1, std::basic_string< char >::const_iterator __k2) -> string
        """
        return _libnuml.string_replace(self, *args)

    def __iadd__(self, v):
        r"""__iadd__(string self, string v) -> string"""
        return _libnuml.string___iadd__(self, v)

    def __add__(self, v):
        r"""__add__(string self, string v) -> string"""
        return _libnuml.string___add__(self, v)

    def __radd__(self, v):
        r"""__radd__(string self, string v) -> string"""
        return _libnuml.string___radd__(self, v)

    def __str__(self):
        r"""__str__(string self) -> string"""
        return _libnuml.string___str__(self)

    def __rlshift__(self, out):
        r"""__rlshift__(string self, ostream out) -> ostream"""
        return _libnuml.string___rlshift__(self, out)

    def __eq__(self, v):
        r"""__eq__(string self, string v) -> bool"""
        return _libnuml.string___eq__(self, v)

    def __ne__(self, v):
        r"""__ne__(string self, string v) -> bool"""
        return _libnuml.string___ne__(self, v)

    def __gt__(self, v):
        r"""__gt__(string self, string v) -> bool"""
        return _libnuml.string___gt__(self, v)

    def __lt__(self, v):
        r"""__lt__(string self, string v) -> bool"""
        return _libnuml.string___lt__(self, v)

    def __ge__(self, v):
        r"""__ge__(string self, string v) -> bool"""
        return _libnuml.string___ge__(self, v)

    def __le__(self, v):
        r"""__le__(string self, string v) -> bool"""
        return _libnuml.string___le__(self, v)
    __swig_destroy__ = _libnuml.delete_string

# Register string in _libnuml:
_libnuml.string_swigregister(string)
cvar = _libnuml.cvar
string.npos = _libnuml.cvar.string_npos

class ostream(object):
    r"""Proxy of C++ std::basic_ostream< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, __sb):
        r"""__init__(ostream self, std::basic_streambuf< char,std::char_traits< char > > * __sb) -> ostream"""
        _libnuml.ostream_swiginit(self, _libnuml.new_ostream(__sb))
    __swig_destroy__ = _libnuml.delete_ostream

# Register ostream in _libnuml:
_libnuml.ostream_swigregister(ostream)
class ostringstream(ostream):
    r"""Proxy of C++ std::basic_ostringstream< char > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(ostringstream self, std::ios_base::openmode __mode=std::ios_base::out) -> ostringstream"""
        _libnuml.ostringstream_swiginit(self, _libnuml.new_ostringstream(*args))
    __swig_destroy__ = _libnuml.delete_ostringstream

    def str(self, *args):
        r"""
        str(ostringstream self) -> string
        str(ostringstream self, string __s)
        """
        return _libnuml.ostringstream_str(self, *args)

# Register ostringstream in _libnuml:
_libnuml.ostringstream_swigregister(ostringstream)

def endl(arg1):
    r"""endl(ostream arg1) -> ostream"""
    return _libnuml.endl(arg1)

def flush(arg1):
    r"""flush(ostream arg1) -> ostream"""
    return _libnuml.flush(arg1)

import sys
import os.path

# @cond doxygen-libnuml-internal

def conditional_abspath (filename):
  """conditional_abspath (filename) -> filename

  Returns filename with an absolute path prepended, if necessary.
  Some combinations of platforms and underlying XML parsers *require*
  an absolute path to a filename while others do not.  This function
  encapsulates the appropriate logic.  It is used by readNUML() and
  NUMLReader.readNUML().
  """
  if sys.platform.find('cygwin') != -1:
    return filename
  else:
    return os.path.abspath(filename)

# @endcond


def readNUML(*args):
  """
  readNUML(self, string filename) -> NUMLDocument

  Reads an NUML document from a file.

  This method is identical to readNUMLFromFile().

  If the file named 'filename' does not exist or its content is not
  valid NUML, one or more errors will be logged with the NUMLDocument
  object returned by this method.  Callers can use the methods on
  NUMLDocument such as NUMLDocument.getNumErrors() and
  NUMLDocument.getError() to get the errors.  The object returned by
  NUMLDocument.getError() is an NUMLError object, and it has methods to
  get the error code, category, and severity level of the problem, as
  well as a textual description of the problem.  The possible severity
  levels range from informational messages to fatal errors; see the
  documentation for NUMLError for more information.

  If the file 'filename' could not be read, the file-reading error will
  appear first.  The error code can provide a clue about what happened.
  For example, a file might be unreadable (either because it does not
  actually exist or because the user does not have the necessary access
  priviledges to read it) or some sort of file operation error may have
  been reported by the underlying operating system.  Callers can check
  for these situations using a program fragment such as the following:

   reader = NUMLReader()
   doc    = reader.readNUML(filename)

   if doc.getNumErrors() > 0:
     if doc.getError(0).getErrorId() == libnuml.XMLFileUnreadable:
# Handle case of unreadable file here.
     elif doc.getError(0).getErrorId() == libnuml.XMLFileOperationError:
# Handle case of other file error here.
     else:
# Handle other error cases here.

  If the given filename ends with the suffix \".gz\" (for example,
  \"myfile.xml.gz\"), the file is assumed to be compressed in gzip format
  and will be automatically decompressed upon reading.  Similarly, if the
  given filename ends with \".zip\" or \".bz2\", the file is assumed to be
  compressed in zip or bzip2 format (respectively).  Files whose names
  lack these suffixes will be read uncompressed.  Note that if the file
  is in zip format but the archive contains more than one file, only the
  first file in the archive will be read and the rest ignored.

  To read a gzip/zip file, libNUML needs to be configured and linked with
  the zlib library at compile time.  It also needs to be linked with the
  bzip2 library to read files in bzip2 format.  (Both of these are the
  default configurations for libNUML.)  Errors about unreadable files
  will be logged if a compressed filename is given and libNUML was not
  linked with the corresponding required library.

  Parameter 'filename is the name or full pathname of the file to be
  read.

  Returns a pointer to the NUMLDocument created from the NUML content.

  See also NUMLError.

  Note:

  LibNUML versions 2.x and later versions behave differently in
  error handling in several respects.  One difference is how early some
  errors are caught and whether libNUML continues processing a file in
  the face of some early errors.  In general, libNUML versions after 2.x
  stop parsing NUML inputs sooner than libNUML version 2.x in the face
  of XML errors, because the errors may invalidate any further NUML
  content.  For example, a missing XML declaration at the beginning of
  the file was ignored by libNUML 2.x but in version 3.x and later, it
  will cause libNUML to stop parsing the rest of the input altogether.
  While this behavior may seem more severe and intolerant, it was
  necessary in order to provide uniform behavior regardless of which
  underlying XML parser (Expat, Xerces, libxml2) is being used by
  libNUML.  The XML parsers themselves behave differently in their error
  reporting, and sometimes libNUML has to resort to the lowest common
  denominator.
  """
  reader = NUMLReader()
  return reader.readNUML(args[0])

LIBNUML_DOTTED_VERSION = _libnuml.LIBNUML_DOTTED_VERSION

LIBNUML_VERSION = _libnuml.LIBNUML_VERSION

LIBNUML_VERSION_STRING = _libnuml.LIBNUML_VERSION_STRING


def getLibNUMLVersion():
    r"""getLibNUMLVersion() -> int"""
    return _libnuml.getLibNUMLVersion()

def getLibNUMLDottedVersion():
    r"""getLibNUMLDottedVersion() -> char const *"""
    return _libnuml.getLibNUMLDottedVersion()

def getLibNUMLVersionString():
    r"""getLibNUMLVersionString() -> char const *"""
    return _libnuml.getLibNUMLVersionString()
LIBNUML_OPERATION_RETURN_VALUES_H = _libnuml.LIBNUML_OPERATION_RETURN_VALUES_H

LIBNUML_OPERATION_SUCCESS = _libnuml.LIBNUML_OPERATION_SUCCESS

LIBNUML_INDEX_EXCEEDS_SIZE = _libnuml.LIBNUML_INDEX_EXCEEDS_SIZE

LIBNUML_UNEXPECTED_ATTRIBUTE = _libnuml.LIBNUML_UNEXPECTED_ATTRIBUTE

LIBNUML_OPERATION_FAILED = _libnuml.LIBNUML_OPERATION_FAILED

LIBNUML_INVALID_ATTRIBUTE_VALUE = _libnuml.LIBNUML_INVALID_ATTRIBUTE_VALUE

LIBNUML_INVALID_OBJECT = _libnuml.LIBNUML_INVALID_OBJECT

LIBNUML_DUPLICATE_OBJECT_ID = _libnuml.LIBNUML_DUPLICATE_OBJECT_ID

LIBNUML_LEVEL_MISMATCH = _libnuml.LIBNUML_LEVEL_MISMATCH

LIBNUML_VERSION_MISMATCH = _libnuml.LIBNUML_VERSION_MISMATCH

LIBNUML_INVALID_XML_OPERATION = _libnuml.LIBNUML_INVALID_XML_OPERATION

LIBNUML_DUPLICATE_ANNOTATION_NS = _libnuml.LIBNUML_DUPLICATE_ANNOTATION_NS

LIBNUML_ANNOTATION_NAME_NOT_FOUND = _libnuml.LIBNUML_ANNOTATION_NAME_NOT_FOUND

LIBNUML_ANNOTATION_NS_NOT_FOUND = _libnuml.LIBNUML_ANNOTATION_NS_NOT_FOUND

class NUMLNamespaces(object):
    r"""Proxy of C++ NUMLNamespaces class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_NUMLNamespaces

    def __init__(self, *args):
        r"""
        __init__(NUMLNamespaces self, unsigned int level=NUML_DEFAULT_LEVEL, unsigned int version=NUML_DEFAULT_VERSION) -> NUMLNamespaces
        __init__(NUMLNamespaces self, NUMLNamespaces orig) -> NUMLNamespaces
        """
        _libnuml.NUMLNamespaces_swiginit(self, _libnuml.new_NUMLNamespaces(*args))

    def clone(self):
        r"""clone(NUMLNamespaces self) -> NUMLNamespaces"""
        return _libnuml.NUMLNamespaces_clone(self)

    @staticmethod
    def getNUMLNamespaceURI(level, version):
        r"""getNUMLNamespaceURI(unsigned int level, unsigned int version) -> string"""
        return _libnuml.NUMLNamespaces_getNUMLNamespaceURI(level, version)

    def getLevel(self):
        r"""getLevel(NUMLNamespaces self) -> unsigned int"""
        return _libnuml.NUMLNamespaces_getLevel(self)

    def getVersion(self):
        r"""getVersion(NUMLNamespaces self) -> unsigned int"""
        return _libnuml.NUMLNamespaces_getVersion(self)

    def getNamespaces(self):
        r"""getNamespaces(NUMLNamespaces self) -> XMLNamespaces"""
        return _libnuml.NUMLNamespaces_getNamespaces(self)

    def addNamespaces(self, xmlns):
        r"""addNamespaces(NUMLNamespaces self, XMLNamespaces xmlns)"""
        return _libnuml.NUMLNamespaces_addNamespaces(self, xmlns)

    __metaclass__ = AutoProperty


    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register NUMLNamespaces in _libnuml:
_libnuml.NUMLNamespaces_swigregister(NUMLNamespaces)
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog
NUML_DEFAULT_LEVEL = cvar.NUML_DEFAULT_LEVEL
NUML_DEFAULT_VERSION = cvar.NUML_DEFAULT_VERSION
NUML_XMLNS_L1 = cvar.NUML_XMLNS_L1
NUML_XMLNS_L1V1 = cvar.NUML_XMLNS_L1V1

class NUMLReader(object):
    r"""Proxy of C++ NUMLReader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(NUMLReader self) -> NUMLReader"""
        _libnuml.NUMLReader_swiginit(self, _libnuml.new_NUMLReader())
    __swig_destroy__ = _libnuml.delete_NUMLReader

    def readNUML(*args):
      """
      readNUML(self, string filename) -> NUMLDocument

      Reads an NUML document from a file.

      This method is identical to readNUMLFromFile().

      If the file named 'filename' does not exist or its content is not
      valid NUML, one or more errors will be logged with the NUMLDocument
      object returned by this method.  Callers can use the methods on
      NUMLDocument such as NUMLDocument.getNumErrors() and
      NUMLDocument.getError() to get the errors.  The object returned by
      NUMLDocument.getError() is an NUMLError object, and it has methods to
      get the error code, category, and severity level of the problem, as
      well as a textual description of the problem.  The possible severity
      levels range from informational messages to fatal errors; see the
      documentation for NUMLError for more information.

      If the file 'filename' could not be read, the file-reading error will
      appear first.  The error code can provide a clue about what happened.
      For example, a file might be unreadable (either because it does not
      actually exist or because the user does not have the necessary access
      priviledges to read it) or some sort of file operation error may have
      been reported by the underlying operating system.  Callers can check
      for these situations using a program fragment such as the following:

       reader = NUMLReader()
       doc    = reader.readNUML(filename)

       if doc.getNumErrors() > 0:
         if doc.getError(0).getErrorId() == libnuml.XMLFileUnreadable:
    # Handle case of unreadable file here.
         elif doc.getError(0).getErrorId() == libnuml.XMLFileOperationError:
    # Handle case of other file error here.
         else:
    # Handle other error cases here.

      If the given filename ends with the suffix \".gz\" (for example,
      \"myfile.xml.gz\"), the file is assumed to be compressed in gzip format
      and will be automatically decompressed upon reading.  Similarly, if the
      given filename ends with \".zip\" or \".bz2\", the file is assumed to be
      compressed in zip or bzip2 format (respectively).  Files whose names
      lack these suffixes will be read uncompressed.  Note that if the file
      is in zip format but the archive contains more than one file, only the
      first file in the archive will be read and the rest ignored.

      To read a gzip/zip file, libNUML needs to be configured and linked with
      the zlib library at compile time.  It also needs to be linked with the
      bzip2 library to read files in bzip2 format.  (Both of these are the
      default configurations for libNUML.)  Errors about unreadable files
      will be logged if a compressed filename is given and libNUML was not
      linked with the corresponding required library.

      Parameter 'filename is the name or full pathname of the file to be
      read.

      Returns a pointer to the NUMLDocument created from the NUML content.

      See also NUMLError.

      Note:

      LibNUML versions 2.x and later versions behave differently in
      error handling in several respects.  One difference is how early some
      errors are caught and whether libNUML continues processing a file in
      the face of some early errors.  In general, libNUML versions after 2.x
      stop parsing NUML inputs sooner than libNUML version 2.x in the face
      of XML errors, because the errors may invalidate any further NUML
      content.  For example, a missing XML declaration at the beginning of
      the file was ignored by libNUML 2.x but in version 3.x and later, it
      will cause libNUML to stop parsing the rest of the input altogether.
      While this behavior may seem more severe and intolerant, it was
      necessary in order to provide uniform behavior regardless of which
      underlying XML parser (Expat, Xerces, libxml2) is being used by
      libNUML.  The XML parsers themselves behave differently in their error
      reporting, and sometimes libNUML has to resort to the lowest common
      denominator.
      """
      args_copy    = list(args)
      args_copy[1] = conditional_abspath(args[1])
      return _libnuml.NUMLReader_readNUML(*args_copy)



    def readNUMLFromFile(*args):
      """
      readNUMLFromFile(self, string filename) -> NUMLDocument

      Reads an NUML document from a file.

      This method is identical to readNUMLFromFile().

      If the file named 'filename' does not exist or its content is not
      valid NUML, one or more errors will be logged with the NUMLDocument
      object returned by this method.  Callers can use the methods on
      NUMLDocument such as NUMLDocument.getNumErrors() and
      NUMLDocument.getError() to get the errors.  The object returned by
      NUMLDocument.getError() is an NUMLError object, and it has methods to
      get the error code, category, and severity level of the problem, as
      well as a textual description of the problem.  The possible severity
      levels range from informational messages to fatal errors; see the
      documentation for NUMLError for more information.

      If the file 'filename' could not be read, the file-reading error will
      appear first.  The error code can provide a clue about what happened.
      For example, a file might be unreadable (either because it does not
      actually exist or because the user does not have the necessary access
      priviledges to read it) or some sort of file operation error may have
      been reported by the underlying operating system.  Callers can check
      for these situations using a program fragment such as the following:

       reader = NUMLReader()
       doc    = reader.readNUML(filename)

       if doc.getNumErrors() > 0:
         if doc.getError(0).getErrorId() == libnuml.XMLFileUnreadable:
    # Handle case of unreadable file here.
         elif doc.getError(0).getErrorId() == libnuml.XMLFileOperationError:
    # Handle case of other file error here.
         else:
    # Handle other error cases here.

      If the given filename ends with the suffix \".gz\" (for example,
      \"myfile.xml.gz\"), the file is assumed to be compressed in gzip format
      and will be automatically decompressed upon reading.  Similarly, if the
      given filename ends with \".zip\" or \".bz2\", the file is assumed to be
      compressed in zip or bzip2 format (respectively).  Files whose names
      lack these suffixes will be read uncompressed.  Note that if the file
      is in zip format but the archive contains more than one file, only the
      first file in the archive will be read and the rest ignored.

      To read a gzip/zip file, libNUML needs to be configured and linked with
      the zlib library at compile time.  It also needs to be linked with the
      bzip2 library to read files in bzip2 format.  (Both of these are the
      default configurations for libNUML.)  Errors about unreadable files
      will be logged if a compressed filename is given and libNUML was not
      linked with the corresponding required library.

      Parameter 'filename is the name or full pathname of the file to be
      read.
      getElementName()
      Returns a pointer to the NUMLDocument created from the NUML content.

      See also NUMLError.

      Note:

      LibNUML versions 2.x and later versions behave differently in
      error handling in several respects.  One difference is how early some
      errors are caught and whether libNUML continues processing a file in
      the face of some early errors.  In general, libNUML versions after 2.x
      stop parsing NUML inputs sooner than libNUML version 2.x in the face
      of XML errors, because the errors may invalidate any further NUML
      content.  For example, a missing XML declaration at the beginning of
      the file was ignored by libNUML 2.x but in version 3.x and later, it
      will cause libNUML to stop parsing the rest of the input altogether.
      While this behavior may seem more severe and intolerant, it was
      necessary in order to provide uniform behavior regardless of which
      underlying XML parser (Expat, Xerces, libxml2) is being used by
      libNUML.  The XML parsers themselves behave differently in their error
      reporting, and sometimes libNUML has to resort to the lowest common
      denominator.
      """
      args_copy    = list(args)
      args_copy[1] = conditional_abspath(args[1])
      return _libnuml.NUMLReader_readNUML(*args_copy)



    def readNUMLFromString(self, xml):
        r"""readNUMLFromString(NUMLReader self, string xml) -> NUMLDocument"""
        return _libnuml.NUMLReader_readNUMLFromString(self, xml)

    @staticmethod
    def hasZlib():
        r"""hasZlib() -> bool"""
        return _libnuml.NUMLReader_hasZlib()

    @staticmethod
    def hasBzip2():
        r"""hasBzip2() -> bool"""
        return _libnuml.NUMLReader_hasBzip2()

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register NUMLReader in _libnuml:
_libnuml.NUMLReader_swigregister(NUMLReader)

def readNUMLFromFile(filename):
    r"""readNUMLFromFile(char const * filename) -> NUMLDocument"""
    return _libnuml.readNUMLFromFile(filename)

def readNUMLFromString(xml):
    r"""readNUMLFromString(char const * xml) -> NUMLDocument"""
    return _libnuml.readNUMLFromString(xml)
class NUMLWriter(object):
    r"""Proxy of C++ NUMLWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(NUMLWriter self) -> NUMLWriter"""
        _libnuml.NUMLWriter_swiginit(self, _libnuml.new_NUMLWriter())
    __swig_destroy__ = _libnuml.delete_NUMLWriter

    def setProgramName(self, name):
        r"""setProgramName(NUMLWriter self, string name) -> int"""
        return _libnuml.NUMLWriter_setProgramName(self, name)

    def setProgramVersion(self, version):
        r"""setProgramVersion(NUMLWriter self, string version) -> int"""
        return _libnuml.NUMLWriter_setProgramVersion(self, version)

    def writeNUML(self, *args):
        r"""
        writeNUML(NUMLWriter self, NUMLDocument d, string filename) -> bool
        writeNUML(NUMLWriter self, NUMLDocument d, ostream stream) -> bool
        """
        return _libnuml.NUMLWriter_writeNUML(self, *args)

    def writeToString(self, d):
        r"""writeToString(NUMLWriter self, NUMLDocument d) -> char *"""
        return _libnuml.NUMLWriter_writeToString(self, d)

    @staticmethod
    def hasZlib():
        r"""hasZlib() -> bool"""
        return _libnuml.NUMLWriter_hasZlib()

    @staticmethod
    def hasBzip2():
        r"""hasBzip2() -> bool"""
        return _libnuml.NUMLWriter_hasBzip2()

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register NUMLWriter in _libnuml:
_libnuml.NUMLWriter_swigregister(NUMLWriter)

def writeNUML(d, filename):
    r"""writeNUML(NUMLDocument d, char const * filename) -> int"""
    return _libnuml.writeNUML(d, filename)

def writeNUMLToString(d):
    r"""writeNUMLToString(NUMLDocument d) -> char *"""
    return _libnuml.writeNUMLToString(d)
NUML_UNKNOWN = _libnuml.NUML_UNKNOWN

NUML_DOCUMENT = _libnuml.NUML_DOCUMENT

NUML_ONTOLOGYTERMS = _libnuml.NUML_ONTOLOGYTERMS

NUML_ONTOLOGYTERM = _libnuml.NUML_ONTOLOGYTERM

NUML_RESULTCOMPONENT = _libnuml.NUML_RESULTCOMPONENT

NUML_RESULTCOMPONENTS = _libnuml.NUML_RESULTCOMPONENTS

NUML_DIMENSION = _libnuml.NUML_DIMENSION

NUML_DIMENSIONDESCRIPTION = _libnuml.NUML_DIMENSIONDESCRIPTION

NUML_COMPOSITEVALUE = _libnuml.NUML_COMPOSITEVALUE

NUML_COMPOSITEVALUES = _libnuml.NUML_COMPOSITEVALUES

NUML_TUPLE = _libnuml.NUML_TUPLE

NUML_TUPLES = _libnuml.NUML_TUPLES

NUML_ATOMICVALUE = _libnuml.NUML_ATOMICVALUE

NUML_ATOMICVALUES = _libnuml.NUML_ATOMICVALUES

NUML_COMPOSITEDESCRIPTION = _libnuml.NUML_COMPOSITEDESCRIPTION

NUML_TUPLEDESCRIPTION = _libnuml.NUML_TUPLEDESCRIPTION

NUML_ATOMICDESCRIPTION = _libnuml.NUML_ATOMICDESCRIPTION

NUML_NUMLLIST = _libnuml.NUML_NUMLLIST


def NUMLTypeCode_toString(tc):
    r"""NUMLTypeCode_toString(NUMLTypeCode_t tc) -> char const *"""
    return _libnuml.NUMLTypeCode_toString(tc)
class NMBase(object):
    r"""Proxy of C++ NMBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_NMBase

    def clone(self):
        r"""clone(NMBase self) -> NMBase"""
        return _libnuml.NMBase_clone(self)

    def getMetaId(self):
        r"""getMetaId(NMBase self) -> string"""
        return _libnuml.NMBase_getMetaId(self)

    def getId(self):
        r"""getId(NMBase self) -> string"""
        return _libnuml.NMBase_getId(self)

    def getName(self):
        r"""getName(NMBase self) -> string"""
        return _libnuml.NMBase_getName(self)

    def getNamespaces(self):
        r"""getNamespaces(NMBase self) -> XMLNamespaces"""
        return _libnuml.NMBase_getNamespaces(self)

    def getNUMLDocument(self, *args):
        r"""
        getNUMLDocument(NMBase self) -> NUMLDocument
        getNUMLDocument(NMBase self) -> NUMLDocument
        """
        return _libnuml.NMBase_getNUMLDocument(self, *args)

    def getParentNUMLObject(self):
        r"""getParentNUMLObject(NMBase self) -> NMBase"""
        return _libnuml.NMBase_getParentNUMLObject(self)

    def getAncestorOfType(self, type):
        r"""getAncestorOfType(NMBase self, NUMLTypeCode_t type) -> NMBase"""
        return _libnuml.NMBase_getAncestorOfType(self, type)

    def getLine(self):
        r"""getLine(NMBase self) -> unsigned int"""
        return _libnuml.NMBase_getLine(self)

    def getColumn(self):
        r"""getColumn(NMBase self) -> unsigned int"""
        return _libnuml.NMBase_getColumn(self)

    def isSetMetaId(self):
        r"""isSetMetaId(NMBase self) -> bool"""
        return _libnuml.NMBase_isSetMetaId(self)

    def isSetName(self):
        r"""isSetName(NMBase self) -> bool"""
        return _libnuml.NMBase_isSetName(self)

    def setMetaId(self, metaid):
        r"""setMetaId(NMBase self, string metaid) -> int"""
        return _libnuml.NMBase_setMetaId(self, metaid)

    def setId(self, sid):
        r"""setId(NMBase self, string sid) -> int"""
        return _libnuml.NMBase_setId(self, sid)

    def setNamespaces(self, xmlns):
        r"""setNamespaces(NMBase self, XMLNamespaces xmlns) -> int"""
        return _libnuml.NMBase_setNamespaces(self, xmlns)

    def unsetMetaId(self):
        r"""unsetMetaId(NMBase self) -> int"""
        return _libnuml.NMBase_unsetMetaId(self)

    def getLevel(self):
        r"""getLevel(NMBase self) -> unsigned int"""
        return _libnuml.NMBase_getLevel(self)

    def getVersion(self):
        r"""getVersion(NMBase self) -> unsigned int"""
        return _libnuml.NMBase_getVersion(self)

    def getTypeCode(self):
        r"""getTypeCode(NMBase self) -> NUMLTypeCode_t"""
        return _libnuml.NMBase_getTypeCode(self)

    def hasValidLevelVersionNamespaceCombination(self):
        r"""hasValidLevelVersionNamespaceCombination(NMBase self) -> bool"""
        return _libnuml.NMBase_hasValidLevelVersionNamespaceCombination(self)

    def getElementName(self):
        r"""getElementName(NMBase self) -> string"""
        return _libnuml.NMBase_getElementName(self)

    def toNUML(self):
        r"""toNUML(NMBase self) -> char *"""
        return _libnuml.NMBase_toNUML(self)

    def hasRequiredAttributes(self):
        r"""hasRequiredAttributes(NMBase self) -> bool"""
        return _libnuml.NMBase_hasRequiredAttributes(self)

    def hasRequiredElements(self):
        r"""hasRequiredElements(NMBase self) -> bool"""
        return _libnuml.NMBase_hasRequiredElements(self)

    def syncAnnotation(self):
        r"""syncAnnotation(NMBase self)"""
        return _libnuml.NMBase_syncAnnotation(self)

    def isSetNotes(self):
        r"""isSetNotes(NMBase self) -> bool"""
        return _libnuml.NMBase_isSetNotes(self)

    def isSetAnnotation(self):
        r"""isSetAnnotation(NMBase self) -> bool"""
        return _libnuml.NMBase_isSetAnnotation(self)

    def setAnnotation(self, *args):
        r"""
        setAnnotation(NMBase self, XMLNode annotation) -> int
        setAnnotation(NMBase self, string annotation) -> int
        """
        return _libnuml.NMBase_setAnnotation(self, *args)

    def appendAnnotation(self, *args):
        r"""
        appendAnnotation(NMBase self, XMLNode annotation) -> int
        appendAnnotation(NMBase self, string annotation) -> int
        """
        return _libnuml.NMBase_appendAnnotation(self, *args)

    def removeTopLevelAnnotationElement(self, *args):
        r"""removeTopLevelAnnotationElement(NMBase self, string elementName, string elementURI="") -> int"""
        return _libnuml.NMBase_removeTopLevelAnnotationElement(self, *args)

    def replaceTopLevelAnnotationElement(self, *args):
        r"""
        replaceTopLevelAnnotationElement(NMBase self, XMLNode annotation) -> int
        replaceTopLevelAnnotationElement(NMBase self, string annotation) -> int
        """
        return _libnuml.NMBase_replaceTopLevelAnnotationElement(self, *args)

    def setNotes(self, *args):
        r"""
        setNotes(NMBase self, XMLNode notes) -> int
        setNotes(NMBase self, string notes, bool addXHTMLMarkup=False) -> int
        """
        return _libnuml.NMBase_setNotes(self, *args)

    def appendNotes(self, *args):
        r"""
        appendNotes(NMBase self, XMLNode notes) -> int
        appendNotes(NMBase self, string notes) -> int
        """
        return _libnuml.NMBase_appendNotes(self, *args)

    def unsetNotes(self):
        r"""unsetNotes(NMBase self) -> int"""
        return _libnuml.NMBase_unsetNotes(self)

    def unsetAnnotation(self):
        r"""unsetAnnotation(NMBase self) -> int"""
        return _libnuml.NMBase_unsetAnnotation(self)

    def getNotes(self):
        r"""getNotes(NMBase self) -> XMLNode"""
        return _libnuml.NMBase_getNotes(self)

    def getNotesString(self):
        r"""getNotesString(NMBase self) -> string"""
        return _libnuml.NMBase_getNotesString(self)

    def getAnnotation(self):
        r"""getAnnotation(NMBase self) -> XMLNode"""
        return _libnuml.NMBase_getAnnotation(self)

    def getAnnotationString(self):
        r"""getAnnotationString(NMBase self) -> string"""
        return _libnuml.NMBase_getAnnotationString(self)

    __metaclass__ = AutoProperty


    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register NMBase in _libnuml:
_libnuml.NMBase_swigregister(NMBase)
class List(object):
    r"""Proxy of C++ List class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(List self) -> List"""
        _libnuml.List_swiginit(self, _libnuml.new_List())
    __swig_destroy__ = _libnuml.delete_List

    def add(self, item):
        r"""add(List self, void * item)"""
        return _libnuml.List_add(self, item)

    def countIf(self, predicate):
        r"""countIf(List self, ListItemPredicate predicate) -> unsigned int"""
        return _libnuml.List_countIf(self, predicate)

    def find(self, item1, comparator):
        r"""find(List self, void const * item1, ListItemComparator comparator) -> void *"""
        return _libnuml.List_find(self, item1, comparator)

    def findIf(self, predicate):
        r"""findIf(List self, ListItemPredicate predicate) -> List"""
        return _libnuml.List_findIf(self, predicate)

    def get(self, n):
        r"""get(List self, unsigned int n) -> void *"""
        return _libnuml.List_get(self, n)

    def prepend(self, item):
        r"""prepend(List self, void * item)"""
        return _libnuml.List_prepend(self, item)

    def remove(self, n):
        r"""remove(List self, unsigned int n) -> void *"""
        return _libnuml.List_remove(self, n)

    def getSize(self):
        r"""getSize(List self) -> unsigned int"""
        return _libnuml.List_getSize(self)

    def transferFrom(self, list):
        r"""transferFrom(List self, List list)"""
        return _libnuml.List_transferFrom(self, list)

    @staticmethod
    def deleteListAndChildrenWith(list, delteFunc):
        r"""deleteListAndChildrenWith(List list, ListDeleteItemFunc delteFunc)"""
        return _libnuml.List_deleteListAndChildrenWith(list, delteFunc)

# Register List in _libnuml:
_libnuml.List_swigregister(List)
MODEL_QUALIFIER = _libnuml.MODEL_QUALIFIER

BIOLOGICAL_QUALIFIER = _libnuml.BIOLOGICAL_QUALIFIER

UNKNOWN_QUALIFIER = _libnuml.UNKNOWN_QUALIFIER

BQM_IS = _libnuml.BQM_IS

BQM_IS_DESCRIBED_BY = _libnuml.BQM_IS_DESCRIBED_BY

BQM_IS_DERIVED_FROM = _libnuml.BQM_IS_DERIVED_FROM

BQM_IS_INSTANCE_OF = _libnuml.BQM_IS_INSTANCE_OF

BQM_HAS_INSTANCE = _libnuml.BQM_HAS_INSTANCE

BQM_UNKNOWN = _libnuml.BQM_UNKNOWN

BQB_IS = _libnuml.BQB_IS

BQB_HAS_PART = _libnuml.BQB_HAS_PART

BQB_IS_PART_OF = _libnuml.BQB_IS_PART_OF

BQB_IS_VERSION_OF = _libnuml.BQB_IS_VERSION_OF

BQB_HAS_VERSION = _libnuml.BQB_HAS_VERSION

BQB_IS_HOMOLOG_TO = _libnuml.BQB_IS_HOMOLOG_TO

BQB_IS_DESCRIBED_BY = _libnuml.BQB_IS_DESCRIBED_BY

BQB_IS_ENCODED_BY = _libnuml.BQB_IS_ENCODED_BY

BQB_ENCODES = _libnuml.BQB_ENCODES

BQB_OCCURS_IN = _libnuml.BQB_OCCURS_IN

BQB_HAS_PROPERTY = _libnuml.BQB_HAS_PROPERTY

BQB_IS_PROPERTY_OF = _libnuml.BQB_IS_PROPERTY_OF

BQB_HAS_TAXON = _libnuml.BQB_HAS_TAXON

BQB_UNKNOWN = _libnuml.BQB_UNKNOWN

class CVTerm(object):
    r"""Proxy of C++ CVTerm class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_CVTerm

    def __init__(self, *args):
        r"""
        __init__(CVTerm self, QualifierType_t type=UNKNOWN_QUALIFIER) -> CVTerm
        __init__(CVTerm self, XMLNode node) -> CVTerm
        __init__(CVTerm self, CVTerm orig) -> CVTerm
        """
        _libnuml.CVTerm_swiginit(self, _libnuml.new_CVTerm(*args))

    def clone(self):
        r"""clone(CVTerm self) -> CVTerm"""
        return _libnuml.CVTerm_clone(self)

    def getQualifierType(self, *args):
        r"""
        getQualifierType(CVTerm self) -> QualifierType_t
        getQualifierType(CVTerm self) -> QualifierType_t
        """
        return _libnuml.CVTerm_getQualifierType(self, *args)

    def getModelQualifierType(self, *args):
        r"""
        getModelQualifierType(CVTerm self) -> ModelQualifierType_t
        getModelQualifierType(CVTerm self) -> ModelQualifierType_t
        """
        return _libnuml.CVTerm_getModelQualifierType(self, *args)

    def getBiologicalQualifierType(self, *args):
        r"""
        getBiologicalQualifierType(CVTerm self) -> BiolQualifierType_t
        getBiologicalQualifierType(CVTerm self) -> BiolQualifierType_t
        """
        return _libnuml.CVTerm_getBiologicalQualifierType(self, *args)

    def getResources(self, *args):
        r"""
        getResources(CVTerm self) -> XMLAttributes
        getResources(CVTerm self) -> XMLAttributes
        """
        return _libnuml.CVTerm_getResources(self, *args)

    def getNumResources(self, *args):
        r"""
        getNumResources(CVTerm self) -> unsigned int
        getNumResources(CVTerm self) -> unsigned int
        """
        return _libnuml.CVTerm_getNumResources(self, *args)

    def getResourceURI(self, *args):
        r"""
        getResourceURI(CVTerm self, unsigned int n) -> string
        getResourceURI(CVTerm self, unsigned int n) -> string
        """
        return _libnuml.CVTerm_getResourceURI(self, *args)

    def setQualifierType(self, type):
        r"""setQualifierType(CVTerm self, QualifierType_t type) -> int"""
        return _libnuml.CVTerm_setQualifierType(self, type)

    def setModelQualifierType(self, *args):
        r"""
        setModelQualifierType(CVTerm self, ModelQualifierType_t type) -> int
        setModelQualifierType(CVTerm self, string qualifier) -> int
        """
        return _libnuml.CVTerm_setModelQualifierType(self, *args)

    def setBiologicalQualifierType(self, *args):
        r"""
        setBiologicalQualifierType(CVTerm self, BiolQualifierType_t type) -> int
        setBiologicalQualifierType(CVTerm self, string qualifier) -> int
        """
        return _libnuml.CVTerm_setBiologicalQualifierType(self, *args)

    def addResource(self, resource):
        r"""addResource(CVTerm self, string resource) -> int"""
        return _libnuml.CVTerm_addResource(self, resource)

    def removeResource(self, resource):
        r"""removeResource(CVTerm self, string resource) -> int"""
        return _libnuml.CVTerm_removeResource(self, resource)

    def hasBeenModified(self):
        r"""hasBeenModified(CVTerm self) -> bool"""
        return _libnuml.CVTerm_hasBeenModified(self)

    def resetModifiedFlags(self):
        r"""resetModifiedFlags(CVTerm self)"""
        return _libnuml.CVTerm_resetModifiedFlags(self)

    def hasRequiredAttributes(self, *args):
        r"""
        hasRequiredAttributes(CVTerm self) -> bool
        hasRequiredAttributes(CVTerm self) -> bool
        """
        return _libnuml.CVTerm_hasRequiredAttributes(self, *args)

    def getNumNestedCVTerms(self):
        r"""getNumNestedCVTerms(CVTerm self) -> unsigned int"""
        return _libnuml.CVTerm_getNumNestedCVTerms(self)

    def getNestedCVTerm(self, *args):
        r"""
        getNestedCVTerm(CVTerm self, unsigned int n) -> CVTerm
        getNestedCVTerm(CVTerm self, unsigned int n) -> CVTerm
        """
        return _libnuml.CVTerm_getNestedCVTerm(self, *args)

    def getListNestedCVTerms(self, *args):
        r"""
        getListNestedCVTerms(CVTerm self) -> List
        getListNestedCVTerms(CVTerm self) -> List
        """
        return _libnuml.CVTerm_getListNestedCVTerms(self, *args)

    def addNestedCVTerm(self, term):
        r"""addNestedCVTerm(CVTerm self, CVTerm term) -> int"""
        return _libnuml.CVTerm_addNestedCVTerm(self, term)

    def removeNestedCVTerm(self, n):
        r"""removeNestedCVTerm(CVTerm self, unsigned int n) -> CVTerm"""
        return _libnuml.CVTerm_removeNestedCVTerm(self, n)

    __metaclass__ = AutoProperty


# Register CVTerm in _libnuml:
_libnuml.CVTerm_swigregister(CVTerm)

def ModelQualifierType_toString(type):
    r"""ModelQualifierType_toString(ModelQualifierType_t type) -> char const *"""
    return _libnuml.ModelQualifierType_toString(type)

def BiolQualifierType_toString(type):
    r"""BiolQualifierType_toString(BiolQualifierType_t type) -> char const *"""
    return _libnuml.BiolQualifierType_toString(type)

def ModelQualifierType_fromString(s):
    r"""ModelQualifierType_fromString(char const * s) -> ModelQualifierType_t"""
    return _libnuml.ModelQualifierType_fromString(s)

def BiolQualifierType_fromString(s):
    r"""BiolQualifierType_fromString(char const * s) -> BiolQualifierType_t"""
    return _libnuml.BiolQualifierType_fromString(s)
class Date(object):
    r"""Proxy of C++ Date class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_Date

    def __init__(self, *args):
        r"""
        __init__(Date self, unsigned int year=2000, unsigned int month=1, unsigned int day=1, unsigned int hour=0, unsigned int minute=0, unsigned int second=0, unsigned int sign=0, unsigned int hoursOffset=0, unsigned int minutesOffset=0) -> Date
        __init__(Date self, string date) -> Date
        __init__(Date self, Date orig) -> Date
        """
        _libnuml.Date_swiginit(self, _libnuml.new_Date(*args))

    def clone(self):
        r"""clone(Date self) -> Date"""
        return _libnuml.Date_clone(self)

    def getYear(self):
        r"""getYear(Date self) -> unsigned int"""
        return _libnuml.Date_getYear(self)

    def getMonth(self):
        r"""getMonth(Date self) -> unsigned int"""
        return _libnuml.Date_getMonth(self)

    def getDay(self):
        r"""getDay(Date self) -> unsigned int"""
        return _libnuml.Date_getDay(self)

    def getHour(self):
        r"""getHour(Date self) -> unsigned int"""
        return _libnuml.Date_getHour(self)

    def getMinute(self):
        r"""getMinute(Date self) -> unsigned int"""
        return _libnuml.Date_getMinute(self)

    def getSecond(self):
        r"""getSecond(Date self) -> unsigned int"""
        return _libnuml.Date_getSecond(self)

    def getSignOffset(self):
        r"""getSignOffset(Date self) -> unsigned int"""
        return _libnuml.Date_getSignOffset(self)

    def getHoursOffset(self):
        r"""getHoursOffset(Date self) -> unsigned int"""
        return _libnuml.Date_getHoursOffset(self)

    def getMinutesOffset(self):
        r"""getMinutesOffset(Date self) -> unsigned int"""
        return _libnuml.Date_getMinutesOffset(self)

    def getDateAsString(self):
        r"""getDateAsString(Date self) -> string"""
        return _libnuml.Date_getDateAsString(self)

    def setYear(self, year):
        r"""setYear(Date self, unsigned int year) -> int"""
        return _libnuml.Date_setYear(self, year)

    def setMonth(self, month):
        r"""setMonth(Date self, unsigned int month) -> int"""
        return _libnuml.Date_setMonth(self, month)

    def setDay(self, day):
        r"""setDay(Date self, unsigned int day) -> int"""
        return _libnuml.Date_setDay(self, day)

    def setHour(self, hour):
        r"""setHour(Date self, unsigned int hour) -> int"""
        return _libnuml.Date_setHour(self, hour)

    def setMinute(self, minute):
        r"""setMinute(Date self, unsigned int minute) -> int"""
        return _libnuml.Date_setMinute(self, minute)

    def setSecond(self, second):
        r"""setSecond(Date self, unsigned int second) -> int"""
        return _libnuml.Date_setSecond(self, second)

    def setSignOffset(self, sign):
        r"""setSignOffset(Date self, unsigned int sign) -> int"""
        return _libnuml.Date_setSignOffset(self, sign)

    def setHoursOffset(self, hoursOffset):
        r"""setHoursOffset(Date self, unsigned int hoursOffset) -> int"""
        return _libnuml.Date_setHoursOffset(self, hoursOffset)

    def setMinutesOffset(self, minutesOffset):
        r"""setMinutesOffset(Date self, unsigned int minutesOffset) -> int"""
        return _libnuml.Date_setMinutesOffset(self, minutesOffset)

    def setDateAsString(self, date):
        r"""setDateAsString(Date self, string date) -> int"""
        return _libnuml.Date_setDateAsString(self, date)

    def representsValidDate(self):
        r"""representsValidDate(Date self) -> bool"""
        return _libnuml.Date_representsValidDate(self)

    def hasBeenModified(self):
        r"""hasBeenModified(Date self) -> bool"""
        return _libnuml.Date_hasBeenModified(self)

    def resetModifiedFlags(self):
        r"""resetModifiedFlags(Date self)"""
        return _libnuml.Date_resetModifiedFlags(self)

    __metaclass__ = AutoProperty


# Register Date in _libnuml:
_libnuml.Date_swigregister(Date)
class ModelHistory(object):
    r"""Proxy of C++ ModelHistory class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_ModelHistory

    def __init__(self, *args):
        r"""
        __init__(ModelHistory self) -> ModelHistory
        __init__(ModelHistory self, ModelHistory orig) -> ModelHistory
        """
        _libnuml.ModelHistory_swiginit(self, _libnuml.new_ModelHistory(*args))

    def clone(self):
        r"""clone(ModelHistory self) -> ModelHistory"""
        return _libnuml.ModelHistory_clone(self)

    def getCreatedDate(self):
        r"""getCreatedDate(ModelHistory self) -> Date"""
        return _libnuml.ModelHistory_getCreatedDate(self)

    def isSetCreatedDate(self):
        r"""isSetCreatedDate(ModelHistory self) -> bool"""
        return _libnuml.ModelHistory_isSetCreatedDate(self)

    def isSetModifiedDate(self):
        r"""isSetModifiedDate(ModelHistory self) -> bool"""
        return _libnuml.ModelHistory_isSetModifiedDate(self)

    def setCreatedDate(self, date):
        r"""setCreatedDate(ModelHistory self, Date date) -> int"""
        return _libnuml.ModelHistory_setCreatedDate(self, date)

    def setModifiedDate(self, date):
        r"""setModifiedDate(ModelHistory self, Date date) -> int"""
        return _libnuml.ModelHistory_setModifiedDate(self, date)

    def addModifiedDate(self, date):
        r"""addModifiedDate(ModelHistory self, Date date) -> int"""
        return _libnuml.ModelHistory_addModifiedDate(self, date)

    def getListModifiedDates(self):
        r"""getListModifiedDates(ModelHistory self) -> List"""
        return _libnuml.ModelHistory_getListModifiedDates(self)

    def getModifiedDate(self, *args):
        r"""
        getModifiedDate(ModelHistory self) -> Date
        getModifiedDate(ModelHistory self, unsigned int n) -> Date
        """
        return _libnuml.ModelHistory_getModifiedDate(self, *args)

    def getNumModifiedDates(self):
        r"""getNumModifiedDates(ModelHistory self) -> unsigned int"""
        return _libnuml.ModelHistory_getNumModifiedDates(self)

    def addCreator(self, mc):
        r"""addCreator(ModelHistory self, ModelCreator mc) -> int"""
        return _libnuml.ModelHistory_addCreator(self, mc)

    def getListCreators(self):
        r"""getListCreators(ModelHistory self) -> List"""
        return _libnuml.ModelHistory_getListCreators(self)

    def getCreator(self, n):
        r"""getCreator(ModelHistory self, unsigned int n) -> ModelCreator"""
        return _libnuml.ModelHistory_getCreator(self, n)

    def getNumCreators(self):
        r"""getNumCreators(ModelHistory self) -> unsigned int"""
        return _libnuml.ModelHistory_getNumCreators(self)

    def hasRequiredAttributes(self):
        r"""hasRequiredAttributes(ModelHistory self) -> bool"""
        return _libnuml.ModelHistory_hasRequiredAttributes(self)

    def hasBeenModified(self):
        r"""hasBeenModified(ModelHistory self) -> bool"""
        return _libnuml.ModelHistory_hasBeenModified(self)

    def resetModifiedFlags(self):
        r"""resetModifiedFlags(ModelHistory self)"""
        return _libnuml.ModelHistory_resetModifiedFlags(self)

    __metaclass__ = AutoProperty


# Register ModelHistory in _libnuml:
_libnuml.ModelHistory_swigregister(ModelHistory)
class ModelCreator(object):
    r"""Proxy of C++ ModelCreator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_ModelCreator

    def __init__(self, *args):
        r"""
        __init__(ModelCreator self) -> ModelCreator
        __init__(ModelCreator self, XMLNode creator) -> ModelCreator
        __init__(ModelCreator self, ModelCreator orig) -> ModelCreator
        """
        _libnuml.ModelCreator_swiginit(self, _libnuml.new_ModelCreator(*args))

    def clone(self):
        r"""clone(ModelCreator self) -> ModelCreator"""
        return _libnuml.ModelCreator_clone(self)

    def getFamilyName(self):
        r"""getFamilyName(ModelCreator self) -> string"""
        return _libnuml.ModelCreator_getFamilyName(self)

    def getGivenName(self):
        r"""getGivenName(ModelCreator self) -> string"""
        return _libnuml.ModelCreator_getGivenName(self)

    def getEmail(self):
        r"""getEmail(ModelCreator self) -> string"""
        return _libnuml.ModelCreator_getEmail(self)

    def getOrganization(self):
        r"""getOrganization(ModelCreator self) -> string"""
        return _libnuml.ModelCreator_getOrganization(self)

    def getOrganisation(self):
        r"""getOrganisation(ModelCreator self) -> string"""
        return _libnuml.ModelCreator_getOrganisation(self)

    def getName(self):
        r"""getName(ModelCreator self) -> string"""
        return _libnuml.ModelCreator_getName(self)

    def isSetFamilyName(self):
        r"""isSetFamilyName(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_isSetFamilyName(self)

    def isSetGivenName(self):
        r"""isSetGivenName(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_isSetGivenName(self)

    def isSetEmail(self):
        r"""isSetEmail(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_isSetEmail(self)

    def isSetOrganization(self):
        r"""isSetOrganization(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_isSetOrganization(self)

    def isSetOrganisation(self):
        r"""isSetOrganisation(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_isSetOrganisation(self)

    def isSetName(self):
        r"""isSetName(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_isSetName(self)

    def setFamilyName(self, familyName):
        r"""setFamilyName(ModelCreator self, string familyName) -> int"""
        return _libnuml.ModelCreator_setFamilyName(self, familyName)

    def setGivenName(self, givenName):
        r"""setGivenName(ModelCreator self, string givenName) -> int"""
        return _libnuml.ModelCreator_setGivenName(self, givenName)

    def setEmail(self, email):
        r"""setEmail(ModelCreator self, string email) -> int"""
        return _libnuml.ModelCreator_setEmail(self, email)

    def setOrganization(self, organization):
        r"""setOrganization(ModelCreator self, string organization) -> int"""
        return _libnuml.ModelCreator_setOrganization(self, organization)

    def setOrganisation(self, organization):
        r"""setOrganisation(ModelCreator self, string organization) -> int"""
        return _libnuml.ModelCreator_setOrganisation(self, organization)

    def setName(self, name):
        r"""setName(ModelCreator self, string name) -> int"""
        return _libnuml.ModelCreator_setName(self, name)

    def unsetFamilyName(self):
        r"""unsetFamilyName(ModelCreator self) -> int"""
        return _libnuml.ModelCreator_unsetFamilyName(self)

    def unsetGivenName(self):
        r"""unsetGivenName(ModelCreator self) -> int"""
        return _libnuml.ModelCreator_unsetGivenName(self)

    def unsetEmail(self):
        r"""unsetEmail(ModelCreator self) -> int"""
        return _libnuml.ModelCreator_unsetEmail(self)

    def unsetOrganization(self):
        r"""unsetOrganization(ModelCreator self) -> int"""
        return _libnuml.ModelCreator_unsetOrganization(self)

    def unsetOrganisation(self):
        r"""unsetOrganisation(ModelCreator self) -> int"""
        return _libnuml.ModelCreator_unsetOrganisation(self)

    def unsetName(self):
        r"""unsetName(ModelCreator self) -> int"""
        return _libnuml.ModelCreator_unsetName(self)

    def hasRequiredAttributes(self):
        r"""hasRequiredAttributes(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_hasRequiredAttributes(self)

    def hasBeenModified(self):
        r"""hasBeenModified(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_hasBeenModified(self)

    def resetModifiedFlags(self):
        r"""resetModifiedFlags(ModelCreator self)"""
        return _libnuml.ModelCreator_resetModifiedFlags(self)

    def usingFNVcard4(self):
        r"""usingFNVcard4(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_usingFNVcard4(self)

    def usingSingleName(self):
        r"""usingSingleName(ModelCreator self) -> bool"""
        return _libnuml.ModelCreator_usingSingleName(self)

    def setUseSingleName(self, flag):
        r"""setUseSingleName(ModelCreator self, bool flag)"""
        return _libnuml.ModelCreator_setUseSingleName(self, flag)

    __metaclass__ = AutoProperty


# Register ModelCreator in _libnuml:
_libnuml.ModelCreator_swigregister(ModelCreator)
class RDFAnnotationParser(object):
    r"""Proxy of C++ RDFAnnotationParser class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def createAnnotation():
        r"""createAnnotation() -> XMLNode"""
        return _libnuml.RDFAnnotationParser_createAnnotation()

    @staticmethod
    def createRDFAnnotation(level=3, version=1):
        r"""createRDFAnnotation(unsigned int level=3, unsigned int version=1) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_createRDFAnnotation(level, version)

    @staticmethod
    def createRDFDescription(obj):
        r"""createRDFDescription(SBase const * obj) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_createRDFDescription(obj)

    @staticmethod
    def createCVTerms(obj):
        r"""createCVTerms(SBase const * obj) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_createCVTerms(obj)

    @staticmethod
    def parseCVTerms(obj):
        r"""parseCVTerms(SBase const * obj) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_parseCVTerms(obj)

    @staticmethod
    def parseModelHistory(obj):
        r"""parseModelHistory(SBase const * obj) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_parseModelHistory(obj)

    @staticmethod
    def parseOnlyModelHistory(obj):
        r"""parseOnlyModelHistory(SBase const * obj) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_parseOnlyModelHistory(obj)

    @staticmethod
    def deleteRDFAnnotation(annotation):
        r"""deleteRDFAnnotation(XMLNode annotation) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_deleteRDFAnnotation(annotation)

    @staticmethod
    def deleteRDFHistoryAnnotation(annotation):
        r"""deleteRDFHistoryAnnotation(XMLNode annotation) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_deleteRDFHistoryAnnotation(annotation)

    @staticmethod
    def deleteRDFCVTermAnnotation(annotation):
        r"""deleteRDFCVTermAnnotation(XMLNode annotation) -> XMLNode"""
        return _libnuml.RDFAnnotationParser_deleteRDFCVTermAnnotation(annotation)

    @staticmethod
    def parseRDFAnnotation(*args):
        r"""
        parseRDFAnnotation(XMLNode annotation, List CVTerms, char const * metaId=None, XMLInputStream stream=None)
        parseRDFAnnotation(XMLNode annotation, char const * metaId=None, XMLInputStream stream=None, SBase const * parent=None) -> ModelHistory
        parseRDFAnnotation(XMLNode annotation, CVTermList CVTerms)
        """
        return _libnuml.RDFAnnotationParser_parseRDFAnnotation(*args)

    def __init__(self):
        r"""__init__(RDFAnnotationParser self) -> RDFAnnotationParser"""
        _libnuml.RDFAnnotationParser_swiginit(self, _libnuml.new_RDFAnnotationParser())
    __swig_destroy__ = _libnuml.delete_RDFAnnotationParser

# Register RDFAnnotationParser in _libnuml:
_libnuml.RDFAnnotationParser_swigregister(RDFAnnotationParser)
IdCheckON = _libnuml.IdCheckON

IdCheckOFF = _libnuml.IdCheckOFF

NUMLCheckON = _libnuml.NUMLCheckON

NUMLCheckOFF = _libnuml.NUMLCheckOFF

SBOCheckON = _libnuml.SBOCheckON

SBOCheckOFF = _libnuml.SBOCheckOFF

MathCheckON = _libnuml.MathCheckON

MathCheckOFF = _libnuml.MathCheckOFF

UnitsCheckON = _libnuml.UnitsCheckON

UnitsCheckOFF = _libnuml.UnitsCheckOFF

OverdeterCheckON = _libnuml.OverdeterCheckON

OverdeterCheckOFF = _libnuml.OverdeterCheckOFF

PracticeCheckON = _libnuml.PracticeCheckON

PracticeCheckOFF = _libnuml.PracticeCheckOFF

AllChecksON = _libnuml.AllChecksON

class NUMLDocument(NMBase):
    r"""Proxy of C++ NUMLDocument class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def getDefaultLevel():
        r"""getDefaultLevel() -> unsigned int"""
        return _libnuml.NUMLDocument_getDefaultLevel()

    @staticmethod
    def getDefaultVersion():
        r"""getDefaultVersion() -> unsigned int"""
        return _libnuml.NUMLDocument_getDefaultVersion()
    __swig_destroy__ = _libnuml.delete_NUMLDocument

    def __init__(self, *args):
        r"""
        __init__(NUMLDocument self, unsigned int level=0, unsigned int version=0) -> NUMLDocument
        __init__(NUMLDocument self, NUMLDocument rhs) -> NUMLDocument
        """
        _libnuml.NUMLDocument_swiginit(self, _libnuml.new_NUMLDocument(*args))

    def clone(self):
        r"""clone(NUMLDocument self) -> NUMLDocument"""
        return _libnuml.NUMLDocument_clone(self)

    def getNumOntologyTerms(self):
        r"""getNumOntologyTerms(NUMLDocument self) -> unsigned int"""
        return _libnuml.NUMLDocument_getNumOntologyTerms(self)

    def getOntologyTerms(self, *args):
        r"""
        getOntologyTerms(NUMLDocument self) -> OntologyTerms
        getOntologyTerms(NUMLDocument self) -> OntologyTerms
        """
        return _libnuml.NUMLDocument_getOntologyTerms(self, *args)

    def getResultComponents(self, *args):
        r"""
        getResultComponents(NUMLDocument self) -> ResultComponents
        getResultComponents(NUMLDocument self) -> ResultComponents
        """
        return _libnuml.NUMLDocument_getResultComponents(self, *args)

    def getNumResultComponents(self):
        r"""getNumResultComponents(NUMLDocument self) -> unsigned int"""
        return _libnuml.NUMLDocument_getNumResultComponents(self)

    def getResultComponent(self, index):
        r"""getResultComponent(NUMLDocument self, unsigned int index) -> ResultComponent"""
        return _libnuml.NUMLDocument_getResultComponent(self, index)

    def setLevelAndVersion(self, level, version, strict=True):
        r"""setLevelAndVersion(NUMLDocument self, unsigned int level, unsigned int version, bool strict=True) -> bool"""
        return _libnuml.NUMLDocument_setLevelAndVersion(self, level, version, strict)

    def createOntologyTerm(self):
        r"""createOntologyTerm(NUMLDocument self) -> OntologyTerm"""
        return _libnuml.NUMLDocument_createOntologyTerm(self)

    def createResultComponent(self):
        r"""createResultComponent(NUMLDocument self) -> ResultComponent"""
        return _libnuml.NUMLDocument_createResultComponent(self)

    def getError(self, n):
        r"""getError(NUMLDocument self, unsigned int n) -> NUMLError"""
        return _libnuml.NUMLDocument_getError(self, n)

    def getNumErrors(self):
        r"""getNumErrors(NUMLDocument self) -> unsigned int"""
        return _libnuml.NUMLDocument_getNumErrors(self)

    def printErrors(self, *args):
        r"""printErrors(NUMLDocument self, ostream stream=cerr)"""
        return _libnuml.NUMLDocument_printErrors(self, *args)

    def getTypeCode(self):
        r"""getTypeCode(NUMLDocument self) -> NUMLTypeCode_t"""
        return _libnuml.NUMLDocument_getTypeCode(self)

    def getElementName(self):
        r"""getElementName(NUMLDocument self) -> string"""
        return _libnuml.NUMLDocument_getElementName(self)

    def getErrorLog(self):
        r"""getErrorLog(NUMLDocument self) -> NUMLErrorLog"""
        return _libnuml.NUMLDocument_getErrorLog(self)

    def getNamespaces(self):
        r"""getNamespaces(NUMLDocument self) -> XMLNamespaces"""
        return _libnuml.NUMLDocument_getNamespaces(self)

# Register NUMLDocument in _libnuml:
_libnuml.NUMLDocument_swigregister(NUMLDocument)
XMLUnknownError = _libnuml.XMLUnknownError

XMLOutOfMemory = _libnuml.XMLOutOfMemory

XMLFileUnreadable = _libnuml.XMLFileUnreadable

XMLFileUnwritable = _libnuml.XMLFileUnwritable

XMLFileOperationError = _libnuml.XMLFileOperationError

XMLNetworkAccessError = _libnuml.XMLNetworkAccessError

InternalXMLParserError = _libnuml.InternalXMLParserError

UnrecognizedXMLParserCode = _libnuml.UnrecognizedXMLParserCode

XMLTranscoderError = _libnuml.XMLTranscoderError

MissingXMLDecl = _libnuml.MissingXMLDecl

MissingXMLEncoding = _libnuml.MissingXMLEncoding

BadXMLDecl = _libnuml.BadXMLDecl

BadXMLDOCTYPE = _libnuml.BadXMLDOCTYPE

InvalidCharInXML = _libnuml.InvalidCharInXML

BadlyFormedXML = _libnuml.BadlyFormedXML

UnclosedXMLToken = _libnuml.UnclosedXMLToken

InvalidXMLConstruct = _libnuml.InvalidXMLConstruct

XMLTagMismatch = _libnuml.XMLTagMismatch

DuplicateXMLAttribute = _libnuml.DuplicateXMLAttribute

UndefinedXMLEntity = _libnuml.UndefinedXMLEntity

BadProcessingInstruction = _libnuml.BadProcessingInstruction

BadXMLPrefix = _libnuml.BadXMLPrefix

BadXMLPrefixValue = _libnuml.BadXMLPrefixValue

MissingXMLRequiredAttribute = _libnuml.MissingXMLRequiredAttribute

XMLAttributeTypeMismatch = _libnuml.XMLAttributeTypeMismatch

XMLBadUTF8Content = _libnuml.XMLBadUTF8Content

MissingXMLAttributeValue = _libnuml.MissingXMLAttributeValue

BadXMLAttributeValue = _libnuml.BadXMLAttributeValue

BadXMLAttribute = _libnuml.BadXMLAttribute

UnrecognizedXMLElement = _libnuml.UnrecognizedXMLElement

BadXMLComment = _libnuml.BadXMLComment

BadXMLDeclLocation = _libnuml.BadXMLDeclLocation

XMLUnexpectedEOF = _libnuml.XMLUnexpectedEOF

BadXMLIDValue = _libnuml.BadXMLIDValue

BadXMLIDRef = _libnuml.BadXMLIDRef

UninterpretableXMLContent = _libnuml.UninterpretableXMLContent

BadXMLDocumentStructure = _libnuml.BadXMLDocumentStructure

InvalidAfterXMLContent = _libnuml.InvalidAfterXMLContent

XMLExpectedQuotedString = _libnuml.XMLExpectedQuotedString

XMLEmptyValueNotPermitted = _libnuml.XMLEmptyValueNotPermitted

XMLBadNumber = _libnuml.XMLBadNumber

XMLBadColon = _libnuml.XMLBadColon

MissingXMLElements = _libnuml.MissingXMLElements

XMLContentEmpty = _libnuml.XMLContentEmpty

XMLErrorCodesUpperBound = _libnuml.XMLErrorCodesUpperBound

LIBSBML_CAT_INTERNAL = _libnuml.LIBSBML_CAT_INTERNAL

LIBSBML_CAT_SYSTEM = _libnuml.LIBSBML_CAT_SYSTEM

LIBSBML_CAT_XML = _libnuml.LIBSBML_CAT_XML

LIBSBML_SEV_INFO = _libnuml.LIBSBML_SEV_INFO

LIBSBML_SEV_WARNING = _libnuml.LIBSBML_SEV_WARNING

LIBSBML_SEV_ERROR = _libnuml.LIBSBML_SEV_ERROR

LIBSBML_SEV_FATAL = _libnuml.LIBSBML_SEV_FATAL

LIBSBML_OVERRIDE_DISABLED = _libnuml.LIBSBML_OVERRIDE_DISABLED

LIBSBML_OVERRIDE_DONT_LOG = _libnuml.LIBSBML_OVERRIDE_DONT_LOG

LIBSBML_OVERRIDE_WARNING = _libnuml.LIBSBML_OVERRIDE_WARNING

LIBSBML_OVERRIDE_ERROR = _libnuml.LIBSBML_OVERRIDE_ERROR

class XMLError(object):
    r"""Proxy of C++ XMLError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(XMLError self, int const errorId=0, string details="", unsigned int const line=0, unsigned int const column=0, unsigned int const severity=LIBSBML_SEV_FATAL, unsigned int const category=LIBSBML_CAT_INTERNAL) -> XMLError
        __init__(XMLError self, XMLError orig) -> XMLError
        """
        _libnuml.XMLError_swiginit(self, _libnuml.new_XMLError(*args))
    __swig_destroy__ = _libnuml.delete_XMLError

    def getErrorId(self):
        r"""getErrorId(XMLError self) -> unsigned int"""
        return _libnuml.XMLError_getErrorId(self)

    def getMessage(self):
        r"""getMessage(XMLError self) -> string"""
        return _libnuml.XMLError_getMessage(self)

    def getShortMessage(self):
        r"""getShortMessage(XMLError self) -> string"""
        return _libnuml.XMLError_getShortMessage(self)

    def getLine(self):
        r"""getLine(XMLError self) -> unsigned int"""
        return _libnuml.XMLError_getLine(self)

    def getColumn(self):
        r"""getColumn(XMLError self) -> unsigned int"""
        return _libnuml.XMLError_getColumn(self)

    def getSeverity(self):
        r"""getSeverity(XMLError self) -> unsigned int"""
        return _libnuml.XMLError_getSeverity(self)

    def getSeverityAsString(self):
        r"""getSeverityAsString(XMLError self) -> string"""
        return _libnuml.XMLError_getSeverityAsString(self)

    def getCategory(self):
        r"""getCategory(XMLError self) -> unsigned int"""
        return _libnuml.XMLError_getCategory(self)

    def getCategoryAsString(self):
        r"""getCategoryAsString(XMLError self) -> string"""
        return _libnuml.XMLError_getCategoryAsString(self)

    def setErrorId(self, errorId):
        r"""setErrorId(XMLError self, unsigned int errorId) -> int"""
        return _libnuml.XMLError_setErrorId(self, errorId)

    def setMessage(self, message):
        r"""setMessage(XMLError self, string message) -> int"""
        return _libnuml.XMLError_setMessage(self, message)

    def setShortMessage(self, shortMessage):
        r"""setShortMessage(XMLError self, string shortMessage) -> int"""
        return _libnuml.XMLError_setShortMessage(self, shortMessage)

    def setSeverity(self, severity):
        r"""setSeverity(XMLError self, unsigned int severity) -> int"""
        return _libnuml.XMLError_setSeverity(self, severity)

    def setSeverityString(self, severityString):
        r"""setSeverityString(XMLError self, string severityString) -> int"""
        return _libnuml.XMLError_setSeverityString(self, severityString)

    def setCategory(self, category):
        r"""setCategory(XMLError self, unsigned int category) -> int"""
        return _libnuml.XMLError_setCategory(self, category)

    def setCategoryString(self, categoryString):
        r"""setCategoryString(XMLError self, string categoryString) -> int"""
        return _libnuml.XMLError_setCategoryString(self, categoryString)

    def isInfo(self):
        r"""isInfo(XMLError self) -> bool"""
        return _libnuml.XMLError_isInfo(self)

    def isWarning(self):
        r"""isWarning(XMLError self) -> bool"""
        return _libnuml.XMLError_isWarning(self)

    def isError(self):
        r"""isError(XMLError self) -> bool"""
        return _libnuml.XMLError_isError(self)

    def isFatal(self):
        r"""isFatal(XMLError self) -> bool"""
        return _libnuml.XMLError_isFatal(self)

    def isInternal(self):
        r"""isInternal(XMLError self) -> bool"""
        return _libnuml.XMLError_isInternal(self)

    def isSystem(self):
        r"""isSystem(XMLError self) -> bool"""
        return _libnuml.XMLError_isSystem(self)

    def isXML(self):
        r"""isXML(XMLError self) -> bool"""
        return _libnuml.XMLError_isXML(self)

    def isValid(self):
        r"""isValid(XMLError self) -> bool"""
        return _libnuml.XMLError_isValid(self)

    def setLine(self, line):
        r"""setLine(XMLError self, unsigned int line) -> int"""
        return _libnuml.XMLError_setLine(self, line)

    def setColumn(self, column):
        r"""setColumn(XMLError self, unsigned int column) -> int"""
        return _libnuml.XMLError_setColumn(self, column)

    @staticmethod
    def getStandardMessage(code):
        r"""getStandardMessage(int const code) -> string"""
        return _libnuml.XMLError_getStandardMessage(code)

    def getPackage(self):
        r"""getPackage(XMLError self) -> string"""
        return _libnuml.XMLError_getPackage(self)

    def getErrorIdOffset(self):
        r"""getErrorIdOffset(XMLError self) -> unsigned int"""
        return _libnuml.XMLError_getErrorIdOffset(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLError in _libnuml:
_libnuml.XMLError_swigregister(XMLError)
class SBMLNamespaces(object):
    r"""Proxy of C++ SBMLNamespaces class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_SBMLNamespaces

    def __init__(self, *args):
        r"""
        __init__(SBMLNamespaces self, unsigned int level=SBML_DEFAULT_LEVEL, unsigned int version=SBML_DEFAULT_VERSION) -> SBMLNamespaces
        __init__(SBMLNamespaces self, unsigned int level, unsigned int version, string pkgName, unsigned int pkgVersion, string pkgPrefix="") -> SBMLNamespaces
        __init__(SBMLNamespaces self, SBMLNamespaces orig) -> SBMLNamespaces
        """
        _libnuml.SBMLNamespaces_swiginit(self, _libnuml.new_SBMLNamespaces(*args))

    def clone(self):
        r"""clone(SBMLNamespaces self) -> SBMLNamespaces"""
        return _libnuml.SBMLNamespaces_clone(self)

    @staticmethod
    def getSBMLNamespaceURI(level, version):
        r"""getSBMLNamespaceURI(unsigned int level, unsigned int version) -> string"""
        return _libnuml.SBMLNamespaces_getSBMLNamespaceURI(level, version)

    @staticmethod
    def getSupportedNamespaces():
        r"""getSupportedNamespaces() -> List"""
        return _libnuml.SBMLNamespaces_getSupportedNamespaces()

    @staticmethod
    def freeSBMLNamespaces(supportedNS):
        r"""freeSBMLNamespaces(List supportedNS)"""
        return _libnuml.SBMLNamespaces_freeSBMLNamespaces(supportedNS)

    def getURI(self):
        r"""getURI(SBMLNamespaces self) -> string"""
        return _libnuml.SBMLNamespaces_getURI(self)

    def getLevel(self, *args):
        r"""
        getLevel(SBMLNamespaces self) -> unsigned int
        getLevel(SBMLNamespaces self) -> unsigned int
        """
        return _libnuml.SBMLNamespaces_getLevel(self, *args)

    def getVersion(self, *args):
        r"""
        getVersion(SBMLNamespaces self) -> unsigned int
        getVersion(SBMLNamespaces self) -> unsigned int
        """
        return _libnuml.SBMLNamespaces_getVersion(self, *args)

    def getNamespaces(self, *args):
        r"""
        getNamespaces(SBMLNamespaces self) -> XMLNamespaces
        getNamespaces(SBMLNamespaces self) -> XMLNamespaces
        """
        return _libnuml.SBMLNamespaces_getNamespaces(self, *args)

    def addNamespaces(self, xmlns):
        r"""addNamespaces(SBMLNamespaces self, XMLNamespaces xmlns) -> int"""
        return _libnuml.SBMLNamespaces_addNamespaces(self, xmlns)

    def addNamespace(self, uri, prefix):
        r"""addNamespace(SBMLNamespaces self, string uri, string prefix) -> int"""
        return _libnuml.SBMLNamespaces_addNamespace(self, uri, prefix)

    def removeNamespace(self, uri):
        r"""removeNamespace(SBMLNamespaces self, string uri) -> int"""
        return _libnuml.SBMLNamespaces_removeNamespace(self, uri)

    def addPackageNamespace(self, *args):
        r"""addPackageNamespace(SBMLNamespaces self, string pkgName, unsigned int pkgVersion, string prefix="") -> int"""
        return _libnuml.SBMLNamespaces_addPackageNamespace(self, *args)

    def addPackageNamespaces(self, xmlns):
        r"""addPackageNamespaces(SBMLNamespaces self, XMLNamespaces xmlns) -> int"""
        return _libnuml.SBMLNamespaces_addPackageNamespaces(self, xmlns)

    def removePackageNamespace(self, level, version, pkgName, pkgVersion):
        r"""removePackageNamespace(SBMLNamespaces self, unsigned int level, unsigned int version, string pkgName, unsigned int pkgVersion) -> int"""
        return _libnuml.SBMLNamespaces_removePackageNamespace(self, level, version, pkgName, pkgVersion)

    def addPkgNamespace(self, *args):
        r"""addPkgNamespace(SBMLNamespaces self, string pkgName, unsigned int pkgVersion, string prefix="") -> int"""
        return _libnuml.SBMLNamespaces_addPkgNamespace(self, *args)

    def addPkgNamespaces(self, xmlns):
        r"""addPkgNamespaces(SBMLNamespaces self, XMLNamespaces xmlns) -> int"""
        return _libnuml.SBMLNamespaces_addPkgNamespaces(self, xmlns)

    def removePkgNamespace(self, level, version, pkgName, pkgVersion):
        r"""removePkgNamespace(SBMLNamespaces self, unsigned int level, unsigned int version, string pkgName, unsigned int pkgVersion) -> int"""
        return _libnuml.SBMLNamespaces_removePkgNamespace(self, level, version, pkgName, pkgVersion)

    @staticmethod
    def isSBMLNamespace(uri):
        r"""isSBMLNamespace(string uri) -> bool"""
        return _libnuml.SBMLNamespaces_isSBMLNamespace(uri)

    def isValidCombination(self):
        r"""isValidCombination(SBMLNamespaces self) -> bool"""
        return _libnuml.SBMLNamespaces_isValidCombination(self)

    def setLevel(self, level):
        r"""setLevel(SBMLNamespaces self, unsigned int level)"""
        return _libnuml.SBMLNamespaces_setLevel(self, level)

    def setVersion(self, version):
        r"""setVersion(SBMLNamespaces self, unsigned int version)"""
        return _libnuml.SBMLNamespaces_setVersion(self, version)

    def setNamespaces(self, xmlns):
        r"""setNamespaces(SBMLNamespaces self, XMLNamespaces xmlns)"""
        return _libnuml.SBMLNamespaces_setNamespaces(self, xmlns)

    def getPackageName(self):
        r"""getPackageName(SBMLNamespaces self) -> string"""
        return _libnuml.SBMLNamespaces_getPackageName(self)

    __metaclass__ = AutoProperty


# Register SBMLNamespaces in _libnuml:
_libnuml.SBMLNamespaces_swigregister(SBMLNamespaces)
SBML_DEFAULT_LEVEL = cvar.SBML_DEFAULT_LEVEL
SBML_DEFAULT_VERSION = cvar.SBML_DEFAULT_VERSION
SBML_XMLNS_L1 = cvar.SBML_XMLNS_L1
SBML_XMLNS_L2V1 = cvar.SBML_XMLNS_L2V1
SBML_XMLNS_L2V2 = cvar.SBML_XMLNS_L2V2
SBML_XMLNS_L2V3 = cvar.SBML_XMLNS_L2V3
SBML_XMLNS_L2V4 = cvar.SBML_XMLNS_L2V4
SBML_XMLNS_L2V5 = cvar.SBML_XMLNS_L2V5
SBML_XMLNS_L3V1 = cvar.SBML_XMLNS_L3V1
SBML_XMLNS_L3V2 = cvar.SBML_XMLNS_L3V2

class NUMLList(NMBase):
    r"""Proxy of C++ NUMLList class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_NUMLList

    def __init__(self, *args):
        r"""
        __init__(NUMLList self, unsigned int level, unsigned int version) -> NUMLList
        __init__(NUMLList self, NUMLNamespaces numlns) -> NUMLList
        __init__(NUMLList self) -> NUMLList
        __init__(NUMLList self, NUMLList orig) -> NUMLList
        """
        _libnuml.NUMLList_swiginit(self, _libnuml.new_NUMLList(*args))

    def clone(self):
        r"""clone(NUMLList self) -> NMBase"""
        return _libnuml.NUMLList_clone(self)

    def append(self, item):
        r"""append(NUMLList self, NMBase item)"""
        return _libnuml.NUMLList_append(self, item)

    def appendAndOwn(self, item):
        r"""appendAndOwn(NUMLList self, NMBase item)"""

        if args[0] is not None: args[0].thisown = 0


        return _libnuml.NUMLList_appendAndOwn(self, item)


    def get(self, *args):
        r"""
        get(NUMLList self, unsigned int n) -> NMBase
        get(NUMLList self, unsigned int n) -> NMBase
        """
        return _libnuml.NUMLList_get(self, *args)

    def clear(self, doDelete=True):
        r"""clear(NUMLList self, bool doDelete=True)"""
        return _libnuml.NUMLList_clear(self, doDelete)

    def remove(self, n):
        r"""remove(NUMLList self, unsigned int n) -> NMBase"""
        return _libnuml.NUMLList_remove(self, n)

    def size(self):
        r"""size(NUMLList self) -> unsigned int"""
        return _libnuml.NUMLList_size(self)

    def getTypeCode(self):
        r"""getTypeCode(NUMLList self) -> NUMLTypeCode_t"""
        return _libnuml.NUMLList_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(NUMLList self) -> NUMLTypeCode_t"""
        return _libnuml.NUMLList_getItemTypeCode(self)

    def getElementName(self):
        r"""getElementName(NUMLList self) -> string"""
        return _libnuml.NUMLList_getElementName(self)

    def __len__(self):
        r"""__len__(NUMLList self) -> int"""
        return _libnuml.NUMLList___len__(self)

    def __getitem__(self, key):

      try:
         keyIsSlice = isinstance(key, slice)
      except:
         keyIsSlice = 0

      if keyIsSlice:
        start = key.start
        if start is None:
          start = 0
        stop = key.stop
        if stop is None:
          stop = self.size()
        return [self[i] for i in range(
          self._fixNegativeIndex(start), self._fixNegativeIndex(stop)
        )]

      key = self._fixNegativeIndex(key)
      if key < 0 or key >= self.size():
        raise IndexError(key)
      return self.get(key)


    def _fixNegativeIndex(self, index):
      if index < 0:
        return index + self.size()
      else:
        return index


    def __iter__(self):
      for i in range(self.size()):
        yield self[i]


    def __repr__(self):
      return "[" + ", ".join([repr(self[i]) for i in range(len(self))]) + "]"


    def __str__(self):
      return repr(self)


# Register NUMLList in _libnuml:
_libnuml.NUMLList_swigregister(NUMLList)
class OntologyTerm(NMBase):
    r"""Proxy of C++ OntologyTerm class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(OntologyTerm self, unsigned int level, unsigned int version) -> OntologyTerm
        __init__(OntologyTerm self, NUMLNamespaces numlns) -> OntologyTerm
        """
        _libnuml.OntologyTerm_swiginit(self, _libnuml.new_OntologyTerm(*args))

    def clone(self):
        r"""clone(OntologyTerm self) -> OntologyTerm"""
        return _libnuml.OntologyTerm_clone(self)

    def getId(self):
        r"""getId(OntologyTerm self) -> string"""
        return _libnuml.OntologyTerm_getId(self)

    def getTerm(self):
        r"""getTerm(OntologyTerm self) -> string"""
        return _libnuml.OntologyTerm_getTerm(self)

    def getSourceTermId(self):
        r"""getSourceTermId(OntologyTerm self) -> string"""
        return _libnuml.OntologyTerm_getSourceTermId(self)

    def getOntologyURI(self):
        r"""getOntologyURI(OntologyTerm self) -> string"""
        return _libnuml.OntologyTerm_getOntologyURI(self)
    __swig_destroy__ = _libnuml.delete_OntologyTerm

    def setId(self, sid):
        r"""setId(OntologyTerm self, string sid) -> int"""
        return _libnuml.OntologyTerm_setId(self, sid)

    def setTerm(self, term):
        r"""setTerm(OntologyTerm self, string term) -> int"""
        return _libnuml.OntologyTerm_setTerm(self, term)

    def setSourceTermId(self, sourceTermId):
        r"""setSourceTermId(OntologyTerm self, string sourceTermId) -> int"""
        return _libnuml.OntologyTerm_setSourceTermId(self, sourceTermId)

    def setOntologyURI(self, ontologyURI):
        r"""setOntologyURI(OntologyTerm self, string ontologyURI) -> int"""
        return _libnuml.OntologyTerm_setOntologyURI(self, ontologyURI)

    def getTypeCode(self):
        r"""getTypeCode(OntologyTerm self) -> NUMLTypeCode_t"""
        return _libnuml.OntologyTerm_getTypeCode(self)

    def getElementName(self):
        r"""getElementName(OntologyTerm self) -> string"""
        return _libnuml.OntologyTerm_getElementName(self)

    def readAttributes(self, attributes):
        r"""readAttributes(OntologyTerm self, XMLAttributes attributes)"""
        return _libnuml.OntologyTerm_readAttributes(self, attributes)

    def writeAttributes(self, stream):
        r"""writeAttributes(OntologyTerm self, XMLOutputStream stream)"""
        return _libnuml.OntologyTerm_writeAttributes(self, stream)

# Register OntologyTerm in _libnuml:
_libnuml.OntologyTerm_swigregister(OntologyTerm)
class ONTOLOGY(object):
    r"""Proxy of C++ ONTOLOGY class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    term = property(_libnuml.ONTOLOGY_term_get, _libnuml.ONTOLOGY_term_set, doc=r"""term : std::string""")
    sourceTermId = property(_libnuml.ONTOLOGY_sourceTermId_get, _libnuml.ONTOLOGY_sourceTermId_set, doc=r"""sourceTermId : std::string""")
    ontologyURI = property(_libnuml.ONTOLOGY_ontologyURI_get, _libnuml.ONTOLOGY_ontologyURI_set, doc=r"""ontologyURI : std::string""")

    def __init__(self):
        r"""__init__(ONTOLOGY self) -> ONTOLOGY"""
        _libnuml.ONTOLOGY_swiginit(self, _libnuml.new_ONTOLOGY())
    __swig_destroy__ = _libnuml.delete_ONTOLOGY

# Register ONTOLOGY in _libnuml:
_libnuml.ONTOLOGY_swigregister(ONTOLOGY)
class OntologyTerms(NUMLList):
    r"""Proxy of C++ OntologyTerms class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def clone(self):
        r"""clone(OntologyTerms self) -> OntologyTerms"""
        return _libnuml.OntologyTerms_clone(self)

    def getTypeCode(self):
        r"""getTypeCode(OntologyTerms self) -> NUMLTypeCode_t"""
        return _libnuml.OntologyTerms_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(OntologyTerms self) -> NUMLTypeCode_t"""
        return _libnuml.OntologyTerms_getItemTypeCode(self)

    def getElementName(self):
        r"""getElementName(OntologyTerms self) -> string"""
        return _libnuml.OntologyTerms_getElementName(self)

    def get(self, *args):
        r"""
        get(OntologyTerms self, unsigned int n) -> OntologyTerm
        get(OntologyTerms self, unsigned int n) -> OntologyTerm
        get(OntologyTerms self, string sid) -> OntologyTerm
        get(OntologyTerms self, string sid) -> OntologyTerm
        """
        return _libnuml.OntologyTerms_get(self, *args)

    def remove(self, *args):
        r"""
        remove(OntologyTerms self, unsigned int n) -> OntologyTerm
        remove(OntologyTerms self, string sid) -> OntologyTerm
        """
        return _libnuml.OntologyTerms_remove(self, *args)

    def __init__(self):
        r"""__init__(OntologyTerms self) -> OntologyTerms"""
        _libnuml.OntologyTerms_swiginit(self, _libnuml.new_OntologyTerms())
    __swig_destroy__ = _libnuml.delete_OntologyTerms

# Register OntologyTerms in _libnuml:
_libnuml.OntologyTerms_swigregister(OntologyTerms)
class ResultComponent(NMBase):
    r"""Proxy of C++ ResultComponent class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def clone(self):
        r"""clone(ResultComponent self) -> ResultComponent"""
        return _libnuml.ResultComponent_clone(self)

    def getId(self):
        r"""getId(ResultComponent self) -> string"""
        return _libnuml.ResultComponent_getId(self)

    def setId(self, sid):
        r"""setId(ResultComponent self, string sid) -> int"""
        return _libnuml.ResultComponent_setId(self, sid)

    def getTypeCode(self):
        r"""getTypeCode(ResultComponent self) -> NUMLTypeCode_t"""
        return _libnuml.ResultComponent_getTypeCode(self)

    def getElementName(self):
        r"""getElementName(ResultComponent self) -> string"""
        return _libnuml.ResultComponent_getElementName(self)

    def __init__(self, *args):
        r"""
        __init__(ResultComponent self, unsigned int level, unsigned int version) -> ResultComponent
        __init__(ResultComponent self, NUMLNamespaces numlns) -> ResultComponent
        """
        _libnuml.ResultComponent_swiginit(self, _libnuml.new_ResultComponent(*args))

    def createDimensionDescription(self):
        r"""createDimensionDescription(ResultComponent self) -> DimensionDescription"""
        return _libnuml.ResultComponent_createDimensionDescription(self)

    def createCompositeDescription(self):
        r"""createCompositeDescription(ResultComponent self) -> CompositeDescription"""
        return _libnuml.ResultComponent_createCompositeDescription(self)

    def createCompositeValue(self):
        r"""createCompositeValue(ResultComponent self) -> CompositeValue"""
        return _libnuml.ResultComponent_createCompositeValue(self)

    def createTupleDescription(self):
        r"""createTupleDescription(ResultComponent self) -> TupleDescription"""
        return _libnuml.ResultComponent_createTupleDescription(self)

    def createTuple(self):
        r"""createTuple(ResultComponent self) -> Tuple"""
        return _libnuml.ResultComponent_createTuple(self)

    def createAtomicDescription(self):
        r"""createAtomicDescription(ResultComponent self) -> AtomicDescription"""
        return _libnuml.ResultComponent_createAtomicDescription(self)

    def createAtomicValue(self):
        r"""createAtomicValue(ResultComponent self) -> AtomicValue"""
        return _libnuml.ResultComponent_createAtomicValue(self)

    def getDimensionDescription(self):
        r"""getDimensionDescription(ResultComponent self) -> DimensionDescription"""
        return _libnuml.ResultComponent_getDimensionDescription(self)

    def getDimension(self):
        r"""getDimension(ResultComponent self) -> Dimension"""
        return _libnuml.ResultComponent_getDimension(self)
    __swig_destroy__ = _libnuml.delete_ResultComponent

    def createObject(self, stream):
        r"""createObject(ResultComponent self, XMLInputStream stream) -> NMBase"""
        return _libnuml.ResultComponent_createObject(self, stream)

    def readAttributes(self, attributes):
        r"""readAttributes(ResultComponent self, XMLAttributes attributes)"""
        return _libnuml.ResultComponent_readAttributes(self, attributes)

    def writeAttributes(self, stream):
        r"""writeAttributes(ResultComponent self, XMLOutputStream stream)"""
        return _libnuml.ResultComponent_writeAttributes(self, stream)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register ResultComponent in _libnuml:
_libnuml.ResultComponent_swigregister(ResultComponent)
class ResultComponents(NUMLList):
    r"""Proxy of C++ ResultComponents class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def clone(self):
        r"""clone(ResultComponents self) -> ResultComponents"""
        return _libnuml.ResultComponents_clone(self)

    def getTypeCode(self):
        r"""getTypeCode(ResultComponents self) -> NUMLTypeCode_t"""
        return _libnuml.ResultComponents_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(ResultComponents self) -> NUMLTypeCode_t"""
        return _libnuml.ResultComponents_getItemTypeCode(self)

    def getElementName(self):
        r"""getElementName(ResultComponents self) -> string"""
        return _libnuml.ResultComponents_getElementName(self)

    def getResultComponents(self):
        r"""getResultComponents(ResultComponents self) -> ResultComponents"""
        return _libnuml.ResultComponents_getResultComponents(self)

    def get(self, *args):
        r"""
        get(ResultComponents self, unsigned int n) -> ResultComponent
        get(ResultComponents self, unsigned int n) -> ResultComponent
        get(ResultComponents self, string sid) -> ResultComponent
        get(ResultComponents self, string sid) -> ResultComponent
        """
        return _libnuml.ResultComponents_get(self, *args)

    def remove(self, *args):
        r"""
        remove(ResultComponents self, unsigned int n) -> ResultComponent
        remove(ResultComponents self, string sid) -> ResultComponent
        """
        return _libnuml.ResultComponents_remove(self, *args)

    def __init__(self):
        r"""__init__(ResultComponents self) -> ResultComponents"""
        _libnuml.ResultComponents_swiginit(self, _libnuml.new_ResultComponents())
    __swig_destroy__ = _libnuml.delete_ResultComponents

# Register ResultComponents in _libnuml:
_libnuml.ResultComponents_swigregister(ResultComponents)
class Dimension(NUMLList):
    r"""Proxy of C++ Dimension class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Dimension self) -> Dimension
        __init__(Dimension self, unsigned int level, unsigned int version) -> Dimension
        __init__(Dimension self, NUMLNamespaces numlns) -> Dimension
        """
        _libnuml.Dimension_swiginit(self, _libnuml.new_Dimension(*args))

    def clone(self):
        r"""clone(Dimension self) -> Dimension"""
        return _libnuml.Dimension_clone(self)

    def createCompositeValue(self):
        r"""createCompositeValue(Dimension self) -> CompositeValue"""
        return _libnuml.Dimension_createCompositeValue(self)

    def createTuple(self):
        r"""createTuple(Dimension self) -> Tuple"""
        return _libnuml.Dimension_createTuple(self)

    def createAtomicValue(self):
        r"""createAtomicValue(Dimension self) -> AtomicValue"""
        return _libnuml.Dimension_createAtomicValue(self)

    def getTypeCode(self):
        r"""getTypeCode(Dimension self) -> NUMLTypeCode_t"""
        return _libnuml.Dimension_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(Dimension self) -> NUMLTypeCode_t"""
        return _libnuml.Dimension_getItemTypeCode(self)

    def getElementName(self):
        r"""getElementName(Dimension self) -> string"""
        return _libnuml.Dimension_getElementName(self)

    def get(self, *args):
        r"""
        get(Dimension self, unsigned int n) -> Dimension
        get(Dimension self, unsigned int n) -> Dimension
        get(Dimension self, string sid) -> CompositeValue
        get(Dimension self, string sid) -> CompositeValue
        """
        return _libnuml.Dimension_get(self, *args)

    def remove(self, *args):
        r"""
        remove(Dimension self, unsigned int n) -> Dimension
        remove(Dimension self, string sid) -> Dimension
        """
        return _libnuml.Dimension_remove(self, *args)
    __swig_destroy__ = _libnuml.delete_Dimension

# Register Dimension in _libnuml:
_libnuml.Dimension_swigregister(Dimension)
class DimensionDescription(NUMLList):
    r"""Proxy of C++ DimensionDescription class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(DimensionDescription self) -> DimensionDescription
        __init__(DimensionDescription self, unsigned int level, unsigned int version) -> DimensionDescription
        __init__(DimensionDescription self, NUMLNamespaces numlns) -> DimensionDescription
        """
        _libnuml.DimensionDescription_swiginit(self, _libnuml.new_DimensionDescription(*args))

    def clone(self):
        r"""clone(DimensionDescription self) -> DimensionDescription"""
        return _libnuml.DimensionDescription_clone(self)

    def createCompositeDescription(self):
        r"""createCompositeDescription(DimensionDescription self) -> CompositeDescription"""
        return _libnuml.DimensionDescription_createCompositeDescription(self)

    def createTupleDescription(self):
        r"""createTupleDescription(DimensionDescription self) -> TupleDescription"""
        return _libnuml.DimensionDescription_createTupleDescription(self)

    def createAtomicDescription(self):
        r"""createAtomicDescription(DimensionDescription self) -> AtomicDescription"""
        return _libnuml.DimensionDescription_createAtomicDescription(self)

    def getElementName(self):
        r"""getElementName(DimensionDescription self) -> string"""
        return _libnuml.DimensionDescription_getElementName(self)

    def getTypeCode(self):
        r"""getTypeCode(DimensionDescription self) -> NUMLTypeCode_t"""
        return _libnuml.DimensionDescription_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(DimensionDescription self) -> NUMLTypeCode_t"""
        return _libnuml.DimensionDescription_getItemTypeCode(self)

    def get(self, *args):
        r"""
        get(DimensionDescription self, unsigned int n) -> DimensionDescription
        get(DimensionDescription self, unsigned int n) -> DimensionDescription
        get(DimensionDescription self, string sid) -> DimensionDescription
        get(DimensionDescription self, string sid) -> DimensionDescription
        """
        return _libnuml.DimensionDescription_get(self, *args)

    def getId(self):
        r"""getId(DimensionDescription self) -> string"""
        return _libnuml.DimensionDescription_getId(self)

    def setId(self, id):
        r"""setId(DimensionDescription self, string id) -> int"""
        return _libnuml.DimensionDescription_setId(self, id)

    def getName(self):
        r"""getName(DimensionDescription self) -> string"""
        return _libnuml.DimensionDescription_getName(self)

    def setName(self, name):
        r"""setName(DimensionDescription self, string name) -> int"""
        return _libnuml.DimensionDescription_setName(self, name)

    def remove(self, *args):
        r"""
        remove(DimensionDescription self, unsigned int n) -> DimensionDescription
        remove(DimensionDescription self, string sid) -> DimensionDescription
        """
        return _libnuml.DimensionDescription_remove(self, *args)
    __swig_destroy__ = _libnuml.delete_DimensionDescription

# Register DimensionDescription in _libnuml:
_libnuml.DimensionDescription_swigregister(DimensionDescription)
class CompositeValue(Dimension):
    r"""Proxy of C++ CompositeValue class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_CompositeValue

    def __init__(self, *args):
        r"""
        __init__(CompositeValue self) -> CompositeValue
        __init__(CompositeValue self, unsigned int level, unsigned int version) -> CompositeValue
        __init__(CompositeValue self, NUMLNamespaces numlns) -> CompositeValue
        """
        _libnuml.CompositeValue_swiginit(self, _libnuml.new_CompositeValue(*args))

    def clone(self):
        r"""clone(CompositeValue self) -> CompositeValue"""
        return _libnuml.CompositeValue_clone(self)

    def getTypeCode(self):
        r"""getTypeCode(CompositeValue self) -> NUMLTypeCode_t"""
        return _libnuml.CompositeValue_getTypeCode(self)

    def getIndexValue(self):
        r"""getIndexValue(CompositeValue self) -> string"""
        return _libnuml.CompositeValue_getIndexValue(self)

    def getDescription(self):
        r"""getDescription(CompositeValue self) -> string"""
        return _libnuml.CompositeValue_getDescription(self)

    def setIndexValue(self, indexValue):
        r"""setIndexValue(CompositeValue self, string indexValue) -> int"""
        return _libnuml.CompositeValue_setIndexValue(self, indexValue)

    def setDescription(self, description):
        r"""setDescription(CompositeValue self, string description) -> int"""
        return _libnuml.CompositeValue_setDescription(self, description)

    def getElementName(self):
        r"""getElementName(CompositeValue self) -> string"""
        return _libnuml.CompositeValue_getElementName(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(CompositeValue self) -> NUMLTypeCode_t"""
        return _libnuml.CompositeValue_getItemTypeCode(self)

    def isContentCompositeValue(self):
        r"""isContentCompositeValue(CompositeValue self) -> bool"""
        return _libnuml.CompositeValue_isContentCompositeValue(self)

    def isContentTuple(self):
        r"""isContentTuple(CompositeValue self) -> bool"""
        return _libnuml.CompositeValue_isContentTuple(self)

    def isContentAtomicValue(self):
        r"""isContentAtomicValue(CompositeValue self) -> bool"""
        return _libnuml.CompositeValue_isContentAtomicValue(self)

    def getCompositeValue(self, n):
        r"""getCompositeValue(CompositeValue self, unsigned int n) -> CompositeValue"""
        return _libnuml.CompositeValue_getCompositeValue(self, n)

    def getTuple(self):
        r"""getTuple(CompositeValue self) -> Tuple"""
        return _libnuml.CompositeValue_getTuple(self)

    def getAtomicValue(self):
        r"""getAtomicValue(CompositeValue self) -> AtomicValue"""
        return _libnuml.CompositeValue_getAtomicValue(self)

    def get(self, *args):
        r"""
        get(CompositeValue self, unsigned int n) -> CompositeValue
        get(CompositeValue self, unsigned int n) -> CompositeValue
        """
        return _libnuml.CompositeValue_get(self, *args)

    def remove(self, n):
        r"""remove(CompositeValue self, unsigned int n) -> CompositeValue"""
        return _libnuml.CompositeValue_remove(self, n)

    def readAttributes(self, attributes):
        r"""readAttributes(CompositeValue self, XMLAttributes attributes)"""
        return _libnuml.CompositeValue_readAttributes(self, attributes)

    def writeAttributes(self, stream):
        r"""writeAttributes(CompositeValue self, XMLOutputStream stream)"""
        return _libnuml.CompositeValue_writeAttributes(self, stream)

    def addCompositeValue(self, compValue):
        r"""addCompositeValue(CompositeValue self, CompositeValue compValue) -> int"""
        return _libnuml.CompositeValue_addCompositeValue(self, compValue)

    def createCompositeValue(self):
        r"""createCompositeValue(CompositeValue self) -> CompositeValue"""
        return _libnuml.CompositeValue_createCompositeValue(self)

    def createTuple(self):
        r"""createTuple(CompositeValue self) -> Tuple"""
        return _libnuml.CompositeValue_createTuple(self)

    def createAtomicValue(self):
        r"""createAtomicValue(CompositeValue self) -> AtomicValue"""
        return _libnuml.CompositeValue_createAtomicValue(self)

# Register CompositeValue in _libnuml:
_libnuml.CompositeValue_swigregister(CompositeValue)
class Tuple(Dimension):
    r"""Proxy of C++ Tuple class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_Tuple

    def __init__(self, *args):
        r"""
        __init__(Tuple self) -> Tuple
        __init__(Tuple self, unsigned int level, unsigned int version) -> Tuple
        __init__(Tuple self, NUMLNamespaces numlns) -> Tuple
        """
        _libnuml.Tuple_swiginit(self, _libnuml.new_Tuple(*args))

    def clone(self):
        r"""clone(Tuple self) -> Tuple"""
        return _libnuml.Tuple_clone(self)

    def getTypeCode(self):
        r"""getTypeCode(Tuple self) -> NUMLTypeCode_t"""
        return _libnuml.Tuple_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(Tuple self) -> NUMLTypeCode_t"""
        return _libnuml.Tuple_getItemTypeCode(self)

    def getElementName(self):
        r"""getElementName(Tuple self) -> string"""
        return _libnuml.Tuple_getElementName(self)

    def getAtomicValue(self, *args):
        r"""
        getAtomicValue(Tuple self, unsigned int n) -> AtomicValue
        getAtomicValue(Tuple self, unsigned int n) -> AtomicValue
        """
        return _libnuml.Tuple_getAtomicValue(self, *args)

    def removeAtomicValue(self, n):
        r"""removeAtomicValue(Tuple self, unsigned int n) -> AtomicValue"""
        return _libnuml.Tuple_removeAtomicValue(self, n)

    def createAtomicValue(self):
        r"""createAtomicValue(Tuple self) -> AtomicValue"""
        return _libnuml.Tuple_createAtomicValue(self)

    def createObject(self, stream):
        r"""createObject(Tuple self, XMLInputStream stream) -> NMBase"""
        return _libnuml.Tuple_createObject(self, stream)

# Register Tuple in _libnuml:
_libnuml.Tuple_swigregister(Tuple)
class AtomicValue(Dimension):
    r"""Proxy of C++ AtomicValue class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getTypeCode(self):
        r"""getTypeCode(AtomicValue self) -> NUMLTypeCode_t"""
        return _libnuml.AtomicValue_getTypeCode(self)

    def getElementName(self):
        r"""getElementName(AtomicValue self) -> string"""
        return _libnuml.AtomicValue_getElementName(self)

    def getValue(self):
        r"""getValue(AtomicValue self) -> string"""
        return _libnuml.AtomicValue_getValue(self)

    def getDoubleValue(self):
        r"""getDoubleValue(AtomicValue self) -> double"""
        return _libnuml.AtomicValue_getDoubleValue(self)

    def setValue(self, value):
        r"""setValue(AtomicValue self, string value) -> int"""
        return _libnuml.AtomicValue_setValue(self, value)

    def writeChars(self, stream):
        r"""writeChars(AtomicValue self, XMLOutputStream stream)"""
        return _libnuml.AtomicValue_writeChars(self, stream)

    def clone(self):
        r"""clone(AtomicValue self) -> AtomicValue"""
        return _libnuml.AtomicValue_clone(self)

    def __init__(self, *args):
        r"""
        __init__(AtomicValue self, unsigned int level, unsigned int version) -> AtomicValue
        __init__(AtomicValue self, NUMLNamespaces numlns) -> AtomicValue
        __init__(AtomicValue self) -> AtomicValue
        """
        _libnuml.AtomicValue_swiginit(self, _libnuml.new_AtomicValue(*args))
    __swig_destroy__ = _libnuml.delete_AtomicValue

# Register AtomicValue in _libnuml:
_libnuml.AtomicValue_swigregister(AtomicValue)
class CompositeDescription(DimensionDescription):
    r"""Proxy of C++ CompositeDescription class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_CompositeDescription

    def __init__(self, *args):
        r"""
        __init__(CompositeDescription self) -> CompositeDescription
        __init__(CompositeDescription self, unsigned int level, unsigned int version) -> CompositeDescription
        __init__(CompositeDescription self, NUMLNamespaces numlns) -> CompositeDescription
        """
        _libnuml.CompositeDescription_swiginit(self, _libnuml.new_CompositeDescription(*args))

    def clone(self):
        r"""clone(CompositeDescription self) -> CompositeDescription"""
        return _libnuml.CompositeDescription_clone(self)

    def getName(self):
        r"""getName(CompositeDescription self) -> string"""
        return _libnuml.CompositeDescription_getName(self)

    def getId(self):
        r"""getId(CompositeDescription self) -> string"""
        return _libnuml.CompositeDescription_getId(self)

    def setId(self, id):
        r"""setId(CompositeDescription self, string id) -> int"""
        return _libnuml.CompositeDescription_setId(self, id)

    def getIndexType(self):
        r"""getIndexType(CompositeDescription self) -> string"""
        return _libnuml.CompositeDescription_getIndexType(self)

    def isContentCompositeDescription(self):
        r"""isContentCompositeDescription(CompositeDescription self) -> bool"""
        return _libnuml.CompositeDescription_isContentCompositeDescription(self)

    def isContentTupleDescription(self):
        r"""isContentTupleDescription(CompositeDescription self) -> bool"""
        return _libnuml.CompositeDescription_isContentTupleDescription(self)

    def isContentAtomicDescription(self):
        r"""isContentAtomicDescription(CompositeDescription self) -> bool"""
        return _libnuml.CompositeDescription_isContentAtomicDescription(self)

    def getOntologyTerm(self):
        r"""getOntologyTerm(CompositeDescription self) -> string"""
        return _libnuml.CompositeDescription_getOntologyTerm(self)

    def setName(self, name):
        r"""setName(CompositeDescription self, string name) -> int"""
        return _libnuml.CompositeDescription_setName(self, name)

    def setIndexType(self, indexType):
        r"""setIndexType(CompositeDescription self, string indexType) -> int"""
        return _libnuml.CompositeDescription_setIndexType(self, indexType)

    def setOntologyTerm(self, ontologyTerm):
        r"""setOntologyTerm(CompositeDescription self, string ontologyTerm) -> int"""
        return _libnuml.CompositeDescription_setOntologyTerm(self, ontologyTerm)

    def getElementName(self):
        r"""getElementName(CompositeDescription self) -> string"""
        return _libnuml.CompositeDescription_getElementName(self)

    def getTypeCode(self):
        r"""getTypeCode(CompositeDescription self) -> NUMLTypeCode_t"""
        return _libnuml.CompositeDescription_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(CompositeDescription self) -> NUMLTypeCode_t"""
        return _libnuml.CompositeDescription_getItemTypeCode(self)

    def getCompositeDescription(self, n):
        r"""getCompositeDescription(CompositeDescription self, unsigned int n) -> CompositeDescription"""
        return _libnuml.CompositeDescription_getCompositeDescription(self, n)

    def getTupleDescription(self):
        r"""getTupleDescription(CompositeDescription self) -> TupleDescription"""
        return _libnuml.CompositeDescription_getTupleDescription(self)

    def getAtomicDescription(self):
        r"""getAtomicDescription(CompositeDescription self) -> AtomicDescription"""
        return _libnuml.CompositeDescription_getAtomicDescription(self)

    def get(self, *args):
        r"""
        get(CompositeDescription self, unsigned int n) -> CompositeDescription
        get(CompositeDescription self, unsigned int n) -> CompositeDescription
        """
        return _libnuml.CompositeDescription_get(self, *args)

    def remove(self, n):
        r"""remove(CompositeDescription self, unsigned int n) -> CompositeDescription"""
        return _libnuml.CompositeDescription_remove(self, n)

    def createCompositeDescription(self):
        r"""createCompositeDescription(CompositeDescription self) -> CompositeDescription"""
        return _libnuml.CompositeDescription_createCompositeDescription(self)

    def createTupleDescription(self):
        r"""createTupleDescription(CompositeDescription self) -> TupleDescription"""
        return _libnuml.CompositeDescription_createTupleDescription(self)

    def createAtomicDescription(self):
        r"""createAtomicDescription(CompositeDescription self) -> AtomicDescription"""
        return _libnuml.CompositeDescription_createAtomicDescription(self)

# Register CompositeDescription in _libnuml:
_libnuml.CompositeDescription_swigregister(CompositeDescription)
class TupleDescription(DimensionDescription):
    r"""Proxy of C++ TupleDescription class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_TupleDescription

    def __init__(self, *args):
        r"""
        __init__(TupleDescription self) -> TupleDescription
        __init__(TupleDescription self, unsigned int level, unsigned int version) -> TupleDescription
        __init__(TupleDescription self, NUMLNamespaces numlns) -> TupleDescription
        """
        _libnuml.TupleDescription_swiginit(self, _libnuml.new_TupleDescription(*args))

    def clone(self):
        r"""clone(TupleDescription self) -> TupleDescription"""
        return _libnuml.TupleDescription_clone(self)

    def getId(self):
        r"""getId(TupleDescription self) -> string"""
        return _libnuml.TupleDescription_getId(self)

    def setId(self, id):
        r"""setId(TupleDescription self, string id) -> int"""
        return _libnuml.TupleDescription_setId(self, id)

    def getTypeCode(self):
        r"""getTypeCode(TupleDescription self) -> NUMLTypeCode_t"""
        return _libnuml.TupleDescription_getTypeCode(self)

    def getItemTypeCode(self):
        r"""getItemTypeCode(TupleDescription self) -> NUMLTypeCode_t"""
        return _libnuml.TupleDescription_getItemTypeCode(self)

    def getElementName(self):
        r"""getElementName(TupleDescription self) -> string"""
        return _libnuml.TupleDescription_getElementName(self)

    def getAtomicDescription(self, *args):
        r"""
        getAtomicDescription(TupleDescription self, unsigned int n) -> AtomicDescription
        getAtomicDescription(TupleDescription self, unsigned int n) -> AtomicDescription
        """
        return _libnuml.TupleDescription_getAtomicDescription(self, *args)

    def removeAtomicDescription(self, n):
        r"""removeAtomicDescription(TupleDescription self, unsigned int n) -> AtomicDescription"""
        return _libnuml.TupleDescription_removeAtomicDescription(self, n)

    def createAtomicDescription(self):
        r"""createAtomicDescription(TupleDescription self) -> AtomicDescription"""
        return _libnuml.TupleDescription_createAtomicDescription(self)

    def createObject(self, stream):
        r"""createObject(TupleDescription self, XMLInputStream stream) -> NMBase"""
        return _libnuml.TupleDescription_createObject(self, stream)

# Register TupleDescription in _libnuml:
_libnuml.TupleDescription_swigregister(TupleDescription)
class AtomicDescription(DimensionDescription):
    r"""Proxy of C++ AtomicDescription class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getTypeCode(self):
        r"""getTypeCode(AtomicDescription self) -> NUMLTypeCode_t"""
        return _libnuml.AtomicDescription_getTypeCode(self)

    def getElementName(self):
        r"""getElementName(AtomicDescription self) -> string"""
        return _libnuml.AtomicDescription_getElementName(self)

    def getValueType(self):
        r"""getValueType(AtomicDescription self) -> string"""
        return _libnuml.AtomicDescription_getValueType(self)

    def getOntologyTerm(self):
        r"""getOntologyTerm(AtomicDescription self) -> string"""
        return _libnuml.AtomicDescription_getOntologyTerm(self)

    def getName(self):
        r"""getName(AtomicDescription self) -> string"""
        return _libnuml.AtomicDescription_getName(self)

    def setOntologyTerm(self, ontologyTerm):
        r"""setOntologyTerm(AtomicDescription self, string ontologyTerm) -> int"""
        return _libnuml.AtomicDescription_setOntologyTerm(self, ontologyTerm)

    def setValueType(self, valueType):
        r"""setValueType(AtomicDescription self, string valueType) -> int"""
        return _libnuml.AtomicDescription_setValueType(self, valueType)

    def setName(self, name):
        r"""setName(AtomicDescription self, string name) -> int"""
        return _libnuml.AtomicDescription_setName(self, name)

    def getId(self):
        r"""getId(AtomicDescription self) -> string"""
        return _libnuml.AtomicDescription_getId(self)

    def setId(self, id):
        r"""setId(AtomicDescription self, string id) -> int"""
        return _libnuml.AtomicDescription_setId(self, id)

    def clone(self):
        r"""clone(AtomicDescription self) -> AtomicDescription"""
        return _libnuml.AtomicDescription_clone(self)

    def __init__(self, *args):
        r"""
        __init__(AtomicDescription self, unsigned int level, unsigned int version) -> AtomicDescription
        __init__(AtomicDescription self, NUMLNamespaces numlns) -> AtomicDescription
        __init__(AtomicDescription self) -> AtomicDescription
        """
        _libnuml.AtomicDescription_swiginit(self, _libnuml.new_AtomicDescription(*args))
    __swig_destroy__ = _libnuml.delete_AtomicDescription

# Register AtomicDescription in _libnuml:
_libnuml.AtomicDescription_swigregister(AtomicDescription)
class XMLAttributes(object):
    r"""Proxy of C++ XMLAttributes class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_XMLAttributes

    def __init__(self, *args):
        r"""
        __init__(XMLAttributes self) -> XMLAttributes
        __init__(XMLAttributes self, XMLAttributes orig) -> XMLAttributes
        """
        _libnuml.XMLAttributes_swiginit(self, _libnuml.new_XMLAttributes(*args))

    def clone(self):
        r"""clone(XMLAttributes self) -> XMLAttributes"""
        return _libnuml.XMLAttributes_clone(self)

    def add(self, *args):
        r"""
        add(XMLAttributes self, string name, string value, string namespaceURI="", string prefix="") -> int
        add(XMLAttributes self, XMLTriple triple, string value) -> int
        """
        return _libnuml.XMLAttributes_add(self, *args)

    def removeResource(self, n):
        r"""removeResource(XMLAttributes self, int n) -> int"""
        return _libnuml.XMLAttributes_removeResource(self, n)

    def remove(self, *args):
        r"""
        remove(XMLAttributes self, int n) -> int
        remove(XMLAttributes self, string name, string uri="") -> int
        remove(XMLAttributes self, XMLTriple triple) -> int
        """
        return _libnuml.XMLAttributes_remove(self, *args)

    def clear(self):
        r"""clear(XMLAttributes self) -> int"""
        return _libnuml.XMLAttributes_clear(self)

    def getIndex(self, *args):
        r"""
        getIndex(XMLAttributes self, string name) -> int
        getIndex(XMLAttributes self, string name, string uri) -> int
        getIndex(XMLAttributes self, XMLTriple triple) -> int
        """
        return _libnuml.XMLAttributes_getIndex(self, *args)

    def getLength(self):
        r"""getLength(XMLAttributes self) -> int"""
        return _libnuml.XMLAttributes_getLength(self)

    def getNumAttributes(self):
        r"""getNumAttributes(XMLAttributes self) -> int"""
        return _libnuml.XMLAttributes_getNumAttributes(self)

    def getName(self, index):
        r"""getName(XMLAttributes self, int index) -> string"""
        return _libnuml.XMLAttributes_getName(self, index)

    def getPrefix(self, index):
        r"""getPrefix(XMLAttributes self, int index) -> string"""
        return _libnuml.XMLAttributes_getPrefix(self, index)

    def getPrefixedName(self, index):
        r"""getPrefixedName(XMLAttributes self, int index) -> string"""
        return _libnuml.XMLAttributes_getPrefixedName(self, index)

    def getURI(self, index):
        r"""getURI(XMLAttributes self, int index) -> string"""
        return _libnuml.XMLAttributes_getURI(self, index)

    def getValue(self, *args):
        r"""
        getValue(XMLAttributes self, int index) -> string
        getValue(XMLAttributes self, string name) -> string
        getValue(XMLAttributes self, string name, string uri) -> string
        getValue(XMLAttributes self, XMLTriple triple) -> string
        """
        return _libnuml.XMLAttributes_getValue(self, *args)

    def hasAttribute(self, *args):
        r"""
        hasAttribute(XMLAttributes self, int index) -> bool
        hasAttribute(XMLAttributes self, string name, string uri="") -> bool
        hasAttribute(XMLAttributes self, XMLTriple triple) -> bool
        """
        return _libnuml.XMLAttributes_hasAttribute(self, *args)

    def isEmpty(self):
        r"""isEmpty(XMLAttributes self) -> bool"""
        return _libnuml.XMLAttributes_isEmpty(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLAttributes in _libnuml:
_libnuml.XMLAttributes_swigregister(XMLAttributes)
class XMLNamespaces(object):
    r"""Proxy of C++ XMLNamespaces class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_XMLNamespaces

    def __init__(self, *args):
        r"""
        __init__(XMLNamespaces self) -> XMLNamespaces
        __init__(XMLNamespaces self, XMLNamespaces orig) -> XMLNamespaces
        """
        _libnuml.XMLNamespaces_swiginit(self, _libnuml.new_XMLNamespaces(*args))

    def clone(self):
        r"""clone(XMLNamespaces self) -> XMLNamespaces"""
        return _libnuml.XMLNamespaces_clone(self)

    def add(self, *args):
        r"""add(XMLNamespaces self, string uri, string prefix="") -> int"""
        return _libnuml.XMLNamespaces_add(self, *args)

    def remove(self, *args):
        r"""
        remove(XMLNamespaces self, int index) -> int
        remove(XMLNamespaces self, string prefix) -> int
        """
        return _libnuml.XMLNamespaces_remove(self, *args)

    def clear(self):
        r"""clear(XMLNamespaces self) -> int"""
        return _libnuml.XMLNamespaces_clear(self)

    def getIndex(self, uri):
        r"""getIndex(XMLNamespaces self, string uri) -> int"""
        return _libnuml.XMLNamespaces_getIndex(self, uri)

    def containsUri(self, uri):
        r"""containsUri(XMLNamespaces self, string uri) -> bool"""
        return _libnuml.XMLNamespaces_containsUri(self, uri)

    def getIndexByPrefix(self, prefix):
        r"""getIndexByPrefix(XMLNamespaces self, string prefix) -> int"""
        return _libnuml.XMLNamespaces_getIndexByPrefix(self, prefix)

    def getLength(self):
        r"""getLength(XMLNamespaces self) -> int"""
        return _libnuml.XMLNamespaces_getLength(self)

    def getNumNamespaces(self):
        r"""getNumNamespaces(XMLNamespaces self) -> int"""
        return _libnuml.XMLNamespaces_getNumNamespaces(self)

    def getPrefix(self, *args):
        r"""
        getPrefix(XMLNamespaces self, int index) -> string
        getPrefix(XMLNamespaces self, string uri) -> string
        """
        return _libnuml.XMLNamespaces_getPrefix(self, *args)

    def getURI(self, *args):
        r"""
        getURI(XMLNamespaces self, int index) -> string
        getURI(XMLNamespaces self, string prefix="") -> string
        """
        return _libnuml.XMLNamespaces_getURI(self, *args)

    def isEmpty(self):
        r"""isEmpty(XMLNamespaces self) -> bool"""
        return _libnuml.XMLNamespaces_isEmpty(self)

    def hasURI(self, uri):
        r"""hasURI(XMLNamespaces self, string uri) -> bool"""
        return _libnuml.XMLNamespaces_hasURI(self, uri)

    def hasPrefix(self, prefix):
        r"""hasPrefix(XMLNamespaces self, string prefix) -> bool"""
        return _libnuml.XMLNamespaces_hasPrefix(self, prefix)

    def hasNS(self, uri, prefix):
        r"""hasNS(XMLNamespaces self, string uri, string prefix) -> bool"""
        return _libnuml.XMLNamespaces_hasNS(self, uri, prefix)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLNamespaces in _libnuml:
_libnuml.XMLNamespaces_swigregister(XMLNamespaces)
class XMLToken(object):
    r"""Proxy of C++ XMLToken class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_XMLToken

    def __init__(self, *args):
        r"""
        __init__(XMLToken self) -> XMLToken
        __init__(XMLToken self, XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, unsigned int const line=0, unsigned int const column=0) -> XMLToken
        __init__(XMLToken self, XMLTriple triple, XMLAttributes attributes, unsigned int const line=0, unsigned int const column=0) -> XMLToken
        __init__(XMLToken self, XMLTriple triple, unsigned int const line=0, unsigned int const column=0) -> XMLToken
        __init__(XMLToken self, string chars, unsigned int const line=0, unsigned int const column=0) -> XMLToken
        __init__(XMLToken self, XMLToken orig) -> XMLToken
        """
        _libnuml.XMLToken_swiginit(self, _libnuml.new_XMLToken(*args))

    def clone(self):
        r"""clone(XMLToken self) -> XMLToken"""
        return _libnuml.XMLToken_clone(self)

    def getAttributes(self):
        r"""getAttributes(XMLToken self) -> XMLAttributes"""
        return _libnuml.XMLToken_getAttributes(self)

    def setAttributes(self, attributes):
        r"""setAttributes(XMLToken self, XMLAttributes attributes) -> int"""
        return _libnuml.XMLToken_setAttributes(self, attributes)

    def addAttr(self, *args):
        r"""
        addAttr(XMLToken self, string name, string value, string namespaceURI="", string prefix="") -> int
        addAttr(XMLToken self, XMLTriple triple, string value) -> int
        """
        return _libnuml.XMLToken_addAttr(self, *args)

    def removeAttr(self, *args):
        r"""
        removeAttr(XMLToken self, int n) -> int
        removeAttr(XMLToken self, string name, string uri="") -> int
        removeAttr(XMLToken self, XMLTriple triple) -> int
        """
        return _libnuml.XMLToken_removeAttr(self, *args)

    def clearAttributes(self):
        r"""clearAttributes(XMLToken self) -> int"""
        return _libnuml.XMLToken_clearAttributes(self)

    def getAttrIndex(self, *args):
        r"""
        getAttrIndex(XMLToken self, string name, string uri="") -> int
        getAttrIndex(XMLToken self, XMLTriple triple) -> int
        """
        return _libnuml.XMLToken_getAttrIndex(self, *args)

    def getAttributesLength(self):
        r"""getAttributesLength(XMLToken self) -> int"""
        return _libnuml.XMLToken_getAttributesLength(self)

    def getAttrName(self, index):
        r"""getAttrName(XMLToken self, int index) -> string"""
        return _libnuml.XMLToken_getAttrName(self, index)

    def getAttrPrefix(self, index):
        r"""getAttrPrefix(XMLToken self, int index) -> string"""
        return _libnuml.XMLToken_getAttrPrefix(self, index)

    def getAttrPrefixedName(self, index):
        r"""getAttrPrefixedName(XMLToken self, int index) -> string"""
        return _libnuml.XMLToken_getAttrPrefixedName(self, index)

    def getAttrURI(self, index):
        r"""getAttrURI(XMLToken self, int index) -> string"""
        return _libnuml.XMLToken_getAttrURI(self, index)

    def getAttrValue(self, *args):
        r"""
        getAttrValue(XMLToken self, int index) -> string
        getAttrValue(XMLToken self, string name, string uri="") -> string
        getAttrValue(XMLToken self, XMLTriple triple) -> string
        """
        return _libnuml.XMLToken_getAttrValue(self, *args)

    def hasAttr(self, *args):
        r"""
        hasAttr(XMLToken self, int index) -> bool
        hasAttr(XMLToken self, string name, string uri="") -> bool
        hasAttr(XMLToken self, XMLTriple triple) -> bool
        """
        return _libnuml.XMLToken_hasAttr(self, *args)

    def isAttributesEmpty(self):
        r"""isAttributesEmpty(XMLToken self) -> bool"""
        return _libnuml.XMLToken_isAttributesEmpty(self)

    def getNamespaces(self):
        r"""getNamespaces(XMLToken self) -> XMLNamespaces"""
        return _libnuml.XMLToken_getNamespaces(self)

    def setNamespaces(self, namespaces):
        r"""setNamespaces(XMLToken self, XMLNamespaces namespaces) -> int"""
        return _libnuml.XMLToken_setNamespaces(self, namespaces)

    def addNamespace(self, *args):
        r"""addNamespace(XMLToken self, string uri, string prefix="") -> int"""
        return _libnuml.XMLToken_addNamespace(self, *args)

    def removeNamespace(self, *args):
        r"""
        removeNamespace(XMLToken self, int index) -> int
        removeNamespace(XMLToken self, string prefix) -> int
        """
        return _libnuml.XMLToken_removeNamespace(self, *args)

    def clearNamespaces(self):
        r"""clearNamespaces(XMLToken self) -> int"""
        return _libnuml.XMLToken_clearNamespaces(self)

    def getNamespaceIndex(self, uri):
        r"""getNamespaceIndex(XMLToken self, string uri) -> int"""
        return _libnuml.XMLToken_getNamespaceIndex(self, uri)

    def getNamespaceIndexByPrefix(self, prefix):
        r"""getNamespaceIndexByPrefix(XMLToken self, string prefix) -> int"""
        return _libnuml.XMLToken_getNamespaceIndexByPrefix(self, prefix)

    def getNamespacesLength(self):
        r"""getNamespacesLength(XMLToken self) -> int"""
        return _libnuml.XMLToken_getNamespacesLength(self)

    def getNamespacePrefix(self, *args):
        r"""
        getNamespacePrefix(XMLToken self, int index) -> string
        getNamespacePrefix(XMLToken self, string uri) -> string
        """
        return _libnuml.XMLToken_getNamespacePrefix(self, *args)

    def getNamespaceURI(self, *args):
        r"""
        getNamespaceURI(XMLToken self, int index) -> string
        getNamespaceURI(XMLToken self, string prefix="") -> string
        """
        return _libnuml.XMLToken_getNamespaceURI(self, *args)

    def isNamespacesEmpty(self):
        r"""isNamespacesEmpty(XMLToken self) -> bool"""
        return _libnuml.XMLToken_isNamespacesEmpty(self)

    def hasNamespaceURI(self, uri):
        r"""hasNamespaceURI(XMLToken self, string uri) -> bool"""
        return _libnuml.XMLToken_hasNamespaceURI(self, uri)

    def hasNamespacePrefix(self, prefix):
        r"""hasNamespacePrefix(XMLToken self, string prefix) -> bool"""
        return _libnuml.XMLToken_hasNamespacePrefix(self, prefix)

    def hasNamespaceNS(self, uri, prefix):
        r"""hasNamespaceNS(XMLToken self, string uri, string prefix) -> bool"""
        return _libnuml.XMLToken_hasNamespaceNS(self, uri, prefix)

    def setTriple(self, triple):
        r"""setTriple(XMLToken self, XMLTriple triple) -> int"""
        return _libnuml.XMLToken_setTriple(self, triple)

    def getName(self):
        r"""getName(XMLToken self) -> string"""
        return _libnuml.XMLToken_getName(self)

    def getPrefix(self):
        r"""getPrefix(XMLToken self) -> string"""
        return _libnuml.XMLToken_getPrefix(self)

    def getURI(self):
        r"""getURI(XMLToken self) -> string"""
        return _libnuml.XMLToken_getURI(self)

    def getCharacters(self):
        r"""getCharacters(XMLToken self) -> string"""
        return _libnuml.XMLToken_getCharacters(self)

    def setCharacters(self, chars):
        r"""setCharacters(XMLToken self, string chars) -> int"""
        return _libnuml.XMLToken_setCharacters(self, chars)

    def append(self, chars):
        r"""append(XMLToken self, string chars) -> int"""
        return _libnuml.XMLToken_append(self, chars)

    def getColumn(self):
        r"""getColumn(XMLToken self) -> unsigned int"""
        return _libnuml.XMLToken_getColumn(self)

    def getLine(self):
        r"""getLine(XMLToken self) -> unsigned int"""
        return _libnuml.XMLToken_getLine(self)

    def isElement(self):
        r"""isElement(XMLToken self) -> bool"""
        return _libnuml.XMLToken_isElement(self)

    def isEnd(self):
        r"""isEnd(XMLToken self) -> bool"""
        return _libnuml.XMLToken_isEnd(self)

    def isEndFor(self, element):
        r"""isEndFor(XMLToken self, XMLToken element) -> bool"""
        return _libnuml.XMLToken_isEndFor(self, element)

    def isEOF(self):
        r"""isEOF(XMLToken self) -> bool"""
        return _libnuml.XMLToken_isEOF(self)

    def isStart(self):
        r"""isStart(XMLToken self) -> bool"""
        return _libnuml.XMLToken_isStart(self)

    def isText(self):
        r"""isText(XMLToken self) -> bool"""
        return _libnuml.XMLToken_isText(self)

    def setEnd(self):
        r"""setEnd(XMLToken self) -> int"""
        return _libnuml.XMLToken_setEnd(self)

    def setEOF(self):
        r"""setEOF(XMLToken self) -> int"""
        return _libnuml.XMLToken_setEOF(self)

    def unsetEnd(self):
        r"""unsetEnd(XMLToken self) -> int"""
        return _libnuml.XMLToken_unsetEnd(self)

    def toString(self):
        r"""toString(XMLToken self) -> string"""
        return _libnuml.XMLToken_toString(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLToken in _libnuml:
_libnuml.XMLToken_swigregister(XMLToken)
class XMLNode(XMLToken):
    r"""Proxy of C++ XMLNode class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _libnuml.delete_XMLNode

    def __init__(self, *args):
        r"""
        __init__(XMLNode self) -> XMLNode
        __init__(XMLNode self, XMLToken token) -> XMLNode
        __init__(XMLNode self, XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, unsigned int const line=0, unsigned int const column=0) -> XMLNode
        __init__(XMLNode self, XMLTriple triple, XMLAttributes attributes, unsigned int const line=0, unsigned int const column=0) -> XMLNode
        __init__(XMLNode self, XMLTriple triple, unsigned int const line=0, unsigned int const column=0) -> XMLNode
        __init__(XMLNode self, string chars, unsigned int const line=0, unsigned int const column=0) -> XMLNode
        __init__(XMLNode self, XMLNode orig) -> XMLNode
        """
        _libnuml.XMLNode_swiginit(self, _libnuml.new_XMLNode(*args))

    def clone(self):
        r"""clone(XMLNode self) -> XMLNode"""
        return _libnuml.XMLNode_clone(self)

    def addChild(self, node):
        r"""addChild(XMLNode self, XMLNode node) -> int"""
        return _libnuml.XMLNode_addChild(self, node)

    def insertChild(self, n, node):
        r"""insertChild(XMLNode self, unsigned int n, XMLNode node) -> XMLNode"""
        return _libnuml.XMLNode_insertChild(self, n, node)

    def removeChild(self, n):
        r"""removeChild(XMLNode self, unsigned int n) -> XMLNode"""
        return _libnuml.XMLNode_removeChild(self, n)

    def removeChildren(self):
        r"""removeChildren(XMLNode self) -> int"""
        return _libnuml.XMLNode_removeChildren(self)

    def getChild(self, *args):
        r"""
        getChild(XMLNode self, unsigned int n) -> XMLNode
        getChild(XMLNode self, unsigned int n) -> XMLNode
        getChild(XMLNode self, string name) -> XMLNode
        getChild(XMLNode self, string name) -> XMLNode
        """
        return _libnuml.XMLNode_getChild(self, *args)

    def getIndex(self, name):
        r"""getIndex(XMLNode self, string name) -> int"""
        return _libnuml.XMLNode_getIndex(self, name)

    def hasChild(self, name):
        r"""hasChild(XMLNode self, string name) -> bool"""
        return _libnuml.XMLNode_hasChild(self, name)

    def equals(self, other, ignoreURI=False, ignoreAttributeValues=False):
        r"""equals(XMLNode self, XMLNode other, bool ignoreURI=False, bool ignoreAttributeValues=False) -> bool"""
        return _libnuml.XMLNode_equals(self, other, ignoreURI, ignoreAttributeValues)

    def getNumChildren(self):
        r"""getNumChildren(XMLNode self) -> unsigned int"""
        return _libnuml.XMLNode_getNumChildren(self)

    def writeToStream(self, stream):
        r"""writeToStream(XMLNode self, XMLOutputStream stream)"""
        return _libnuml.XMLNode_writeToStream(self, stream)

    def toXMLString(self):
        r"""toXMLString(XMLNode self) -> string"""
        return _libnuml.XMLNode_toXMLString(self)

    @staticmethod
    def convertXMLNodeToString(node):
        r"""convertXMLNodeToString(XMLNode node) -> string"""
        return _libnuml.XMLNode_convertXMLNodeToString(node)

    @staticmethod
    def convertStringToXMLNode(xmlstr, xmlns=None):
        r"""convertStringToXMLNode(string xmlstr, XMLNamespaces xmlns=None) -> XMLNode"""
        return _libnuml.XMLNode_convertStringToXMLNode(xmlstr, xmlns)

    @staticmethod
    def readXMLNodeFromFile(filename):
        r"""readXMLNodeFromFile(string filename) -> XMLNode"""
        return _libnuml.XMLNode_readXMLNodeFromFile(filename)

# Register XMLNode in _libnuml:
_libnuml.XMLNode_swigregister(XMLNode)
class XMLTriple(object):
    r"""Proxy of C++ XMLTriple class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(XMLTriple self) -> XMLTriple
        __init__(XMLTriple self, string name, string uri, string prefix) -> XMLTriple
        __init__(XMLTriple self, string triplet, char const sepchar=' ') -> XMLTriple
        __init__(XMLTriple self, XMLTriple orig) -> XMLTriple
        """
        _libnuml.XMLTriple_swiginit(self, _libnuml.new_XMLTriple(*args))
    __swig_destroy__ = _libnuml.delete_XMLTriple

    def clone(self):
        r"""clone(XMLTriple self) -> XMLTriple"""
        return _libnuml.XMLTriple_clone(self)

    def getName(self):
        r"""getName(XMLTriple self) -> string"""
        return _libnuml.XMLTriple_getName(self)

    def getPrefix(self):
        r"""getPrefix(XMLTriple self) -> string"""
        return _libnuml.XMLTriple_getPrefix(self)

    def getURI(self):
        r"""getURI(XMLTriple self) -> string"""
        return _libnuml.XMLTriple_getURI(self)

    def getPrefixedName(self):
        r"""getPrefixedName(XMLTriple self) -> string"""
        return _libnuml.XMLTriple_getPrefixedName(self)

    def isEmpty(self):
        r"""isEmpty(XMLTriple self) -> bool"""
        return _libnuml.XMLTriple_isEmpty(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLTriple in _libnuml:
_libnuml.XMLTriple_swigregister(XMLTriple)
class XMLInputStream(object):
    r"""Proxy of C++ XMLInputStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(XMLInputStream self, char const * content, bool isFile=True, string library="", XMLErrorLog errorLog=None) -> XMLInputStream"""
        _libnuml.XMLInputStream_swiginit(self, _libnuml.new_XMLInputStream(*args))
    __swig_destroy__ = _libnuml.delete_XMLInputStream

    def getEncoding(self):
        r"""getEncoding(XMLInputStream self) -> string"""
        return _libnuml.XMLInputStream_getEncoding(self)

    def getVersion(self):
        r"""getVersion(XMLInputStream self) -> string"""
        return _libnuml.XMLInputStream_getVersion(self)

    def getErrorLog(self):
        r"""getErrorLog(XMLInputStream self) -> XMLErrorLog"""
        return _libnuml.XMLInputStream_getErrorLog(self)

    def isEOF(self):
        r"""isEOF(XMLInputStream self) -> bool"""
        return _libnuml.XMLInputStream_isEOF(self)

    def isError(self):
        r"""isError(XMLInputStream self) -> bool"""
        return _libnuml.XMLInputStream_isError(self)

    def isGood(self):
        r"""isGood(XMLInputStream self) -> bool"""
        return _libnuml.XMLInputStream_isGood(self)

    def next(self):
        r"""next(XMLInputStream self) -> XMLToken"""
        return _libnuml.XMLInputStream_next(self)

    def peek(self):
        r"""peek(XMLInputStream self) -> XMLToken"""
        return _libnuml.XMLInputStream_peek(self)

    def skipPastEnd(self, element):
        r"""skipPastEnd(XMLInputStream self, XMLToken element)"""
        return _libnuml.XMLInputStream_skipPastEnd(self, element)

    def skipText(self):
        r"""skipText(XMLInputStream self)"""
        return _libnuml.XMLInputStream_skipText(self)

    def setErrorLog(self, log):
        r"""setErrorLog(XMLInputStream self, XMLErrorLog log) -> int"""
        return _libnuml.XMLInputStream_setErrorLog(self, log)

    def toString(self):
        r"""toString(XMLInputStream self) -> string"""
        return _libnuml.XMLInputStream_toString(self)

    def getSBMLNamespaces(self):
        r"""getSBMLNamespaces(XMLInputStream self) -> SBMLNamespaces"""
        return _libnuml.XMLInputStream_getSBMLNamespaces(self)

    def setSBMLNamespaces(self, sbmlns):
        r"""setSBMLNamespaces(XMLInputStream self, SBMLNamespaces sbmlns)"""
        return _libnuml.XMLInputStream_setSBMLNamespaces(self, sbmlns)

    def determineNumberChildren(self, *args):
        r"""determineNumberChildren(XMLInputStream self, string elementName="") -> unsigned int"""
        return _libnuml.XMLInputStream_determineNumberChildren(self, *args)

    def determineNumSpecificChildren(self, childName, container):
        r"""determineNumSpecificChildren(XMLInputStream self, string childName, string container) -> unsigned int"""
        return _libnuml.XMLInputStream_determineNumSpecificChildren(self, childName, container)

    def containsChild(self, childName, container):
        r"""containsChild(XMLInputStream self, string childName, string container) -> bool"""
        return _libnuml.XMLInputStream_containsChild(self, childName, container)

# Register XMLInputStream in _libnuml:
_libnuml.XMLInputStream_swigregister(XMLInputStream)
class XMLOutputStream(object):
    r"""Proxy of C++ XMLOutputStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(XMLOutputStream self, ostream stream, string encoding="UTF-8", bool writeXMLDecl=True, string programName="", string programVersion="") -> XMLOutputStream"""
        _libnuml.XMLOutputStream_swiginit(self, _libnuml.new_XMLOutputStream(*args))
    __swig_destroy__ = _libnuml.delete_XMLOutputStream

    def endElement(self, *args):
        r"""
        endElement(XMLOutputStream self, string name, string prefix="")
        endElement(XMLOutputStream self, XMLTriple triple, bool text=False)
        """
        return _libnuml.XMLOutputStream_endElement(self, *args)

    def setAutoIndent(self, indent):
        r"""setAutoIndent(XMLOutputStream self, bool indent)"""
        return _libnuml.XMLOutputStream_setAutoIndent(self, indent)

    def startElement(self, *args):
        r"""
        startElement(XMLOutputStream self, string name, string prefix="")
        startElement(XMLOutputStream self, XMLTriple triple)
        """
        return _libnuml.XMLOutputStream_startElement(self, *args)

    def startEndElement(self, *args):
        r"""
        startEndElement(XMLOutputStream self, string name, string prefix="")
        startEndElement(XMLOutputStream self, XMLTriple triple)
        """
        return _libnuml.XMLOutputStream_startEndElement(self, *args)

    def writeAttribute(self, *args):
        r"""
        writeAttribute(XMLOutputStream self, string name, string value)
        writeAttribute(XMLOutputStream self, string name, string prefix, string value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, string value)
        writeAttribute(XMLOutputStream self, string name, char const * value)
        writeAttribute(XMLOutputStream self, string name, string prefix, char const * value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, char const * value)
        writeAttribute(XMLOutputStream self, string name, bool const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, bool const & value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, bool const & value)
        writeAttribute(XMLOutputStream self, string name, double const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, double const & value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, double const & value)
        writeAttribute(XMLOutputStream self, string name, long const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, long const & value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, long const & value)
        writeAttribute(XMLOutputStream self, string name, int const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, int const & value)
        writeAttribute(XMLOutputStream self, XMLTriple triple, int const & value)
        writeAttribute(XMLOutputStream self, string name, string prefix, unsigned int const & value)
        """

        if type(args[1]) == type(True): return _libnuml.XMLOutputStream_writeAttributeBool(self, *args)


        return _libnuml.XMLOutputStream_writeAttribute(self, *args)


    def writeXMLDecl(self):
        r"""writeXMLDecl(XMLOutputStream self)"""
        return _libnuml.XMLOutputStream_writeXMLDecl(self)

    def writeComment(self, programName, programVersion, writeTimestamp=True):
        r"""writeComment(XMLOutputStream self, string programName, string programVersion, bool writeTimestamp=True)"""
        return _libnuml.XMLOutputStream_writeComment(self, programName, programVersion, writeTimestamp)

    def downIndent(self):
        r"""downIndent(XMLOutputStream self)"""
        return _libnuml.XMLOutputStream_downIndent(self)

    def upIndent(self):
        r"""upIndent(XMLOutputStream self)"""
        return _libnuml.XMLOutputStream_upIndent(self)

    def getSBMLNamespaces(self):
        r"""getSBMLNamespaces(XMLOutputStream self) -> SBMLNamespaces"""
        return _libnuml.XMLOutputStream_getSBMLNamespaces(self)

    def setSBMLNamespaces(self, sbmlns):
        r"""setSBMLNamespaces(XMLOutputStream self, SBMLNamespaces sbmlns)"""
        return _libnuml.XMLOutputStream_setSBMLNamespaces(self, sbmlns)

    @staticmethod
    def getWriteComment():
        r"""getWriteComment() -> bool"""
        return _libnuml.XMLOutputStream_getWriteComment()

    @staticmethod
    def setWriteComment(writeComment):
        r"""setWriteComment(bool writeComment)"""
        return _libnuml.XMLOutputStream_setWriteComment(writeComment)

    @staticmethod
    def getWriteTimestamp():
        r"""getWriteTimestamp() -> bool"""
        return _libnuml.XMLOutputStream_getWriteTimestamp()

    @staticmethod
    def setWriteTimestamp(writeTimestamp):
        r"""setWriteTimestamp(bool writeTimestamp)"""
        return _libnuml.XMLOutputStream_setWriteTimestamp(writeTimestamp)

    @staticmethod
    def getLibraryName():
        r"""getLibraryName() -> string"""
        return _libnuml.XMLOutputStream_getLibraryName()

    @staticmethod
    def setLibraryName(libraryName):
        r"""setLibraryName(string libraryName)"""
        return _libnuml.XMLOutputStream_setLibraryName(libraryName)

    @staticmethod
    def getLibraryVersion():
        r"""getLibraryVersion() -> string"""
        return _libnuml.XMLOutputStream_getLibraryVersion()

    @staticmethod
    def setLibraryVersion(libraryVersion):
        r"""setLibraryVersion(string libraryVersion)"""
        return _libnuml.XMLOutputStream_setLibraryVersion(libraryVersion)

    def getIndent(self):
        r"""getIndent(XMLOutputStream self) -> unsigned int"""
        return _libnuml.XMLOutputStream_getIndent(self)

    def setIndent(self, indent):
        r"""setIndent(XMLOutputStream self, unsigned int indent)"""
        return _libnuml.XMLOutputStream_setIndent(self, indent)

    def writeAttributeBool(self, *args):
        r"""
        writeAttributeBool(XMLOutputStream self, string name, bool const & value)
        writeAttributeBool(XMLOutputStream self, XMLTriple name, bool const & value)
        """
        return _libnuml.XMLOutputStream_writeAttributeBool(self, *args)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLOutputStream in _libnuml:
_libnuml.XMLOutputStream_swigregister(XMLOutputStream)
class XMLOwningOutputStringStream(object):
    r"""Proxy of C++ XMLOwningOutputStringStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(XMLOwningOutputStringStream self, string encoding="UTF-8", bool writeXMLDecl=True, string programName="", string programVersion="") -> XMLOwningOutputStringStream"""
        _libnuml.XMLOwningOutputStringStream_swiginit(self, _libnuml.new_XMLOwningOutputStringStream(*args))
    __swig_destroy__ = _libnuml.delete_XMLOwningOutputStringStream

# Register XMLOwningOutputStringStream in _libnuml:
_libnuml.XMLOwningOutputStringStream_swigregister(XMLOwningOutputStringStream)
class XMLOwningOutputFileStream(object):
    r"""Proxy of C++ XMLOwningOutputFileStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(XMLOwningOutputFileStream self, string filename, string encoding="UTF-8", bool writeXMLDecl=True, string programName="", string programVersion="") -> XMLOwningOutputFileStream"""
        _libnuml.XMLOwningOutputFileStream_swiginit(self, _libnuml.new_XMLOwningOutputFileStream(*args))
    __swig_destroy__ = _libnuml.delete_XMLOwningOutputFileStream

# Register XMLOwningOutputFileStream in _libnuml:
_libnuml.XMLOwningOutputFileStream_swigregister(XMLOwningOutputFileStream)
class XMLErrorLog(object):
    r"""Proxy of C++ XMLErrorLog class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def getNumErrors(self):
        r"""getNumErrors(XMLErrorLog self) -> unsigned int"""
        return _libnuml.XMLErrorLog_getNumErrors(self)

    def getError(self, n):
        r"""getError(XMLErrorLog self, unsigned int n) -> XMLError"""
        return _libnuml.XMLErrorLog_getError(self, n)

    def clearLog(self):
        r"""clearLog(XMLErrorLog self)"""
        return _libnuml.XMLErrorLog_clearLog(self)
    __swig_destroy__ = _libnuml.delete_XMLErrorLog

    def toString(self):
        r"""toString(XMLErrorLog self) -> string"""
        return _libnuml.XMLErrorLog_toString(self)

    def printErrors(self, *args):
        r"""
        printErrors(XMLErrorLog self, ostream stream=cerr)
        printErrors(XMLErrorLog self, ostream stream, unsigned int severity)
        """
        return _libnuml.XMLErrorLog_printErrors(self, *args)

    def isSeverityOverridden(self):
        r"""isSeverityOverridden(XMLErrorLog self) -> bool"""
        return _libnuml.XMLErrorLog_isSeverityOverridden(self)

    def unsetSeverityOverride(self):
        r"""unsetSeverityOverride(XMLErrorLog self)"""
        return _libnuml.XMLErrorLog_unsetSeverityOverride(self)

    def getSeverityOverride(self):
        r"""getSeverityOverride(XMLErrorLog self) -> XMLErrorSeverityOverride_t"""
        return _libnuml.XMLErrorLog_getSeverityOverride(self)

    def setSeverityOverride(self, severity):
        r"""setSeverityOverride(XMLErrorLog self, XMLErrorSeverityOverride_t severity)"""
        return _libnuml.XMLErrorLog_setSeverityOverride(self, severity)

    def changeErrorSeverity(self, *args):
        r"""changeErrorSeverity(XMLErrorLog self, XMLErrorSeverity_t originalSeverity, XMLErrorSeverity_t targetSeverity, string package="all")"""
        return _libnuml.XMLErrorLog_changeErrorSeverity(self, *args)

    def contains(self, errorId):
        r"""contains(XMLErrorLog self, unsigned int const errorId) -> bool"""
        return _libnuml.XMLErrorLog_contains(self, errorId)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


# Register XMLErrorLog in _libnuml:
_libnuml.XMLErrorLog_swigregister(XMLErrorLog)
class ASTNode(object):
    r"""Proxy of C++ ASTNode class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ASTNode self, ASTNodeType_t type=AST_UNKNOWN) -> ASTNode
        __init__(ASTNode self, ASTNode orig) -> ASTNode
        """
        _libnuml.ASTNode_swiginit(self, _libnuml.new_ASTNode(*args))
    __swig_destroy__ = _libnuml.delete_ASTNode

    def freeName(self):
        r"""freeName(ASTNode self) -> int"""
        return _libnuml.ASTNode_freeName(self)

    def canonicalize(self):
        r"""canonicalize(ASTNode self) -> bool"""
        return _libnuml.ASTNode_canonicalize(self)

    def addChild(self, disownedChild, inRead=False):
        r"""addChild(ASTNode self, ASTNode disownedChild, bool inRead=False) -> int"""

        if args[0] is not None: args[0].thisown = 0


        return _libnuml.ASTNode_addChild(self, disownedChild, inRead)


    def prependChild(self, disownedChild):
        r"""prependChild(ASTNode self, ASTNode disownedChild) -> int"""

        if args[0] is not None: args[0].thisown = 0


        return _libnuml.ASTNode_prependChild(self, disownedChild)


    def removeChild(self, n, delremoved=False):
        r"""removeChild(ASTNode self, unsigned int n, bool delremoved=False) -> int"""
        return _libnuml.ASTNode_removeChild(self, n, delremoved)

    def replaceChild(self, n, disownedChild, delreplaced=False):
        r"""replaceChild(ASTNode self, unsigned int n, ASTNode disownedChild, bool delreplaced=False) -> int"""

        if args[1] is not None: args[1].thisown = 0


        return _libnuml.ASTNode_replaceChild(self, n, disownedChild, delreplaced)


    def insertChild(self, n, disownedChild):
        r"""insertChild(ASTNode self, unsigned int n, ASTNode disownedChild) -> int"""

        if args[1] is not None: args[1].thisown = 0


        return _libnuml.ASTNode_insertChild(self, n, disownedChild)


    def deepCopy(self):
        r"""deepCopy(ASTNode self) -> ASTNode"""
        return _libnuml.ASTNode_deepCopy(self)

    def getChild(self, n):
        r"""getChild(ASTNode self, unsigned int n) -> ASTNode"""
        return _libnuml.ASTNode_getChild(self, n)

    def getLeftChild(self):
        r"""getLeftChild(ASTNode self) -> ASTNode"""
        return _libnuml.ASTNode_getLeftChild(self)

    def getRightChild(self):
        r"""getRightChild(ASTNode self) -> ASTNode"""
        return _libnuml.ASTNode_getRightChild(self)

    def getNumChildren(self):
        r"""getNumChildren(ASTNode self) -> unsigned int"""
        return _libnuml.ASTNode_getNumChildren(self)

    def addSemanticsAnnotation(self, disownedAnnotation):
        r"""addSemanticsAnnotation(ASTNode self, XMLNode disownedAnnotation) -> int"""

        if args[0] is not None: args[0].thisown = 0


        return _libnuml.ASTNode_addSemanticsAnnotation(self, disownedAnnotation)


    def getNumSemanticsAnnotations(self):
        r"""getNumSemanticsAnnotations(ASTNode self) -> unsigned int"""
        return _libnuml.ASTNode_getNumSemanticsAnnotations(self)

    def getSemanticsAnnotation(self, n):
        r"""getSemanticsAnnotation(ASTNode self, unsigned int n) -> XMLNode"""
        return _libnuml.ASTNode_getSemanticsAnnotation(self, n)

    def getCharacter(self):
        r"""getCharacter(ASTNode self) -> char"""
        return _libnuml.ASTNode_getCharacter(self)

    def getId(self):
        r"""getId(ASTNode self) -> string"""
        return _libnuml.ASTNode_getId(self)

    def getStyle(self):
        r"""getStyle(ASTNode self) -> string"""
        return _libnuml.ASTNode_getStyle(self)

    def getInteger(self):
        r"""getInteger(ASTNode self) -> long"""
        return _libnuml.ASTNode_getInteger(self)

    def getName(self):
        r"""getName(ASTNode self) -> char const *"""
        return _libnuml.ASTNode_getName(self)

    def getOperatorName(self):
        r"""getOperatorName(ASTNode self) -> char const *"""
        return _libnuml.ASTNode_getOperatorName(self)

    def getNumerator(self):
        r"""getNumerator(ASTNode self) -> long"""
        return _libnuml.ASTNode_getNumerator(self)

    def getDenominator(self):
        r"""getDenominator(ASTNode self) -> long"""
        return _libnuml.ASTNode_getDenominator(self)

    def getReal(self):
        r"""getReal(ASTNode self) -> double"""
        return _libnuml.ASTNode_getReal(self)

    def getMantissa(self):
        r"""getMantissa(ASTNode self) -> double"""
        return _libnuml.ASTNode_getMantissa(self)

    def getExponent(self):
        r"""getExponent(ASTNode self) -> long"""
        return _libnuml.ASTNode_getExponent(self)

    def getValue(self):
        r"""getValue(ASTNode self) -> double"""
        return _libnuml.ASTNode_getValue(self)

    def getPrecedence(self):
        r"""getPrecedence(ASTNode self) -> int"""
        return _libnuml.ASTNode_getPrecedence(self)

    def getType(self):
        r"""getType(ASTNode self) -> ASTNodeType_t"""
        return _libnuml.ASTNode_getType(self)

    def getUnits(self):
        r"""getUnits(ASTNode self) -> string"""
        return _libnuml.ASTNode_getUnits(self)

    def isAvogadro(self):
        r"""isAvogadro(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isAvogadro(self)

    def isBoolean(self):
        r"""isBoolean(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isBoolean(self)

    def returnsBoolean(self, model=None):
        r"""returnsBoolean(ASTNode self, Model const * model=None) -> bool"""
        return _libnuml.ASTNode_returnsBoolean(self, model)

    def isConstant(self):
        r"""isConstant(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isConstant(self)

    def isCiNumber(self):
        r"""isCiNumber(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isCiNumber(self)

    def isConstantNumber(self):
        r"""isConstantNumber(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isConstantNumber(self)

    def isCSymbolFunction(self):
        r"""isCSymbolFunction(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isCSymbolFunction(self)

    def isFunction(self):
        r"""isFunction(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isFunction(self)

    def isInfinity(self):
        r"""isInfinity(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isInfinity(self)

    def isInteger(self):
        r"""isInteger(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isInteger(self)

    def isLambda(self):
        r"""isLambda(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isLambda(self)

    def isLog10(self):
        r"""isLog10(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isLog10(self)

    def isLogical(self):
        r"""isLogical(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isLogical(self)

    def isName(self):
        r"""isName(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isName(self)

    def isNaN(self):
        r"""isNaN(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isNaN(self)

    def isNegInfinity(self):
        r"""isNegInfinity(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isNegInfinity(self)

    def isNumber(self):
        r"""isNumber(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isNumber(self)

    def isOperator(self):
        r"""isOperator(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isOperator(self)

    def isPiecewise(self):
        r"""isPiecewise(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isPiecewise(self)

    def isRational(self):
        r"""isRational(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isRational(self)

    def isReal(self):
        r"""isReal(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isReal(self)

    def isRelational(self):
        r"""isRelational(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isRelational(self)

    def isSqrt(self):
        r"""isSqrt(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isSqrt(self)

    def isUMinus(self):
        r"""isUMinus(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isUMinus(self)

    def isUPlus(self):
        r"""isUPlus(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isUPlus(self)

    def isUserFunction(self):
        r"""isUserFunction(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isUserFunction(self)

    def hasTypeAndNumChildren(self, type, numchildren):
        r"""hasTypeAndNumChildren(ASTNode self, ASTNodeType_t type, unsigned int numchildren) -> int"""
        return _libnuml.ASTNode_hasTypeAndNumChildren(self, type, numchildren)

    def isUnknown(self):
        r"""isUnknown(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isUnknown(self)

    def isSetId(self):
        r"""isSetId(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isSetId(self)

    def isSetClass(self):
        r"""isSetClass(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isSetClass(self)

    def isSetStyle(self):
        r"""isSetStyle(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isSetStyle(self)

    def isSetUnits(self):
        r"""isSetUnits(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isSetUnits(self)

    def hasUnits(self):
        r"""hasUnits(ASTNode self) -> bool"""
        return _libnuml.ASTNode_hasUnits(self)

    def setCharacter(self, value):
        r"""setCharacter(ASTNode self, char value) -> int"""
        return _libnuml.ASTNode_setCharacter(self, value)

    def setId(self, id):
        r"""setId(ASTNode self, string id) -> int"""
        return _libnuml.ASTNode_setId(self, id)

    def setClass(self, className):
        r"""setClass(ASTNode self, string className) -> int"""
        return _libnuml.ASTNode_setClass(self, className)

    def setStyle(self, style):
        r"""setStyle(ASTNode self, string style) -> int"""
        return _libnuml.ASTNode_setStyle(self, style)

    def setName(self, name):
        r"""setName(ASTNode self, char const * name) -> int"""
        return _libnuml.ASTNode_setName(self, name)

    def setValue(self, *args):
        r"""
        setValue(ASTNode self, long value) -> int
        setValue(ASTNode self, long numerator, long denominator) -> int
        setValue(ASTNode self, double value) -> int
        setValue(ASTNode self, double mantissa, long exponent) -> int
        """
        return _libnuml.ASTNode_setValue(self, *args)

    def setType(self, type):
        r"""setType(ASTNode self, ASTNodeType_t type) -> int"""
        return _libnuml.ASTNode_setType(self, type)

    def setUnits(self, units):
        r"""setUnits(ASTNode self, string units) -> int"""
        return _libnuml.ASTNode_setUnits(self, units)

    def swapChildren(self, that):
        r"""swapChildren(ASTNode self, ASTNode that) -> int"""
        return _libnuml.ASTNode_swapChildren(self, that)

    def renameSIdRefs(self, oldid, newid):
        r"""renameSIdRefs(ASTNode self, string oldid, string newid)"""
        return _libnuml.ASTNode_renameSIdRefs(self, oldid, newid)

    def renameUnitSIdRefs(self, oldid, newid):
        r"""renameUnitSIdRefs(ASTNode self, string oldid, string newid)"""
        return _libnuml.ASTNode_renameUnitSIdRefs(self, oldid, newid)

    def replaceIDWithFunction(self, id, function):
        r"""replaceIDWithFunction(ASTNode self, string id, ASTNode function)"""
        return _libnuml.ASTNode_replaceIDWithFunction(self, id, function)

    def multiplyTimeBy(self, function):
        r"""multiplyTimeBy(ASTNode self, ASTNode function)"""
        return _libnuml.ASTNode_multiplyTimeBy(self, function)

    def unsetUnits(self):
        r"""unsetUnits(ASTNode self) -> int"""
        return _libnuml.ASTNode_unsetUnits(self)

    def unsetId(self):
        r"""unsetId(ASTNode self) -> int"""
        return _libnuml.ASTNode_unsetId(self)

    def unsetClass(self):
        r"""unsetClass(ASTNode self) -> int"""
        return _libnuml.ASTNode_unsetClass(self)

    def unsetStyle(self):
        r"""unsetStyle(ASTNode self) -> int"""
        return _libnuml.ASTNode_unsetStyle(self)

    def getDefinitionURL(self):
        r"""getDefinitionURL(ASTNode self) -> XMLAttributes"""
        return _libnuml.ASTNode_getDefinitionURL(self)

    def replaceArgument(self, bvar, arg):
        r"""replaceArgument(ASTNode self, string bvar, ASTNode arg)"""
        return _libnuml.ASTNode_replaceArgument(self, bvar, arg)

    def replaceArguments(self, bvars, args):
        r"""replaceArguments(ASTNode self, std::vector< std::string > const & bvars, std::vector< ASTNode * > & args)"""
        return _libnuml.ASTNode_replaceArguments(self, bvars, args)

    def setParentSBMLObject(self, sb):
        r"""setParentSBMLObject(ASTNode self, SBase * sb)"""
        return _libnuml.ASTNode_setParentSBMLObject(self, sb)

    def getParentSBMLObject(self):
        r"""getParentSBMLObject(ASTNode self) -> SBase *"""
        return _libnuml.ASTNode_getParentSBMLObject(self)

    def unsetParentSBMLObject(self):
        r"""unsetParentSBMLObject(ASTNode self) -> int"""
        return _libnuml.ASTNode_unsetParentSBMLObject(self)

    def isSetParentSBMLObject(self):
        r"""isSetParentSBMLObject(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isSetParentSBMLObject(self)

    def reduceToBinary(self):
        r"""reduceToBinary(ASTNode self)"""
        return _libnuml.ASTNode_reduceToBinary(self)

    def unsetUserData(self):
        r"""unsetUserData(ASTNode self) -> int"""
        return _libnuml.ASTNode_unsetUserData(self)

    def isSetUserData(self):
        r"""isSetUserData(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isSetUserData(self)

    def isWellFormedASTNode(self):
        r"""isWellFormedASTNode(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isWellFormedASTNode(self)

    def hasCorrectNumberArguments(self):
        r"""hasCorrectNumberArguments(ASTNode self) -> bool"""
        return _libnuml.ASTNode_hasCorrectNumberArguments(self)

    def getDefinitionURLString(self):
        r"""getDefinitionURLString(ASTNode self) -> string"""
        return _libnuml.ASTNode_getDefinitionURLString(self)

    def representsBvar(self):
        r"""representsBvar(ASTNode self) -> bool"""
        return _libnuml.ASTNode_representsBvar(self)

    def isBvar(self):
        r"""isBvar(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isBvar(self)

    def setBvar(self):
        r"""setBvar(ASTNode self)"""
        return _libnuml.ASTNode_setBvar(self)

    def usesL3V2MathConstructs(self):
        r"""usesL3V2MathConstructs(ASTNode self) -> bool"""
        return _libnuml.ASTNode_usesL3V2MathConstructs(self)

    def usesRateOf(self):
        r"""usesRateOf(ASTNode self) -> bool"""
        return _libnuml.ASTNode_usesRateOf(self)

    def isQualifier(self):
        r"""isQualifier(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isQualifier(self)

    def isSemantics(self):
        r"""isSemantics(ASTNode self) -> bool"""
        return _libnuml.ASTNode_isSemantics(self)

    def getNumBvars(self):
        r"""getNumBvars(ASTNode self) -> unsigned int"""
        return _libnuml.ASTNode_getNumBvars(self)

    def addPlugin(self, plugin):
        r"""addPlugin(ASTNode self, ASTBasePlugin * plugin)"""
        return _libnuml.ASTNode_addPlugin(self, plugin)

    def loadASTPlugins(self, sbmlns):
        r"""loadASTPlugins(ASTNode self, SBMLNamespaces sbmlns)"""
        return _libnuml.ASTNode_loadASTPlugins(self, sbmlns)

    def loadASTPlugin(self, pkgName):
        r"""loadASTPlugin(ASTNode self, string pkgName)"""
        return _libnuml.ASTNode_loadASTPlugin(self, pkgName)

    def getASTPlugin(self, *args):
        r"""
        getASTPlugin(ASTNode self, SBMLNamespaces sbmlns) -> ASTBasePlugin
        getASTPlugin(ASTNode self, ASTNodeType_t type) -> ASTBasePlugin
        getASTPlugin(ASTNode self, string name, bool isCsymbol=False, bool strCmpIsCaseSensitive=False) -> ASTBasePlugin
        getASTPlugin(ASTNode self, SBMLNamespaces sbmlns) -> ASTBasePlugin const
        getASTPlugin(ASTNode self, ASTNodeType_t type) -> ASTBasePlugin const
        getASTPlugin(ASTNode self, string name, bool isCsymbol=False, bool strCmpIsCaseSensitive=False) -> ASTBasePlugin const
        """
        return _libnuml.ASTNode_getASTPlugin(self, *args)

    def getPlugin(self, *args):
        r"""
        getPlugin(ASTNode self, string package) -> ASTBasePlugin
        getPlugin(ASTNode self, string package) -> ASTBasePlugin const
        getPlugin(ASTNode self, unsigned int n) -> ASTBasePlugin
        getPlugin(ASTNode self, unsigned int n) -> ASTBasePlugin const *
        """
        return _libnuml.ASTNode_getPlugin(self, *args)

    def getNumPlugins(self):
        r"""getNumPlugins(ASTNode self) -> unsigned int"""
        return _libnuml.ASTNode_getNumPlugins(self)

    def exactlyEqual(self, rhs):
        r"""exactlyEqual(ASTNode self, ASTNode rhs) -> bool"""
        return _libnuml.ASTNode_exactlyEqual(self, rhs)

    def refactor(self):
        r"""refactor(ASTNode self)"""
        return _libnuml.ASTNode_refactor(self)

    def decompose(self):
        r"""decompose(ASTNode self)"""
        return _libnuml.ASTNode_decompose(self)

    def derivative(self, variable):
        r"""derivative(ASTNode self, string variable) -> ASTNode"""
        return _libnuml.ASTNode_derivative(self, variable)

    def getDeclaredNamespaces(self):
        r"""getDeclaredNamespaces(ASTNode self) -> XMLNamespaces"""
        return _libnuml.ASTNode_getDeclaredNamespaces(self)

    def setDeclaredNamespaces(self, xmlns):
        r"""setDeclaredNamespaces(ASTNode self, XMLNamespaces xmlns)"""
        return _libnuml.ASTNode_setDeclaredNamespaces(self, xmlns)

    def unsetDeclaredNamespaces(self):
        r"""unsetDeclaredNamespaces(ASTNode self)"""
        return _libnuml.ASTNode_unsetDeclaredNamespaces(self)

    def __eq__(self, rhs):
      if ((self is None) and (rhs is None)): return True
      if ((self is None) or  (rhs is None)): return False
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return True
      return False

    def __ne__(self, rhs):
      if ((self is None) and (rhs is None)): return False
      if ((self is None) or  (rhs is None)): return True
      if (hasattr(self, 'this') and hasattr(rhs, 'this')):
        if (self.this == rhs.this): return False
      return True


    def getListOfNodes(self):
        r"""getListOfNodes(ASTNode self) -> ASTNodeList"""
        return _libnuml.ASTNode_getListOfNodes(self)

# Register ASTNode in _libnuml:
_libnuml.ASTNode_swigregister(ASTNode)
class NUMLErrorLog(XMLErrorLog):
    r"""Proxy of C++ NUMLErrorLog class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def getError(self, n):
        r"""getError(NUMLErrorLog self, unsigned int n) -> NUMLError"""
        return _libnuml.NUMLErrorLog_getError(self, n)

    def getNumFailsWithSeverity(self, severity):
        r"""getNumFailsWithSeverity(NUMLErrorLog self, unsigned int severity) -> unsigned int"""
        return _libnuml.NUMLErrorLog_getNumFailsWithSeverity(self, severity)
    __swig_destroy__ = _libnuml.delete_NUMLErrorLog

# Register NUMLErrorLog in _libnuml:
_libnuml.NUMLErrorLog_swigregister(NUMLErrorLog)
NUMLUnknownError = _libnuml.NUMLUnknownError

NUMLNotUTF8 = _libnuml.NUMLNotUTF8

NUMLUnrecognizedElement = _libnuml.NUMLUnrecognizedElement

NUMLNotSchemaConformant = _libnuml.NUMLNotSchemaConformant

NUMLInvalidMathElement = _libnuml.NUMLInvalidMathElement

NUMLMultipleAssignmentOrRateRules = _libnuml.NUMLMultipleAssignmentOrRateRules

NUMLMultipleEventAssignmentsForId = _libnuml.NUMLMultipleEventAssignmentsForId

NUMLEventAndAssignmentRuleForId = _libnuml.NUMLEventAndAssignmentRuleForId

NUMLDuplicateMetaId = _libnuml.NUMLDuplicateMetaId

NUMLInvalidSBOTermSyntax = _libnuml.NUMLInvalidSBOTermSyntax

NUMLInvalidMetaidSyntax = _libnuml.NUMLInvalidMetaidSyntax

NUMLInvalidIdSyntax = _libnuml.NUMLInvalidIdSyntax

NUMLInvalidUnitIdSyntax = _libnuml.NUMLInvalidUnitIdSyntax

NUMLMissingAnnotationNamespace = _libnuml.NUMLMissingAnnotationNamespace

NUMLDuplicateAnnotationNamespaces = _libnuml.NUMLDuplicateAnnotationNamespaces

NUMLNamespaceInAnnotation = _libnuml.NUMLNamespaceInAnnotation

NUMLMissingOntologyTerms = _libnuml.NUMLMissingOntologyTerms

NUMLMissingResultComponents = _libnuml.NUMLMissingResultComponents

NUMLInconsistentArgUnits = _libnuml.NUMLInconsistentArgUnits

NUMLAssignRuleCompartmentMismatch = _libnuml.NUMLAssignRuleCompartmentMismatch

NUMLOverdeterminedSystem = _libnuml.NUMLOverdeterminedSystem

NUMLInvalidModelSBOTerm = _libnuml.NUMLInvalidModelSBOTerm

NUMLInvalidFunctionDefSBOTerm = _libnuml.NUMLInvalidFunctionDefSBOTerm

NUMLInvalidRuleSBOTerm = _libnuml.NUMLInvalidRuleSBOTerm

NUMLInvalidConstraintSBOTerm = _libnuml.NUMLInvalidConstraintSBOTerm

NUMLNotesNotInXHTMLNamespace = _libnuml.NUMLNotesNotInXHTMLNamespace

NUMLNotesContainsXMLDecl = _libnuml.NUMLNotesContainsXMLDecl

NUMLNotesContainsDOCTYPE = _libnuml.NUMLNotesContainsDOCTYPE

NUMLInvalidNotesContent = _libnuml.NUMLInvalidNotesContent

NUMLInvalidNamespaceOnNUML = _libnuml.NUMLInvalidNamespaceOnNUML

NUMLMissingOrInconsistentLevel = _libnuml.NUMLMissingOrInconsistentLevel

NUMLMissingOrInconsistentVersion = _libnuml.NUMLMissingOrInconsistentVersion

NUMLAnnotationNotesNotAllowedLevel1 = _libnuml.NUMLAnnotationNotesNotAllowedLevel1

NUMLMissingModel = _libnuml.NUMLMissingModel

NUMLIncorrectOrderInModel = _libnuml.NUMLIncorrectOrderInModel

NUMLEmptyListElement = _libnuml.NUMLEmptyListElement

NUMLNeedCompartmentIfHaveSpecies = _libnuml.NUMLNeedCompartmentIfHaveSpecies

NUMLFunctionDefMathNotLambda = _libnuml.NUMLFunctionDefMathNotLambda

NUMLInvalidApplyCiInLambda = _libnuml.NUMLInvalidApplyCiInLambda

NUMLConstraintNotInXHTMLNamespace = _libnuml.NUMLConstraintNotInXHTMLNamespace

NUMLConstraintContainsXMLDecl = _libnuml.NUMLConstraintContainsXMLDecl

NUMLConstraintContainsDOCTYPE = _libnuml.NUMLConstraintContainsDOCTYPE

NUMLInvalidConstraintContent = _libnuml.NUMLInvalidConstraintContent

NUMLEventAssignmentForConstantEntity = _libnuml.NUMLEventAssignmentForConstantEntity

NUMLGeneralWarningNotSpecified = _libnuml.NUMLGeneralWarningNotSpecified

LibNUMLAdditionalCodesLowerBound = _libnuml.LibNUMLAdditionalCodesLowerBound

NUMLCannotConvertToL1V1 = _libnuml.NUMLCannotConvertToL1V1

NUMLNoEventsInL1 = _libnuml.NUMLNoEventsInL1

NUMLStrictUnitsRequiredInL1 = _libnuml.NUMLStrictUnitsRequiredInL1

NUMLNoConstraintsInL2v1 = _libnuml.NUMLNoConstraintsInL2v1

NUMLStrictUnitsRequiredInL2v1 = _libnuml.NUMLStrictUnitsRequiredInL2v1

InvalidNUMLLevelVersion = _libnuml.InvalidNUMLLevelVersion

NUMLInvalidRuleOrdering = _libnuml.NUMLInvalidRuleOrdering

NUMLNoTimeSymbolInFunctionDef = _libnuml.NUMLNoTimeSymbolInFunctionDef

NUMLUnrecognisedSBOTerm = _libnuml.NUMLUnrecognisedSBOTerm

NUMLObseleteSBOTerm = _libnuml.NUMLObseleteSBOTerm

NUMLOffsetNotValidAttribute = _libnuml.NUMLOffsetNotValidAttribute

NUMLCodesUpperBound = _libnuml.NUMLCodesUpperBound

LIBNUML_CAT_INTERNAL = _libnuml.LIBNUML_CAT_INTERNAL

LIBNUML_CAT_NUML = _libnuml.LIBNUML_CAT_NUML

LIBNUML_CAT_NUML_L1_COMPAT = _libnuml.LIBNUML_CAT_NUML_L1_COMPAT

LIBNUML_CAT_NUML_L1V1_COMPAT = _libnuml.LIBNUML_CAT_NUML_L1V1_COMPAT

LIBNUML_CAT_GENERAL_CONSISTENCY = _libnuml.LIBNUML_CAT_GENERAL_CONSISTENCY

LIBNUML_CAT_IDENTIFIER_CONSISTENCY = _libnuml.LIBNUML_CAT_IDENTIFIER_CONSISTENCY

LIBNUML_CAT_INTERNAL_CONSISTENCY = _libnuml.LIBNUML_CAT_INTERNAL_CONSISTENCY

LIBNUML_SEV_ERROR = _libnuml.LIBNUML_SEV_ERROR

LIBNUML_SEV_FATAL = _libnuml.LIBNUML_SEV_FATAL

LIBNUML_SEV_WARNING = _libnuml.LIBNUML_SEV_WARNING

LIBNUML_SEV_SCHEMA_ERROR = _libnuml.LIBNUML_SEV_SCHEMA_ERROR

LIBNUML_SEV_GENERAL_WARNING = _libnuml.LIBNUML_SEV_GENERAL_WARNING

LIBNUML_SEV_NOT_APPLICABLE = _libnuml.LIBNUML_SEV_NOT_APPLICABLE

class NUMLError(XMLError):
    r"""Proxy of C++ NUMLError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(NUMLError self, unsigned int const errorId=0, unsigned int const level=NUML_DEFAULT_LEVEL, unsigned int const version=NUML_DEFAULT_VERSION, string details="", unsigned int const line=0, unsigned int const column=0, unsigned int const severity=LIBNUML_SEV_ERROR, unsigned int const category=LIBNUML_CAT_NUML) -> NUMLError
        __init__(NUMLError self, NUMLError orig) -> NUMLError
        """
        _libnuml.NUMLError_swiginit(self, _libnuml.new_NUMLError(*args))

    def clone(self):
        r"""clone(NUMLError self) -> NUMLError"""
        return _libnuml.NUMLError_clone(self)
    __swig_destroy__ = _libnuml.delete_NUMLError

# Register NUMLError in _libnuml:
_libnuml.NUMLError_swigregister(NUMLError)


global __version__
__version__ = '1.1.7'
