"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionsBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const iam_generated_1 = require("./iam.generated");
/**
 * Modify the Permissions Boundaries of Users and Roles in a construct tree.
 *
 * @stability stable
 * @example
 *
 * const policy = ManagedPolicy.fromAwsManagedPolicyName('ReadOnlyAccess');
 * PermissionsBoundary.of(stack).apply(policy);
 */
class PermissionsBoundary {
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * Access the Permissions Boundaries of a construct tree.
     *
     * @stability stable
     */
    static of(scope) {
        return new PermissionsBoundary(scope);
    }
    /**
     * Apply the given policy as Permissions Boundary to all Roles in the scope.
     *
     * Will override any Permissions Boundaries configured previously; in case
     * a Permission Boundary is applied in multiple scopes, the Boundary applied
     * closest to the Role wins.
     *
     * @stability stable
     */
    apply(boundaryPolicy) {
        constructs_1.Node.of(this.scope).applyAspect({
            visit(node) {
                if (node instanceof iam_generated_1.CfnRole || node instanceof iam_generated_1.CfnUser) {
                    node.permissionsBoundary = boundaryPolicy.managedPolicyArn;
                }
            },
        });
    }
    /**
     * Remove previously applied Permissions Boundaries.
     *
     * @stability stable
     */
    clear() {
        constructs_1.Node.of(this.scope).applyAspect({
            visit(node) {
                if (node instanceof iam_generated_1.CfnRole || node instanceof iam_generated_1.CfnUser) {
                    node.permissionsBoundary = undefined;
                }
            },
        });
    }
}
exports.PermissionsBoundary = PermissionsBoundary;
_a = JSII_RTTI_SYMBOL_1;
PermissionsBoundary[_a] = { fqn: "@aws-cdk/aws-iam.PermissionsBoundary", version: "1.96.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGVybWlzc2lvbnMtYm91bmRhcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJwZXJtaXNzaW9ucy1ib3VuZGFyeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDJDQUE4QztBQUM5QyxtREFBbUQ7Ozs7Ozs7Ozs7QUFXbkQsTUFBYSxtQkFBbUI7SUFROUIsWUFBcUMsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTtJQUN0RCxDQUFDOzs7Ozs7SUFMTSxNQUFNLENBQUMsRUFBRSxDQUFDLEtBQWlCO1FBQ2hDLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN4QyxDQUFDOzs7Ozs7Ozs7O0lBWU0sS0FBSyxDQUFDLGNBQThCO1FBQ3pDLGlCQUFJLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxXQUFXLENBQUM7WUFDOUIsS0FBSyxDQUFDLElBQWdCO2dCQUNwQixJQUFJLElBQUksWUFBWSx1QkFBTyxJQUFJLElBQUksWUFBWSx1QkFBTyxFQUFFO29CQUN0RCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsY0FBYyxDQUFDLGdCQUFnQixDQUFDO2lCQUM1RDtZQUNILENBQUM7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDOzs7Ozs7SUFLTSxLQUFLO1FBQ1YsaUJBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLFdBQVcsQ0FBQztZQUM5QixLQUFLLENBQUMsSUFBZ0I7Z0JBQ3BCLElBQUksSUFBSSxZQUFZLHVCQUFPLElBQUksSUFBSSxZQUFZLHVCQUFPLEVBQUU7b0JBQ3RELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxTQUFTLENBQUM7aUJBQ3RDO1lBQ0gsQ0FBQztTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBdkNILGtEQXdDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IE5vZGUsIElDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmblJvbGUsIENmblVzZXIgfSBmcm9tICcuL2lhbS5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSU1hbmFnZWRQb2xpY3kgfSBmcm9tICcuL21hbmFnZWQtcG9saWN5JztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUGVybWlzc2lvbnNCb3VuZGFyeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgb2Yoc2NvcGU6IElDb25zdHJ1Y3QpOiBQZXJtaXNzaW9uc0JvdW5kYXJ5IHtcbiAgICByZXR1cm4gbmV3IFBlcm1pc3Npb25zQm91bmRhcnkoc2NvcGUpO1xuICB9XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHNjb3BlOiBJQ29uc3RydWN0KSB7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFwcGx5KGJvdW5kYXJ5UG9saWN5OiBJTWFuYWdlZFBvbGljeSkge1xuICAgIE5vZGUub2YodGhpcy5zY29wZSkuYXBwbHlBc3BlY3Qoe1xuICAgICAgdmlzaXQobm9kZTogSUNvbnN0cnVjdCkge1xuICAgICAgICBpZiAobm9kZSBpbnN0YW5jZW9mIENmblJvbGUgfHwgbm9kZSBpbnN0YW5jZW9mIENmblVzZXIpIHtcbiAgICAgICAgICBub2RlLnBlcm1pc3Npb25zQm91bmRhcnkgPSBib3VuZGFyeVBvbGljeS5tYW5hZ2VkUG9saWN5QXJuO1xuICAgICAgICB9XG4gICAgICB9LFxuICAgIH0pO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjbGVhcigpIHtcbiAgICBOb2RlLm9mKHRoaXMuc2NvcGUpLmFwcGx5QXNwZWN0KHtcbiAgICAgIHZpc2l0KG5vZGU6IElDb25zdHJ1Y3QpIHtcbiAgICAgICAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5Sb2xlIHx8IG5vZGUgaW5zdGFuY2VvZiBDZm5Vc2VyKSB7XG4gICAgICAgICAgbm9kZS5wZXJtaXNzaW9uc0JvdW5kYXJ5ID0gdW5kZWZpbmVkO1xuICAgICAgICB9XG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59Il19