/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.cmd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.Grammars;
import com.siemens.ct.exi.core.helpers.DefaultEXIFactory;
import com.siemens.ct.exi.main.api.sax.EXIResult;
import com.siemens.ct.exi.main.api.sax.EXISource;
import com.siemens.ct.exi.main.cmd.BuiltInSchema;
import com.siemens.ct.exi.main.cmd.DocumentSource;
import com.siemens.ct.exi.main.cmd.JSONConformance;
import com.siemens.ct.exi.main.cmd.Message;
import com.siemens.ct.exi.main.cmd.SecurityPayloads;
import com.siemens.ct.exi.main.generatedgrammar.CommonAppProtocol;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_AC;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_ACDP;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_CommonMessages;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_DC;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_20_V2G_CI_WPT;
import com.siemens.ct.exi.main.generatedgrammar.ISO15118_2Grammar;
import com.siemens.ct.exi.main.generatedgrammar.XMLDSIG_Core_Schema_Grammar;
import com.siemens.ct.exi.main.messages.appProtocol.SupportedAppProtocolReq;
import com.siemens.ct.exi.main.messages.appProtocol.SupportedAppProtocolRes;
import com.siemens.ct.exi.main.messages.iso15118_2.SignedInfoType;
import com.siemens.ct.exi.main.messages.iso15118_2.V2G_Message;
import com.siemens.ct.exi.main.messages.iso15118_20.commonmessages.V2GMessageType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONObject;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractEXICodec {
    protected String lastEncodingError = "";
    protected String lastDecodingError = "";
    protected EXIFactory exiFactory = DefaultEXIFactory.newInstance();
    private Grammars commonAppProtocol = new CommonAppProtocol();
    private Grammars iso15118_2_Grammar = new ISO15118_2Grammar();
    private Grammars core_schema_Protocol = new XMLDSIG_Core_Schema_Grammar();
    private Grammars iso15118_20_V2G_CI_AC = new ISO15118_20_V2G_CI_AC();
    private Grammars iso15118_20_V2G_CI_ACDP = new ISO15118_20_V2G_CI_ACDP();
    private Grammars iso15118_20_V2G_CI_CommonMessages = new ISO15118_20_V2G_CI_CommonMessages();
    private Grammars iso15118_20_V2G_CI_DC = new ISO15118_20_V2G_CI_DC();
    private Grammars iso15118_20_V2G_CI_WPT = new ISO15118_20_V2G_CI_WPT();
    private InputStream inStream;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private OutputStream encodeOS;
    private JAXBContext jaxbContext;
    private String decodedExi;
    private XMLReader xmlReader;
    private String XMLDSIGNAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private String V2G_CI_MSG_BODY_NAMESPACE = "urn:iso:15118:2:2013:MsgBody";
    private String V2G_CI_MSG_DATATYPES_NAMESPACE = "urn:iso:15118:2:2013:MsgDataTypes";
    private String V2G_CI_COMMONMESSAGES_NAMESPACE = "urn:iso:std:iso:15118:-20:CommonMessages";
    private Message messageType;
    private static boolean fullDebug = true;
    BuiltInSchema builtInSchemaOption = BuiltInSchema.External;
    public static String[] signatureElements = new String[]{"ContractSignatureCertChain", "ContractSignatureEncryptedPrivateKey", "DHpublickey", "eMAID", "SalesTariff"};
    public static String[] signatureElements_20 = new String[]{"OEMProvisioningCertificateChain"};
    public static String[] fragmentGrammarElements_ISO15118_2 = new String[]{"CertificateInstallationReq", "AuthorizationReq", "MeteringReceiptReq"};

    public AbstractEXICodec() {
        this.exiFactory.setValueMaxLength(0);
        this.exiFactory.setValuePartitionCapacity(0);
        this.exiFactory.setMaximumNumberOfBuiltInElementGrammars(0);
        this.exiFactory.setMaximumNumberOfBuiltInProductions(0);
        this.setJaxbContext(SupportedAppProtocolReq.class, SupportedAppProtocolRes.class, V2G_Message.class);
        this.setUpXMLReader();
    }

    protected synchronized void setJaxbContext(Class ... classesToBeBound) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(classesToBeBound);
            this.setJAXBContext(jaxbContext);
            this.setUnmarshaller(this.getJaxbContext().createUnmarshaller());
            this.setMarshaller(this.getJaxbContext().createMarshaller());
            this.getUnmarshaller().setEventHandler(new ValidationEventHandler(){

                @Override
                public boolean handleEvent(ValidationEvent event) {
                    throw new RuntimeException(event.getMessage(), event.getLinkedException());
                }
            });
        }
        catch (JAXBException e) {
            System.out.println("A JAXBException occurred while trying to set JAXB context" + e);
        }
    }

    private JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    private void setJAXBContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    private Object unmarshallToMessage(String decodedExiString) throws IOException, JAXBException {
        if (this.getInStream() != null) {
            this.getInStream().reset();
        }
        this.setInStream(new ByteArrayInputStream(decodedExiString.getBytes()));
        if (fullDebug) {
            System.out.println("Decoded XML:\n" + decodedExiString);
        }
        Object unmarhalledObject = this.getUnmarshaller().unmarshal(this.getInStream());
        return unmarhalledObject;
    }

    private String marshallToJSON(Object decodedObject) throws JAXBException {
        this.getMarshaller().setProperty("eclipselink.media-type", "application/json");
        this.getMarshaller().setProperty("eclipselink.json.include-root", true);
        StringWriter sw = new StringWriter();
        this.getMarshaller().marshal(decodedObject, sw);
        this.getMarshaller().setProperty("eclipselink.media-type", "application/xml");
        return sw.toString();
    }

    private String marshallObjectToXML(Object object) throws JAXBException {
        StringWriter sw = new StringWriter();
        this.getMarshaller().marshal(object, sw);
        if (fullDebug) {
            System.out.println("XML:\n" + sw.toString());
        }
        return sw.toString();
    }

    private Object unmarshallJSONToMessage(String jsonString) throws IOException, JAXBException {
        if (this.getInStream() != null) {
            this.getInStream().reset();
        }
        Object unmarshalledObject = null;
        this.setInStream(new ByteArrayInputStream(jsonString.getBytes()));
        this.getUnmarshaller().setProperty("eclipselink.media-type", "application/json");
        this.getUnmarshaller().setProperty("eclipselink.json.include-root", true);
        unmarshalledObject = this.getUnmarshaller().unmarshal(this.getInStream());
        this.getUnmarshaller().setProperty("eclipselink.media-type", "application/xml");
        return unmarshalledObject;
    }

    public static <T> boolean IsOneOf15118_2_SignatureElements(String v) {
        String[] stringArray = signatureElements;
        int n = signatureElements.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e == v || v != null && v.equals(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean IsOneOf15118_20_SignatureElements(String v) {
        String[] stringArray = signatureElements_20;
        int n = signatureElements_20.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e == v || v != null && v.equals(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean IsOneOfFragmentGrammarElements_ISO15118_2(String v) {
        String[] stringArray = fragmentGrammarElements_ISO15118_2;
        int n = fragmentGrammarElements_ISO15118_2.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e == v || v != null && v.equals(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Grammars getGrammar(BuiltInSchema schemaID) {
        Grammars grammar = null;
        switch (schemaID) {
            case AppProtocol: {
                grammar = this.commonAppProtocol;
                break;
            }
            case XSDCore: {
                grammar = this.core_schema_Protocol;
                break;
            }
            case ISO15118_2: {
                grammar = this.iso15118_2_Grammar;
                break;
            }
            case ISO15118_20_V2G_CI_AC: {
                grammar = this.iso15118_20_V2G_CI_AC;
                break;
            }
            case ISO15118_20_V2G_CI_ACDP: {
                grammar = this.iso15118_20_V2G_CI_ACDP;
                break;
            }
            case ISO15118_20_V2G_CI_CommonMessages: {
                grammar = this.iso15118_20_V2G_CI_CommonMessages;
                break;
            }
            case ISO15118_20_V2G_CI_DC: {
                grammar = this.iso15118_20_V2G_CI_DC;
                break;
            }
            case ISO15118_20_V2G_CI_WPT: {
                grammar = this.iso15118_20_V2G_CI_WPT;
                break;
            }
        }
        return grammar;
    }

    public synchronized <T> JAXBElement<T> getJaxbElement(T messageOrField) {
        String messageName = messageOrField.getClass().getSimpleName().replace("Type", "");
        String namespace = "";
        JAXBElement jaxbElement = null;
        if (this.messageType == Message.ISO15118_2) {
            if (messageOrField instanceof SignedInfoType) {
                namespace = this.XMLDSIGNAMESPACE;
            } else {
                namespace = this.V2G_CI_MSG_BODY_NAMESPACE;
                if (messageName.equals("CertificateChain")) {
                    messageName = "ContractSignatureCertChain";
                } else if (messageName.equals("DiffieHellmanPublickey")) {
                    messageName = "DHpublickey";
                } else if (messageName.equals("EMAID")) {
                    messageName = "eMAID";
                } else if (messageName.equals("ContractSignatureEncryptedPrivateKey")) {
                    messageName = "ContractSignatureEncryptedPrivateKey";
                } else if (messageName.equals("SalesTariff")) {
                    namespace = this.V2G_CI_MSG_DATATYPES_NAMESPACE;
                }
            }
        } else if (this.messageType == Message.ISO15118_20) {
            if (messageName.equals("SignedCertificateChain")) {
                messageName = "OEMProvisioningCertificateChain";
            }
            namespace = this.V2G_CI_COMMONMESSAGES_NAMESPACE;
        }
        jaxbElement = new JAXBElement(new QName(namespace, messageName), messageOrField.getClass(), messageOrField);
        if (fullDebug) {
            try {
                this.marshallObjectToXML(jaxbElement);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        return jaxbElement;
    }

    public void setLastEncodingError(String lastEncodingError) {
        this.lastEncodingError = lastEncodingError;
    }

    protected void resetLastEncodingError() {
        this.lastEncodingError = "";
    }

    public void setLastDecodingError(String lastDecodingError) {
        this.lastDecodingError = lastDecodingError;
    }

    protected void resetLastDecodingError() {
        this.lastDecodingError = "";
    }

    public void setDecodedMessage(Object decodedMessage) {
    }

    public String getDecodedExi() {
        return this.decodedExi;
    }

    public void setDecodedExi(String decodedExi) {
        this.decodedExi = decodedExi;
    }

    public InputStream getInStream() {
        return this.inStream;
    }

    public void setInStream(InputStream inStream) {
        this.inStream = inStream;
    }

    protected byte[] encode_json(String jsonDocument, BuiltInSchema schemaID) throws ClassNotFoundException, JAXBException, IOException {
        jsonDocument = JSONConformance.getInstance().checkConformance(jsonDocument, schemaID, DocumentSource.BeforeEncode);
        Object messageObject = null;
        this.setJAXBContext(schemaID);
        String messageRoot = this.GetMessageRoot(jsonDocument);
        if (this.messageType == Message.ISO15118_2) {
            if (schemaID == BuiltInSchema.XSDCore || AbstractEXICodec.IsOneOf15118_2_SignatureElements(messageRoot)) {
                SignedInfoType si = null;
                if (schemaID == BuiltInSchema.XSDCore) {
                    si = SecurityPayloads.GetSignedInfo(jsonDocument);
                    messageObject = this.getJaxbElement(si);
                } else {
                    if (messageRoot.equals("ContractSignatureCertChain")) {
                        messageObject = SecurityPayloads.getContractSignatureChain(jsonDocument);
                    } else if (messageRoot.equals("ContractSignatureEncryptedPrivateKey")) {
                        messageObject = SecurityPayloads.GetContractSignatureEncryptedPrivateKey(jsonDocument);
                    } else if (messageRoot.equals("DHpublickey")) {
                        messageObject = SecurityPayloads.GetDHPublicKey(jsonDocument);
                    } else if (messageRoot.equals("eMAID")) {
                        messageObject = SecurityPayloads.GetEMAIDType(jsonDocument);
                    } else if (messageRoot.equals("SalesTariff")) {
                        messageObject = SecurityPayloads.GetSalesTariffType(jsonDocument);
                    }
                    messageObject = this.getJaxbElement(messageObject);
                }
            } else {
                messageObject = this.unmarshallJSONToMessage(jsonDocument);
            }
        } else if (this.messageType == Message.ISO15118_20) {
            if (AbstractEXICodec.IsOneOf15118_20_SignatureElements(messageRoot)) {
                messageObject = SecurityPayloads.GetSignedCertificateChainType_15118_20(jsonDocument);
                messageObject = this.getJaxbElement(messageObject);
            } else {
                messageObject = this.unmarshallJSONToMessage(jsonDocument);
            }
        } else {
            messageObject = this.unmarshallJSONToMessage(jsonDocument);
        }
        InputStream inStream = this.marshalToInputStream(messageObject);
        Grammars grammar = this.getGrammar(schemaID);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.UseFragmentMode(messageRoot, schemaID)) {
            this.exiFactory.setFragment(true);
            if (fullDebug) {
                System.out.println("Using fragment mode.");
            }
        }
        baos = (ByteArrayOutputStream)this.encode(inStream, grammar);
        if (this.UseFragmentMode(messageRoot, schemaID)) {
            this.exiFactory.setFragment(false);
        }
        return baos.toByteArray();
    }

    public String decode_exi(byte[] exiStream, BuiltInSchema schemaID) {
        Grammars grammar = this.getGrammar(schemaID);
        this.exiFactory.setGrammars(grammar);
        this.setJAXBContext(schemaID);
        try {
            this.resetLastDecodingError();
            ByteArrayInputStream bais = new ByteArrayInputStream(exiStream);
            this.setDecodedExi(this.decode_stream(bais));
            Object messageObject = this.unmarshallToMessage(this.getDecodedExi());
            String jsonDocument = this.marshallToJSON(messageObject);
            return JSONConformance.getInstance().checkConformance(jsonDocument, schemaID, DocumentSource.AfterDecode);
        }
        catch (EXIException e1) {
            this.setLastDecodingError("EXI Exception: " + e1.getLocalizedMessage());
        }
        catch (TransformerException e1) {
            this.setLastDecodingError("Transformer Exception: " + e1.getLocalizedMessage());
        }
        catch (JsonProcessingException e) {
            this.setLastDecodingError("Error processing json: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (Exception ae) {
            if (ae.getMessage() != null) {
                this.setLastDecodingError("Exception: " + ae.getMessage());
            }
            this.setLastDecodingError("Exception: " + ae.getClass().getName());
        }
        return null;
    }

    public abstract float get_version();

    private boolean UseFragmentMode(String messageRoot, BuiltInSchema schemaID) {
        boolean useFragment = false;
        if (schemaID == BuiltInSchema.ISO15118_2 && AbstractEXICodec.IsOneOfFragmentGrammarElements_ISO15118_2(messageRoot)) {
            useFragment = true;
        }
        if (schemaID == BuiltInSchema.ISO15118_2 && AbstractEXICodec.IsOneOf15118_2_SignatureElements(messageRoot)) {
            useFragment = true;
        }
        if (schemaID == BuiltInSchema.XSDCore) {
            useFragment = true;
        }
        if (schemaID == BuiltInSchema.ISO15118_20_V2G_CI_CommonMessages && AbstractEXICodec.IsOneOf15118_20_SignatureElements(messageRoot)) {
            useFragment = true;
        }
        return useFragment;
    }

    private String GetMessageRoot(String json) {
        JSONObject object = new JSONObject(json);
        return object.keys().next();
    }

    private void setJAXBContext(BuiltInSchema schema) {
        if (schema == BuiltInSchema.ISO15118_2) {
            this.setJaxbContext(SupportedAppProtocolReq.class, SupportedAppProtocolRes.class, V2G_Message.class);
            this.messageType = Message.ISO15118_2;
        } else if (schema == BuiltInSchema.XSDCore) {
            this.setJaxbContext(SupportedAppProtocolReq.class, SupportedAppProtocolRes.class, V2G_Message.class);
            this.messageType = Message.ISO15118_2;
        } else if (schema == BuiltInSchema.ISO15118_20_V2G_CI_CommonMessages) {
            this.setJaxbContext(SupportedAppProtocolReq.class, SupportedAppProtocolRes.class, V2GMessageType.class);
            this.messageType = Message.ISO15118_20;
        } else if (schema == BuiltInSchema.AppProtocol) {
            this.messageType = Message.AppProtocol;
        }
    }

    private synchronized String decode_stream(InputStream exiInputStream) throws EXIException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = null;
        StringWriter stringWriter = new StringWriter();
        transformer = tf.newTransformer();
        EXISource saxSource = new EXISource(this.exiFactory);
        SAXSource exiSource = new SAXSource(new InputSource(exiInputStream));
        XMLReader exiReader = saxSource.getXMLReader();
        exiSource.setXMLReader(exiReader);
        transformer.transform(exiSource, new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public boolean compareEncodedAndDecodedJSONFiles(String input_to_encode, String output_decoded) {
        try {
            return new JSONObject(input_to_encode).similar(new JSONObject(output_decoded));
        }
        catch (Exception ae) {
            System.out.println("CompareEncodedAndDecodedJSONFiles: " + ae.getMessage());
            return false;
        }
    }

    private void setUpXMLReader() {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            this.xmlReader = parser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private InputStream marshalToInputStream(Object jaxbObject) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (fullDebug) {
            this.marshallObjectToXML(jaxbObject);
        }
        try {
            if (this.getInStream() != null) {
                this.getInStream().reset();
            }
            this.getMarshaller().marshal(jaxbObject, baos);
            this.setInStream(new ByteArrayInputStream(baos.toByteArray()));
            baos.close();
            return this.getInStream();
        }
        catch (Exception e) {
            System.out.println("MarshalToInputStream error " + e.getMessage());
            return null;
        }
    }

    private synchronized OutputStream encode(InputStream jaxbXML, Grammars grammar) {
        EXIResult exiResult = null;
        try {
            this.exiFactory.setGrammars(grammar);
            this.encodeOS = new ByteArrayOutputStream();
            exiResult = new EXIResult(this.exiFactory);
            exiResult.setOutputStream(this.encodeOS);
            this.xmlReader.setContentHandler(exiResult.getHandler());
            this.xmlReader.parse(new InputSource(jaxbXML));
            this.encodeOS.close();
        }
        catch (Exception e) {
            System.out.println("Error encoding stream: " + e.getMessage());
        }
        return this.encodeOS;
    }
}

