/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.cmd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.siemens.ct.exi.main.cmd.AbstractEXICodec;
import com.siemens.ct.exi.main.cmd.BuiltInSchema;
import com.siemens.ct.exi.main.cmd.EXICodecQuickTest;
import javax.xml.bind.DatatypeConverter;

public final class EXICodec
extends AbstractEXICodec {
    private static float version = 1.38f;

    public byte[] encode(String jsonDocument, BuiltInSchema schemaID) {
        try {
            this.resetLastEncodingError();
            return this.encode_json(jsonDocument, schemaID);
        }
        catch (JsonMappingException e) {
            this.setLastEncodingError("JSON Mapping Error " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            String className = e.getMessage().substring(e.getMessage().lastIndexOf(46) + 1);
            this.setLastEncodingError("Unknown Message Type: " + className);
        }
        catch (JsonProcessingException e) {
            this.setLastEncodingError("JSON Processing Error " + e.getMessage());
        }
        catch (Exception e) {
            this.setLastEncodingError("Unknown error: " + e.toString());
        }
        return null;
    }

    public String decode(byte[] exiStream, BuiltInSchema schemaID) {
        return this.decode_exi(exiStream, schemaID);
    }

    public byte[] encode_signed_info(String jsonDocument) {
        this.exiFactory.setFragment(true);
        byte[] exi_stream = this.encode(jsonDocument, BuiltInSchema.XSDCore);
        this.exiFactory.setFragment(false);
        return exi_stream;
    }

    public String decode_signed_info(byte[] exiStream) {
        this.exiFactory.setFragment(true);
        String signed_info = this.decode_exi(exiStream, BuiltInSchema.XSDCore);
        this.exiFactory.setFragment(false);
        return signed_info;
    }

    public String get_last_encoding_error() {
        return this.lastEncodingError;
    }

    public String get_last_decoding_error() {
        return this.lastDecodingError;
    }

    public boolean check_encode_decode_cycle(String jsonDocument, BuiltInSchema schemaID) {
        this.resetLastDecodingError();
        this.resetLastEncodingError();
        byte[] encoded_message = this.encode(jsonDocument, schemaID);
        boolean result = false;
        if (encoded_message != null) {
            String decoded_message = this.decode(encoded_message, schemaID);
            result = this.compareEncodedAndDecodedJSONFiles(jsonDocument, decoded_message);
        }
        return result;
    }

    public static byte[] toByteArray(String s) {
        return DatatypeConverter.parseHexBinary(s);
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    @Override
    public float get_version() {
        return version;
    }

    public static void main(String[] args) {
        EXICodecQuickTest.runFullEncodeDecodeTests();
        String json = "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"B3FBC37458069DBA\"}, \"Body\": {\"PaymentServiceSelectionReq\": {\"SelectedPaymentOption\": \"Contract\", \"SelectedServiceList\": {\"SelectedService\": [{\"ServiceID\": 1}, {\"ServiceID\": 2}]}}}}} ";
        EXICodecQuickTest.runSingleJSONEncodeDecodeTest(json, BuiltInSchema.ISO15118_2);
    }
}

