/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream {
    public static final int BITS_IN_BYTE = 8;
    protected int buffer = 0;
    protected int capacity = 8;
    private OutputStream ostream;
    protected int len;
    private boolean fullDebug = false;

    public BitOutputStream(OutputStream ostream) {
        this.ostream = ostream;
        this.len = 0;
    }

    public OutputStream getUnderlyingOutputStream() {
        return this.ostream;
    }

    public int getLength() {
        if (this.fullDebug) {
            System.out.println("GetLength() " + this.len);
        }
        return this.len;
    }

    protected void flushBuffer() throws IOException {
        if (this.capacity == 0) {
            if (this.fullDebug) {
                System.out.println("Flush buffer d:" + this.buffer + " (1 bit?)");
            }
            this.ostream.write(this.buffer);
            this.capacity = 8;
            this.buffer = 0;
            ++this.len;
        }
    }

    public boolean isByteAligned() {
        return this.capacity == 8;
    }

    public int getBitsInBuffer() {
        return 8 - this.capacity;
    }

    @Override
    public void flush() throws IOException {
        this.align();
        this.ostream.flush();
    }

    public void align() throws IOException {
        if (this.capacity < 8) {
            this.ostream.write(this.buffer << this.capacity);
            this.capacity = 8;
            this.buffer = 0;
            ++this.len;
        }
    }

    public void writeBit0() throws IOException {
        if (this.fullDebug) {
            System.out.println("\tWriteBit0 d: 0 n: 1");
        }
        this.buffer <<= 1;
        --this.capacity;
        this.flushBuffer();
    }

    public void writeBit1() throws IOException {
        if (this.fullDebug) {
            System.out.println("\tWriteBit1 d: 1 n: 1");
        }
        this.buffer = this.buffer << 1 | 1;
        --this.capacity;
        this.flushBuffer();
    }

    protected void writeBit(int b) throws IOException {
        if (this.fullDebug) {
            System.out.println("\tWriteBit d: " + b + " n: 1");
        }
        this.buffer = this.buffer << 1 | b & 1;
        --this.capacity;
        this.flushBuffer();
    }

    public void writeBits(int b, int n) throws IOException {
        if (this.fullDebug) {
            System.out.println("\tWriteBits b: " + b + " n:" + n);
        }
        if (n <= this.capacity) {
            this.buffer = this.buffer << n | b & 255 >> 8 - n;
            this.capacity -= n;
            if (this.capacity == 0) {
                this.ostream.write(this.buffer);
                this.capacity = 8;
                ++this.len;
            }
        } else {
            this.buffer = this.buffer << this.capacity | b >>> n - this.capacity & 255 >> 8 - this.capacity;
            n -= this.capacity;
            this.ostream.write(this.buffer);
            ++this.len;
            while (n >= 8) {
                this.ostream.write(b >>> (n -= 8));
                ++this.len;
            }
            this.buffer = b;
            this.capacity = 8 - n;
        }
    }

    protected void writeDirectByte(int b) throws IOException {
        if (this.fullDebug) {
            System.out.println("WriteDirectByte: b: " + b + "n:8");
        }
        this.ostream.write(b);
        ++this.len;
    }

    protected void writeDirectBytes(byte[] b, int off, int len) throws IOException {
        if (this.fullDebug) {
            System.out.println("WriteDirectBytes: b: " + b + "n:8 offset:" + off);
        }
        this.ostream.write(b, off, len);
        len += len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.fullDebug) {
            System.out.println("WriteByte b:" + b + "n:8");
        }
        this.writeBits(b, 8);
    }
}

