# Generated by Django 2.2.12 on 2020-05-14 23:56

from django.db import migrations, models
import django.db.models.deletion

from wagtail import blocks as wagtail_blocks
from wagtail import fields as wagtail_fields

import wagtail.documents.blocks
import wagtail.embeds.blocks
import wagtail.images.blocks
import wagtail.snippets.blocks

from wagtail.images import get_image_model_string

image_model = get_image_model_string()


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(get_image_model_string()),
        ("wagtaildonate", "0021_checkout_hero"),
    ]

    operations = [
        migrations.AddField(
            model_name="donationcampaignpage",
            name="thank_you_page_content",
            field=wagtail_fields.StreamField(
                [
                    (
                        "heading",
                        wagtail_blocks.CharBlock(
                            classname="full title",
                            icon="title",
                            template="wagtaildonate/streamfield/blocks/heading_block.html",
                        ),
                    ),
                    ("paragraph", wagtail_blocks.RichTextBlock()),
                    (
                        "image",
                        wagtail_blocks.StructBlock(
                            [
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                (
                                    "caption",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    (
                        "document",
                        wagtail_blocks.StructBlock(
                            [
                                (
                                    "document",
                                    wagtail.documents.blocks.DocumentChooserBlock(),
                                ),
                                (
                                    "title",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    (
                        "quote",
                        wagtail_blocks.StructBlock(
                            [
                                (
                                    "quote",
                                    wagtail_blocks.CharBlock(classname="title"),
                                ),
                                (
                                    "attribution",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    ("video", wagtail.embeds.blocks.EmbedBlock()),
                    (
                        "call_to_action",
                        wagtail.snippets.blocks.SnippetChooserBlock(
                            "wagtaildonate.ThankYouCTASnippet",
                            template="wagtaildonate/streamfield/blocks/thank_you_cta_block.html",
                        ),
                    ),
                ],
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name="donationfundraisingpayinpage",
            name="thank_you_page_content",
            field=wagtail_fields.StreamField(
                [
                    (
                        "heading",
                        wagtail_blocks.CharBlock(
                            classname="full title",
                            icon="title",
                            template="wagtaildonate/streamfield/blocks/heading_block.html",
                        ),
                    ),
                    ("paragraph", wagtail_blocks.RichTextBlock()),
                    (
                        "image",
                        wagtail_blocks.StructBlock(
                            [
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                (
                                    "caption",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    (
                        "document",
                        wagtail_blocks.StructBlock(
                            [
                                (
                                    "document",
                                    wagtail.documents.blocks.DocumentChooserBlock(),
                                ),
                                (
                                    "title",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    (
                        "quote",
                        wagtail_blocks.StructBlock(
                            [
                                (
                                    "quote",
                                    wagtail_blocks.CharBlock(classname="title"),
                                ),
                                (
                                    "attribution",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    ("video", wagtail.embeds.blocks.EmbedBlock()),
                    (
                        "call_to_action",
                        wagtail.snippets.blocks.SnippetChooserBlock(
                            "wagtaildonate.ThankYouCTASnippet",
                            template="wagtaildonate/streamfield/blocks/thank_you_cta_block.html",
                        ),
                    ),
                ],
                blank=True,
            ),
        ),
        migrations.AddField(
            model_name="donationpage",
            name="thank_you_page_content",
            field=wagtail_fields.StreamField(
                [
                    (
                        "heading",
                        wagtail_blocks.CharBlock(
                            classname="full title",
                            icon="title",
                            template="wagtaildonate/streamfield/blocks/heading_block.html",
                        ),
                    ),
                    ("paragraph", wagtail_blocks.RichTextBlock()),
                    (
                        "image",
                        wagtail_blocks.StructBlock(
                            [
                                ("image", wagtail.images.blocks.ImageChooserBlock()),
                                (
                                    "caption",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    (
                        "document",
                        wagtail_blocks.StructBlock(
                            [
                                (
                                    "document",
                                    wagtail.documents.blocks.DocumentChooserBlock(),
                                ),
                                (
                                    "title",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    (
                        "quote",
                        wagtail_blocks.StructBlock(
                            [
                                (
                                    "quote",
                                    wagtail_blocks.CharBlock(classname="title"),
                                ),
                                (
                                    "attribution",
                                    wagtail_blocks.CharBlock(required=False),
                                ),
                            ]
                        ),
                    ),
                    ("video", wagtail.embeds.blocks.EmbedBlock()),
                    (
                        "call_to_action",
                        wagtail.snippets.blocks.SnippetChooserBlock(
                            "wagtaildonate.ThankYouCTASnippet",
                            template="wagtaildonate/streamfield/blocks/thank_you_cta_block.html",
                        ),
                    ),
                ],
                blank=True,
            ),
        ),
        migrations.CreateModel(
            name="ThankYouCTASnippet",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=255)),
                (
                    "summary",
                    wagtail_fields.RichTextField(blank=True, max_length=255),
                ),
                (
                    "link",
                    wagtail_fields.StreamField(
                        [
                            (
                                "external_link",
                                wagtail_blocks.StructBlock(
                                    [
                                        ("url", wagtail_blocks.URLBlock()),
                                        ("title", wagtail_blocks.CharBlock()),
                                    ],
                                    icon="link",
                                ),
                            ),
                            (
                                "internal_link",
                                wagtail_blocks.StructBlock(
                                    [
                                        (
                                            "page",
                                            wagtail_blocks.PageChooserBlock(),
                                        ),
                                        (
                                            "title",
                                            wagtail_blocks.CharBlock(required=False),
                                        ),
                                    ],
                                    icon="link",
                                ),
                            ),
                        ],
                        blank=True,
                    ),
                ),
                (
                    "image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=image_model,
                    ),
                ),
            ],
            options={"verbose_name": "Thank you CTA snippet"},
        ),
    ]
