from setuptools import setup, find_packages
from cnvrg.version import VERSION
setup(
    name='cnvrg',
    version=VERSION,
    python_requires='>3.5',
    packages=find_packages(exclude=("tests",)),
    install_requires=[
        'click',
        'requests==2.23.0',
        "boto3",
        'colorama',
        "tqdm",
        "pyaml",
        'tinynetrc',
        'pycryptodome',
        'psutil',
        'dill',
        'pytz',
        'numpy',
        'pandas',
        'azure-core==1.10.0',
        'azure-storage-blob==12.6.0',
        'google-cloud-storage',
        'six>=1.13',
        'progress',
        'croniter'
    ],
    author="cnvrg",
    author_email="support@cnvrg.io",
    entry_points='''
        [console_scripts]
        cnvrgp=cnvrg.main:cli
    ''',
)
