"""
ANN Lab Code - Embedded Complete Notebook Code
===============================================

This module contains the complete code from all ANN lab notebooks,
embedded as string constants for easy access via flowlab functions.

Lab 8: Autoencoders
Lab 9: Advanced Neural Networks
Lab 10: Deep Learning Architectures  
Lab 11: Transfer Learning & Fine-tuning
"""

LAB_CODE = {
    8: 'import torch\nfrom torch import nn, optim\nfrom torchvision import datasets, transforms\nimport matplotlib.pyplot as plt\n\ntensor_transform = transforms.ToTensor()\ndataset = datasets.MNIST(root="./data", train=True,\n                         download=True, transform=tensor_transform)\nloader = torch.utils.data.DataLoader(\n    dataset=dataset, batch_size=32, shuffle=True)\n\nclass AE(nn.Module):\n    def __init__(self):\n        super(AE, self).__init__()\n        self.encoder = nn.Sequential(\n            nn.Linear(28 * 28, 128),\n            nn.ReLU(),\n            nn.Linear(128, 64),\n            nn.ReLU(),\n            nn.Linear(64, 36),\n            nn.ReLU(),\n            nn.Linear(36, 18),\n            nn.ReLU(),\n            nn.Linear(18, 9)\n        )\n        self.decoder = nn.Sequential(\n            nn.Linear(9, 18),\n            nn.ReLU(),\n            nn.Linear(18, 36),\n            nn.ReLU(),\n            nn.Linear(36, 64),\n            nn.ReLU(),\n            nn.Linear(64, 128),\n            nn.ReLU(),\n            nn.Linear(128, 28 * 28),\n            nn.Sigmoid()\n        )\n\n    def forward(self, x):\n        encoded = self.encoder(x)\n        decoded = self.decoder(encoded)\n        return decoded\n\nmodel = AE()\nloss_function = nn.MSELoss()\noptimizer = optim.Adam(model.parameters(), lr=1e-3, weight_decay=1e-8)\n\nepochs = 20\noutputs = []\nlosses = []\n\ndevice = torch.device("cuda" if torch.cuda.is_available() else "cpu")\nmodel.to(device)\n\nfor epoch in range(epochs):\n    for images, _ in loader:\n        images = images.view(-1, 28 * 28).to(device)\n\n        reconstructed = model(images)\n        loss = loss_function(reconstructed, images)\n\n        optimizer.zero_grad()\n        loss.backward()\n        optimizer.step()\n\n        losses.append(loss.item())\n\n    outputs.append((epoch, images, reconstructed))\n    print(f"Epoch {epoch+1}/{epochs}, Loss: {loss.item():.6f}")\n\nplt.style.use(\'fivethirtyeight\')\nplt.figure(figsize=(8, 5))\nplt.plot(losses, label=\'Loss\')\nplt.xlabel(\'Iterations\')\nplt.ylabel(\'Loss\')\nplt.legend()\nplt.show()\n\nmodel.eval()\ndataiter = iter(loader)\nimages, _ = next(dataiter)\n\nimages = images.view(-1, 28 * 28).to(device)\nreconstructed = model(images)\n\nfig, axes = plt.subplots(nrows=2, ncols=10, figsize=(10, 3))\nfor i in range(10):\n    axes[0, i].imshow(images[i].cpu().detach().numpy().reshape(28, 28), cmap=\'gray\')\n    axes[0, i].axis(\'off\')\n    axes[1, i].imshow(reconstructed[i].cpu().detach().numpy().reshape(28, 28), cmap=\'gray\')\n    axes[1, i].axis(\'off\')\nplt.show()\n\nmodel = AE()\nloss_function = nn.MSELoss()\noptimizer = optim.Adam(model.parameters(), lr=1e-3, weight_decay=1e-8)\n\nepochs = 20\noutputs_denoising = []\nlosses_denoising = []\n\ndevice = torch.device("cuda" if torch.cuda.is_available() else "cpu")\nmodel.to(device)\n\nnoise_factor = 0.5 # Define noise factor\n\nfor epoch in range(epochs):\n    for images, _ in loader:\n        images = images.view(-1, 28 * 28).to(device)\n\n        # Add random noise to the images\n        noisy_images = images + noise_factor * torch.randn_like(images)\n        noisy_images = torch.clamp(noisy_images, 0., 1.) # Clamp pixel values\n\n        reconstructed = model(noisy_images) # Pass noisy images to the model\n        loss = loss_function(reconstructed, images) # Compare reconstructed with original clean images\n\n        optimizer.zero_grad()\n        loss.backward()\n        optimizer.step()\n\n        losses_denoising.append(loss.item())\n\n    outputs_denoising.append((epoch, images, noisy_images, reconstructed))\n    print(f"Epoch {epoch+1}/{epochs}, Loss: {loss.item():.6f}")\n\nplt.style.use(\'fivethirtyeight\')\nplt.figure(figsize=(8, 5))\nplt.plot(losses_denoising, label=\'Denoising AE Loss\')\nplt.xlabel(\'Iterations\')\nplt.ylabel(\'Loss\')\nplt.legend()\nplt.show()\n\nmodel.eval()\ndataiter = iter(loader)\nimages, _ = next(dataiter)\n\nimages = images.view(-1, 28 * 28).to(device)\n\n# Add noise to a fresh batch of images for visualization\nnoise_factor = 0.5 # Using the same noise factor as during training\nnoisy_images = images + noise_factor * torch.randn_like(images)\nnoisy_images = torch.clamp(noisy_images, 0., 1.)\n\nreconstructed = model(noisy_images)\n\nfig, axes = plt.subplots(nrows=3, ncols=10, figsize=(10, 5))\nfor i in range(10):\n    # Original Images\n    axes[0, i].imshow(images[i].cpu().detach().numpy().reshape(28, 28), cmap=\'gray\')\n    axes[0, i].axis(\'off\')\n    if i == 0:\n        axes[0, i].set_title(\'Original\')\n\n    # Noisy Images\n    axes[1, i].imshow(noisy_images[i].cpu().detach().numpy().reshape(28, 28), cmap=\'gray\')\n    axes[1, i].axis(\'off\')\n    if i == 0:\n        axes[1, i].set_title(\'Noisy\')\n\n    # Reconstructed Images\n    axes[2, i].imshow(reconstructed[i].cpu().detach().numpy().reshape(28, 28), cmap=\'gray\')\n    axes[2, i].axis(\'off\')\n    if i == 0:\n        axes[2, i].set_title(\'Reconstructed\')\nplt.show()\n\nfashion_transform = transforms.ToTensor()\nfashion_dataset = datasets.FashionMNIST(root="./data", train=True,\n                                        download=True, transform=fashion_transform)\nfashion_loader = torch.utils.data.DataLoader(\n    dataset=fashion_dataset, batch_size=32, shuffle=True)\n\nclass CAE(nn.Module):\n    def __init__(self):\n        super(CAE, self).__init__()\n        # Encoder\n        self.encoder = nn.Sequential(\n            nn.Conv2d(1, 16, 3, padding=1), # (batch_size, 16, 28, 28)\n            nn.ReLU(),\n            nn.MaxPool2d(2, 2), # (batch_size, 16, 14, 14)\n            nn.Conv2d(16, 8, 3, padding=1), # (batch_size, 8, 14, 14)\n            nn.ReLU(),\n            nn.MaxPool2d(2, 2) # (batch_size, 8, 7, 7)\n        )\n        # Decoder\n        self.decoder = nn.Sequential(\n            nn.ConvTranspose2d(8, 8, 3, stride=2, padding=1, output_padding=1), # (batch_size, 8, 14, 14)\n            nn.ReLU(),\n            nn.ConvTranspose2d(8, 16, 3, stride=2, padding=1, output_padding=1), # (batch_size, 16, 28, 28)\n            nn.ReLU(),\n            nn.Conv2d(16, 1, 3, padding=1), # (batch_size, 1, 28, 28)\n            nn.Sigmoid()\n        )\n\n    def forward(self, x):\n        encoded = self.encoder(x)\n        decoded = self.decoder(encoded)\n        return decoded\n\n\ncae_model = CAE()\ncae_loss_function = nn.MSELoss()\ncae_optimizer = optim.Adam(cae_model.parameters(), lr=1e-3, weight_decay=1e-8)\n\nepochs_cae = 20\noutputs_cae = []\nlosses_cae = []\n\ncae_device = torch.device("cuda" if torch.cuda.is_available() else "cpu")\ncae_model.to(cae_device)\n\nfor epoch in range(epochs_cae):\n    for images, _ in fashion_loader:\n        images = images.to(cae_device) # Images are already 1x28x28 for CAE\n\n        reconstructed = cae_model(images)\n        loss = cae_loss_function(reconstructed, images)\n\n        cae_optimizer.zero_grad()\n        loss.backward()\n        cae_optimizer.step()\n\n        losses_cae.append(loss.item())\n\n    outputs_cae.append((epoch, images, reconstructed))\n    print(f"Epoch {epoch+1}/{epochs_cae}, Loss: {loss.item():.6f}")\n\nplt.style.use(\'fivethirtyeight\')\nplt.figure(figsize=(8, 5))\nplt.plot(losses_cae, label=\'CAE Loss\')\nplt.xlabel(\'Iterations\')\nplt.ylabel(\'Loss\')\nplt.legend()\nplt.show()\n\ncae_model.eval()\ndataiter_fashion = iter(fashion_loader)\nimages_fashion, _ = next(dataiter_fashion)\n\nimages_fashion = images_fashion.to(cae_device)\nreconstructed_fashion = cae_model(images_fashion)\n\nfig, axes = plt.subplots(nrows=2, ncols=10, figsize=(10, 4))\nfor i in range(10):\n    # Original Images\n    axes[0, i].imshow(images_fashion[i].cpu().detach().numpy().reshape(28, 28), cmap=\'gray\')\n    axes[0, i].axis(\'off\')\n    if i == 0:\n        axes[0, i].set_title(\'Original\')\n\n    # Reconstructed Images\n    axes[1, i].imshow(reconstructed_fashion[i].cpu().detach().numpy().reshape(28, 28), cmap=\'gray\')\n    axes[1, i].axis(\'off\')\n    if i == 0:\n        axes[1, i].set_title(\'Reconstructed\')\nplt.show()',
    9: 'import numpy as np\nimport matplotlib.pyplot as plt\nimport pandas as pd\n\nimport torch\nimport torch.nn as nn\nfrom torch.utils.data import Dataset, DataLoader, TensorDataset, random_split\n\nimport tensorflow as tf\nfrom tensorflow.keras.datasets import imdb\nfrom tensorflow.keras.preprocessing.sequence import pad_sequences\n\nfrom sklearn.metrics import classification_report, confusion_matrix\n\ndevice = torch.device("cuda" if torch.cuda.is_available() else "cpu")\nprint(f"Using device: {device}")\n\ndf = pd.read_csv(r"/content/100_Unique_QA_Dataset.csv")\nprint(df.head())\n\ndef tokenize(text):\n  text = text.lower().replace(\'?\',\'\').replace("\'","")\n  return text.split()\n\ndef build_vocab(row):\n  tokenized_question = tokenize(row[\'question\'])\n  tokenized_answer = tokenize(row[\'answer\'])\n  merged_tokens = tokenized_question + tokenized_answer\n  for token in merged_tokens:\n    if token not in vocab:\n      vocab[token] = len(vocab)\n\ndef text_to_indices(text, vocab):\n  indexed_text = []\n  for token in tokenize(text):\n    if token in vocab:\n      indexed_text.append(vocab[token])\n    else:\n      indexed_text.append(vocab[\'<UNK>\'])\n  return indexed_text\n\nvocab = {\'<UNK>\': 0}\ndf.apply(build_vocab, axis=1)\nprint("Vocab Size:", len(vocab))\n\nclass QADataset(Dataset):\n  def __init__(self, df, vocab):\n    self.df = df\n    self.vocab = vocab\n\n  def __len__(self):\n    return self.df.shape[0]\n\n  def __getitem__(self, index):\n    numerical_question = text_to_indices(self.df.iloc[index][\'question\'], self.vocab)\n    numerical_answer = text_to_indices(self.df.iloc[index][\'answer\'], self.vocab)\n    return torch.tensor(numerical_question), torch.tensor(numerical_answer)\n\nclass SimpleRNN(nn.Module):\n  def __init__(self, vocab_size):\n    super().__init__()\n    self.embedding = nn.Embedding(vocab_size, embedding_dim=50)\n    self.rnn = nn.RNN(50, 64, batch_first=True)\n    self.fc = nn.Linear(64, vocab_size)\n\n  def forward(self, question):\n    embedded_question = self.embedding(question)\n    output, hidden = self.rnn(embedded_question)\n    final_encoding = output[:, -1, :]\n    final_output = self.fc(final_encoding)\n    return final_output\n\ndataset = QADataset(df, vocab)\ndataloader = DataLoader(dataset, batch_size=1, shuffle=True)\n\nmodel = SimpleRNN(len(vocab)).to(device)\n\nlearning_rate = 0.01\nepochs = 50\ncriterion = nn.CrossEntropyLoss()\noptimizer = torch.optim.Adam(model.parameters(), lr=learning_rate)\n\nprint("Starting Training...\\n")\n\nfor epoch in range(epochs):\n  total_loss = 0\n  for question, answer in dataloader:\n\n    question = question.to(device)\n    answer = answer.to(device)\n\n    optimizer.zero_grad()\n    output = model(question)\n\n    loss = criterion(output, answer[0])\n\n    loss.backward()\n    optimizer.step()\n    total_loss = total_loss + loss.item()\n\n  if (epoch+1) % 10 == 0:\n      print(f"Epoch {epoch+1}, Loss: {total_loss:.4f}")\n\ndef predict(model, question, threshold=0.5):\n  model.eval()\n  numerical_question = text_to_indices(question, vocab)\n  question_tensor = torch.tensor(numerical_question).unsqueeze(0).to(device)\n\n  with torch.no_grad():\n      output = model(question_tensor)\n      probs = torch.nn.functional.softmax(output, dim=1)\n      value, index = torch.max(probs, dim=1)\n\n  predicted_index = index.item()\n  predicted_word = list(vocab.keys())[list(vocab.values()).index(predicted_index)]\n  print(f"Q: {question}\\nA: {predicted_word}")\n\nprint("--- Predictions ---\\n")\npredict(model, "what\'s the capital of Brazil?")\npredict(model, "Which Disney character had a long nose that grew from lying?")\n\nVOCAB_SIZE = 10_000\nMAX_LEN = 200\nBATCH_SIZE = 64\n\nprint("Loading IMDB Data via Keras...")\n(X_train_raw, y_train_raw), (X_test_raw, y_test_raw) = imdb.load_data(num_words=VOCAB_SIZE)\n\nX_train_pad = pad_sequences(X_train_raw, maxlen=MAX_LEN, padding=\'pre\')\nX_test_pad = pad_sequences(X_test_raw, maxlen=MAX_LEN, padding=\'pre\')\n\ntensor_x = torch.tensor(X_train_pad, dtype=torch.long)\ntensor_y = torch.tensor(y_train_raw, dtype=torch.float32).unsqueeze(1)\ntest_x = torch.tensor(X_test_pad, dtype=torch.long)\ntest_y = torch.tensor(y_test_raw, dtype=torch.float32).unsqueeze(1)\n\nfull_train_dataset = TensorDataset(tensor_x, tensor_y)\ntest_dataset = TensorDataset(test_x, test_y)\n\ntrain_size = int(0.8 * len(full_train_dataset))\nval_size = len(full_train_dataset) - train_size\ntrain_dataset, val_dataset = random_split(full_train_dataset, [train_size, val_size])\n\ntrain_loader = DataLoader(train_dataset, batch_size=BATCH_SIZE, shuffle=True)\nval_loader = DataLoader(val_dataset, batch_size=BATCH_SIZE, shuffle=False)\ntest_loader = DataLoader(test_dataset, batch_size=BATCH_SIZE, shuffle=False)\n\nclass SentimentRNN(nn.Module):\n    def __init__(self, vocab_size, embedding_dim, hidden_dim):\n        super(SentimentRNN, self).__init__()\n        self.embedding = nn.Embedding(vocab_size, embedding_dim, padding_idx=0)\n        self.rnn = nn.RNN(embedding_dim, hidden_dim, batch_first=True)\n        self.fc = nn.Linear(hidden_dim, 1)\n        self.sigmoid = nn.Sigmoid()\n\n    def forward(self, x):\n        embeds = self.embedding(x)\n        rnn_out, hidden = self.rnn(embeds)\n        last_step_output = rnn_out[:, -1, :]\n        out = self.fc(last_step_output)\n        return self.sigmoid(out)\n\nmodel = SentimentRNN(vocab_size=VOCAB_SIZE, embedding_dim=32, hidden_dim=64).to(device)\n\nlearning_rate = 0.001\nepochs = 10\ncriterion = nn.BCELoss()\noptimizer = torch.optim.Adam(model.parameters(), lr=learning_rate)\n\ntrain_losses = []\n\nhistory = {\'train_loss\': [], \'train_acc\': [], \'val_loss\': [], \'val_acc\': []}\n\nprint("\\n--- Starting Training ---")\n\nfor epoch in range(epochs):\n    model.train()\n    train_loss, train_correct, train_total = 0, 0, 0\n\n    for inputs, labels in train_loader:\n        inputs, labels = inputs.to(device), labels.to(device)\n\n        optimizer.zero_grad()\n        outputs = model(inputs)\n        loss = criterion(outputs, labels)\n        loss.backward()\n        optimizer.step()\n\n        train_loss += loss.item()\n        predicted = (outputs > 0.5).float()\n        train_total += labels.size(0)\n        train_correct += (predicted == labels).sum().item()\n\n    model.eval()\n    val_loss, val_correct, val_total = 0, 0, 0\n\n    with torch.no_grad():\n        for inputs, labels in val_loader:\n            inputs, labels = inputs.to(device), labels.to(device)\n            outputs = model(inputs)\n            loss = criterion(outputs, labels)\n\n            val_loss += loss.item()\n            predicted = (outputs > 0.5).float()\n            val_total += labels.size(0)\n            val_correct += (predicted == labels).sum().item()\n\n    avg_train_loss = train_loss / len(train_loader)\n    avg_train_acc = train_correct / train_total\n    avg_val_loss = val_loss / len(val_loader)\n    avg_val_acc = val_correct / val_total\n\n    history[\'train_loss\'].append(avg_train_loss)\n    history[\'train_acc\'].append(avg_train_acc)\n    history[\'val_loss\'].append(avg_val_loss)\n    history[\'val_acc\'].append(avg_val_acc)\n\n    print(f"Epoch {epoch+1}/{epochs} | "\n          f"Train Loss: {avg_train_loss:.4f} Acc: {avg_train_acc:.4f} | "\n          f"Val Loss: {avg_val_loss:.4f} Acc: {avg_val_acc:.4f}")\n\nmodel.eval()\nall_preds = []\nall_labels = []\n\nwith torch.no_grad():\n    for inputs, labels in test_loader:\n        inputs = inputs.to(device)\n        outputs = model(inputs)\n        predicted = (outputs > 0.5).float()\n\n        all_preds.extend(predicted.cpu().numpy())\n        all_labels.extend(labels.numpy())\n\nprint("\\n--- Classification Report ---")\nprint(classification_report(all_labels, all_preds, target_names=[\'Negative\', \'Positive\']))\n\nepochs_range = range(1, epochs + 1)\n\nplt.figure(figsize=(12, 5))\n\nplt.subplot(1, 2, 1)\nplt.plot(epochs_range, history[\'train_acc\'], label=\'Training Accuracy\')\nplt.plot(epochs_range, history[\'val_acc\'], label=\'Validation Accuracy\')\nplt.title(\'Training and Validation Accuracy\')\nplt.xlabel(\'Epochs\')\nplt.ylabel(\'Accuracy\')\nplt.legend()\n\nplt.subplot(1, 2, 2)\nplt.plot(epochs_range, history[\'train_loss\'], label=\'Training Loss\')\nplt.plot(epochs_range, history[\'val_loss\'], label=\'Validation Loss\')\nplt.title(\'Training and Validation Loss\')\nplt.xlabel(\'Epochs\')\nplt.ylabel(\'Loss\')\nplt.legend()\n\nplt.show()\n\nmodel.eval()\nall_preds, all_labels = [], []\n\nwith torch.no_grad():\n    for inputs, labels in test_loader:\n        inputs = inputs.to(device)\n        outputs = model(inputs)\n        predicted = (outputs > 0.5).float()\n        all_preds.extend(predicted.cpu().numpy())\n        all_labels.extend(labels.numpy())\n\nprint("\\n--- Test Set Evaluation ---")\nprint(classification_report(all_labels, all_preds, target_names=[\'Negative\', \'Positive\']))\n\nword_index = imdb.get_word_index()\n\ndef predict_sentiment(text):\n    model.eval()\n    words = text.lower().split()\n    encoded_list = []\n    for w in words:\n        idx = word_index.get(w, -3) + 3\n        if idx >= VOCAB_SIZE or idx < 3: idx = 2\n        encoded_list.append(idx)\n\n    if len(encoded_list) < MAX_LEN:\n        padded = [0] * (MAX_LEN - len(encoded_list)) + encoded_list\n    else:\n        padded = encoded_list[:MAX_LEN]\n\n    tensor_input = torch.tensor([padded], dtype=torch.long).to(device)\n\n    with torch.no_grad():\n        output = model(tensor_input)\n        prob = output.item()\n\n    return "Positive" if prob > 0.5 else "Negative", prob\n\nprint("--- Five User Reviews Test ---\\n")\nreviews = ["This movie was absolutely fantastic",\n           "I hated it, total waste of time",\n           "It was alright, I liked the parts where the one actor that I liked showed up though.",\n           "I was really invested in this film",\n           "This was a net loss of brain cells, an absolutely baffling experience."]\n\nfor r in reviews:\n    sent, score = predict_sentiment(r)\n    print(f"Review: \'{r}\' -> {sent} ({score:.4f})")',
    10: 'import torch\nimport torch.nn as nn\nimport torch.optim as optim\nfrom torch.utils.data import Dataset, DataLoader\nimport numpy as np\nimport string\nimport random\n\ndevice = torch.device(\'cuda\' if torch.cuda.is_available() else \'cpu\')\n\ndef tokenize_text(text: str) -> list[str]:\n    standardized_text: str = text.casefold()\n    cleaned_text: str = ""\n    for i in range(len(text)):\n        if standardized_text[i] not in string.punctuation:\n            cleaned_text += standardized_text[i]\n\n    token_array: list[str] = cleaned_text.split()\n    return token_array\n\ndef make_vocab(tokenized_text: list[str]) -> dict[str, int]:\n    vocab: dict[str, int] = {"<pad>": 0, "<unk>": 1}\n    unique_words = sorted(list(set(tokenized_text)))\n\n    for word in unique_words:\n        if word not in vocab:\n            vocab[word] = len(vocab)\n\n    return vocab\n\nraw_text = """\nThe Data Science Mentorship Program follows a monthly subscription model in which students are required to make a payment of Rs. 799 per month. The total duration of the program is seven months, which makes the complete fee approximately Rs. 5600. The program is designed to cover all essential concepts required to build a strong foundation in data science. The curriculum includes Python fundamentals, Python libraries for data science, data analysis, SQL for data science, mathematics for machine learning, machine learning algorithms, practical machine learning, MLOps, and real-world case studies. A detailed syllabus is made available to students after successful registration.\nDeep Learning and Natural Language Processing are not included as part of this program’s curriculum. All live sessions are recorded, so if a student misses any session, they can watch the recording later through their dashboard. The month-by-month class schedule is shared with enrolled students via the student dashboard. Each live session is approximately two hours long, and the language of instruction is Hinglish. Students receive email notifications before every paid live session. The program is open to students from both technical and non-technical backgrounds. Learners can join the program at any time, even after it has already started. Once a student makes the payment, they receive access to all past lectures available on the dashboard. There is no requirement for task submission; solutions are provided so students can self-evaluate their performance. Case studies are an integral part of the program. For general queries, students are advised to contact the official program support team through the provided email after registration.\nAll monthly payments must be made on the official program website. The entire course fee cannot be paid in one installment, as the program strictly follows a monthly subscription model. Each subscription is valid for 30 days from the date of payment. For example, if a student pays on the 15th of January, the next payment will be due on the 15th of February. Students are eligible for a seven-day refund period from the date of payment in case they are not satisfied with the course. Students living outside India who are unable to complete the payment through the website must contact the support team via email for assistance with international payment options.\nStudents can view paid videos only while their subscription remains active. For example, if a student purchases a subscription on 21st January, they can access all paid sessions until 20th February. After this date, the subscription must be renewed to continue access. However, once the full fee of Rs. 5600 (or seven installments of Rs. 799) has been fully paid, students will be able to access all paid sessions until August 2024. Lifetime access is not provided due to the highly subsidized course fee.\nFor doubt resolution after sessions, students are required to fill out a Google Form available in their dashboard, after which the support team will arrange a one-on-one doubt clarification session. Even students who join the program late are allowed to ask doubts from previous weeks by selecting the appropriate option in the form. Students living outside India who face payment issues must again contact the support team via email for further assistance.\nTo receive a certificate, students must fulfill two conditions: they must complete all seven monthly payments amounting to Rs. 5600 and must attempt all course assessments. Students who join late will receive a dashboard link after paying for the current month to clear the remaining earlier months’ fees.\nPlacement assistance is included in the program, but it does not guarantee job placement or interview calls. Students should not join the program solely for placement expectations. The placement assistance includes portfolio-building sessions, soft skill development sessions, interactions with industry mentors, and guidance on job-hunting strategies.\n"""\n\ntokens = tokenize_text(raw_text)\nvocab = make_vocab(tokens)\nidx_to_word = {v: k for k, v in vocab.items()}\n\nsequence_length = 5\ninput_sequences = []\n\nfor i in range(len(tokens) - sequence_length):\n    seq_words = tokens[i : i + sequence_length]\n    seq_indices = [vocab[w] for w in seq_words]\n    input_sequences.append(seq_indices)\n\ndata_tensor = torch.tensor(input_sequences, dtype=torch.long)\n\nX = data_tensor[:, :-1]\ny = data_tensor[:, -1]\n\nclass FAQDataset(Dataset):\n    def __init__(self, X, y):\n        self.X = X\n        self.y = y\n    def __len__(self):\n        return len(self.X)\n    def __getitem__(self, idx):\n        return self.X[idx], self.y[idx]\n\ntrain_size = int(0.8 * len(X))\nval_size = len(X) - train_size\n\ndataset = FAQDataset(X, y)\ntrain_set, val_set = torch.utils.data.random_split(dataset, [train_size, val_size])\n\ntrain_loader = DataLoader(train_set, batch_size=32, shuffle=True)\nval_loader = DataLoader(val_set, batch_size=32, shuffle=False)\n\nclass NextWordLSTM(nn.Module):\n    def __init__(self, vocab_size, embed_dim, hidden_dim):\n        super(NextWordLSTM, self).__init__()\n        self.embedding = nn.Embedding(vocab_size, embed_dim, padding_idx=0)\n        self.lstm = nn.LSTM(embed_dim, hidden_dim, batch_first=True)\n        self.fc = nn.Linear(hidden_dim, vocab_size)\n\n    def forward(self, x):\n        embeds = self.embedding(x)\n        lstm_out, _ = self.lstm(embeds)\n        last_time_step = lstm_out[:, -1, :]\n        out = self.fc(last_time_step)\n        return out\n\nEMBED_DIM = 64\nHIDDEN_DIM = 100\nVOCAB_SIZE = len(vocab)\n\nmodel = NextWordLSTM(VOCAB_SIZE, EMBED_DIM, HIDDEN_DIM).to(device)\n\ncriterion = nn.CrossEntropyLoss()\noptimizer = optim.Adam(model.parameters(), lr=0.01)\n\nEPOCHS = 50\nbest_val_loss = float(\'inf\')\n\nfor epoch in range(EPOCHS):\n    model.train()\n    train_loss = 0\n\n    for inputs, targets in train_loader:\n        inputs, targets = inputs.to(device), targets.to(device)\n\n        optimizer.zero_grad()\n        output = model(inputs)\n        loss = criterion(output, targets)\n        loss.backward()\n        optimizer.step()\n\n        train_loss += loss.item()\n\n    model.eval()\n    val_loss = 0\n    with torch.no_grad():\n        for inputs, targets in val_loader:\n            inputs, targets = inputs.to(device), targets.to(device)\n            output = model(inputs)\n            loss = criterion(output, targets)\n            val_loss += loss.item()\n\n    train_loss /= len(train_loader)\n    val_loss /= len(val_loader)\n\n    if (epoch + 1) % 10 == 0:\n        print(f"Epoch {epoch+1}/{EPOCHS} | Train Loss: {train_loss:.4f} | Val Loss: {val_loss:.4f}")\n\n    if val_loss < best_val_loss:\n        best_val_loss = val_loss\n        torch.save(model.state_dict(), "best_faq_model.pth")\n\ndef predict_next_word(text_fragment, top_k=3):\n    model.eval()\n\n    fragment_tokens = tokenize_text(text_fragment)\n    input_indices = [vocab.get(w, vocab["<unk>"]) for w in fragment_tokens]\n\n    req_len = 4\n    if len(input_indices) < req_len:\n        input_indices = [0] * (req_len - len(input_indices)) + input_indices\n    else:\n        input_indices = input_indices[-req_len:]\n\n    input_tensor = torch.tensor([input_indices], dtype=torch.long).to(device)\n\n    with torch.no_grad():\n        output = model(input_tensor)\n        probabilities = torch.softmax(output, dim=1)\n        probs, indices = torch.topk(probabilities, top_k)\n\n    print(f"\\nInput: \'{text_fragment}\'")\n    print("Suggestions:")\n    for i in range(top_k):\n        idx = indices[0][i].item()\n        prob = probs[0][i].item()\n        word = idx_to_word.get(idx, "<unk>")\n        print(f"- {word} ({prob:.2%})")\n\nmodel.load_state_dict(torch.load("best_faq_model.pth"))\npredict_next_word("what is the")\npredict_next_word("can we pay")\npredict_next_word("what is the refund")\n\nimport torch\nimport torch.nn as nn\nimport torch.optim as optim\nfrom torch.utils.data import DataLoader\nfrom datasets import load_dataset\nfrom transformers import AutoTokenizer\nimport numpy as np\n\ndevice = torch.device(\'cuda\' if torch.cuda.is_available() else \'cpu\')\n\ntokenizer = AutoTokenizer.from_pretrained("bert-base-uncased")\n\ndef tokenize_function(examples):\n    return tokenizer(\n        examples["text"],\n        padding="max_length",\n        truncation=True,\n        max_length=200\n    )\n\ndataset = load_dataset("imdb")\n\ntokenized_datasets = dataset.map(tokenize_function, batched=True)\n\ntokenized_datasets = tokenized_datasets.remove_columns(["text"])\ntokenized_datasets = tokenized_datasets.rename_column("label", "labels")\ntokenized_datasets.set_format("torch")\n\ntrain_dataset = tokenized_datasets["train"]\ntest_dataset = tokenized_datasets["test"]\n\ntrain_loader = DataLoader(train_dataset, batch_size=64, shuffle=True)\ntest_loader = DataLoader(test_dataset, batch_size=64, shuffle=False)\n\nclass LSTMClassifier(nn.Module):\n    def __init__(self, vocab_size, embed_dim, hidden_dim, output_dim):\n        super(LSTMClassifier, self).__init__()\n        self.embedding = nn.Embedding(vocab_size, embed_dim, padding_idx=tokenizer.pad_token_id)\n        self.lstm = nn.LSTM(embed_dim, hidden_dim, batch_first=True, dropout=0.2)\n        self.fc = nn.Linear(hidden_dim, output_dim)\n        self.sigmoid = nn.Sigmoid()\n\n    def forward(self, input_ids):\n        embeds = self.embedding(input_ids)\n        lstm_out, (hidden, cell) = self.lstm(embeds)\n        final_hidden = hidden[-1]\n        return self.sigmoid(self.fc(final_hidden))\n\nVOCAB_SIZE = tokenizer.vocab_size\nEMBED_DIM = 64\nHIDDEN_DIM = 64\nOUTPUT_DIM = 1\n\nmodel = LSTMClassifier(VOCAB_SIZE, EMBED_DIM, HIDDEN_DIM, OUTPUT_DIM).to(device)\n\ncriterion = nn.BCELoss()\noptimizer = optim.Adam(model.parameters(), lr=0.001)\n\ndef binary_accuracy(preds, y):\n    rounded_preds = torch.round(preds)\n    correct = (rounded_preds == y).float()\n    acc = correct.sum() / len(correct)\n    return acc\n\nEPOCHS = 3\n\nfor epoch in range(EPOCHS):\n    model.train()\n    total_loss = 0\n    total_acc = 0\n\n    for batch in train_loader:\n        input_ids = batch[\'input_ids\'].to(device)\n        labels = batch[\'labels\'].float().to(device)\n\n        optimizer.zero_grad()\n        predictions = model(input_ids).squeeze(1)\n\n        loss = criterion(predictions, labels)\n        acc = binary_accuracy(predictions, labels)\n\n        loss.backward()\n        optimizer.step()\n\n        total_loss += loss.item()\n        total_acc += acc.item()\n\n    print(f"Epoch {epoch+1} | Loss: {total_loss/len(train_loader):.4f} | Acc: {total_acc/len(train_loader):.4f}")\n\nmodel.eval()\nval_acc = 0\nwith torch.no_grad():\n    for batch in test_loader:\n        input_ids = batch[\'input_ids\'].to(device)\n        labels = batch[\'labels\'].float().to(device)\n\n        predictions = model(input_ids).squeeze(1)\n        acc = binary_accuracy(predictions, labels)\n        val_acc += acc.item()\n\nprint(f"Final Validation Accuracy: {val_acc/len(test_loader):.4f}")\n\ndef predict_sentiment(text):\n    model.eval()\n    inputs = tokenizer(\n        text,\n        padding="max_length",\n        truncation=True,\n        max_length=200,\n        return_tensors="pt"\n    )\n\n    input_ids = inputs["input_ids"].to(device)\n\n    with torch.no_grad():\n        prediction = model(input_ids).item()\n\n    status = "Positive" if prediction > 0.5 else "Negative"\n    print(f"Review: \'{text}\'")\n    print(f"Sentiment: {status} (Score: {prediction:.4f})\\n")\n\nreviews = [\n    "The movie was absolutely fantastic and the acting was great",\n    "I hated this film it was a complete waste of time and money",\n    "It was okay not the best but certainly not the worst movie ever"\n]\n\nfor r in reviews:\n    predict_sentiment(r)',
    11: 'import os\nimport torch\nimport torch.nn as nn\nimport torch.optim as optim\nfrom torchvision import datasets, transforms\nfrom torch.utils.data import DataLoader\nfrom torchvision.utils import make_grid, save_image\nimport matplotlib.pyplot as plt\n\n\n# Device configuration\ndevice = torch.device("cuda" if torch.cuda.is_available() else "cpu")\n\n# Create output directory\nos.makedirs("synthetic_pack", exist_ok=True)\n\ntransform = transforms.Compose([\n    transforms.ToTensor(),\n    transforms.Normalize((0.5,), (0.5,))  # [-1, 1]\n])\n\ndataset = datasets.MNIST(\n    root="./data",\n    train=True,\n    transform=transform,\n    download=True\n)\n\nbatch_size = 128\ndataloader = DataLoader(dataset, batch_size=batch_size, shuffle=True)\n\nreal_batch = next(iter(dataloader))[0][:64]\ngrid = make_grid(real_batch, nrow=8, normalize=True)\nplt.imshow(grid.permute(1, 2, 0))\nplt.title("Real MNIST Samples")\nplt.axis("off")\nplt.show()\n\nclass Generator(nn.Module):\n    def __init__(self, nz=100):\n        super().__init__()\n        self.net = nn.Sequential(\n            nn.ConvTranspose2d(nz, 256, 7, 1, 0, bias=False),\n            nn.BatchNorm2d(256),\n            nn.ReLU(True),\n\n            nn.ConvTranspose2d(256, 128, 4, 2, 1, bias=False),\n            nn.BatchNorm2d(128),\n            nn.ReLU(True),\n\n            nn.ConvTranspose2d(128, 1, 4, 2, 1, bias=False),\n            nn.Tanh()\n        )\n\n    def forward(self, x):\n        return self.net(x)\n\nnz = 100\nG = Generator(nz).to(device)\nprint(G)\n\n\nz = torch.randn(8, nz, 1, 1).to(device)\nfake = G(z)\nprint(fake.shape)  # (8, 1, 28, 28)\n\nclass Discriminator(nn.Module):\n    def __init__(self):\n        super().__init__()\n        self.net = nn.Sequential(\n            nn.Conv2d(1, 64, 4, 2, 1, bias=False),\n            nn.LeakyReLU(0.2, inplace=True),\n\n            nn.Conv2d(64, 128, 4, 2, 1, bias=False),\n            nn.BatchNorm2d(128),\n            nn.LeakyReLU(0.2, inplace=True),\n\n            nn.Conv2d(128, 1, 7, 1, 0, bias=False),\n            nn.Sigmoid()\n        )\n\n    def forward(self, x):\n        return self.net(x).view(-1, 1)\n\n\nD = Discriminator().to(device)\nprint(D)\n\nD = Discriminator().to(device)\nprint(D)\n\nout = D(fake)\nprint(out.shape)  # (batch, 1)\n\ncriterion = nn.BCELoss()\nlr = 0.0002\n\noptimizerD = optim.Adam(D.parameters(), lr=lr, betas=(0.5, 0.999))\noptimizerG = optim.Adam(G.parameters(), lr=lr, betas=(0.5, 0.999))\n\nepochs = 30\nfixed_noise = torch.randn(64, nz, 1, 1).to(device)\n\nfor epoch in range(epochs):\n    for i, (real_imgs, _) in enumerate(dataloader):\n        real_imgs = real_imgs.to(device)\n        batch_size = real_imgs.size(0)\n\n        real_labels = torch.ones(batch_size, 1).to(device)\n        fake_labels = torch.zeros(batch_size, 1).to(device)\n\n        # ---- Train Discriminator ----\n        optimizerD.zero_grad()\n\n        real_loss = criterion(D(real_imgs), real_labels)\n\n        noise = torch.randn(batch_size, nz, 1, 1).to(device)\n        fake_imgs = G(noise)\n        fake_loss = criterion(D(fake_imgs.detach()), fake_labels)\n\n        lossD = real_loss + fake_loss\n        lossD.backward()\n        optimizerD.step()\n\n        # ---- Train Generator ----\n        optimizerG.zero_grad()\n\n        lossG = criterion(D(fake_imgs), real_labels)\n        lossG.backward()\n        optimizerG.step()\n\n        if i % 200 == 0:\n            print(f"Epoch [{epoch}/{epochs}] "\n                  f"Step [{i}/{len(dataloader)}] "\n                  f"LossD: {lossD.item():.4f} "\n                  f"LossG: {lossG.item():.4f}")\n\n    # ---- Save Epoch Snapshots ----\n    with torch.no_grad():\n        fake_samples = G(fixed_noise)\n        save_image(\n            fake_samples,\n            f"synthetic_pack/fake_epoch_{epoch}.png",\n            normalize=True,\n            nrow=8\n        )\n\n\n# ---- Save Final Grid ----\nwith torch.no_grad():\n    final_fake = G(fixed_noise)\n    save_image(\n        final_fake,\n        "synthetic_pack/final_grid.png",\n        normalize=True,\n        nrow=8\n    )\n\nprint("Final synthetic digit pack saved in synthetic_pack/")\n\n\ndef generate_digits(num_images=16):\n    noise = torch.randn(num_images, nz, 1, 1).to(device)\n    with torch.no_grad():\n        fake_imgs = G(noise)\n    grid = make_grid(fake_imgs, nrow=4, normalize=True)\n    plt.figure(figsize=(5,5))\n    plt.imshow(grid.permute(1, 2, 0).cpu()) # Added .cpu() here\n    plt.axis("off")\n    plt.show()\n\ngenerate_digits()',
}
