// Generated by Peggy 3.0.2.
//
// https://peggyjs.org/

"use strict";

function peg$subclass(child, parent) {
  function C() { this.constructor = child; }
  C.prototype = parent.prototype;
  child.prototype = new C();
}

function peg$SyntaxError(message, expected, found, location) {
  var self = Error.call(this, message);
  // istanbul ignore next Check is a necessary evil to support older environments
  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(self, peg$SyntaxError.prototype);
  }
  self.expected = expected;
  self.found = found;
  self.location = location;
  self.name = "SyntaxError";
  return self;
}

peg$subclass(peg$SyntaxError, Error);

function peg$padEnd(str, targetLength, padString) {
  padString = padString || " ";
  if (str.length > targetLength) { return str; }
  targetLength -= str.length;
  padString += padString.repeat(targetLength);
  return str + padString.slice(0, targetLength);
}

peg$SyntaxError.prototype.format = function(sources) {
  var str = "Error: " + this.message;
  if (this.location) {
    var src = null;
    var k;
    for (k = 0; k < sources.length; k++) {
      if (sources[k].source === this.location.source) {
        src = sources[k].text.split(/\r\n|\n|\r/g);
        break;
      }
    }
    var s = this.location.start;
    var offset_s = (this.location.source && (typeof this.location.source.offset === "function"))
      ? this.location.source.offset(s)
      : s;
    var loc = this.location.source + ":" + offset_s.line + ":" + offset_s.column;
    if (src) {
      var e = this.location.end;
      var filler = peg$padEnd("", offset_s.line.toString().length, ' ');
      var line = src[s.line - 1];
      var last = s.line === e.line ? e.column : line.length + 1;
      var hatLen = (last - s.column) || 1;
      str += "\n --> " + loc + "\n"
          + filler + " |\n"
          + offset_s.line + " | " + line + "\n"
          + filler + " | " + peg$padEnd("", s.column - 1, ' ')
          + peg$padEnd("", hatLen, "^");
    } else {
      str += "\n at " + loc;
    }
  }
  return str;
};

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
    literal: function(expectation) {
      return "\"" + literalEscape(expectation.text) + "\"";
    },

    class: function(expectation) {
      var escapedParts = expectation.parts.map(function(part) {
        return Array.isArray(part)
          ? classEscape(part[0]) + "-" + classEscape(part[1])
          : classEscape(part);
      });

      return "[" + (expectation.inverted ? "^" : "") + escapedParts.join("") + "]";
    },

    any: function() {
      return "any character";
    },

    end: function() {
      return "end of input";
    },

    other: function(expectation) {
      return expectation.description;
    }
  };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/"/g,  "\\\"")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, "\\\\")
      .replace(/\]/g, "\\]")
      .replace(/\^/g, "\\^")
      .replace(/-/g,  "\\-")
      .replace(/\0/g, "\\0")
      .replace(/\t/g, "\\t")
      .replace(/\n/g, "\\n")
      .replace(/\r/g, "\\r")
      .replace(/[\x00-\x0F]/g,          function(ch) { return "\\x0" + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return "\\x"  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = expected.map(describeExpectation);
    var i, j;

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== undefined ? options : {};

  var peg$FAILED = {};
  var peg$source = options.grammarSource;

  var peg$startRuleFunctions = { extract_from_clause: peg$parseextract_from_clause };
  var peg$startRuleFunction = peg$parseextract_from_clause;

  var peg$c0 = "(";
  var peg$c1 = ")";
  var peg$c2 = ",";
  var peg$c3 = "AS";
  var peg$c4 = "=";
  var peg$c5 = "!";
  var peg$c6 = ">=";
  var peg$c7 = ">";
  var peg$c8 = "<=";
  var peg$c9 = "<>";
  var peg$c10 = "<";
  var peg$c11 = "!=";
  var peg$c12 = "+";
  var peg$c13 = "-";
  var peg$c14 = "*";
  var peg$c15 = "/";
  var peg$c16 = "%";
  var peg$c17 = "`";
  var peg$c18 = "\"";
  var peg$c19 = "'";
  var peg$c20 = "\\'";
  var peg$c21 = "\\\"";
  var peg$c22 = "\\\\";
  var peg$c23 = "\\/";
  var peg$c24 = "\\b";
  var peg$c25 = "\\f";
  var peg$c26 = "\\n";
  var peg$c27 = "\\r";
  var peg$c28 = "\\t";
  var peg$c29 = "\\u";
  var peg$c30 = ".";
  var peg$c31 = "null";
  var peg$c32 = "not null";
  var peg$c33 = "unique";
  var peg$c34 = "primary key";
  var peg$c35 = "increment";
  var peg$c36 = "auto_increment";
  var peg$c37 = "default";
  var peg$c38 = "generated";
  var peg$c39 = "always";
  var peg$c40 = "by default";
  var peg$c41 = "by default on null";
  var peg$c42 = "identity";
  var peg$c43 = "start";
  var peg$c44 = "with";
  var peg$c45 = "minvalue";
  var peg$c46 = "no minvalue";
  var peg$c47 = "maxvalue";
  var peg$c48 = "no maxvalue";
  var peg$c49 = "owned by";
  var peg$c50 = "owned by none";
  var peg$c51 = "cache";
  var peg$c52 = "cycle";
  var peg$c53 = "no cycle";
  var peg$c54 = "check";
  var peg$c55 = "true";
  var peg$c56 = "false";
  var peg$c57 = "show";
  var peg$c58 = "drop";
  var peg$c59 = "select";
  var peg$c60 = "update";
  var peg$c61 = "create";
  var peg$c62 = "create table";
  var peg$c63 = "drop table";
  var peg$c64 = "drop view";
  var peg$c65 = "if not exists";
  var peg$c66 = "if exists";
  var peg$c67 = "delete";
  var peg$c68 = "insert";
  var peg$c69 = "replace";
  var peg$c70 = "explain";
  var peg$c71 = "alter";
  var peg$c72 = "add";
  var peg$c73 = "modify";
  var peg$c74 = "drop column";
  var peg$c75 = "into";
  var peg$c76 = "from";
  var peg$c77 = "set";
  var peg$c78 = "as";
  var peg$c79 = "table";
  var peg$c80 = "column";
  var peg$c81 = "on";
  var peg$c82 = "left";
  var peg$c83 = "inner";
  var peg$c84 = "join";
  var peg$c85 = "union";
  var peg$c86 = "values";
  var peg$c87 = "exists";
  var peg$c88 = "where";
  var peg$c89 = "group";
  var peg$c90 = "by";
  var peg$c91 = "order";
  var peg$c92 = "having";
  var peg$c93 = "limit";
  var peg$c94 = "asc";
  var peg$c95 = "desc";
  var peg$c96 = "all";
  var peg$c97 = "distinct";
  var peg$c98 = "duplicate";
  var peg$c99 = "between";
  var peg$c100 = "in";
  var peg$c101 = "is";
  var peg$c102 = "like";
  var peg$c103 = "contains";
  var peg$c104 = "key";
  var peg$c105 = "not";
  var peg$c106 = "and";
  var peg$c107 = "or";
  var peg$c108 = "count";
  var peg$c109 = "max";
  var peg$c110 = "min";
  var peg$c111 = "sum";
  var peg$c112 = "avg";
  var peg$c113 = "cast";
  var peg$c114 = "recursive";
  var peg$c115 = "foreign key";
  var peg$c116 = "references";
  var peg$c117 = "index";
  var peg$c118 = "cascade";
  var peg$c119 = "set null";
  var peg$c120 = "set default";
  var peg$c121 = "restrict";
  var peg$c122 = "no action";
  var peg$c123 = "type";
  var peg$c124 = "enum";
  var peg$c125 = "range";
  var peg$c126 = "[";
  var peg$c127 = "]";
  var peg$c128 = "{";
  var peg$c129 = "}";
  var peg$c130 = "--";
  var peg$c131 = "/*";
  var peg$c132 = "*/";
  var peg$c133 = ";";
  var peg$c134 = "current_user";
  var peg$c135 = "current_date";
  var peg$c136 = "current_time";
  var peg$c137 = "current_timestamp";
  var peg$c138 = "localtime";
  var peg$c139 = "localtimestamp";
  var peg$c140 = "session_user";
  var peg$c141 = "system_user";
  var peg$c142 = "user";
  var peg$c143 = "$";
  var peg$c144 = "return";
  var peg$c145 = ":=";

  var peg$r0 = /^[^)]/;
  var peg$r1 = /^[^`]/;
  var peg$r2 = /^[^"]/;
  var peg$r3 = /^[.]/;
  var peg$r4 = /^[A-Za-z_]/;
  var peg$r5 = /^[A-Za-z0-9_]/;
  var peg$r6 = /^[A-Za-z0-9_:[\]']/;
  var peg$r7 = /^[:@]/;
  var peg$r8 = /^[^'\\\0-\x1F\x7F]/;
  var peg$r9 = /^[^"\\\0-\x1F\x7F]/;
  var peg$r10 = /^[\n\r]/;
  var peg$r11 = /^[0-9]/;
  var peg$r12 = /^[1-9]/;
  var peg$r13 = /^[0-9a-fA-F]/;
  var peg$r14 = /^[eE]/;
  var peg$r15 = /^[+\-]/;
  var peg$r16 = /^[ \t\n\r]/;

  var peg$e0 = peg$literalExpectation("(", false);
  var peg$e1 = peg$literalExpectation(")", false);
  var peg$e2 = peg$anyExpectation();
  var peg$e3 = peg$literalExpectation(",", false);
  var peg$e4 = peg$literalExpectation("AS", false);
  var peg$e5 = peg$classExpectation([")"], true, false);
  var peg$e6 = peg$literalExpectation("=", false);
  var peg$e7 = peg$literalExpectation("!", false);
  var peg$e8 = peg$literalExpectation(">=", false);
  var peg$e9 = peg$literalExpectation(">", false);
  var peg$e10 = peg$literalExpectation("<=", false);
  var peg$e11 = peg$literalExpectation("<>", false);
  var peg$e12 = peg$literalExpectation("<", false);
  var peg$e13 = peg$literalExpectation("!=", false);
  var peg$e14 = peg$literalExpectation("+", false);
  var peg$e15 = peg$literalExpectation("-", false);
  var peg$e16 = peg$literalExpectation("*", false);
  var peg$e17 = peg$literalExpectation("/", false);
  var peg$e18 = peg$literalExpectation("%", false);
  var peg$e19 = peg$literalExpectation("`", false);
  var peg$e20 = peg$classExpectation(["`"], true, false);
  var peg$e21 = peg$classExpectation(["\""], true, false);
  var peg$e22 = peg$classExpectation(["."], false, false);
  var peg$e23 = peg$classExpectation([["A", "Z"], ["a", "z"], "_"], false, false);
  var peg$e24 = peg$classExpectation([["A", "Z"], ["a", "z"], ["0", "9"], "_"], false, false);
  var peg$e25 = peg$classExpectation([["A", "Z"], ["a", "z"], ["0", "9"], "_", ":", "[", "]", "'"], false, false);
  var peg$e26 = peg$classExpectation([":", "@"], false, false);
  var peg$e27 = peg$literalExpectation("\"", false);
  var peg$e28 = peg$literalExpectation("'", false);
  var peg$e29 = peg$classExpectation(["'", "\\", ["\0", "\x1F"], "\x7F"], true, false);
  var peg$e30 = peg$classExpectation(["\"", "\\", ["\0", "\x1F"], "\x7F"], true, false);
  var peg$e31 = peg$literalExpectation("\\'", false);
  var peg$e32 = peg$literalExpectation("\\\"", false);
  var peg$e33 = peg$literalExpectation("\\\\", false);
  var peg$e34 = peg$literalExpectation("\\/", false);
  var peg$e35 = peg$literalExpectation("\\b", false);
  var peg$e36 = peg$literalExpectation("\\f", false);
  var peg$e37 = peg$literalExpectation("\\n", false);
  var peg$e38 = peg$literalExpectation("\\r", false);
  var peg$e39 = peg$literalExpectation("\\t", false);
  var peg$e40 = peg$literalExpectation("\\u", false);
  var peg$e41 = peg$classExpectation(["\n", "\r"], false, false);
  var peg$e42 = peg$literalExpectation(".", false);
  var peg$e43 = peg$classExpectation([["0", "9"]], false, false);
  var peg$e44 = peg$classExpectation([["1", "9"]], false, false);
  var peg$e45 = peg$classExpectation([["0", "9"], ["a", "f"], ["A", "F"]], false, false);
  var peg$e46 = peg$classExpectation(["e", "E"], false, false);
  var peg$e47 = peg$classExpectation(["+", "-"], false, false);
  var peg$e48 = peg$literalExpectation("NULL", true);
  var peg$e49 = peg$literalExpectation("NOT NULL", true);
  var peg$e50 = peg$literalExpectation("UNIQUE", true);
  var peg$e51 = peg$literalExpectation("PRIMARY KEY", true);
  var peg$e52 = peg$literalExpectation("INCREMENT", true);
  var peg$e53 = peg$literalExpectation("AUTO_INCREMENT", true);
  var peg$e54 = peg$literalExpectation("DEFAULT", true);
  var peg$e55 = peg$literalExpectation("GENERATED", true);
  var peg$e56 = peg$literalExpectation("ALWAYS", true);
  var peg$e57 = peg$literalExpectation("BY DEFAULT", true);
  var peg$e58 = peg$literalExpectation("BY DEFAULT ON NULL", true);
  var peg$e59 = peg$literalExpectation("IDENTITY", true);
  var peg$e60 = peg$literalExpectation("START", true);
  var peg$e61 = peg$literalExpectation("WITH", true);
  var peg$e62 = peg$literalExpectation("MINVALUE", true);
  var peg$e63 = peg$literalExpectation("NO MINVALUE", true);
  var peg$e64 = peg$literalExpectation("MAXVALUE", true);
  var peg$e65 = peg$literalExpectation("NO MAXVALUE", true);
  var peg$e66 = peg$literalExpectation("OWNED BY", true);
  var peg$e67 = peg$literalExpectation("OWNED BY NONE", true);
  var peg$e68 = peg$literalExpectation("CACHE", true);
  var peg$e69 = peg$literalExpectation("CYCLE", true);
  var peg$e70 = peg$literalExpectation("NO CYCLE", true);
  var peg$e71 = peg$literalExpectation("CHECK", true);
  var peg$e72 = peg$literalExpectation("TRUE", true);
  var peg$e73 = peg$literalExpectation("FALSE", true);
  var peg$e74 = peg$literalExpectation("SHOW", true);
  var peg$e75 = peg$literalExpectation("DROP", true);
  var peg$e76 = peg$literalExpectation("SELECT", true);
  var peg$e77 = peg$literalExpectation("UPDATE", true);
  var peg$e78 = peg$literalExpectation("CREATE", true);
  var peg$e79 = peg$literalExpectation("CREATE TABLE", true);
  var peg$e80 = peg$literalExpectation("DROP TABLE", true);
  var peg$e81 = peg$literalExpectation("DROP VIEW", true);
  var peg$e82 = peg$literalExpectation("IF NOT EXISTS", true);
  var peg$e83 = peg$literalExpectation("IF EXISTS", true);
  var peg$e84 = peg$literalExpectation("DELETE", true);
  var peg$e85 = peg$literalExpectation("INSERT", true);
  var peg$e86 = peg$literalExpectation("REPLACE", true);
  var peg$e87 = peg$literalExpectation("EXPLAIN", true);
  var peg$e88 = peg$literalExpectation("ALTER", true);
  var peg$e89 = peg$literalExpectation("ADD", true);
  var peg$e90 = peg$literalExpectation("MODIFY", true);
  var peg$e91 = peg$literalExpectation("DROP COLUMN", true);
  var peg$e92 = peg$literalExpectation("INTO", true);
  var peg$e93 = peg$literalExpectation("FROM", true);
  var peg$e94 = peg$literalExpectation("SET", true);
  var peg$e95 = peg$literalExpectation("AS", true);
  var peg$e96 = peg$literalExpectation("TABLE", true);
  var peg$e97 = peg$literalExpectation("COLUMN", true);
  var peg$e98 = peg$literalExpectation("ON", true);
  var peg$e99 = peg$literalExpectation("LEFT", true);
  var peg$e100 = peg$literalExpectation("INNER", true);
  var peg$e101 = peg$literalExpectation("JOIN", true);
  var peg$e102 = peg$literalExpectation("UNION", true);
  var peg$e103 = peg$literalExpectation("VALUES", true);
  var peg$e104 = peg$literalExpectation("EXISTS", true);
  var peg$e105 = peg$literalExpectation("WHERE", true);
  var peg$e106 = peg$literalExpectation("GROUP", true);
  var peg$e107 = peg$literalExpectation("BY", true);
  var peg$e108 = peg$literalExpectation("ORDER", true);
  var peg$e109 = peg$literalExpectation("HAVING", true);
  var peg$e110 = peg$literalExpectation("LIMIT", true);
  var peg$e111 = peg$literalExpectation("ASC", true);
  var peg$e112 = peg$literalExpectation("DESC", true);
  var peg$e113 = peg$literalExpectation("ALL", true);
  var peg$e114 = peg$literalExpectation("DISTINCT", true);
  var peg$e115 = peg$literalExpectation("DUPLICATE", true);
  var peg$e116 = peg$literalExpectation("BETWEEN", true);
  var peg$e117 = peg$literalExpectation("IN", true);
  var peg$e118 = peg$literalExpectation("IS", true);
  var peg$e119 = peg$literalExpectation("LIKE", true);
  var peg$e120 = peg$literalExpectation("CONTAINS", true);
  var peg$e121 = peg$literalExpectation("KEY", true);
  var peg$e122 = peg$literalExpectation("NOT", true);
  var peg$e123 = peg$literalExpectation("AND", true);
  var peg$e124 = peg$literalExpectation("OR", true);
  var peg$e125 = peg$literalExpectation("COUNT", true);
  var peg$e126 = peg$literalExpectation("MAX", true);
  var peg$e127 = peg$literalExpectation("MIN", true);
  var peg$e128 = peg$literalExpectation("SUM", true);
  var peg$e129 = peg$literalExpectation("AVG", true);
  var peg$e130 = peg$literalExpectation("CAST", true);
  var peg$e131 = peg$literalExpectation("RECURSIVE", true);
  var peg$e132 = peg$literalExpectation("FOREIGN KEY", true);
  var peg$e133 = peg$literalExpectation("REFERENCES", true);
  var peg$e134 = peg$literalExpectation("INDEX", true);
  var peg$e135 = peg$literalExpectation("CASCADE", true);
  var peg$e136 = peg$literalExpectation("SET NULL", true);
  var peg$e137 = peg$literalExpectation("SET DEFAULT", true);
  var peg$e138 = peg$literalExpectation("RESTRICT", true);
  var peg$e139 = peg$literalExpectation("NO ACTION", true);
  var peg$e140 = peg$literalExpectation("TYPE", true);
  var peg$e141 = peg$literalExpectation("ENUM", true);
  var peg$e142 = peg$literalExpectation("RANGE", true);
  var peg$e143 = peg$literalExpectation("[", false);
  var peg$e144 = peg$literalExpectation("]", false);
  var peg$e145 = peg$literalExpectation("{", false);
  var peg$e146 = peg$literalExpectation("}", false);
  var peg$e147 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false);
  var peg$e148 = peg$literalExpectation("--", false);
  var peg$e149 = peg$literalExpectation("/*", false);
  var peg$e150 = peg$literalExpectation("*/", false);
  var peg$e151 = peg$literalExpectation(";", false);
  var peg$e152 = peg$literalExpectation("CURRENT_USER", true);
  var peg$e153 = peg$literalExpectation("CURRENT_DATE", true);
  var peg$e154 = peg$literalExpectation("CURRENT_TIME", true);
  var peg$e155 = peg$literalExpectation("CURRENT_TIMESTAMP", true);
  var peg$e156 = peg$literalExpectation("LOCALTIME", true);
  var peg$e157 = peg$literalExpectation("LOCALTIMESTAMP", true);
  var peg$e158 = peg$literalExpectation("SESSION_USER", true);
  var peg$e159 = peg$literalExpectation("SYSTEM_USER", true);
  var peg$e160 = peg$literalExpectation("USER", true);
  var peg$e161 = peg$literalExpectation("$", false);
  var peg$e162 = peg$literalExpectation("return", true);
  var peg$e163 = peg$literalExpectation(":=", false);

  var peg$f0 = function() { return true; };
  var peg$f1 = function(ast, tail) {
      return {
        ast   : ast,
        asts  : [ast].concat(tail.map(v => v[2].ast))
      } 
    };
  var peg$f2 = function(ast) {
      return {
        ast : ast  
      }
    };
  var peg$f3 = function(head, tail) {
      var cur = head;
      for (var i = 0; i < tail.length; i++) {
        cur._next = tail[i][3];
        cur = cur._next
      }
      return head; 
    };
  var peg$f4 = function(s) {
      return s[2];
    };
  var peg$f5 = function() { return text() };
  var peg$f6 = function(before, f, after) {
      return {
        before: before,
        from: f,
        after: after.join('')
      }
    };
  var peg$f7 = function(keyword, recursive, cteList) {
    return {
      type: "with",
      keyword: keyword,
      recursive: recursive,
      cteList: cteList,
    }
  };
  var peg$f8 = function(first, rest) {
    return [first].concat(rest)
  };
  var peg$f9 = function(cte) {
    return [cte]
  };
  var peg$f10 = function(name, args, query) {
      return {
        type: "cte",
        name: name,
        arguments: args || [],
        query: query
      };
    };
  var peg$f11 = function(args) {
      return args;
    };
  var peg$f12 = function(first, rest) {
      return [first].concat(rest);
    };
  var peg$f13 = function(identifier) {
      return [identifier];
    };
  var peg$f14 = function(with_clause, val, d, c, f, w, g, o, l) {
      return {
        type      : 'select',
        keyword   : val,
        with      : with_clause,
        distinct  : d,
        columns   : c,
        from      : f,
        where     : w,
        groupby   : g,
        orderby   : o,
        limit     : l,
        location  : location()
      }
  };
  var peg$f15 = function(val) {
    return { type: 'keyword', value: val && val[0], location: location() }
  };
  var peg$f16 = function() {
      return { type: 'star', value: '*' };
    };
  var peg$f17 = function(head, tail) {
      return createList(head, tail);
    };
  var peg$f18 = function(e, alias) { 
      return {
        type: 'column_list_item',
        expr : e, 
        as : alias,
        location: location()
      }; 
    };
  var peg$f19 = function(i) { return i; };
  var peg$f20 = function(k, l) {
      return {
        type: 'from',
        keyword: k,
        tables: l,
        location: location()
      }
  };
  var peg$f21 = function(val) {
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$f22 = function(head, tail) {
      tail.unshift(head);
      return tail;
    };
  var peg$f23 = function(t) { return t; };
  var peg$f24 = function(t) { return t; };
  var peg$f25 = function(op, t, expr) {
    t.join = op;
    t.on   = expr;
    return t;
    /*
      return  {
        db    : t.db,
        table : t.table,
        as    : t.as,
        join  : op,
        on    : expr
      }
    */
    };
  var peg$f26 = function(cat, db, t, alias) {
      if (t && t.type == 'var') {
        t.as = alias;
        return t;
      } else {
        return  {
          type: 'table',
          catalog: cat,
          db    : db,
          table : t,
          as    : alias,
          location: location()
        }
      }
    };
  var peg$f27 = function(db, t, alias) {
      if (t && t.type == 'var') {
        t.as = alias;
        return t;
      } else {
        return  {
          type: 'table',
          catalog: '',
          db    : db,
          table : t,
          as    : alias,
          location: location()
        }
      }
    };
  var peg$f28 = function(t, alias) {
      if (t && t.type == 'var') {
        t.as = alias;
        return t;
      } else {
        return  {
          type: 'table',
          catalog: '',
          db    : '',
          table : t,
          as    : alias,
          location: location()
        }
      }
    };
  var peg$f29 = function(s, alias) {
      return  { type: 'subquery', subquery: s, as: alias, location: location() };
    };
  var peg$f30 = function(table, alias) {
      return  { type: 'subquery', subquery: table, as: alias, location: location() };
    };
  var peg$f31 = function() {return text()};
  var peg$f32 = function(text, alias) {
      return  { type: 'incomplete_subquery', text: text.join(''), as: alias, location: location() };
    };
  var peg$f33 = function() { return 'LEFT JOIN'; };
  var peg$f34 = function() { return 'INNER JOIN'; };
  var peg$f35 = function(cat) {
    return cat;
  };
  var peg$f36 = function(db) {
    return db;
  };
  var peg$f37 = function(table) {
      return table;
    };
  var peg$f38 = function(v) {
      return v.name;
    };
  var peg$f39 = function(e) { return e; };
  var peg$f40 = function(k, e) {
      return {
        type: 'where',
        keyword: k,
        expression: e,
        location: location()
      }
    };
  var peg$f41 = function(val) {
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$f42 = function(l) { return l; };
  var peg$f43 = function(head, tail) {
      return createList(head, tail);
    };
  var peg$f44 = function(e) { return e; };
  var peg$f45 = function(l) { return l; };
  var peg$f46 = function(head, tail) {
      return createList(head, tail);
    };
  var peg$f47 = function(e, d) {
    var obj = {
      expr : e,
      type : 'ASC'
    }
    if (d == 'DESC') {
      obj.type = 'DESC';
    }
    return obj;
  };
  var peg$f48 = function(i1, tail) {
      var res = [i1];
      if (tail === null) {
        res.unshift({
          type  : 'number',
          value : 0
        });  
      } else {
        res.push(tail[2]);
      }
      return res;
    };
  var peg$f49 = function(with_clause, db, t, l, w) {
      return {
        type  : 'update',
        with: with_clause,
        db    : db,
        table : t,
        set   : l,
        where : w
      }
    };
  var peg$f50 = function(with_clause, t, l, w) {
      return {
        type  : 'update',
        with: with_clause,
        db    : '',
        table : t,
        set   : l,
        where : w
      }
    };
  var peg$f51 = function(with_clause, t, j, l, w) {
      return {
        type  : 'update',
        with: with_clause,
        db    : '',
        table : t,
        join  : j,
        set   : l,
        where : w
      }
    };
  var peg$f52 = function(head, tail) {
      return createList(head, tail);
    };
  var peg$f53 = function(c, v) {
      return {
        column: c,
        value : v
      }
    };
  var peg$f54 = function(t, c, v) {
      return {
        table: t,
        column: c,
        value : v
      }
    };
  var peg$f55 = function() {error('EXPECTED COLUMN NAME')};
  var peg$f56 = function(with_clause, ri, db, t, c, v) {
      return {
        type      : ri,
        with: with_clause,
        db        : db,
        table     : t,
        columns   : c,
        values    : v
      }
    };
  var peg$f57 = function(with_clause, ri, db, t, l, u) {
      var v = {
        type  : ri,
        with: with_clause,
        db    : db,
        table : t,
        set   : l
      };

      if (u) {
        v.duplicateSet = u;
      }

      return v;
    };
  var peg$f58 = function(with_clause, ri, t, c, v) {
      return {
        type      : ri,
        with: with_clause,
        db        : '',
        table     : t,
        columns   : c,
        values    : v
      }
    };
  var peg$f59 = function(with_clause, ri, t, l, u) {
      var v = {
        type  : ri,
        with: with_clause,
        db    : '',
        table : t,
        set   : l
      }

      if (u) {
        v.duplicateSet = u;
      }

      return v;
    };
  var peg$f60 = function(c) {error('EXPECTED COLUMN NAME')};
  var peg$f61 = function(c) {
    return c
  };
  var peg$f62 = function() { return 'insert'; };
  var peg$f63 = function() { return 'replace' };
  var peg$f64 = function(l) {
    return {
      type: 'values',
      values: l
    };
  };
  var peg$f65 = function(l) {
    return l;
  };
  var peg$f66 = function(head, tail) {
    var l = createExprList(head, tail);
    return l;
  };
  var peg$f67 = function(head, tail) {
      var el = {
        type : 'expr_list'  
      }
      var l = createExprList(head, tail, el); 

      el.value = l;
      return el;
    };
  var peg$f68 = function() {
      return { 
        type  : 'expr_list',
        value : []
      }
    };
  var peg$f69 = function(head, tail) {
      return createBinaryExprChain(head, tail);
    };
  var peg$f70 = function(head, tail) {
      return createBinaryExprChain(head, tail);
    };
  var peg$f71 = function(expr) {
      return createUnaryExpr('NOT', expr);
    };
  var peg$f72 = function(left, rh) {
      if (rh === null) {
        return left;  
      } else {
        var res = null;
        if (rh !== null && rh.type == 'arithmetic') {
          res = createBinaryExprChain(left, rh.tail);
        } else {
          res = createBinaryExpr(rh && rh.op, left, rh && rh.right);
        }
        return res;
      }
    };
  var peg$f73 = function(l) {
      return {
        type : 'arithmetic',
        tail : l
      }
    };
  var peg$f74 = function(op, begin, end) {
    return {
      op: op,
      right: {
        type: 'expr_list',
        value: [begin, end]
      }
    }
  };
  var peg$f75 = function(op, not, right) {
    return {
      op    : op,
      right : ((not || '') + ' ' + right[0]).trim()
    }
  };
  var peg$f76 = function(op, right) {
    return {
      op    : op,
      right : right
    }
  };
  var peg$f77 = function(nk) { return nk[0] + ' ' + nk[2]; };
  var peg$f78 = function(nk) { return nk[0] + ' ' + nk[2]; };
  var peg$f79 = function(nk) { return nk[0] + ' ' + nk[2]; };
  var peg$f80 = function(op, right) {
      return {
        op    : op,
        right : right
      }
    };
  var peg$f81 = function(op, l) {
      return {
        op    : op,
        right : l
      }
    };
  var peg$f82 = function(op, l) {
    return {
        op    : op,
        right : l
      }
    };
  var peg$f83 = function(op, e) {
      return {
        op    : op,  
        right : e
      }
    };
  var peg$f84 = function(op, l) {
      return {
        op    : op,  
        right : l
      }
    };
  var peg$f85 = function(op, e) {
      return {
        op    : op,  
        right : e
      }
    };
  var peg$f86 = function(head, tail) {
      return createBinaryExprChain(head, tail);
    };
  var peg$f87 = function(head, tail) {
      return createBinaryExprChain(head, tail)
    };
  var peg$f88 = function(e) { 
      e.paren = true; 
      return e; 
    };
  var peg$f89 = function(tbl, col) {
      return {
        type  : 'column_ref',
        table : tbl, 
        column : col,
        location: location()
      }; 
    };
  var peg$f90 = function(col) {
      return {
        type  : 'column_ref',
        table : '', 
        column: col,
        location: location()
      };
    };
  var peg$f91 = function(head, tail) {
      return createList(head, tail);
    };
  var peg$f92 = function(name) { return reservedMap[name.toUpperCase()] === true; };
  var peg$f93 = function(name) {
    return name;
  };
  var peg$f94 = function(chars) {
    return chars.join('');
  };
  var peg$f95 = function(chars) {
    return chars.join('');
  };
  var peg$f96 = function(name) { return reservedMap[name.toUpperCase()] === true; };
  var peg$f97 = function(name) {
    return name;
  };
  var peg$f98 = function() {
    return text();
  };
  var peg$f99 = function(name) {
    return name;
  };
  var peg$f100 = function(col) {
    return {
      type: 'column',
      value: col,
      location: location()
    };
  };
  var peg$f101 = function() {
     return text();
  };
  var peg$f102 = function(start, parts) { return start + parts.join(''); };
  var peg$f103 = function(l) {
    var p = {
      type : 'param',
      value: l[1]
    } 
    return p;
  };
  var peg$f104 = function(name, e) {
      return {
        type : 'aggr_func',
        name : name,
        args : {
          expr : e  
        },
        location: location()
      }   
    };
  var peg$f105 = function(name, arg) {
      return {
        type : 'aggr_func',
        name : name,
        args : arg,
        location: location()
      }   
    };
  var peg$f106 = function(e) {
      return {
        expr  : e 
      }
    };
  var peg$f107 = function(d, c) {
      return {
        distinct : d, 
        expr   : c
      }
    };
  var peg$f108 = function() {
      return {
        type  : 'star',
        value : '*'
      }
    };
  var peg$f109 = function(name, l) {
      return {
        type : 'function',
        name : name, 
        args : l
      }
    };
  var peg$f110 = function(keyword, e, datatype) {
    return {
      type: 'cast_function',
      keyword: keyword,
      datatype: datatype,
      expr: e
    }
  };
  var peg$f111 = function(l) {
    return l
  };
  var peg$f112 = function(head, tail) {
      return createList(head, tail); 
    };
  var peg$f113 = function() {
      return {
        type     : 'null',
        value    : null,
        location : location()
      };  
    };
  var peg$f114 = function() { 
      return {
        type     : 'bool',
        value    : true,
        location : location()
      };  
    };
  var peg$f115 = function() { 
      return {
        type     : 'bool',
        value    : false,
        location : location()
      };  
    };
  var peg$f116 = function(ca) {
      return {
        type     : 'string',
        value    : ca[1].join(''),
        location : location()
      }
    };
  var peg$f117 = function() { return "'";  };
  var peg$f118 = function() { return '"';  };
  var peg$f119 = function() { return "\\"; };
  var peg$f120 = function() { return "/";  };
  var peg$f121 = function() { return "\b"; };
  var peg$f122 = function() { return "\f"; };
  var peg$f123 = function() { return "\n"; };
  var peg$f124 = function() { return "\r"; };
  var peg$f125 = function() { return "\t"; };
  var peg$f126 = function(h1, h2, h3, h4) {
      return String.fromCharCode(parseInt("0x" + h1 + h2 + h3 + h4));
    };
  var peg$f127 = function(n) {
      return {
        type    : 'number',
        value   : n,
        location: location() 
      }  
    };
  var peg$f128 = function(int_, frac, exp) { return parseFloat(int_ + frac + exp); };
  var peg$f129 = function(int_, frac) { return parseFloat(int_ + frac);       };
  var peg$f130 = function(int_, exp) { return parseFloat(int_ + exp);        };
  var peg$f131 = function(int_) { return parseFloat(int_);              };
  var peg$f132 = function(digit19, digits) { return digit19 + digits;       };
  var peg$f133 = function(op, digit19, digits) { return "-" + digit19 + digits; };
  var peg$f134 = function(op, digit) { return "-" + digit;            };
  var peg$f135 = function(digits) { return "." + digits; };
  var peg$f136 = function(e, digits) { return e + digits; };
  var peg$f137 = function(digits) { return digits.join(""); };
  var peg$f138 = function(e, sign) { return e + (sign || ''); };
  var peg$f139 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f140 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f141 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f142 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f143 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f144 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f145 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f146 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f147 = function() { return 'ASC';      };
  var peg$f148 = function() { return 'DESC';     };
  var peg$f149 = function() { return 'ALL';      };
  var peg$f150 = function() { return 'DISTINCT'; };
  var peg$f151 = function() { return 'DUPLICATE';};
  var peg$f152 = function() { return 'BETWEEN';  };
  var peg$f153 = function() { return 'IN';       };
  var peg$f154 = function() { return 'IS';       };
  var peg$f155 = function() { return 'LIKE';     };
  var peg$f156 = function() { return 'CONTAINS'; };
  var peg$f157 = function() { return 'KEY';      };
  var peg$f158 = function() { return 'NOT';      };
  var peg$f159 = function() { return 'AND';      };
  var peg$f160 = function() { return 'OR';       };
  var peg$f161 = function() { return 'COUNT';    };
  var peg$f162 = function() { return 'MAX';      };
  var peg$f163 = function() { return 'MIN';      };
  var peg$f164 = function() { return 'SUM';      };
  var peg$f165 = function() { return 'AVG';      };
  var peg$f166 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f167 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f168 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f169 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f170 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f171 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f172 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f173 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f174 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f175 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f176 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f177 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f178 = function(val) { return makeKeywordNode(val, location()) };
  var peg$f179 = function() { return true; };
  var peg$f180 = function(s) {
      return {
        stmt : s,
      }
    };
  var peg$f181 = function(va, e) {
    return {
      type : 'assign',
      left : va,
      right: e
    }
  };
  var peg$f182 = function(e) {
  return {
    type : 'return',
    expr: e
  }
};
  var peg$f183 = function(head, tail) {
      return createBinaryExprChain(head, tail);
    };
  var peg$f184 = function(head, tail) {
      return createBinaryExprChain(head, tail);
    };
  var peg$f185 = function(lt, op, rt, expr) {
      return {
        type    : 'join',
        ltable  : lt, 
        rtable  : rt,
        op      : op,
        on      : expr
      }
    };
  var peg$f186 = function(e) { 
      e.paren = true; 
      return e; 
    };
  var peg$f187 = function(name, l) {
      //compatible with original func_call
      return {
        type : 'function',
        name : name, 
        args : {
          type  : 'expr_list',
          value : l
        },
        location: location(),
      }
    };
  var peg$f188 = function(value) {
      return {
        type : 'special_system_function',
        name : value,
        location: location(),
      }
    };
  var peg$f189 = function(head, tail) {
      return createList(head, tail);
    };
  var peg$f190 = function(l) {
    return {
      type : 'array',
      value : l
    }
  };
  var peg$f191 = function(name, m) {
    return {
      type : 'var',
      name : name,
      members : m,
      location: location()
    }
  };
  var peg$f192 = function(name, m) {
    return {
      type : 'var_pg_promise',
      name : name,
      members : m,
      location: location()
    }
  };
  var peg$f193 = function(l) {
    var s = [];
    for (var i = 0; i < l.length; i++) {
      s.push(l[i][1]); 
    }
    return s;
  };
  var peg$f194 = function(with_clause, val, t, w) {
      return {
        type    : 'delete',
        with    : with_clause,
        table   : t,
        where   : w
      }
    };
  var peg$f195 = function(db, t) {
      return  {
        type: 'table',
        db    : db,
        table : t,
        location: location()
      }
    };
  var peg$f196 = function(t) {
      return  {
        type: 'table',
        db    : '',
        table : t,
        location: location()
      }
    };
  var peg$f197 = function(keyword, if_exists_keyword, table) {
      return {
        type: 'drop_table',
        keyword: keyword,
        if_exists: if_exists_keyword,
        table: table
      }
    };
  var peg$f198 = function(keyword, table) {
      return {
        type: 'drop_table',
        keyword: keyword,
        if_exists: null,
        table: table
      }
    };
  var peg$f199 = function(val) {
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$f200 = function(keyword, table, as, select) {
      return {
        type: 'create_table',
        keyword: keyword,
        if_not_exists: null,
        column_definitions: [],
        select: select,
        location: location(),
      }
    };
  var peg$f201 = function(keyword, if_not_exists_keyword, table, fields) {
      return {
        type: 'create_table',
        keyword: keyword,
        if_not_exists: if_not_exists_keyword,
        column_definitions: fields,
        select: null,
        location: location(),
      }
    };
  var peg$f202 = function(keyword, table, fields) {
      return {
        type: 'create_table',
        if_not_exists: null,
        keyword: keyword,
        column_definitions: fields,
        select: null,
        location: location(),
      }
    };
  var peg$f203 = function(val) {
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$f204 = function(val) {
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$f205 = function(head, tail) {
  return createList(head, tail);
};
  var peg$f206 = function(name, type, constraints) {
    return {
      type: 'field',
      name: name,
      data_type: type,
      constraints: constraints,
      location: location()
    }
  };
  var peg$f207 = function(name, type) {
    return {
      type: 'field',
      name: name,
      data_type: type,
      constraints: [],
      location: location()
    }
  };
  var peg$f208 = function(k1, col_head, col_tail, k2, ref_table, ref_col_head, ref_col_tail, on) {
    return {
      type: 'foreign_key',
      foreign_keyword: k1,
      columns: createList(col_head, col_tail),
      references_keyword: k2,
      references_table: ref_table,
      references_columns: createList(ref_col_head, ref_col_tail),
      on: on,
      location: location()
    }
  };
  var peg$f209 = function(on, trigger, action) {
    return {
      type: 'foreign_key_on',
      on_keyword: on,
      trigger: trigger,
      action: action,
      location: location()
    }
  };
  var peg$f210 = function(k, col_head, col_tail) {
    return {
      type: 'primary_key',
      keyword: k,
      columns: createList(col_head, col_tail),
      location: location()
    }
  };
  var peg$f211 = function(name, args_head, args_tail) {
    return {
      type: 'field_data_type',
      name: name,
      args: createList(args_head, args_tail),
      location: location()
    }
  };
  var peg$f212 = function(name) {
    return {
      type: 'field_data_type',
      name: name,
      args: [],
      location: location()
    }
  };
  var peg$f213 = function(head, tail) {
    return createList(head, tail, 1);
  };
  var peg$f214 = function(k) {
  return { type: 'constraint_not_null', keyword: k, location: location() }
};
  var peg$f215 = function(k) {
  return { type: 'keyword', value: k && k[0], location: location() }
};
  var peg$f216 = function(k) {
  return { type: 'constraint_primary_key', keyword: k, location: location() }
};
  var peg$f217 = function(k) {
  return { type: 'keyword', value: k && k[0], location: location() }
};
  var peg$f218 = function(k) {
  return { type: 'constraint_unique', keyword: k, location: location() }
};
  var peg$f219 = function(k) {
  return { type: 'keyword', value: k && k[0], location: location() }
};
  var peg$f220 = function(k) {
  return { type: 'constraint_auto_increment', keyword: k, location: location() }
};
  var peg$f221 = function(k) {
  return { type: 'keyword', value: k && k[0], location: location() }
};
  var peg$f222 = function(g, opt, data, seq) {
    return { type: 'constraint_generated', option: opt, data_type: data, sequence_options: seq }
};
  var peg$f223 = function(k) {
  return { type: 'constraint_generated_option', option: 'ALWAYS', keyword: k }
};
  var peg$f224 = function(k) {
  return { type: 'constraint_generated_option', option: 'BY_DEFAULT', keyword: k }
};
  var peg$f225 = function(k) {
  return { type: 'constraint_generated_option', option: 'BY_DEFAULT_ON_NULL', keyword: k }
};
  var peg$f226 = function(k, value) {
      return { type: 'constraint_default', keyword: k, value: value, location: location() }
};
  var peg$f227 = function(k) {
  return { type: 'keyword', value: k && k[0], location: location() }
};
  var peg$f228 = function(k) {
  return { type: 'keyword', value: k && k[0], location: location() }
};
  var peg$f229 = function(k) {
  return { type: 'keyword', value: k && k[0], location: location() }
};
  var peg$f230 = function(val) {
  return { type: 'sequence_option_data_type', value: val, location: location() }
};
  var peg$f231 = function(s) {
  return s[2]
};
  var peg$f232 = function(head, tail) {
    return createList(head, tail, 1);
  };
  var peg$f233 = function(val) {
  return { type: 'sequence_option_increment', value: val, location: location() }
};
  var peg$f234 = function(val) {
  return { type: 'sequence_option_increment', value: val, location: location() }
};
  var peg$f235 = function(val) {
  return { type: 'sequence_option_maxvalue', value: val, location: location() }
};
  var peg$f236 = function(val) {
  return { type: 'sequence_option_maxvalue', value: val, location: location() }
};
  var peg$f237 = function() {
  return { type: 'sequence_option_no_maxvalue', location: location() }
};
  var peg$f238 = function() {
  return { type: 'sequence_option_no_minvalue', location: location() }
};
  var peg$f239 = function(val) {
  return { type: 'sequence_option_cache', value: val, location: location() }
};
  var peg$f240 = function() {
  return { type: 'sequence_option_cycle', location: location() }
};
  var peg$f241 = function() {
  return { type: 'sequence_option_no_cycle', location: location() }
};
  var peg$f242 = function(val) {
  return { type: 'sequence_option_owned_by', value: val, location: location() }
};
  var peg$f243 = function() {
  return { type: 'sequence_option_owned_by_none', location: location() }
};
  var peg$f244 = function(keyword, table, command) {
      return {
        type: 'alter_table',
        keyword: keyword,
        table: table,
        command: command
      }
    };
  var peg$f245 = function(val) {
    return {
      type: 'keyword',
      value: (val || []).map((v) => (v && v[0]) || [], []).join(''),
      location: location()
    }
  };
  var peg$f246 = function(keyword, field) {
      return {
        type: 'alter_table_add_column',
        keyword: keyword,
        field: field,
        location: location()
      }
    };
  var peg$f247 = function(val) {
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$f248 = function(keyword) {error('EXPECTED COLUMN NAME')};
  var peg$f249 = function(keyword, column) {
      return {
        type: 'alter_table_drop_column',
        keyword: keyword,
        column: column,
        location: location()
      }
    };
  var peg$f250 = function(val) {
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$f251 = function(keyword) {error('EXPECTED COLUMN NAME')};
  var peg$f252 = function(keyword, field) {
      return {
        type: 'alter_table_modify_column',
        keyword: keyword,
        field: field,
        location: location()
      }
    };
  var peg$f253 = function(val) {
    return {
      type: 'keyword',
      value: (val || []).map((v) => (v && v[0]) || [], []).join(''),
      location: location()
    }
  };
  var peg$f254 = function(val) {
    const ary = val || []
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$f255 = function(val) {
    return {
      type: 'keyword',
      value: (val || []).map((v) => (v && v[0]) || [], []).join(''),
      location: location()
    }
  };
  var peg$f256 = function(kw_create, kw_index, kw_if_not_exists, name, kw_on, table, columns) {
    return {
      type: 'create_index',
      create_keyword: kw_create,
      index_keyword: kw_index,
      if_not_exists_keyword: kw_if_not_exists,
      if_not_exists: !!kw_if_not_exists,
      name: name,
      on_keyword: kw_on,
      table: table,
      columns: columns,
      location: location()
    }
  };
  var peg$f257 = function(kw_create, kw_type, name, kw_as, fields) {
    return {
      type: 'create_type',
      type_variant: 'composite_type',
      create_keyword: kw_create,
      type_keyword: kw_type,
      name: name,
      as_keyword: kw_as,
      fields: fields,
      location: location()
    }
  };
  var peg$f258 = function(name, type) {
    return {
      type: 'composite_type_field',
      name: name,
      data_type: type,
      location: location()
    }
  };
  var peg$f259 = function(head, tail) {
    return createList(head, tail);
  };
  var peg$f260 = function(kw_create, kw_type, name, kw_as, kw_enum, values) {
    return {
      type: 'create_type',
      type_variant: 'enum_type',
      create_keyword: kw_create,
      type_keyword: kw_type,
      name: name,
      as_keyword: kw_as,
      enum_keyword: kw_enum,
      values: values,
      location: location()
    }
  };
  var peg$f261 = function(head, tail) {
    return createList(head, tail);
  };
  var peg$f262 = function(kw_create, kw_type, name, kw_as, kw_range, values) {
    return {
      type: 'create_type',
      type_variant: 'range_type',
      create_keyword: kw_create,
      type_keyword: kw_type,
      name: name,
      as_keyword: kw_as,
      range_keyword: kw_range,
      values: values,
      location: location()
    }
  };
  var peg$f263 = function(name, val) {
    if (val.type === 'number') {
      val = val.value
    }
    return {
      type: 'assign_value_expr',
      name: name,
      value: val,
      location: location()
    }
  };
  var peg$f264 = function(name) {
    return {
      type: 'assign_value_expr',
      name: name,
      value: true,
      location: location()
    }
  };
  var peg$f265 = function(head, tail) {
    return createList(head, tail);
  };
  var peg$f266 = function(kw_create, kw_type, name, values) {
    return {
      type: 'create_type',
      type_variant: 'base_type',
      create_keyword: kw_create,
      type_keyword: kw_type,
      name: name,
      values: (values && values[2]) || [],
      location: location()
    }
  };
  var peg$f267 = function(kw_drop, kw_type, kw_if_exists, names, dependency_action) {
    return {
      type: 'drop_type',
      drop_keyword: kw_drop,
      type_keyword: kw_type,
      names: names,
      if_exists: kw_if_exists || null,
      dependency_action: dependency_action || null,
      location: location()
    }
  };
  var peg$f268 = function(keyword, if_exists_keyword, views, dependency_action) {
      return {
        type: 'drop_view',
        keyword: keyword,
        if_exists: if_exists_keyword || null,
        views: views,
        dependency_action: dependency_action || null,
      }
    };
  var peg$f269 = function(head, tail) {
      return createList(head, tail);
    };
  var peg$f270 = function(view) {
      return  {
        type: 'view',
        value  : view,
      }
    };
  var peg$f271 = function(val) {
    return {
      type: 'keyword',
      value: val && val[0],
      location: location()
    }
  };
  var peg$currPos = 0;
  var peg$savedPos = 0;
  var peg$posDetailsCache = [{ line: 1, column: 1 }];
  var peg$maxFailPos = 0;
  var peg$maxFailExpected = [];
  var peg$silentFails = 0;

  var peg$result;

  if ("startRule" in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function offset() {
    return peg$savedPos;
  }

  function range() {
    return {
      source: peg$source,
      start: peg$savedPos,
      end: peg$currPos
    };
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== undefined
      ? location
      : peg$computeLocation(peg$savedPos, peg$currPos);

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos];
    var p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;

      return details;
    }
  }

  function peg$computeLocation(startPos, endPos, offset) {
    var startPosDetails = peg$computePosDetails(startPos);
    var endPosDetails = peg$computePosDetails(endPos);

    var res = {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column
      }
    };
    if (offset && peg$source && (typeof peg$source.offset === "function")) {
      res.start = peg$source.offset(res.start);
      res.end = peg$source.offset(res.end);
    }
    return res;
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parsestart() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    peg$savedPos = peg$currPos;
    s1 = peg$f0();
    if (s1) {
      s1 = undefined;
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseast();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = [];
        s6 = peg$currPos;
        s7 = peg$parseEOSQL();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parsestart();
          if (s9 !== peg$FAILED) {
            s7 = [s7, s8, s9];
            s6 = s7;
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
        } else {
          peg$currPos = s6;
          s6 = peg$FAILED;
        }
        if (s6 === peg$FAILED) {
          s6 = peg$parseEOSQL();
        }
        while (s6 !== peg$FAILED) {
          s5.push(s6);
          s6 = peg$currPos;
          s7 = peg$parseEOSQL();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parsestart();
            if (s9 !== peg$FAILED) {
              s7 = [s7, s8, s9];
              s6 = s7;
            } else {
              peg$currPos = s6;
              s6 = peg$FAILED;
            }
          } else {
            peg$currPos = s6;
            s6 = peg$FAILED;
          }
          if (s6 === peg$FAILED) {
            s6 = peg$parseEOSQL();
          }
        }
        peg$savedPos = s0;
        s0 = peg$f1(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseproc_stmts();
      peg$savedPos = s0;
      s1 = peg$f2(s1);
      s0 = s1;
    }

    return s0;
  }

  function peg$parseast() {
    var s0;

    s0 = peg$parseunion_stmt();
    if (s0 === peg$FAILED) {
      s0 = peg$parseupdate_stmt();
      if (s0 === peg$FAILED) {
        s0 = peg$parsereplace_insert_stmt();
        if (s0 === peg$FAILED) {
          s0 = peg$parsedelete_stmt();
          if (s0 === peg$FAILED) {
            s0 = peg$parsedrop_table_stmt();
            if (s0 === peg$FAILED) {
              s0 = peg$parsedrop_view_stmt();
              if (s0 === peg$FAILED) {
                s0 = peg$parsecreate_table_stmt();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsealter_table_stmt();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parsecreate_index_stmt();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parsecreate_type_stmt();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parsedrop_type_stmt();
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseunion_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseselect_stmt();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseKW_UNION();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseKW_ALL();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        s8 = peg$parse__();
        s9 = peg$parseselect_stmt();
        if (s9 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7, s8, s9];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseKW_UNION();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_ALL();
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          s8 = peg$parse__();
          s9 = peg$parseselect_stmt();
          if (s9 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7, s8, s9];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f3(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseselect_stmt() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$parseselect_stmt_nake();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s2 = peg$c0;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e0); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$parseselect_stmt();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          if (input.charCodeAt(peg$currPos) === 41) {
            s6 = peg$c1;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e1); }
          }
          if (s6 !== peg$FAILED) {
            s2 = [s2, s3, s4, s5, s6];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f4(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseextract_from_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parse__();
    s3 = peg$parseLPAREN();
    if (s3 === peg$FAILED) {
      s3 = null;
    }
    s4 = peg$parse__();
    s5 = peg$parseKW_SELECT();
    if (s5 !== peg$FAILED) {
      s6 = peg$parse__();
      s7 = [];
      s8 = peg$currPos;
      s9 = peg$currPos;
      peg$silentFails++;
      s10 = peg$parseKW_FROM();
      peg$silentFails--;
      if (s10 === peg$FAILED) {
        s9 = undefined;
      } else {
        peg$currPos = s9;
        s9 = peg$FAILED;
      }
      if (s9 !== peg$FAILED) {
        if (input.length > peg$currPos) {
          s10 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s10 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e2); }
        }
        if (s10 !== peg$FAILED) {
          s9 = [s9, s10];
          s8 = s9;
        } else {
          peg$currPos = s8;
          s8 = peg$FAILED;
        }
      } else {
        peg$currPos = s8;
        s8 = peg$FAILED;
      }
      while (s8 !== peg$FAILED) {
        s7.push(s8);
        s8 = peg$currPos;
        s9 = peg$currPos;
        peg$silentFails++;
        s10 = peg$parseKW_FROM();
        peg$silentFails--;
        if (s10 === peg$FAILED) {
          s9 = undefined;
        } else {
          peg$currPos = s9;
          s9 = peg$FAILED;
        }
        if (s9 !== peg$FAILED) {
          if (input.length > peg$currPos) {
            s10 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s10 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e2); }
          }
          if (s10 !== peg$FAILED) {
            s9 = [s9, s10];
            s8 = s9;
          } else {
            peg$currPos = s8;
            s8 = peg$FAILED;
          }
        } else {
          peg$currPos = s8;
          s8 = peg$FAILED;
        }
      }
      peg$savedPos = s1;
      s1 = peg$f5();
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsefrom_clause();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = [];
      if (input.length > peg$currPos) {
        s6 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s6 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e2); }
      }
      while (s6 !== peg$FAILED) {
        s5.push(s6);
        if (input.length > peg$currPos) {
          s6 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s6 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e2); }
        }
      }
      peg$savedPos = s0;
      s0 = peg$f6(s1, s3, s5);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewith_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_WITH();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_RECURSIVE();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseCTE_list();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f7(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseCTE_list() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseCTE_definition();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 44) {
        s3 = peg$c2;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e3); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseCTE_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f8(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseCTE_definition();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f9(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseCTE_definition() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsearguments();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      if (input.substr(peg$currPos, 2) === peg$c3) {
        s5 = peg$c3;
        peg$currPos += 2;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e4); }
      }
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        if (input.charCodeAt(peg$currPos) === 40) {
          s7 = peg$c0;
          peg$currPos++;
        } else {
          s7 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e0); }
        }
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseunion_stmt();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            if (input.charCodeAt(peg$currPos) === 41) {
              s11 = peg$c1;
              peg$currPos++;
            } else {
              s11 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e1); }
            }
            if (s11 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f10(s1, s3, s9);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsearguments() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 40) {
      s1 = peg$c0;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e0); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident_list();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        if (input.charCodeAt(peg$currPos) === 41) {
          s5 = peg$c1;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e1); }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f11(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseident_list() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 44) {
        s3 = peg$c2;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e3); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f12(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseident();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f13(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseselect_stmt_nake() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17;

    s0 = peg$currPos;
    s1 = peg$parsewith_clause();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseselect_keyword();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseKW_DISTINCT();
      if (s5 === peg$FAILED) {
        s5 = null;
      }
      s6 = peg$parse__();
      s7 = peg$parsecolumn_clause();
      if (s7 !== peg$FAILED) {
        s8 = peg$parse__();
        s9 = peg$parsefrom_clause();
        if (s9 === peg$FAILED) {
          s9 = null;
        }
        s10 = peg$parse__();
        s11 = peg$parsewhere_clause();
        if (s11 === peg$FAILED) {
          s11 = null;
        }
        s12 = peg$parse__();
        s13 = peg$parsegroup_by_clause();
        if (s13 === peg$FAILED) {
          s13 = null;
        }
        s14 = peg$parse__();
        s15 = peg$parseorder_by_clause();
        if (s15 === peg$FAILED) {
          s15 = null;
        }
        s16 = peg$parse__();
        s17 = peg$parselimit_clause();
        if (s17 === peg$FAILED) {
          s17 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f14(s1, s3, s5, s7, s9, s11, s13, s15, s17);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseselect_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_SELECT();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f15(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsecolumn_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALL();
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      s2 = peg$parseSTAR();
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        peg$silentFails++;
        s4 = peg$parseident_start();
        peg$silentFails--;
        if (s4 === peg$FAILED) {
          s3 = undefined;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f16();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecolumn_list_item();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_list_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parse__();
          s5 = peg$parseCOMMA();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parsecolumn_list_item();
            if (s7 !== peg$FAILED) {
              s4 = [s4, s5, s6, s7];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        peg$savedPos = s0;
        s0 = peg$f17(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecolumn_list_item() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseadditive_expr();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsealias_clause();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f18(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealias_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_AS();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseident();
    if (s3 !== peg$FAILED) {
      peg$savedPos = s0;
      s0 = peg$f19(s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefrom_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsefrom_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsetable_ref_list();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f20(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefrom_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_FROM();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f21(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetable_ref_list() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsetable_base();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsetable_ref();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsetable_ref();
      }
      peg$savedPos = s0;
      s0 = peg$f22(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_ref() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parse__();
    s2 = peg$parseCOMMA();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parsetable_base();
      if (s4 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f23(s4);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parse__();
      s2 = peg$parsetable_join();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f24(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsetable_join() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsejoin_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsetable_base();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseon_clause();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f25(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetable_base() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$parsecatalog_name();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseDOT();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsedb_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseDOT();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parsetable_name();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseKW_AS();
              if (s11 === peg$FAILED) {
                s11 = null;
              }
              s12 = peg$parse__();
              s13 = peg$parseident();
              if (s13 === peg$FAILED) {
                s13 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f26(s1, s5, s9, s13);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedb_name();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseDOT();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsetable_name();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseKW_AS();
            if (s7 === peg$FAILED) {
              s7 = null;
            }
            s8 = peg$parse__();
            s9 = peg$parseident();
            if (s9 === peg$FAILED) {
              s9 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f27(s1, s5, s9);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsetable_name();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseKW_AS();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          s4 = peg$parse__();
          s5 = peg$parseident();
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f28(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseselect_stmt();
          if (s1 !== peg$FAILED) {
            s2 = peg$parse__();
            s3 = peg$parseKW_AS();
            if (s3 === peg$FAILED) {
              s3 = null;
            }
            s4 = peg$parse__();
            s5 = peg$parseident();
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            peg$savedPos = s0;
            s0 = peg$f29(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseLPAREN();
            if (s1 !== peg$FAILED) {
              s2 = peg$parse__();
              s3 = peg$parsetable_base();
              if (s3 !== peg$FAILED) {
                s4 = peg$parse__();
                s5 = peg$parseRPAREN();
                if (s5 !== peg$FAILED) {
                  s6 = peg$parse__();
                  s7 = peg$parseKW_AS();
                  if (s7 === peg$FAILED) {
                    s7 = null;
                  }
                  s8 = peg$parse__();
                  s9 = peg$parseident();
                  if (s9 === peg$FAILED) {
                    s9 = null;
                  }
                  peg$savedPos = s0;
                  s0 = peg$f30(s3, s9);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$currPos;
              s2 = peg$parseLPAREN();
              if (s2 !== peg$FAILED) {
                s3 = peg$parse__();
                s4 = peg$currPos;
                s5 = [];
                if (peg$r0.test(input.charAt(peg$currPos))) {
                  s6 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e5); }
                }
                while (s6 !== peg$FAILED) {
                  s5.push(s6);
                  if (peg$r0.test(input.charAt(peg$currPos))) {
                    s6 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s6 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e5); }
                  }
                }
                peg$savedPos = s4;
                s5 = peg$f31();
                s4 = s5;
                s5 = peg$parse__();
                s6 = peg$parseRPAREN();
                if (s6 !== peg$FAILED) {
                  s2 = [s2, s3, s4, s5, s6];
                  s1 = s2;
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                s3 = peg$parseKW_AS();
                if (s3 === peg$FAILED) {
                  s3 = null;
                }
                s4 = peg$parse__();
                s5 = peg$parseident();
                if (s5 === peg$FAILED) {
                  s5 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f32(s1, s5);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsejoin_op() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_LEFT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_JOIN();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f33();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parseKW_INNER();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parseKW_JOIN();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f34();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsecatalog_name() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseident_name();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f35(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsedb_name() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseident_name();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f36(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsetable_name() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f37(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsevar_decl();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f38(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseon_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_ON();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseor_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f39(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewhere_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsewhere_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseor_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f40(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsewhere_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_WHERE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f41(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsegroup_by_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_GROUP();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_BY();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsecolumn_ref_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f42(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_ref_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_ref();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecolumn_ref();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_ref();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f43(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsehaving_clause() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parseKW_HAVING();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseor_expr();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f44(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseorder_by_clause() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_ORDER();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_BY();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseorder_by_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f45(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseorder_by_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseorder_by_element();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseorder_by_element();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseorder_by_element();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f46(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseorder_by_element() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseor_expr();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_DESC();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_ASC();
      }
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f47(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenumber_or_param() {
    var s0;

    s0 = peg$parseliteral_numeric();
    if (s0 === peg$FAILED) {
      s0 = peg$parseparam();
    }

    return s0;
  }

  function peg$parselimit_clause() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parseKW_LIMIT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsenumber_or_param();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$currPos;
        s6 = peg$parseCOMMA();
        if (s6 !== peg$FAILED) {
          s7 = peg$parse__();
          s8 = peg$parsenumber_or_param();
          if (s8 !== peg$FAILED) {
            s6 = [s6, s7, s8];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f48(s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseupdate_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parsewith_clause();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseKW_UPDATE();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parsedb_name();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseDOT();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parsetable_name();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseKW_SET();
            if (s11 !== peg$FAILED) {
              s12 = peg$parse__();
              s13 = peg$parseset_list();
              if (s13 !== peg$FAILED) {
                s14 = peg$parse__();
                s15 = peg$parsewhere_clause();
                if (s15 === peg$FAILED) {
                  s15 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f49(s1, s5, s9, s13, s15);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsewith_clause();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parseKW_UPDATE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_SET();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseset_list();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parsewhere_clause();
              if (s11 === peg$FAILED) {
                s11 = null;
              }
              peg$savedPos = s0;
              s0 = peg$f50(s1, s5, s9, s11);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsewith_clause();
        if (s1 === peg$FAILED) {
          s1 = null;
        }
        s2 = peg$parse__();
        s3 = peg$parseKW_UPDATE();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsetable_name();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = [];
            s8 = peg$parsetable_ref();
            while (s8 !== peg$FAILED) {
              s7.push(s8);
              s8 = peg$parsetable_ref();
            }
            s8 = peg$parse__();
            s9 = peg$parseKW_SET();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseset_list();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parsewhere_clause();
                if (s13 === peg$FAILED) {
                  s13 = null;
                }
                peg$savedPos = s0;
                s0 = peg$f51(s1, s5, s7, s11, s13);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parseset_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseset_item();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseset_item();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseset_item();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f52(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseset_item() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parsecolumn();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 61) {
        s3 = peg$c4;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e6); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseadditive_expr();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f53(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseident();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseDOT();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parsecolumn();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            if (input.charCodeAt(peg$currPos) === 61) {
              s7 = peg$c4;
              peg$currPos++;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e6); }
            }
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parseadditive_expr();
              if (s9 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f54(s1, s5, s9);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        peg$savedPos = peg$currPos;
        s0 = peg$f55();
        if (s0) {
          s0 = peg$FAILED;
        } else {
          s0 = undefined;
        }
      }
    }

    return s0;
  }

  function peg$parsereplace_insert_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17;

    s0 = peg$currPos;
    s1 = peg$parsewith_clause();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parsereplace_insert();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseKW_INTO();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsedb_name();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseDOT();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parsetable_name();
            if (s11 !== peg$FAILED) {
              s12 = peg$parse__();
              s13 = peg$parseinsert_column_list();
              if (s13 !== peg$FAILED) {
                s14 = peg$parse__();
                s15 = peg$parsevalue_clause();
                if (s15 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f56(s1, s3, s7, s11, s13, s15);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsewith_clause();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parsereplace_insert();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_INTO();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsedb_name();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseDOT();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parsetable_name();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parseKW_SET();
                if (s13 !== peg$FAILED) {
                  s14 = peg$parse__();
                  s15 = peg$parseset_list();
                  if (s15 !== peg$FAILED) {
                    s16 = peg$parse__();
                    s17 = peg$parseon_duplicate_key_update();
                    if (s17 === peg$FAILED) {
                      s17 = null;
                    }
                    peg$savedPos = s0;
                    s0 = peg$f57(s1, s3, s7, s11, s15, s17);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsewith_clause();
        if (s1 === peg$FAILED) {
          s1 = null;
        }
        s2 = peg$parse__();
        s3 = peg$parsereplace_insert();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseKW_INTO();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parsetable_name();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parseinsert_column_list();
              if (s9 !== peg$FAILED) {
                s10 = peg$parse__();
                s11 = peg$parsevalue_clause();
                if (s11 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f58(s1, s3, s7, s9, s11);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parsewith_clause();
          if (s1 === peg$FAILED) {
            s1 = null;
          }
          s2 = peg$parse__();
          s3 = peg$parsereplace_insert();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse__();
            s5 = peg$parseKW_INTO();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              s7 = peg$parsetable_name();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse__();
                s9 = peg$parseKW_SET();
                if (s9 !== peg$FAILED) {
                  s10 = peg$parse__();
                  s11 = peg$parseset_list();
                  if (s11 !== peg$FAILED) {
                    s12 = peg$parse__();
                    s13 = peg$parseon_duplicate_key_update();
                    if (s13 === peg$FAILED) {
                      s13 = null;
                    }
                    peg$savedPos = s0;
                    s0 = peg$f59(s1, s3, s7, s11, s13);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
    }

    return s0;
  }

  function peg$parseinsert_column_list() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parseLPAREN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$currPos;
      s4 = peg$parsecolumn_list();
      if (s4 !== peg$FAILED) {
        s5 = peg$parse__();
        s6 = peg$parseRPAREN();
        if (s6 === peg$FAILED) {
          peg$savedPos = peg$currPos;
          s6 = peg$f60(s4);
          if (s6) {
            s6 = peg$FAILED;
          } else {
            s6 = undefined;
          }
        }
        if (s6 !== peg$FAILED) {
          peg$savedPos = s3;
          s3 = peg$f61(s4);
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereplace_insert() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_INSERT();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f62();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_REPLACE();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f63();
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsevalue_clause() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_VALUES();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsevalues();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f64(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseon_duplicate_key_update() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_ON();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_DUPLICATE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_KEY();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_UPDATE();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseset_list();
            if (s9 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f65(s9);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevalues() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseLPAREN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseor_expr();
      if (s3 === peg$FAILED) {
        s3 = peg$parseselect_stmt();
      }
      if (s3 !== peg$FAILED) {
        s4 = [];
        s5 = peg$currPos;
        s6 = peg$parse__();
        s7 = peg$parseCOMMA();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseor_expr();
          if (s9 === peg$FAILED) {
            s9 = peg$parseselect_stmt();
          }
          if (s9 !== peg$FAILED) {
            s6 = [s6, s7, s8, s9];
            s5 = s6;
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        } else {
          peg$currPos = s5;
          s5 = peg$FAILED;
        }
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$currPos;
          s6 = peg$parse__();
          s7 = peg$parseCOMMA();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseor_expr();
            if (s9 === peg$FAILED) {
              s9 = peg$parseselect_stmt();
            }
            if (s9 !== peg$FAILED) {
              s6 = [s6, s7, s8, s9];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
        }
        s5 = peg$parse__();
        s6 = peg$parseRPAREN();
        if (s6 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f66(s3, s4);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexpr_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseor_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseor_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseor_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f67(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexpr_list_or_empty() {
    var s0, s1;

    s0 = peg$parseexpr_list();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = '';
      peg$savedPos = s0;
      s1 = peg$f68();
      s0 = s1;
    }

    return s0;
  }

  function peg$parseor_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseand_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseKW_OR();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseand_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseKW_OR();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseand_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f69(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseand_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsenot_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseKW_AND();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsenot_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseKW_AND();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsenot_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f70(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsenot_expr() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parseKW_NOT();
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 33) {
        s2 = peg$c5;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e7); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        peg$silentFails++;
        if (input.charCodeAt(peg$currPos) === 61) {
          s4 = peg$c4;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e6); }
        }
        peg$silentFails--;
        if (s4 === peg$FAILED) {
          s3 = undefined;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsenot_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f71(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsecomparison_expr();
    }

    return s0;
  }

  function peg$parsecomparison_expr() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseadditive_expr();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecomparison_op_right();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f72(s1, s3);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecomparison_op_right() {
    var s0;

    s0 = peg$parsearithmetic_op_right();
    if (s0 === peg$FAILED) {
      s0 = peg$parsein_op_right();
      if (s0 === peg$FAILED) {
        s0 = peg$parsebetween_op_right();
        if (s0 === peg$FAILED) {
          s0 = peg$parseis_op_right();
          if (s0 === peg$FAILED) {
            s0 = peg$parselike_op_right();
            if (s0 === peg$FAILED) {
              s0 = peg$parsecontains_op_right();
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsearithmetic_op_right() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$currPos;
    s3 = peg$parse__();
    s4 = peg$parsearithmetic_comparison_operator();
    if (s4 !== peg$FAILED) {
      s5 = peg$parse__();
      s6 = peg$parseadditive_expr();
      if (s6 !== peg$FAILED) {
        s3 = [s3, s4, s5, s6];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$currPos;
        s3 = peg$parse__();
        s4 = peg$parsearithmetic_comparison_operator();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          s6 = peg$parseadditive_expr();
          if (s6 !== peg$FAILED) {
            s3 = [s3, s4, s5, s6];
            s2 = s3;
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f73(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsearithmetic_comparison_operator() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c6) {
      s0 = peg$c6;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e8); }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 62) {
        s0 = peg$c7;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e9); }
      }
      if (s0 === peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c8) {
          s0 = peg$c8;
          peg$currPos += 2;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e10); }
        }
        if (s0 === peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c9) {
            s0 = peg$c9;
            peg$currPos += 2;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e11); }
          }
          if (s0 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 60) {
              s0 = peg$c10;
              peg$currPos++;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e12); }
            }
            if (s0 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 61) {
                s0 = peg$c4;
                peg$currPos++;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e6); }
              }
              if (s0 === peg$FAILED) {
                if (input.substr(peg$currPos, 2) === peg$c11) {
                  s0 = peg$c11;
                  peg$currPos += 2;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e13); }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsebetween_op_right() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_BETWEEN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseadditive_expr();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_AND();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseadditive_expr();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f74(s1, s3, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseis_op_right() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_IS();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_NOT();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseKW_NULL();
      if (s5 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f75(s1, s3, s5);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_IS();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseadditive_expr();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f76(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parselike_op() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_NOT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_LIKE();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f77(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_LIKE();
    }

    return s0;
  }

  function peg$parsein_op() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_NOT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_IN();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f78(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_IN();
    }

    return s0;
  }

  function peg$parsecontains_op() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_NOT();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_CONTAINS();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f79(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_CONTAINS();
    }

    return s0;
  }

  function peg$parselike_op_right() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parselike_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecomparison_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f80(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsein_op_right() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsein_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr_list();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f81(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsein_op();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseselect_stmt();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f82(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsein_op();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parsevar_decl();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f83(s1, s3);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsecontains_op_right() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecontains_op();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr_list();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f84(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecontains_op();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsevar_decl();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f85(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseadditive_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsemultiplicative_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseadditive_operator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsemultiplicative_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseadditive_operator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsemultiplicative_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f86(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseadditive_operator() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 43) {
      s0 = peg$c12;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e14); }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 45) {
        s0 = peg$c13;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e15); }
      }
    }

    return s0;
  }

  function peg$parsemultiplicative_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseprimary();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsemultiplicative_operator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseprimary();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsemultiplicative_operator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseprimary();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f87(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsemultiplicative_operator() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 42) {
      s0 = peg$c14;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e16); }
    }
    if (s0 === peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 47) {
        s0 = peg$c15;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e17); }
      }
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 37) {
          s0 = peg$c16;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e18); }
        }
      }
    }

    return s0;
  }

  function peg$parseprimary() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$parseliteral();
    if (s0 === peg$FAILED) {
      s0 = peg$parseaggr_func();
      if (s0 === peg$FAILED) {
        s0 = peg$parsefunc_call();
        if (s0 === peg$FAILED) {
          s0 = peg$parsecolumn_ref();
          if (s0 === peg$FAILED) {
            s0 = peg$parseparam();
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseLPAREN();
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                s3 = peg$parseor_expr();
                if (s3 !== peg$FAILED) {
                  s4 = peg$parse__();
                  s5 = peg$parseRPAREN();
                  if (s5 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f88(s3);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
              if (s0 === peg$FAILED) {
                s0 = peg$parseselect_stmt();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsevar_decl();
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsecolumn_ref() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseDOT();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsecolumn();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f89(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecolumn();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f90(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsecolumn_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecolumn();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecolumn();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f91(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseident() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseident_name();
    if (s1 !== peg$FAILED) {
      peg$savedPos = peg$currPos;
      s2 = peg$f92(s1);
      if (s2) {
        s2 = peg$FAILED;
      } else {
        s2 = undefined;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f93(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 96) {
        s1 = peg$c17;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e19); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$r1.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e20); }
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            if (peg$r1.test(input.charAt(peg$currPos))) {
              s3 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e20); }
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 96) {
            s3 = peg$c17;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e19); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f94(s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseDQUOTE();
        if (s1 !== peg$FAILED) {
          s2 = [];
          if (peg$r2.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e21); }
          }
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              if (peg$r2.test(input.charAt(peg$currPos))) {
                s3 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e21); }
              }
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parseDQUOTE();
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f95(s2);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsecolumn() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_name();
    if (s1 !== peg$FAILED) {
      peg$savedPos = peg$currPos;
      s2 = peg$f96(s1);
      if (s2) {
        s2 = peg$FAILED;
      } else {
        s2 = undefined;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f97(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsebacktik_column();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        if (peg$r3.test(input.charAt(peg$currPos))) {
          s4 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e22); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsebacktik_column();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          if (peg$r3.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e22); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parsebacktik_column();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        peg$savedPos = s0;
        s0 = peg$f98();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseDQUOTE();
        if (s1 !== peg$FAILED) {
          s2 = peg$parsecolumn_name();
          if (s2 !== peg$FAILED) {
            s3 = peg$parseDQUOTE();
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f99(s2);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsecolumn_node() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsecolumn();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f100(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsebacktik_column() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 96) {
      s1 = peg$c17;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e19); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$r1.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e20); }
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$r1.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e20); }
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 96) {
          s3 = peg$c17;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e19); }
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecolumn_name() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseident_start();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsecolumn_char();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsecolumn_char();
      }
      s3 = [];
      s4 = peg$currPos;
      if (peg$r3.test(input.charAt(peg$currPos))) {
        s5 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e22); }
      }
      if (s5 !== peg$FAILED) {
        s6 = [];
        s7 = peg$parsecolumn_char();
        if (s7 !== peg$FAILED) {
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$parsecolumn_char();
          }
        } else {
          s6 = peg$FAILED;
        }
        if (s6 !== peg$FAILED) {
          s5 = [s5, s6];
          s4 = s5;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$currPos;
        if (peg$r3.test(input.charAt(peg$currPos))) {
          s5 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e22); }
        }
        if (s5 !== peg$FAILED) {
          s6 = [];
          s7 = peg$parsecolumn_char();
          if (s7 !== peg$FAILED) {
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parsecolumn_char();
            }
          } else {
            s6 = peg$FAILED;
          }
          if (s6 !== peg$FAILED) {
            s5 = [s5, s6];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f101();
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseident_name() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseident_start();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseident_part();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseident_part();
      }
      peg$savedPos = s0;
      s0 = peg$f102(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseident_start() {
    var s0;

    if (peg$r4.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e23); }
    }

    return s0;
  }

  function peg$parseident_part() {
    var s0;

    if (peg$r5.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e24); }
    }

    return s0;
  }

  function peg$parsecolumn_char() {
    var s0;

    if (peg$r6.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e25); }
    }

    return s0;
  }

  function peg$parseparam() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$currPos;
    if (peg$r7.test(input.charAt(peg$currPos))) {
      s2 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e26); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$parseident_name();
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f103(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseaggr_func() {
    var s0;

    s0 = peg$parseaggr_fun_count();
    if (s0 === peg$FAILED) {
      s0 = peg$parseaggr_fun_smma();
    }

    return s0;
  }

  function peg$parseaggr_fun_smma() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_SUM_MAX_MIN_AVG();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseadditive_expr();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f104(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SUM_MAX_MIN_AVG() {
    var s0;

    s0 = peg$parseKW_SUM();
    if (s0 === peg$FAILED) {
      s0 = peg$parseKW_MAX();
      if (s0 === peg$FAILED) {
        s0 = peg$parseKW_MIN();
        if (s0 === peg$FAILED) {
          s0 = peg$parseKW_AVG();
        }
      }
    }

    return s0;
  }

  function peg$parseaggr_fun_count() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_COUNT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsecount_arg();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f105(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecount_arg() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsestar_expr();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f106(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_DISTINCT();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      s2 = peg$parse__();
      s3 = peg$parsecolumn_ref();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f107(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsestar_expr() {
    var s0, s1;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 42) {
      s1 = peg$c14;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e16); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f108();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsefunc_call() {
    var s0;

    s0 = peg$parsefunc_call_cast();
    if (s0 === peg$FAILED) {
      s0 = peg$parsefunc_call_others();
    }

    return s0;
  }

  function peg$parsefunc_call_others() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseexpr_list_or_empty();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f109(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefunc_call_cast() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_CAST();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseor_expr();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_AS();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseident();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseRPAREN();
              if (s11 !== peg$FAILED) {
                peg$savedPos = s0;
                s0 = peg$f110(s1, s5, s9);
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseliteral() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseliteral_string();
    if (s1 === peg$FAILED) {
      s1 = peg$parseliteral_numeric();
      if (s1 === peg$FAILED) {
        s1 = peg$parseliteral_bool();
        if (s1 === peg$FAILED) {
          s1 = peg$parseliteral_null();
        }
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseDOT();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f111(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseliteral_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseliteral();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseliteral();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseliteral();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f112(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseliteral_null() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_NULL();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f113();
    }
    s0 = s1;

    return s0;
  }

  function peg$parseliteral_bool() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_TRUE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f114();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_FALSE();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f115();
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseliteral_string() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 34) {
      s2 = peg$c18;
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e27); }
    }
    if (s2 !== peg$FAILED) {
      s3 = [];
      s4 = peg$parsedouble_char();
      while (s4 !== peg$FAILED) {
        s3.push(s4);
        s4 = peg$parsedouble_char();
      }
      if (input.charCodeAt(peg$currPos) === 34) {
        s4 = peg$c18;
        peg$currPos++;
      } else {
        s4 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e27); }
      }
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 39) {
        s2 = peg$c19;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e28); }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parsesingle_char();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parsesingle_char();
        }
        if (input.charCodeAt(peg$currPos) === 39) {
          s4 = peg$c19;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e28); }
        }
        if (s4 !== peg$FAILED) {
          s2 = [s2, s3, s4];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f116(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsesingle_char() {
    var s0;

    if (peg$r8.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e29); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseescape_char();
    }

    return s0;
  }

  function peg$parsedouble_char() {
    var s0;

    if (peg$r9.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e30); }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseescape_char();
    }

    return s0;
  }

  function peg$parseescape_char() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c20) {
      s1 = peg$c20;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e31); }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f117();
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c21) {
        s1 = peg$c21;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e32); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f118();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c22) {
          s1 = peg$c22;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e33); }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f119();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 2) === peg$c23) {
            s1 = peg$c23;
            peg$currPos += 2;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e34); }
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$f120();
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c24) {
              s1 = peg$c24;
              peg$currPos += 2;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e35); }
            }
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$f121();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.substr(peg$currPos, 2) === peg$c25) {
                s1 = peg$c25;
                peg$currPos += 2;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e36); }
              }
              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$f122();
              }
              s0 = s1;
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 2) === peg$c26) {
                  s1 = peg$c26;
                  peg$currPos += 2;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e37); }
                }
                if (s1 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$f123();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                  s0 = peg$currPos;
                  if (input.substr(peg$currPos, 2) === peg$c27) {
                    s1 = peg$c27;
                    peg$currPos += 2;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e38); }
                  }
                  if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$f124();
                  }
                  s0 = s1;
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c28) {
                      s1 = peg$c28;
                      peg$currPos += 2;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e39); }
                    }
                    if (s1 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$f125();
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                      s0 = peg$currPos;
                      if (input.substr(peg$currPos, 2) === peg$c29) {
                        s1 = peg$c29;
                        peg$currPos += 2;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$e40); }
                      }
                      if (s1 !== peg$FAILED) {
                        s2 = peg$parsehexDigit();
                        if (s2 !== peg$FAILED) {
                          s3 = peg$parsehexDigit();
                          if (s3 !== peg$FAILED) {
                            s4 = peg$parsehexDigit();
                            if (s4 !== peg$FAILED) {
                              s5 = peg$parsehexDigit();
                              if (s5 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s0 = peg$f126(s2, s3, s4, s5);
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseline_terminator() {
    var s0;

    if (peg$r10.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e41); }
    }

    return s0;
  }

  function peg$parseliteral_numeric() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsenumber();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f127(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsenumber() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parseint();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsefrac();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseexp();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          peg$savedPos = s0;
          s0 = peg$f128(s1, s2, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseint();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsefrac();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse__();
          peg$savedPos = s0;
          s0 = peg$f129(s1, s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseint();
        if (s1 !== peg$FAILED) {
          s2 = peg$parseexp();
          if (s2 !== peg$FAILED) {
            s3 = peg$parse__();
            peg$savedPos = s0;
            s0 = peg$f130(s1, s2);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseint();
          if (s1 !== peg$FAILED) {
            s2 = peg$parse__();
            peg$savedPos = s0;
            s0 = peg$f131(s1);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
    }

    return s0;
  }

  function peg$parseint() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsedigit19();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedigits();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f132(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parsedigit();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 45) {
          s1 = peg$c13;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e15); }
        }
        if (s1 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 43) {
            s1 = peg$c12;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e14); }
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parsedigit19();
          if (s2 !== peg$FAILED) {
            s3 = peg$parsedigits();
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f133(s1, s2, s3);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 45) {
            s1 = peg$c13;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e15); }
          }
          if (s1 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 43) {
              s1 = peg$c12;
              peg$currPos++;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e14); }
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parsedigit();
            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s0 = peg$f134(s1, s2);
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
    }

    return s0;
  }

  function peg$parsefrac() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 46) {
      s1 = peg$c30;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e42); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedigits();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f135(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseexp() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = peg$parsee();
    if (s1 !== peg$FAILED) {
      s2 = peg$parsedigits();
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f136(s1, s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedigits() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parsedigit();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parsedigit();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f137(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsedigit() {
    var s0;

    if (peg$r11.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e43); }
    }

    return s0;
  }

  function peg$parsedigit19() {
    var s0;

    if (peg$r12.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e44); }
    }

    return s0;
  }

  function peg$parsehexDigit() {
    var s0;

    if (peg$r13.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e45); }
    }

    return s0;
  }

  function peg$parsee() {
    var s0, s1, s2;

    s0 = peg$currPos;
    if (peg$r14.test(input.charAt(peg$currPos))) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e46); }
    }
    if (s1 !== peg$FAILED) {
      if (peg$r15.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e47); }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      peg$savedPos = s0;
      s0 = peg$f138(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NULL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c31) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e48); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NOT_NULL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c32) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e49); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNIQUE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c33) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e50); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_PRIMARY_KEY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c34) {
      s1 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e51); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INCREMENT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c35) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e52); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_AUTO_INCREMENT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 14).toLowerCase() === peg$c36) {
      s1 = input.substr(peg$currPos, 14);
      peg$currPos += 14;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e53); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DEFAULT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c37) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e54); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f139(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_GENERATED() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c38) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e55); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ALWAYS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c39) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e56); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BY_DEFAULT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c40) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e57); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BY_DEFAULT_ON_NULL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 18).toLowerCase() === peg$c41) {
      s1 = input.substr(peg$currPos, 18);
      peg$currPos += 18;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e58); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_IDENTITY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c42) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e59); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_START() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c43) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e60); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_WITH() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c44) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e61); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f140(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_MINVALUE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c45) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e62); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NO_MINVALUE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c46) {
      s1 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e63); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_MAXVALUE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c47) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e64); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NO_MAXVALUE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c48) {
      s1 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e65); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_OWNED_BY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c49) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e66); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_OWNED_BY_NONE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 13).toLowerCase() === peg$c50) {
      s1 = input.substr(peg$currPos, 13);
      peg$currPos += 13;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e67); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CACHE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c51) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e68); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CYCLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c52) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e69); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NO_CYCLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c53) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e70); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CHECK() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c54) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e71); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TRUE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c55) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e72); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FALSE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c56) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e73); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SHOW() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c57) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e74); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DROP() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c58) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e75); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f141(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SELECT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c59) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e76); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UPDATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c60) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e77); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f142(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CREATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c61) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e78); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f143(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CREATE_TABLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c62) {
      s1 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e79); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DROP_TABLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c63) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e80); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DROP_VIEW() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c64) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e81); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_IF_NOT_EXISTS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 13).toLowerCase() === peg$c65) {
      s1 = input.substr(peg$currPos, 13);
      peg$currPos += 13;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e82); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_IF_EXISTS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c66) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e83); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f144(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DELETE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c67) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e84); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f145(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INSERT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c68) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e85); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REPLACE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c69) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e86); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_EXPLAIN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c70) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e87); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ALTER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c71) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e88); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ADD() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c72) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e89); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_MODIFY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c73) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e90); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DROP_COLUMN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c74) {
      s1 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e91); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INTO() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c75) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e92); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FROM() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c76) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e93); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SET() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c77) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e94); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_AS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c78) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e95); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TABLE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c79) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e96); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_COLUMN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c80) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e97); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ON() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c81) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e98); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f146(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LEFT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c82) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e99); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INNER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c83) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e100); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_JOIN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c84) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e101); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_UNION() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c85) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e102); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_VALUES() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c86) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e103); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_EXISTS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c87) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e104); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_WHERE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c88) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e105); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_GROUP() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c89) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e106); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c90) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e107); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ORDER() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c91) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e108); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_HAVING() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c92) {
      s1 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e109); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LIMIT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c93) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e110); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ASC() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c94) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e111); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f147();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DESC() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c95) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e112); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f148();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ALL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c96) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e113); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f149();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DISTINCT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c97) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e114); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f150();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_DUPLICATE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c98) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e115); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f151();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_BETWEEN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c99) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e116); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f152();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_IN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c100) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e117); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f153();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_IS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c101) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e118); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f154();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_LIKE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c102) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e119); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f155();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CONTAINS() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c103) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e120); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f156();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_KEY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c104) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e121); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f157();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NOT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c105) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e122); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f158();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_AND() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c106) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e123); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f159();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_OR() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c107) {
      s1 = input.substr(peg$currPos, 2);
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e124); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f160();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_COUNT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c108) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e125); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f161();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_MAX() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c109) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e126); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f162();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_MIN() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c110) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e127); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f163();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SUM() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c111) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e128); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f164();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_AVG() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c112) {
      s1 = input.substr(peg$currPos, 3);
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e129); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f165();
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CAST() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c113) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e130); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f166(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_RECURSIVE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c114) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e131); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f167(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_FOREIGN_KEY() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c115) {
      s1 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e132); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f168(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_REFERENCES() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 10).toLowerCase() === peg$c116) {
      s1 = input.substr(peg$currPos, 10);
      peg$currPos += 10;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e133); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f169(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_INDEX() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c117) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e134); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f170(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_CASCADE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c118) {
      s1 = input.substr(peg$currPos, 7);
      peg$currPos += 7;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e135); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f171(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SET_NULL() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c119) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e136); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f172(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_SET_DEFAULT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 11).toLowerCase() === peg$c120) {
      s1 = input.substr(peg$currPos, 11);
      peg$currPos += 11;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e137); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f173(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_RESTRICT() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 8).toLowerCase() === peg$c121) {
      s1 = input.substr(peg$currPos, 8);
      peg$currPos += 8;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e138); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f174(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_NO_ACTION() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 9).toLowerCase() === peg$c122) {
      s1 = input.substr(peg$currPos, 9);
      peg$currPos += 9;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e139); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f175(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_TYPE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c123) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e140); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f176(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_ENUM() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c124) {
      s1 = input.substr(peg$currPos, 4);
      peg$currPos += 4;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e141); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f177(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseKW_RANGE() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c125) {
      s1 = input.substr(peg$currPos, 5);
      peg$currPos += 5;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e142); }
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$currPos;
      peg$silentFails++;
      s3 = peg$parseident_start();
      peg$silentFails--;
      if (s3 === peg$FAILED) {
        s2 = undefined;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f178(s1);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseDOT() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 46) {
      s0 = peg$c30;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e42); }
    }

    return s0;
  }

  function peg$parseCOMMA() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 44) {
      s0 = peg$c2;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e3); }
    }

    return s0;
  }

  function peg$parseSTAR() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 42) {
      s0 = peg$c14;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e16); }
    }

    return s0;
  }

  function peg$parseLPAREN() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 40) {
      s0 = peg$c0;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e0); }
    }

    return s0;
  }

  function peg$parseRPAREN() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 41) {
      s0 = peg$c1;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e1); }
    }

    return s0;
  }

  function peg$parseLBRAKE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 91) {
      s0 = peg$c126;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e143); }
    }

    return s0;
  }

  function peg$parseRBRAKE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 93) {
      s0 = peg$c127;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e144); }
    }

    return s0;
  }

  function peg$parseLBRACE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 123) {
      s0 = peg$c128;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e145); }
    }

    return s0;
  }

  function peg$parseRBRACE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 125) {
      s0 = peg$c129;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e146); }
    }

    return s0;
  }

  function peg$parseDQUOTE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 34) {
      s0 = peg$c18;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e27); }
    }

    return s0;
  }

  function peg$parse__() {
    var s0, s1;

    s0 = [];
    s1 = peg$parsewhitespace();
    if (s1 === peg$FAILED) {
      s1 = peg$parseComment();
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parsewhitespace();
      if (s1 === peg$FAILED) {
        s1 = peg$parseComment();
      }
    }

    return s0;
  }

  function peg$parsechar() {
    var s0;

    if (input.length > peg$currPos) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e2); }
    }

    return s0;
  }

  function peg$parsewhitespace() {
    var s0;

    if (peg$r16.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e147); }
    }

    return s0;
  }

  function peg$parseComment() {
    var s0;

    s0 = peg$parseSingleLineComment();
    if (s0 === peg$FAILED) {
      s0 = peg$parseMultiLineComment();
    }

    return s0;
  }

  function peg$parseSingleLineComment() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c130) {
      s1 = peg$c130;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e148); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      s5 = peg$parseline_terminator();
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parsechar();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        s5 = peg$parseline_terminator();
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsechar();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseMultiLineComment() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c131) {
      s1 = peg$c131;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e149); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$currPos;
      peg$silentFails++;
      if (input.substr(peg$currPos, 2) === peg$c132) {
        s5 = peg$c132;
        peg$currPos += 2;
      } else {
        s5 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e150); }
      }
      peg$silentFails--;
      if (s5 === peg$FAILED) {
        s4 = undefined;
      } else {
        peg$currPos = s4;
        s4 = peg$FAILED;
      }
      if (s4 !== peg$FAILED) {
        s5 = peg$parsechar();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$currPos;
        peg$silentFails++;
        if (input.substr(peg$currPos, 2) === peg$c132) {
          s5 = peg$c132;
          peg$currPos += 2;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e150); }
        }
        peg$silentFails--;
        if (s5 === peg$FAILED) {
          s4 = undefined;
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsechar();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      if (input.substr(peg$currPos, 2) === peg$c132) {
        s3 = peg$c132;
        peg$currPos += 2;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e150); }
      }
      if (s3 !== peg$FAILED) {
        s1 = [s1, s2, s3];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseEOL() {
    var s0, s1;

    s0 = peg$parseEOF();
    if (s0 === peg$FAILED) {
      s0 = [];
      if (peg$r10.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e41); }
      }
      if (s1 !== peg$FAILED) {
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          if (peg$r10.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e41); }
          }
        }
      } else {
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseEOF() {
    var s0, s1;

    s0 = peg$currPos;
    peg$silentFails++;
    if (input.length > peg$currPos) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e2); }
    }
    peg$silentFails--;
    if (s1 === peg$FAILED) {
      s0 = undefined;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseEOSQL() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 59) {
      s0 = peg$c133;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e151); }
    }

    return s0;
  }

  function peg$parseproc_stmts() {
    var s0, s1;

    s0 = [];
    s1 = peg$parseproc_stmt();
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = peg$parseproc_stmt();
    }

    return s0;
  }

  function peg$parseproc_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    peg$savedPos = peg$currPos;
    s1 = peg$f179();
    if (s1) {
      s1 = undefined;
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseassign_stmt();
      if (s3 === peg$FAILED) {
        s3 = peg$parsereturn_stmt();
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f180(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseassign_stmt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsevar_decl();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_ASSIGN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseproc_expr();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f181(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsereturn_stmt() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_RETURN();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseproc_expr();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f182(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_expr() {
    var s0;

    s0 = peg$parseselect_stmt();
    if (s0 === peg$FAILED) {
      s0 = peg$parseproc_join();
      if (s0 === peg$FAILED) {
        s0 = peg$parseproc_additive_expr();
        if (s0 === peg$FAILED) {
          s0 = peg$parseproc_array();
        }
      }
    }

    return s0;
  }

  function peg$parseproc_additive_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseproc_multiplicative_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseadditive_operator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseproc_multiplicative_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseadditive_operator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseproc_multiplicative_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f183(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_multiplicative_expr() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseproc_primary();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsemultiplicative_operator();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseproc_primary();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsemultiplicative_operator();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseproc_primary();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f184(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_join() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsevar_decl();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsejoin_op();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsevar_decl();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseon_clause();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f185(s1, s3, s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_primary() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$parseliteral();
    if (s0 === peg$FAILED) {
      s0 = peg$parsevar_decl();
      if (s0 === peg$FAILED) {
        s0 = peg$parseproc_func_call();
        if (s0 === peg$FAILED) {
          s0 = peg$parsespecial_system_function();
          if (s0 === peg$FAILED) {
            s0 = peg$parseparam();
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseLPAREN();
              if (s1 !== peg$FAILED) {
                s2 = peg$parse__();
                s3 = peg$parseproc_additive_expr();
                if (s3 !== peg$FAILED) {
                  s4 = peg$parse__();
                  s5 = peg$parseRPAREN();
                  if (s5 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f186(s3);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parseproc_func_call() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseproc_primary_list();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseRPAREN();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f187(s1, s5);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsespecial_system_function() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c134) {
      s2 = input.substr(peg$currPos, 12);
      peg$currPos += 12;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e152); }
    }
    if (s2 !== peg$FAILED) {
      s3 = peg$currPos;
      peg$silentFails++;
      s4 = peg$parseident_start();
      peg$silentFails--;
      if (s4 === peg$FAILED) {
        s3 = undefined;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s2 = [s2, s3];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 === peg$FAILED) {
      s1 = peg$currPos;
      if (input.substr(peg$currPos, 12).toLowerCase() === peg$c135) {
        s2 = input.substr(peg$currPos, 12);
        peg$currPos += 12;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e153); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$currPos;
        peg$silentFails++;
        s4 = peg$parseident_start();
        peg$silentFails--;
        if (s4 === peg$FAILED) {
          s3 = undefined;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        if (input.substr(peg$currPos, 12).toLowerCase() === peg$c136) {
          s2 = input.substr(peg$currPos, 12);
          peg$currPos += 12;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$e154); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          peg$silentFails++;
          s4 = peg$parseident_start();
          peg$silentFails--;
          if (s4 === peg$FAILED) {
            s3 = undefined;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s2 = [s2, s3];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 === peg$FAILED) {
          s1 = peg$currPos;
          if (input.substr(peg$currPos, 17).toLowerCase() === peg$c137) {
            s2 = input.substr(peg$currPos, 17);
            peg$currPos += 17;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$e155); }
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$currPos;
            peg$silentFails++;
            s4 = peg$parseident_start();
            peg$silentFails--;
            if (s4 === peg$FAILED) {
              s3 = undefined;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 !== peg$FAILED) {
              s2 = [s2, s3];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
          if (s1 === peg$FAILED) {
            s1 = peg$currPos;
            if (input.substr(peg$currPos, 9).toLowerCase() === peg$c138) {
              s2 = input.substr(peg$currPos, 9);
              peg$currPos += 9;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$e156); }
            }
            if (s2 !== peg$FAILED) {
              s3 = peg$currPos;
              peg$silentFails++;
              s4 = peg$parseident_start();
              peg$silentFails--;
              if (s4 === peg$FAILED) {
                s3 = undefined;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
              if (s3 !== peg$FAILED) {
                s2 = [s2, s3];
                s1 = s2;
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
            if (s1 === peg$FAILED) {
              s1 = peg$currPos;
              if (input.substr(peg$currPos, 14).toLowerCase() === peg$c139) {
                s2 = input.substr(peg$currPos, 14);
                peg$currPos += 14;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$e157); }
              }
              if (s2 !== peg$FAILED) {
                s3 = peg$currPos;
                peg$silentFails++;
                s4 = peg$parseident_start();
                peg$silentFails--;
                if (s4 === peg$FAILED) {
                  s3 = undefined;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
                if (s3 !== peg$FAILED) {
                  s2 = [s2, s3];
                  s1 = s2;
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
              } else {
                peg$currPos = s1;
                s1 = peg$FAILED;
              }
              if (s1 === peg$FAILED) {
                s1 = peg$currPos;
                if (input.substr(peg$currPos, 12).toLowerCase() === peg$c140) {
                  s2 = input.substr(peg$currPos, 12);
                  peg$currPos += 12;
                } else {
                  s2 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$e158); }
                }
                if (s2 !== peg$FAILED) {
                  s3 = peg$currPos;
                  peg$silentFails++;
                  s4 = peg$parseident_start();
                  peg$silentFails--;
                  if (s4 === peg$FAILED) {
                    s3 = undefined;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                  if (s3 !== peg$FAILED) {
                    s2 = [s2, s3];
                    s1 = s2;
                  } else {
                    peg$currPos = s1;
                    s1 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s1;
                  s1 = peg$FAILED;
                }
                if (s1 === peg$FAILED) {
                  s1 = peg$currPos;
                  if (input.substr(peg$currPos, 11).toLowerCase() === peg$c141) {
                    s2 = input.substr(peg$currPos, 11);
                    peg$currPos += 11;
                  } else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$e159); }
                  }
                  if (s2 !== peg$FAILED) {
                    s3 = peg$currPos;
                    peg$silentFails++;
                    s4 = peg$parseident_start();
                    peg$silentFails--;
                    if (s4 === peg$FAILED) {
                      s3 = undefined;
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                    if (s3 !== peg$FAILED) {
                      s2 = [s2, s3];
                      s1 = s2;
                    } else {
                      peg$currPos = s1;
                      s1 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s1;
                    s1 = peg$FAILED;
                  }
                  if (s1 === peg$FAILED) {
                    s1 = peg$currPos;
                    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c142) {
                      s2 = input.substr(peg$currPos, 4);
                      peg$currPos += 4;
                    } else {
                      s2 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$e160); }
                    }
                    if (s2 !== peg$FAILED) {
                      s3 = peg$currPos;
                      peg$silentFails++;
                      s4 = peg$parseident_start();
                      peg$silentFails--;
                      if (s4 === peg$FAILED) {
                        s3 = undefined;
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                      if (s3 !== peg$FAILED) {
                        s2 = [s2, s3];
                        s1 = s2;
                      } else {
                        peg$currPos = s1;
                        s1 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s1;
                      s1 = peg$FAILED;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f188(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseproc_primary_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseproc_primary();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseproc_primary();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseproc_primary();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f189(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseproc_array() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseLBRAKE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseproc_primary_list();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseRBRAKE();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f190(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevar_decl() {
    var s0;

    s0 = peg$parsevar_decl_std();
    if (s0 === peg$FAILED) {
      s0 = peg$parsevar_decl_pg_promise();
    }

    return s0;
  }

  function peg$parsevar_decl_std() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_VAR_PRE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseident_name();
      if (s2 !== peg$FAILED) {
        s3 = peg$parsemem_chain();
        peg$savedPos = s0;
        s0 = peg$f191(s2, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsevar_decl_pg_promise() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_VAR_PRE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseLBRACE();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseident_name();
        if (s3 !== peg$FAILED) {
          s4 = peg$parsemem_chain();
          s5 = peg$parseRBRACE();
          if (s5 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f192(s3, s4);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsemem_chain() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = [];
    s2 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 46) {
      s3 = peg$c30;
      peg$currPos++;
    } else {
      s3 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e42); }
    }
    if (s3 !== peg$FAILED) {
      s4 = peg$parseident_name();
      if (s4 !== peg$FAILED) {
        s3 = [s3, s4];
        s2 = s3;
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    } else {
      peg$currPos = s2;
      s2 = peg$FAILED;
    }
    while (s2 !== peg$FAILED) {
      s1.push(s2);
      s2 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 46) {
        s3 = peg$c30;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e42); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parseident_name();
        if (s4 !== peg$FAILED) {
          s3 = [s3, s4];
          s2 = s3;
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
      } else {
        peg$currPos = s2;
        s2 = peg$FAILED;
      }
    }
    peg$savedPos = s0;
    s1 = peg$f193(s1);
    s0 = s1;

    return s0;
  }

  function peg$parseKW_VAR_PRE() {
    var s0;

    if (input.charCodeAt(peg$currPos) === 36) {
      s0 = peg$c143;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e161); }
    }

    return s0;
  }

  function peg$parseKW_RETURN() {
    var s0;

    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c144) {
      s0 = input.substr(peg$currPos, 6);
      peg$currPos += 6;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e162); }
    }

    return s0;
  }

  function peg$parseKW_ASSIGN() {
    var s0;

    if (input.substr(peg$currPos, 2) === peg$c145) {
      s0 = peg$c145;
      peg$currPos += 2;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$e163); }
    }

    return s0;
  }

  function peg$parsedelete_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parsewith_clause();
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    s2 = peg$parse__();
    s3 = peg$parseKW_DELETE();
    if (s3 !== peg$FAILED) {
      s4 = peg$parse__();
      s5 = peg$parseKW_FROM();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsedelete_table();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parsewhere_clause();
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f194(s1, s3, s7, s9);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedelete_table() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsedb_name();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseDOT();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsetable_name();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f195(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsetable_name();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f196(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsedrop_table_stmt() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parsedrop_table_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_IF_EXISTS();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsedelete_table();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          peg$savedPos = s0;
          s0 = peg$f197(s1, s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsedrop_table_keyword();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsedelete_table();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          peg$savedPos = s0;
          s0 = peg$f198(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parsedrop_table_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_DROP_TABLE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f199(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsecreate_table_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parsecreate_table_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_AS();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseselect_stmt();
          if (s7 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f200(s1, s3, s5, s7);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsecreate_table_keyword();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parseif_not_exists_keyword();
        if (s3 !== peg$FAILED) {
          s4 = peg$parse__();
          s5 = peg$parseident();
          if (s5 !== peg$FAILED) {
            s6 = peg$parse__();
            s7 = peg$parseLPAREN();
            if (s7 !== peg$FAILED) {
              s8 = peg$parse__();
              s9 = peg$parsecolumn_definition_list();
              if (s9 !== peg$FAILED) {
                s10 = peg$parse__();
                s11 = peg$parseRPAREN();
                if (s11 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f201(s1, s3, s5, s9);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsecreate_table_keyword();
        if (s1 !== peg$FAILED) {
          s2 = peg$parse__();
          s3 = peg$parseident();
          if (s3 !== peg$FAILED) {
            s4 = peg$parse__();
            s5 = peg$parseLPAREN();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse__();
              s7 = peg$parsecolumn_definition_list();
              if (s7 !== peg$FAILED) {
                s8 = peg$parse__();
                s9 = peg$parseRPAREN();
                if (s9 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f202(s1, s3, s7);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
    }

    return s0;
  }

  function peg$parsecreate_table_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE_TABLE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f203(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseif_not_exists_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_IF_NOT_EXISTS();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f204(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsecolumn_definition() {
    var s0;

    s0 = peg$parseforeign_key();
    if (s0 === peg$FAILED) {
      s0 = peg$parseprimary_key();
      if (s0 === peg$FAILED) {
        s0 = peg$parsefield();
      }
    }

    return s0;
  }

  function peg$parsecolumn_definition_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecolumn_definition();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecolumn_definition();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecolumn_definition();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f205(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefield() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsefield_data_type();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsefield_constraint_list();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f206(s1, s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseident();
      if (s1 !== peg$FAILED) {
        s2 = peg$parse__();
        s3 = peg$parsefield_data_type();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f207(s1, s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseforeign_key() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22;

    s0 = peg$currPos;
    s1 = peg$parseKW_FOREIGN_KEY();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 !== peg$FAILED) {
          s6 = [];
          s7 = peg$currPos;
          s8 = peg$parse__();
          s9 = peg$parseCOMMA();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseident();
            if (s11 !== peg$FAILED) {
              s8 = [s8, s9, s10, s11];
              s7 = s8;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$currPos;
            s8 = peg$parse__();
            s9 = peg$parseCOMMA();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseident();
              if (s11 !== peg$FAILED) {
                s8 = [s8, s9, s10, s11];
                s7 = s8;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          }
          s7 = peg$parse__();
          s8 = peg$parseRPAREN();
          if (s8 !== peg$FAILED) {
            s9 = peg$parse__();
            s10 = peg$parseKW_REFERENCES();
            if (s10 !== peg$FAILED) {
              s11 = peg$parse__();
              s12 = peg$parseident();
              if (s12 !== peg$FAILED) {
                s13 = peg$parse__();
                s14 = peg$parseLPAREN();
                if (s14 !== peg$FAILED) {
                  s15 = peg$parse__();
                  s16 = peg$parseident();
                  if (s16 !== peg$FAILED) {
                    s17 = [];
                    s18 = peg$currPos;
                    s19 = peg$parse__();
                    s20 = peg$parseCOMMA();
                    if (s20 !== peg$FAILED) {
                      s21 = peg$parse__();
                      s22 = peg$parseident();
                      if (s22 !== peg$FAILED) {
                        s19 = [s19, s20, s21, s22];
                        s18 = s19;
                      } else {
                        peg$currPos = s18;
                        s18 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s18;
                      s18 = peg$FAILED;
                    }
                    while (s18 !== peg$FAILED) {
                      s17.push(s18);
                      s18 = peg$currPos;
                      s19 = peg$parse__();
                      s20 = peg$parseCOMMA();
                      if (s20 !== peg$FAILED) {
                        s21 = peg$parse__();
                        s22 = peg$parseident();
                        if (s22 !== peg$FAILED) {
                          s19 = [s19, s20, s21, s22];
                          s18 = s19;
                        } else {
                          peg$currPos = s18;
                          s18 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s18;
                        s18 = peg$FAILED;
                      }
                    }
                    s18 = peg$parse__();
                    s19 = peg$parseRPAREN();
                    if (s19 !== peg$FAILED) {
                      s20 = peg$parse__();
                      s21 = peg$parseforeign_key_on();
                      if (s21 === peg$FAILED) {
                        s21 = null;
                      }
                      peg$savedPos = s0;
                      s0 = peg$f208(s1, s5, s6, s10, s12, s16, s17, s21);
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseforeign_key_on() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_ON();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_DELETE();
      if (s3 === peg$FAILED) {
        s3 = peg$parseKW_UPDATE();
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_CASCADE();
        if (s5 === peg$FAILED) {
          s5 = peg$parseKW_SET_NULL();
          if (s5 === peg$FAILED) {
            s5 = peg$parseKW_SET_DEFAULT();
            if (s5 === peg$FAILED) {
              s5 = peg$parseKW_RESTRICT();
              if (s5 === peg$FAILED) {
                s5 = peg$parseKW_NO_ACTION();
              }
            }
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f209(s1, s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseprimary_key() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseKW_PRIMARY_KEY();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 !== peg$FAILED) {
          s6 = [];
          s7 = peg$currPos;
          s8 = peg$parse__();
          s9 = peg$parseCOMMA();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseident();
            if (s11 !== peg$FAILED) {
              s8 = [s8, s9, s10, s11];
              s7 = s8;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$currPos;
            s8 = peg$parse__();
            s9 = peg$parseCOMMA();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseident();
              if (s11 !== peg$FAILED) {
                s8 = [s8, s9, s10, s11];
                s7 = s8;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          }
          s7 = peg$parse__();
          s8 = peg$parseRPAREN();
          if (s8 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f210(s1, s5, s6);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefield_data_type() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseLPAREN();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseint();
        if (s5 !== peg$FAILED) {
          s6 = [];
          s7 = peg$currPos;
          s8 = peg$parse__();
          s9 = peg$parseCOMMA();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseint();
            if (s11 !== peg$FAILED) {
              s8 = [s8, s9, s10, s11];
              s7 = s8;
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$currPos;
            s8 = peg$parse__();
            s9 = peg$parseCOMMA();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseint();
              if (s11 !== peg$FAILED) {
                s8 = [s8, s9, s10, s11];
                s7 = s8;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          }
          s7 = peg$parse__();
          s8 = peg$parseRPAREN();
          if (s8 !== peg$FAILED) {
            peg$savedPos = s0;
            s0 = peg$f211(s1, s5, s6);
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseident();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f212(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsefield_constraint_list() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsefield_constraint();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsefield_constraint();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsefield_constraint();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f213(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsefield_constraint() {
    var s0;

    s0 = peg$parsefield_constraint_not_null();
    if (s0 === peg$FAILED) {
      s0 = peg$parsefield_constraint_primary_key();
      if (s0 === peg$FAILED) {
        s0 = peg$parsefield_constraint_unique();
        if (s0 === peg$FAILED) {
          s0 = peg$parsefield_constraint_auto_increment();
          if (s0 === peg$FAILED) {
            s0 = peg$parsefield_constraint_generated();
            if (s0 === peg$FAILED) {
              s0 = peg$parsefield_constraint_default();
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsefield_constraint_not_null() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsekeyword_not_null();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f214(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsekeyword_not_null() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_NOT_NULL();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f215(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsefield_constraint_primary_key() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsekeyword_primary_key();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f216(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsekeyword_primary_key() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_PRIMARY_KEY();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f217(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsefield_constraint_unique() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsekeyword_unique();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f218(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsekeyword_unique() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_UNIQUE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f219(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsefield_constraint_auto_increment() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsekeyword_auto_increment();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f220(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsekeyword_auto_increment() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_AUTO_INCREMENT();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f221(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsefield_constraint_generated() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseKW_GENERATED();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseconstraint_generated_option();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseconstraint_generated_data_type();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parsesequence_option_list_wrap();
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f222(s1, s3, s5, s7);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseconstraint_generated_option() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parsekeyword_always();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f223(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsekeyword_by_default();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f224(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsekeyword_by_default_on_null();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f225(s1);
        }
        s0 = s1;
      }
    }

    return s0;
  }

  function peg$parsefield_constraint_default() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_DEFAULT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseliteral();
      if (s3 === peg$FAILED) {
        s3 = peg$parseproc_func_call();
        if (s3 === peg$FAILED) {
          s3 = peg$parsespecial_system_function();
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f226(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsekeyword_always() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_ALWAYS();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f227(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsekeyword_by_default() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_BY_DEFAULT();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f228(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsekeyword_by_default_on_null() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_BY_DEFAULT_ON_NULL();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f229(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parseconstraint_generated_data_type() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_AS();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f230(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_option_list_wrap() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$parsesequence_option_list();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parseLPAREN();
      if (s2 !== peg$FAILED) {
        s3 = peg$parse__();
        s4 = peg$parsesequence_option_list();
        if (s4 !== peg$FAILED) {
          s5 = peg$parse__();
          s6 = peg$parseRPAREN();
          if (s6 !== peg$FAILED) {
            s2 = [s2, s3, s4, s5, s6];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f231(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parsesequence_option_list() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsesequence_option();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parsesequence_option();
      if (s5 !== peg$FAILED) {
        s4 = [s4, s5];
        s3 = s4;
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parsesequence_option();
        if (s5 !== peg$FAILED) {
          s4 = [s4, s5];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f232(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_option() {
    var s0;

    s0 = peg$parsesequence_option_increment();
    if (s0 === peg$FAILED) {
      s0 = peg$parsesequence_option_start();
      if (s0 === peg$FAILED) {
        s0 = peg$parsesequence_option_maxvalue();
        if (s0 === peg$FAILED) {
          s0 = peg$parsesequence_option_minvalue();
          if (s0 === peg$FAILED) {
            s0 = peg$parsesequence_option_no_maxvalue();
            if (s0 === peg$FAILED) {
              s0 = peg$parsesequence_option_no_minvalue();
              if (s0 === peg$FAILED) {
                s0 = peg$parsesequence_option_cache();
                if (s0 === peg$FAILED) {
                  s0 = peg$parsesequence_option_cycle();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parsesequence_option_no_cycle();
                    if (s0 === peg$FAILED) {
                      s0 = peg$parsesequence_option_owned_by();
                      if (s0 === peg$FAILED) {
                        s0 = peg$parsesequence_option_owned_by_none();
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }

    return s0;
  }

  function peg$parsesequence_option_increment() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_INCREMENT();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_BY();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseint();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f233(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_option_start() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseKW_START();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_WITH();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseint();
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f234(s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_option_maxvalue() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_MAXVALUE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseint();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f235(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_option_minvalue() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_MINVALUE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseint();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f236(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_option_no_maxvalue() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_NO_MAXVALUE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f237();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsesequence_option_no_minvalue() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_NO_MINVALUE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f238();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsesequence_option_cache() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_CACHE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseint();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f239(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_option_cycle() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_CYCLE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f240();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsesequence_option_no_cycle() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_NO_CYCLE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f241();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsesequence_option_owned_by() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseKW_OWNED_BY();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecolumn_ref();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f242(s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsesequence_option_owned_by_none() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_OWNED_BY_NONE();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f243();
    }
    s0 = s1;

    return s0;
  }

  function peg$parsealter_table_stmt() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parsealter_table_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseident();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parsealter_table_add_column();
        if (s5 === peg$FAILED) {
          s5 = peg$parsealter_table_drop_column();
          if (s5 === peg$FAILED) {
            s5 = peg$parsealter_table_modify_column();
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f244(s1, s3, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsealter_table_keyword() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_ALTER();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_TABLE();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f245(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsealter_table_add_column() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseadd_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsefield();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f246(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseadd_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_ADD();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f247(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsealter_table_drop_column() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsedrop_column_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsecolumn_node();
      if (s3 === peg$FAILED) {
        peg$savedPos = peg$currPos;
        s3 = peg$f248(s1);
        if (s3) {
          s3 = peg$FAILED;
        } else {
          s3 = undefined;
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f249(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedrop_column_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_DROP_COLUMN();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f250(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsealter_table_modify_column() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsemodify_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsefield();
      if (s3 === peg$FAILED) {
        peg$savedPos = peg$currPos;
        s3 = peg$f251(s1);
        if (s3) {
          s3 = peg$FAILED;
        } else {
          s3 = undefined;
        }
      }
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f252(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsemodify_keyword() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$currPos;
    s2 = peg$parseKW_MODIFY();
    if (s2 !== peg$FAILED) {
      s3 = peg$parse__();
      s4 = peg$parseKW_COLUMN();
      if (s4 !== peg$FAILED) {
        s2 = [s2, s3, s4];
        s1 = s2;
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
    } else {
      peg$currPos = s1;
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f253(s1);
    }
    s0 = s1;
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseKW_MODIFY();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f254(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$currPos;
        s2 = peg$parseKW_ALTER();
        if (s2 !== peg$FAILED) {
          s3 = peg$parse__();
          s4 = peg$parseKW_COLUMN();
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$f255(s1);
        }
        s0 = s1;
      }
    }

    return s0;
  }

  function peg$parsecreate_index_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_INDEX();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_IF_NOT_EXISTS();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseident();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseKW_ON();
          if (s9 !== peg$FAILED) {
            s10 = peg$parse__();
            s11 = peg$parseident();
            if (s11 !== peg$FAILED) {
              s12 = peg$parse__();
              s13 = peg$parseLPAREN();
              if (s13 !== peg$FAILED) {
                s14 = peg$parse__();
                s15 = peg$parsecolumn_list();
                if (s15 !== peg$FAILED) {
                  s16 = peg$parse__();
                  s17 = peg$parseRPAREN();
                  if (s17 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f256(s1, s3, s5, s7, s9, s11, s15);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_type_stmt() {
    var s0;

    s0 = peg$parsecreate_type_stmt_composite();
    if (s0 === peg$FAILED) {
      s0 = peg$parsecreate_type_stmt_enum();
      if (s0 === peg$FAILED) {
        s0 = peg$parsecreate_type_stmt_range();
        if (s0 === peg$FAILED) {
          s0 = peg$parsecreate_type_stmt_base();
        }
      }
    }

    return s0;
  }

  function peg$parsecreate_type_stmt_composite() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TYPE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_AS();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseLPAREN();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parsecomposite_type_field_list();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parseRPAREN();
                if (s13 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s0 = peg$f257(s1, s3, s5, s7, s11);
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecomposite_type_field() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parsefield_data_type();
      if (s3 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f258(s1, s3);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecomposite_type_field_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsecomposite_type_field();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parsecomposite_type_field();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parsecomposite_type_field();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f259(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_type_stmt_enum() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TYPE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_AS();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseKW_ENUM();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseLPAREN();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parsecreate_type_value_list();
                if (s13 !== peg$FAILED) {
                  s14 = peg$parse__();
                  s15 = peg$parseRPAREN();
                  if (s15 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f260(s1, s3, s5, s7, s9, s13);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_type_value_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseliteral_string();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseliteral_string();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseliteral_string();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f261(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_type_stmt_range() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TYPE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseKW_AS();
          if (s7 !== peg$FAILED) {
            s8 = peg$parse__();
            s9 = peg$parseKW_RANGE();
            if (s9 !== peg$FAILED) {
              s10 = peg$parse__();
              s11 = peg$parseLPAREN();
              if (s11 !== peg$FAILED) {
                s12 = peg$parse__();
                s13 = peg$parseassign_value_expr_list();
                if (s13 !== peg$FAILED) {
                  s14 = peg$parse__();
                  s15 = peg$parseRPAREN();
                  if (s15 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s0 = peg$f262(s1, s3, s5, s7, s9, s13);
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseassign_value_expr() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      if (input.charCodeAt(peg$currPos) === 61) {
        s3 = peg$c4;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$e6); }
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 === peg$FAILED) {
          s5 = peg$parseliteral_numeric();
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f263(s1, s5);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseident();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$f264(s1);
      }
      s0 = s1;
    }

    return s0;
  }

  function peg$parseassign_value_expr_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseassign_value_expr();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseassign_value_expr();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseassign_value_expr();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f265(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsecreate_type_stmt_base() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

    s0 = peg$currPos;
    s1 = peg$parseKW_CREATE();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TYPE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseident();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$currPos;
          s8 = peg$parseLPAREN();
          if (s8 !== peg$FAILED) {
            s9 = peg$parse__();
            s10 = peg$parseassign_value_expr_list();
            if (s10 !== peg$FAILED) {
              s11 = peg$parse__();
              s12 = peg$parseRPAREN();
              if (s12 !== peg$FAILED) {
                s8 = [s8, s9, s10, s11, s12];
                s7 = s8;
              } else {
                peg$currPos = s7;
                s7 = peg$FAILED;
              }
            } else {
              peg$currPos = s7;
              s7 = peg$FAILED;
            }
          } else {
            peg$currPos = s7;
            s7 = peg$FAILED;
          }
          if (s7 === peg$FAILED) {
            s7 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f266(s1, s3, s5, s7);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedrop_type_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

    s0 = peg$currPos;
    s1 = peg$parseKW_DROP();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_TYPE();
      if (s3 !== peg$FAILED) {
        s4 = peg$parse__();
        s5 = peg$parseKW_IF_EXISTS();
        if (s5 === peg$FAILED) {
          s5 = null;
        }
        s6 = peg$parse__();
        s7 = peg$parseident_list();
        if (s7 !== peg$FAILED) {
          s8 = peg$parse__();
          s9 = peg$parseKW_CASCADE();
          if (s9 === peg$FAILED) {
            s9 = peg$parseKW_RESTRICT();
          }
          if (s9 === peg$FAILED) {
            s9 = null;
          }
          peg$savedPos = s0;
          s0 = peg$f267(s1, s3, s5, s7, s9);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsedrop_view_stmt() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parsedrop_view_keyword();
    if (s1 !== peg$FAILED) {
      s2 = peg$parse__();
      s3 = peg$parseKW_IF_EXISTS();
      if (s3 === peg$FAILED) {
        s3 = null;
      }
      s4 = peg$parse__();
      s5 = peg$parseview_ref_list();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseKW_CASCADE();
        if (s7 === peg$FAILED) {
          s7 = peg$parseKW_RESTRICT();
        }
        if (s7 === peg$FAILED) {
          s7 = null;
        }
        peg$savedPos = s0;
        s0 = peg$f268(s1, s3, s5, s7);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseview_ref_list() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parseview_ref();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$currPos;
      s4 = peg$parse__();
      s5 = peg$parseCOMMA();
      if (s5 !== peg$FAILED) {
        s6 = peg$parse__();
        s7 = peg$parseview_ref();
        if (s7 !== peg$FAILED) {
          s4 = [s4, s5, s6, s7];
          s3 = s4;
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      } else {
        peg$currPos = s3;
        s3 = peg$FAILED;
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$currPos;
        s4 = peg$parse__();
        s5 = peg$parseCOMMA();
        if (s5 !== peg$FAILED) {
          s6 = peg$parse__();
          s7 = peg$parseview_ref();
          if (s7 !== peg$FAILED) {
            s4 = [s4, s5, s6, s7];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
      }
      peg$savedPos = s0;
      s0 = peg$f269(s1, s2);
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseview_ref() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseident();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f270(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsedrop_view_keyword() {
    var s0, s1;

    s0 = peg$currPos;
    s1 = peg$parseKW_DROP_VIEW();
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f271(s1);
    }
    s0 = s1;

    return s0;
  }


  var reservedMap = module.exports.reservedMap || {};

  function debug(str){
    console.log(str);
  }

  function createUnaryExpr(op, e) {
    return {
      type     : 'unary_expr',
      operator : op,
      expr     : e
    }
  }

  function createBinaryExpr(op, left, right) {
    return {
      type      : 'binary_expr',
      operator  : op,
      left      : left,
      right     : right,
      location  : location()
    }  
  }

  function createList(head, tail, idx=3) {
    var result = [head];
    for (var i = 0; i < tail.length; i++) {
      result.push(tail[i][idx]);
    }
    return result;
  }

  function createExprList(head, tail, room) {
    var epList = createList(head, tail);
    var exprList  = [];
    var ep;
    for (var i = 0; i < epList.length; i++) {
      ep = epList[i]; 
      if (ep && ep.type == 'param') {
        ep.room = room;
        ep.pos  = i;
      } else {
        exprList.push(ep);  
      }
    }
    return exprList;
  }

  function createBinaryExprChain(head, tail) {
    var result = head;
    for (var i = 0; i < tail.length; i++) {
      result = createBinaryExpr(tail[i][1], result, tail[i][3]);
    }
    return result;
  }

  function makeKeywordNode(val, location) {
    return {
      type: 'keyword',
      value: val,
      location: location
    }
  }

  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}

module.exports = {
  SyntaxError: peg$SyntaxError,
  parse: peg$parse
};
