"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const yargs_1 = __importDefault(require("yargs"));
const helpers_1 = require("yargs/helpers");
const createServer_1 = require("../src/createServer");
(0, yargs_1.default)((0, helpers_1.hideBin)(process.argv))
    .usage('SQL Language Server Command Line Interface')
    .command('up', 'run sql-language-server', (v) => {
    return v.option('method', {
        alias: 'm',
        type: 'string',
        default: 'node-ipc',
        choices: ['stdio', 'node-ipc'],
        describe: 'What use to communicate with sql language server'
    }).option('debug', {
        alias: 'd',
        type: 'boolean',
        default: false,
        describe: 'Enable debug logging'
    });
}, (v) => {
    (0, createServer_1.createServer)({ method: v.method, debug: v.debug });
    process.stdin.resume();
})
    .example('$0 up --method stdio', ': start up sql-language-server - communicate via stdio')
    .demandCommand()
    .help()
    .parse();
process.stdin.on('close', () => {
    process.exit(0);
});
//# sourceMappingURL=cli.js.map