/// <reference types="node" />
import EventEmitter from 'events';
export declare type SSHConfig = {
    remoteHost: string;
    remotePort?: number;
    dbHost?: string;
    dbPort?: number;
    user?: string;
    passphrase?: string;
    identityFile?: string;
};
export declare type Connection = {
    name: string | null;
    adapter: 'json' | 'mysql' | 'postgresql' | 'postgres' | 'sqlite3' | 'bigquery' | null;
    host: string | null;
    port: number | null;
    user: string | null;
    database: string | null;
    password: string | null;
    filename: string | null;
    keyFile: string | null;
    projectId: string | null;
    projectPaths: string[];
    ssh: SSHConfig | null;
    jupyterLabMode: boolean;
};
declare type PersonalConfig = {
    connections: Connection[];
};
export default class SettingStore extends EventEmitter.EventEmitter {
    private personalConfig;
    private state;
    private static instance;
    private constructor();
    static getInstance(): SettingStore;
    getSetting(): Connection;
    getPersonalConfig(): PersonalConfig;
    changeConnection(connectionName: string): Promise<void>;
    setSettingFromFile(personalConfigPath: string, projectConfigPath: string, projectPath: string): Promise<Connection | null>;
    setSettingFromWorkspaceConfig(connections: Connection[], projectPath?: string): Promise<Connection>;
    setSetting(setting: Partial<Connection>): void;
    private extractPersonalConfigMatchedProjectPath;
}
export {};
