"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const events_1 = __importDefault(require("events"));
const log4js_1 = __importDefault(require("log4js"));
const logger = log4js_1.default.getLogger();
function fileExists(filePath) {
    try {
        return fs.statSync(path.resolve(filePath)).isFile();
    }
    catch (e) {
        const err = e;
        if (err && err.code === 'ENOENT') {
            return false;
        }
        throw err;
    }
}
function readFile(filePath) {
    return fs.readFileSync(path.resolve(filePath), 'utf8').replace(/^\ufeff/u, '');
}
class SettingStore extends events_1.default.EventEmitter {
    constructor() {
        super();
        this.personalConfig = { connections: [] };
        this.state = {
            name: null,
            adapter: null,
            host: null,
            port: null,
            user: null,
            database: null,
            password: null,
            ssh: null,
            filename: null,
            keyFile: null,
            projectId: null,
            projectPaths: [],
            jupyterLabMode: false,
        };
    }
    static getInstance() {
        if (SettingStore.instance) {
            return SettingStore.instance;
        }
        SettingStore.instance = new SettingStore();
        return SettingStore.instance;
    }
    getSetting() {
        return Object.assign({}, this.state);
    }
    getPersonalConfig() {
        return this.personalConfig;
    }
    async changeConnection(connectionName) {
        const config = this.personalConfig.connections.find((v) => v.name === connectionName);
        if (!config) {
            const errorMessage = `not find connection name: ${connectionName}`;
            logger.error(errorMessage);
            throw new Error(errorMessage);
        }
        this.setSetting(config);
    }
    async setSettingFromFile(personalConfigPath, projectConfigPath, projectPath) {
        let personalConfig = { connections: [] }, projectConfig = {};
        if (fileExists(personalConfigPath)) {
            personalConfig = JSON.parse(readFile(personalConfigPath));
            this.personalConfig = personalConfig;
            logger.debug(`Found personalConfig. ${JSON.stringify(personalConfig)}`);
        }
        else {
            logger.debug(`There isn't personal config file. ${personalConfigPath}`);
        }
        if (fileExists(projectConfigPath)) {
            projectConfig = JSON.parse(readFile(projectConfigPath));
        }
        else {
            logger.debug(`There isn't project config file., ${projectConfigPath}`);
        }
        const extractedPersonalConfig = projectConfig.name
            ? personalConfig.connections.find((v) => v.name === projectConfig.name)
            : this.extractPersonalConfigMatchedProjectPath(projectPath);
        const sshConfig = Object.assign(Object.assign({}, ((extractedPersonalConfig === null || extractedPersonalConfig === void 0 ? void 0 : extractedPersonalConfig.ssh) || {})), ((projectConfig === null || projectConfig === void 0 ? void 0 : projectConfig.ssh) || {}));
        const config = Object.assign(Object.assign({}, extractedPersonalConfig), projectConfig);
        config.ssh = sshConfig;
        this.setSetting(config);
        return this.getSetting();
    }
    async setSettingFromWorkspaceConfig(connections, projectPath = '') {
        this.personalConfig = { connections };
        let extractedPersonalConfig = this.extractPersonalConfigMatchedProjectPath(projectPath);
        // Default to first connection if none are matched
        if (extractedPersonalConfig == undefined) {
            if ((connections === null || connections === void 0 ? void 0 : connections.length) > 0) {
                extractedPersonalConfig = connections[0];
            }
        }
        this.setSetting(extractedPersonalConfig || {});
        return this.getSetting();
    }
    setSetting(setting) {
        logger.debug(`Set config: ${JSON.stringify(setting)}`);
        // TODO: remove any
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const replaceEnv = (v) => {
            for (const k in v) {
                if (v[k] && typeof v[k] === 'object') {
                    replaceEnv(v[k]);
                }
                else if (typeof v[k] === 'string') {
                    const matched = v[k].match(/\${env:(.*?)}/);
                    if (matched) {
                        v[k] = v[k].replace(`\${env:${matched[1]}}`, process.env[matched[1]] || '');
                    }
                }
            }
        };
        const newSetting = Object.assign({}, setting);
        newSetting.ssh = newSetting.ssh ? Object.assign({}, newSetting.ssh) : null;
        replaceEnv(newSetting);
        this.state = Object.assign({}, this.state, newSetting);
        logger.debug('setting store, emit "change"');
        this.emit('change', this.state);
    }
    extractPersonalConfigMatchedProjectPath(projectPath) {
        const con = this.personalConfig.connections.find((v) => { var _a; return (_a = v.projectPaths) === null || _a === void 0 ? void 0 : _a.includes(projectPath); });
        if (!con) {
            logger.debug(`Not found personal config, { path: ${projectPath} }`);
        }
        return con;
    }
}
exports.default = SettingStore;
//# sourceMappingURL=SettingStore.js.map