"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const log4js_1 = __importDefault(require("log4js"));
const logger = log4js_1.default.getLogger();
class Cache {
    constructor() {
        this._lintResult = new Map();
    }
    setLintCache(uri, lintCache) {
        this._lintResult.set(uri, lintCache);
        logger.debug(this.getLintCache(uri));
    }
    getLintCache(uri) {
        return this._lintResult.get(uri) || [];
    }
    findLintCacheByRange(uri, range) {
        const lintCacheList = this.getLintCache(uri);
        let minDistance = Number.MAX_VALUE;
        let result = null;
        lintCacheList
            .filter((v) => {
            if (v.diagnostic.range.start.line > range.start.line ||
                v.diagnostic.range.end.line < range.end.line) {
                return false;
            }
            if (v.diagnostic.range.start.line <= range.start.line &&
                v.diagnostic.range.end.line > range.end.line) {
                return true;
            }
            return (v.diagnostic.range.start.character <= range.start.character &&
                v.diagnostic.range.end.character >= range.end.character);
        })
            .forEach((v) => {
            const distance = Math.abs(v.diagnostic.range.start.character - range.start.character);
            if (distance < minDistance) {
                minDistance = distance;
                result = v;
            }
        });
        return result;
    }
}
exports.default = new Cache();
//# sourceMappingURL=cache.js.map