import { ColumnRefNode, FromTableNode, SelectStatement, NodeRange } from '@joe-re/sql-parser';
import { Table } from '../database_libs/AbstractClient';
import { Pos } from './complete';
export declare function getColumnRefByPos(columns: ColumnRefNode[], pos: Pos): ColumnRefNode | null;
export declare function isPosInLocation(location: NodeRange, pos: Pos): boolean;
export declare function createTablesFromFromNodes(fromNodes: FromTableNode[]): Table[];
export declare function findColumnAtPosition(ast: SelectStatement, pos: Pos): ColumnRefNode | null;
/**
 * Recursively pull out the FROM nodes (including sub-queries)
 * @param tableNodes
 * @returns
 */
export declare function getAllNestedFromNodes(tableNodes: FromTableNode[]): FromTableNode[];
/**
 * Finds the most deeply nested FROM node that have a range encompasing the position.
 * In cases such as SELECT * FROM T1 JOIN (SELECT * FROM (SELECT * FROM T2 <pos>))
 * We will get a list of nodes like this
 * SELECT * FROM T1
 * (SELECT * FROM
 *    (SELECT * FROM T2))
 * The idea is to reverse the list so that the most nested queries come first. Then
 * apply a filter to keep only the FROM nodes which encompass the position and take
 * the first one from that resulting list.
 * @param fromNodes
 * @param pos
 * @returns
 */
export declare function getNearestFromTableFromPos(fromNodes: FromTableNode[], pos: Pos): FromTableNode | null;
/**
 * Test if the given table matches the fromNode.
 * @param fromNode
 * @param table
 * @returns
 */
export declare function isTableMatch(fromNode: FromTableNode, table: Table): boolean;
