"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toCompletionItemForKeyword = exports.toCompletionItemForAlias = exports.toCompletionItemForFunction = exports.ICONS = void 0;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
exports.ICONS = {
    KEYWORD: vscode_languageserver_types_1.CompletionItemKind.Text,
    COLUMN: vscode_languageserver_types_1.CompletionItemKind.Interface,
    TABLE: vscode_languageserver_types_1.CompletionItemKind.Field,
    FUNCTION: vscode_languageserver_types_1.CompletionItemKind.Property,
    ALIAS: vscode_languageserver_types_1.CompletionItemKind.Variable,
    UTILITY: vscode_languageserver_types_1.CompletionItemKind.Event,
};
function toCompletionItemForFunction(f) {
    const item = {
        label: f.name,
        detail: 'function',
        kind: exports.ICONS.FUNCTION,
        documentation: f.description,
    };
    return item;
}
exports.toCompletionItemForFunction = toCompletionItemForFunction;
function toCompletionItemForAlias(alias) {
    const item = {
        label: alias,
        detail: 'alias',
        kind: exports.ICONS.ALIAS,
    };
    return item;
}
exports.toCompletionItemForAlias = toCompletionItemForAlias;
function toCompletionItemForKeyword(name) {
    const item = {
        label: name,
        kind: exports.ICONS.KEYWORD,
        detail: 'keyword',
    };
    return item;
}
exports.toCompletionItemForKeyword = toCompletionItemForKeyword;
//# sourceMappingURL=CompletionItemUtils.js.map