import { CompletionItem, CompletionItemKind } from 'vscode-languageserver-types';
export declare const ICONS: {
    KEYWORD: 1;
    COLUMN: 8;
    TABLE: 5;
    FUNCTION: 10;
    ALIAS: 6;
    UTILITY: 23;
};
declare type OnClause = 'FROM' | 'ALTER TABLE' | 'OTHERS';
export declare class Identifier {
    lastToken: string;
    identifier: string;
    detail: string;
    kind: CompletionItemKind;
    onClause: OnClause;
    constructor(lastToken: string, identifier: string, detail: string, kind: CompletionItemKind, onClause?: OnClause);
    matchesLastToken(): boolean;
    toCompletionItem(): CompletionItem;
}
export {};
