"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Identifier = exports.ICONS = void 0;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const StringUtils_1 = require("./StringUtils");
exports.ICONS = {
    KEYWORD: vscode_languageserver_types_1.CompletionItemKind.Text,
    COLUMN: vscode_languageserver_types_1.CompletionItemKind.Interface,
    TABLE: vscode_languageserver_types_1.CompletionItemKind.Field,
    FUNCTION: vscode_languageserver_types_1.CompletionItemKind.Property,
    ALIAS: vscode_languageserver_types_1.CompletionItemKind.Variable,
    UTILITY: vscode_languageserver_types_1.CompletionItemKind.Event,
};
class Identifier {
    constructor(lastToken, identifier, detail, kind, onClause) {
        this.lastToken = lastToken;
        this.identifier = identifier;
        this.detail = detail !== null && detail !== void 0 ? detail : '';
        this.kind = kind;
        this.onClause = onClause !== null && onClause !== void 0 ? onClause : 'OTHERS';
    }
    matchesLastToken() {
        if (this.identifier.startsWith(this.lastToken)) {
            // prevent suggesting the lastToken itself, there is nothing to complete in that case
            if (this.identifier !== this.lastToken) {
                return true;
            }
        }
        return false;
    }
    toCompletionItem() {
        const idx = this.lastToken.lastIndexOf('.');
        const label = this.identifier.substring(idx + 1);
        let kindName;
        let tableAlias = '';
        if (this.kind === exports.ICONS.TABLE) {
            let tableName = label;
            const i = tableName.lastIndexOf('.');
            if (i > 0) {
                tableName = label.substring(i + 1);
            }
            tableAlias = this.onClause === 'FROM' ? (0, StringUtils_1.makeTableAlias)(tableName) : '';
            kindName = 'table';
        }
        else {
            kindName = 'column';
        }
        const item = {
            label: label,
            detail: `${kindName} ${this.detail}`,
            kind: this.kind,
        };
        if (this.kind === exports.ICONS.TABLE) {
            if (tableAlias) {
                item.insertText = `${label} AS ${tableAlias}`;
            }
            else {
                item.insertText = label;
            }
        }
        return item;
    }
}
exports.Identifier = Identifier;
//# sourceMappingURL=Identifier.js.map