"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeColumnName = exports.getAliasFromFromTableNode = exports.makeTableName = exports.getRidOfAfterPosString = exports.makeTableAlias = void 0;
function makeTableAlias(tableName) {
    if (tableName.length > 3) {
        return tableName.substring(0, 3);
    }
    return tableName;
}
exports.makeTableAlias = makeTableAlias;
function getRidOfAfterPosString(sql, pos) {
    return sql
        .split('\n')
        .filter((_v, idx) => pos.line >= idx)
        .map((v, idx) => (idx === pos.line ? v.slice(0, pos.column) : v))
        .join('\n');
}
exports.getRidOfAfterPosString = getRidOfAfterPosString;
function makeTableName(table) {
    if (table.catalog) {
        return table.catalog + '.' + table.database + '.' + table.tableName;
    }
    else if (table.database) {
        return table.database + '.' + table.tableName;
    }
    return table.tableName;
}
exports.makeTableName = makeTableName;
function getAliasFromFromTableNode(node) {
    if (node.as) {
        return node.as;
    }
    if (node.type === 'table') {
        return node.table;
    }
    return '';
}
exports.getAliasFromFromTableNode = getAliasFromFromTableNode;
function makeColumnName(alias, columnName) {
    return alias ? alias + '.' + columnName : columnName;
}
exports.makeColumnName = makeColumnName;
//# sourceMappingURL=StringUtils.js.map