"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAliasCandidates = void 0;
const CompletionItemUtils_1 = require("../CompletionItemUtils");
function createAliasCandidates(fromNodes, token) {
    return fromNodes
        .map((fromNode) => fromNode.as)
        .filter((aliasName) => aliasName && aliasName.startsWith(token))
        .map((aliasName) => (0, CompletionItemUtils_1.toCompletionItemForAlias)(aliasName || ''));
}
exports.createAliasCandidates = createAliasCandidates;
//# sourceMappingURL=createAliasCandidates.js.map