"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBasicKeywordCandidates = void 0;
const CompletionItemUtils_1 = require("../CompletionItemUtils");
const CLAUSES = [
    'SELECT',
    'WHERE',
    'ORDER BY',
    'GROUP BY',
    'LIMIT',
    '--',
    '/*',
    '(',
];
function createBasicKeywordCandidates() {
    return CLAUSES.map((v) => (0, CompletionItemUtils_1.toCompletionItemForKeyword)(v));
}
exports.createBasicKeywordCandidates = createBasicKeywordCandidates;
//# sourceMappingURL=createBasicKeywordCandidates.js.map