"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCandidatesForScopedColumns = exports.createCandidatesForColumnsOfAnyTable = void 0;
const StringUtils_1 = require("../StringUtils");
const AstUtils_1 = require("../AstUtils");
const CompletionItemUtils_1 = require("../CompletionItemUtils");
const Identifier_1 = require("../Identifier");
function createCandidatesForColumnsOfAnyTable(tables, lastToken) {
    return tables
        .flatMap((table) => table.columns)
        .map((column) => {
        return new Identifier_1.Identifier(lastToken, column.columnName, column.description, CompletionItemUtils_1.ICONS.TABLE);
    })
        .filter((item) => item.matchesLastToken())
        .map((item) => item.toCompletionItem());
}
exports.createCandidatesForColumnsOfAnyTable = createCandidatesForColumnsOfAnyTable;
function createCandidatesForScopedColumns(fromNodes, tables, lastToken) {
    return tables
        .flatMap((table) => {
        return fromNodes
            .filter((fromNode) => (0, AstUtils_1.isTableMatch)(fromNode, table))
            .map(StringUtils_1.getAliasFromFromTableNode)
            .filter((alias) => lastToken.startsWith(alias + '.'))
            .flatMap((alias) => table.columns.map((col) => {
            return new Identifier_1.Identifier(lastToken, (0, StringUtils_1.makeColumnName)(alias, col.columnName), col.description, CompletionItemUtils_1.ICONS.COLUMN);
        }));
    })
        .filter((item) => item.matchesLastToken())
        .map((item) => item.toCompletionItem());
}
exports.createCandidatesForScopedColumns = createCandidatesForScopedColumns;
//# sourceMappingURL=createColumnCandidates.js.map