"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFunctionCandidates = void 0;
const CompletionItemUtils_1 = require("../CompletionItemUtils");
function createFunctionCandidates(functions, token) {
    var _a;
    const lowerToken = (_a = token === null || token === void 0 ? void 0 : token.toLocaleLowerCase()) !== null && _a !== void 0 ? _a : '';
    const isTypedUpper = token !== lowerToken;
    const targets = functions.filter((v) => v.name.startsWith(lowerToken));
    return (targets
        // Search using lowercase prefix
        .filter((v) => v.name.startsWith(lowerToken))
        // If typed string is in upper case, then return upper case suggestions
        .map((v) => {
        if (isTypedUpper)
            v.name = v.name.toUpperCase();
        return v;
    })
        .map((v) => (0, CompletionItemUtils_1.toCompletionItemForFunction)(v)));
}
exports.createFunctionCandidates = createFunctionCandidates;
//# sourceMappingURL=createFunctionCandidates.js.map