"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createJoinCondidates = void 0;
const AstUtils_1 = require("../AstUtils");
const CompletionItemUtils_1 = require("../CompletionItemUtils");
const createTableCandidates_1 = require("./createTableCandidates");
function createJoinCondidates(ast, tables, pos, token) {
    var _a, _b;
    if (!Array.isArray((_a = ast.from) === null || _a === void 0 ? void 0 : _a.tables)) {
        return [];
    }
    const result = [];
    const fromTable = (0, AstUtils_1.getNearestFromTableFromPos)(((_b = ast.from) === null || _b === void 0 ? void 0 : _b.tables) || [], pos);
    if (fromTable && fromTable.type === 'table') {
        result.push(...(0, createTableCandidates_1.createTableCandidates)(tables, token, true));
        result.push((0, CompletionItemUtils_1.toCompletionItemForKeyword)('INNER JOIN'));
        result.push((0, CompletionItemUtils_1.toCompletionItemForKeyword)('LEFT JOIN'));
        result.push((0, CompletionItemUtils_1.toCompletionItemForKeyword)('ON'));
    }
    return result;
}
exports.createJoinCondidates = createJoinCondidates;
//# sourceMappingURL=createJoinCandidates.js.map