"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createJoinTablesCandidates = void 0;
const StringUtils_1 = require("../StringUtils");
const AstUtils_1 = require("../AstUtils");
const CompletionItemUtils_1 = require("../CompletionItemUtils");
function createJoinTablesCandidates(tables, expected, fromNodes, token) {
    if (!(fromNodes && fromNodes.length > 0)) {
        return [];
    }
    let joinType = '';
    if ('INNER'.startsWith(token || '')) {
        joinType = 'INNER';
    }
    else if ('LEFT'.startsWith(token || '')) {
        joinType = 'LEFT';
    }
    else if ('RIGH'.startsWith(token || '')) {
        joinType = 'RIGHT';
    }
    if (!joinType) {
        return [];
    }
    const isExpectedJoinKeyWord = !!expected
        .map((v) => v.text)
        .find((v) => v === 'JOIN');
    if (!isExpectedJoinKeyWord) {
        return [];
    }
    const fromNode = fromNodes[0];
    const fromAlias = (0, StringUtils_1.getAliasFromFromTableNode)(fromNode);
    const fromTable = tables.find((table) => (0, AstUtils_1.isTableMatch)(fromNode, table));
    return tables
        .filter((table) => table !== fromTable)
        .reduce((c, p) => {
        const newItems = p.columns
            .filter((column) => fromTable === null || fromTable === void 0 ? void 0 : fromTable.columns.map((col) => col.columnName).includes(column.columnName))
            .map((column) => {
            return {
                tableName: (0, StringUtils_1.makeTableName)(p),
                alias: (0, StringUtils_1.makeTableAlias)(p.tableName),
                columnName: column.columnName,
            };
        })
            .map((match) => {
            const label = `${joinType} JOIN ${match.tableName} AS ${match.alias} ON ${match.alias}.${match.columnName} = ${fromAlias}.${match.columnName}`;
            return {
                label: label,
                detail: 'utility',
                kind: CompletionItemUtils_1.ICONS.UTILITY,
            };
        });
        return c.concat(newItems);
    }, []);
}
exports.createJoinTablesCandidates = createJoinTablesCandidates;
//# sourceMappingURL=createJoinTableCndidates.js.map