"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSelectAllColumnsCandidates = void 0;
const StringUtils_1 = require("../StringUtils");
const StringUtils_2 = require("../StringUtils");
const AstUtils_1 = require("../AstUtils");
const CompletionItemUtils_1 = require("../CompletionItemUtils");
function createSelectAllColumnsCandidates(fromNodes, tables, lastToken) {
    return tables.flatMap((table) => {
        return fromNodes
            .filter((fromNode) => (0, AstUtils_1.isTableMatch)(fromNode, table))
            .map(StringUtils_2.getAliasFromFromTableNode)
            .filter(() => lastToken.toUpperCase() === 'SELECT' || // complete SELECT keyword
            lastToken === '') // complete at space after SELECT
            .map((alias) => {
            const columnNames = table.columns
                .map((col) => (0, StringUtils_1.makeColumnName)(alias, col.columnName))
                .join(',\n');
            const label = `Select all columns from ${alias}`;
            let prefix = '';
            if (lastToken) {
                prefix = lastToken + '\n';
            }
            return {
                label: label,
                insertText: prefix + columnNames,
                filterText: prefix + label,
                detail: 'utility',
                kind: CompletionItemUtils_1.ICONS.UTILITY,
            };
        });
    });
}
exports.createSelectAllColumnsCandidates = createSelectAllColumnsCandidates;
//# sourceMappingURL=createSelectAllColumnsCandidates.js.map