"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTableCandidates = void 0;
const Identifier_1 = require("../Identifier");
const CompletionItemUtils_1 = require("../CompletionItemUtils");
/**
 * Given a table returns all possible ways to refer to it.
 * That is by table name only, using the database scope,
 * using the catalog and database scopes.
 * @param table
 * @returns
 */
function allTableNameCombinations(table) {
    const names = [table.tableName];
    if (table.database)
        names.push(table.database + '.' + table.tableName);
    if (table.catalog)
        names.push(table.catalog + '.' + table.database + '.' + table.tableName);
    return names;
}
function createTableCandidates(tables, lastToken, onFromClause) {
    return tables
        .flatMap((table) => allTableNameCombinations(table))
        .map((aTableNameVariant) => {
        return new Identifier_1.Identifier(lastToken, aTableNameVariant, '', CompletionItemUtils_1.ICONS.TABLE, onFromClause ? 'FROM' : 'OTHERS');
    })
        .filter((item) => item.matchesLastToken())
        .map((item) => item.toCompletionItem());
}
exports.createTableCandidates = createTableCandidates;
//# sourceMappingURL=createTableCandidates.js.map