"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const main_1 = require("vscode-languageserver/lib/node/main");
const main_2 = require("vscode-jsonrpc/lib/node/main");
const log4js_1 = __importDefault(require("log4js"));
const logger = log4js_1.default.getLogger();
function createConnection(method) {
    logger.debug(`createConnection: method {${method}}`);
    switch (method) {
        case 'stdio':
            return (0, main_1.createConnection)(process.stdin, process.stdout);
        case 'node-ipc':
        default:
            return (0, main_1.createConnection)(new main_2.IPCMessageReader(process), new main_2.IPCMessageWriter(process));
    }
}
exports.default = createConnection;
//# sourceMappingURL=createConnection.js.map