"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sql_parser_1 = require("@joe-re/sql-parser");
const log4js_1 = __importDefault(require("log4js"));
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const sqlint_1 = require("sqlint");
const cache_1 = __importDefault(require("./cache"));
const logger = log4js_1.default.getLogger();
function doLint(uri, sql, config) {
    if (!sql) {
        return [];
    }
    const result = JSON.parse((0, sqlint_1.lint)({
        configPath: process.cwd(),
        formatType: 'json',
        text: sql,
        configObject: config,
    }));
    const lintDiagnostics = result.map((v) => v.diagnostics).flat();
    const lintCache = [];
    const diagnostics = lintDiagnostics.map((v) => {
        const diagnostic = {
            range: {
                start: {
                    line: v.location.start.line - 1,
                    character: v.location.start.column - 1,
                },
                end: {
                    line: v.location.end.line - 1,
                    character: v.location.end.column - 1,
                },
            },
            message: v.message,
            severity: v.errorLevel === sqlint_1.ErrorLevel.Error
                ? vscode_languageserver_types_1.DiagnosticSeverity.Error
                : vscode_languageserver_types_1.DiagnosticSeverity.Warning,
            source: 'sql',
            relatedInformation: [],
        };
        lintCache.push({ diagnostic, lint: v });
        return diagnostic;
    });
    cache_1.default.setLintCache(uri, lintCache);
    return diagnostics;
}
function createDiagnostics(uri, sql, config) {
    logger.debug(`createDiagnostics`);
    let diagnostics = [];
    try {
        const ast = (0, sql_parser_1.parse)(sql);
        logger.debug(`ast: ${JSON.stringify(ast)}`);
        diagnostics = doLint(uri, sql, config);
    }
    catch (e) {
        const err = e;
        logger.debug('parse error');
        logger.debug(e);
        cache_1.default.setLintCache(uri, []);
        if (err.name !== 'SyntaxError') {
            throw e;
        }
        const pe = e;
        diagnostics.push({
            range: {
                start: {
                    line: pe.location.start.line - 1,
                    character: pe.location.start.column,
                },
                end: {
                    line: pe.location.end.line - 1,
                    character: pe.location.end.column,
                },
            },
            message: pe.message,
            severity: vscode_languageserver_types_1.DiagnosticSeverity.Error,
            // code: number | string,
            source: 'sql',
            relatedInformation: [],
        });
    }
    logger.debug(`diagnostics: ${JSON.stringify(diagnostics)}`);
    return { uri: uri, diagnostics };
}
exports.default = createDiagnostics;
//# sourceMappingURL=createDiagnostics.js.map