import { Connection } from '../SettingStore';
export declare type RawField = {
    field: string;
    type: string;
    null: 'Yes' | 'No';
    default: string;
    comment: string;
};
export declare type Column = {
    columnName: string;
    description: string;
};
export declare type Table = {
    catalog: string | null;
    database: string | null;
    tableName: string;
    columns: Column[];
};
export declare type DbFunction = {
    name: string;
    description: string;
};
export declare type Schema = {
    tables: Table[];
    functions: DbFunction[];
};
export default abstract class AbstractClient {
    protected settings: Connection;
    connection: unknown;
    constructor(settings: Connection);
    abstract connect(): Promise<boolean> | boolean;
    abstract disconnect(): void;
    abstract getTables(): Promise<string[]>;
    abstract getColumns(tableName: string): Promise<RawField[]>;
    abstract DefaultPort: number;
    abstract DefaultHost: string;
    abstract DefaultUser: string;
    getSchema(): Promise<Schema>;
    private toColumnFromRawField;
}
