"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const log4js_1 = __importDefault(require("log4js"));
const node_ssh_forward_1 = require("node-ssh-forward");
const logger = log4js_1.default.getLogger();
class AbstractClient {
    constructor(settings) {
        this.settings = settings;
    }
    async getSchema() {
        var _a, _b, _c;
        const schema = { tables: [], functions: [] };
        const sshConnection = ((_a = this.settings.ssh) === null || _a === void 0 ? void 0 : _a.remoteHost)
            ? new node_ssh_forward_1.SSHConnection({
                endHost: this.settings.ssh.remoteHost,
                username: this.settings.ssh.user,
                privateKey: (0, fs_1.readFileSync)(this.settings.ssh.identityFile || `${process.env.HOME}/.ssh/id_rsa`),
                passphrase: this.settings.ssh.passphrase || '',
            })
            : null;
        if (sshConnection) {
            await sshConnection
                .forward({
                fromPort: this.settings.port || this.DefaultPort,
                toPort: ((_b = this.settings.ssh) === null || _b === void 0 ? void 0 : _b.dbPort) || this.DefaultPort,
                toHost: ((_c = this.settings.ssh) === null || _c === void 0 ? void 0 : _c.dbHost) || '127.0.0.1',
            })
                .then((v) => {
                if (v) {
                    logger.error('Failed to ssh remote server');
                    logger.error(v);
                }
                return [];
            });
        }
        if (!(await this.connect())) {
            logger.error('AbstractClinet.getSchema: failed to connect database');
            return { tables: [], functions: [] };
        }
        try {
            const tables = await this.getTables();
            schema.tables = await Promise.all(tables.map((v) => this.getColumns(v).then((columns) => ({
                catalog: null,
                database: this.settings.database,
                tableName: v,
                columns: columns.map((v) => this.toColumnFromRawField(v)),
            }))));
        }
        catch (e) {
            logger.error(e);
            throw e;
        }
        finally {
            this.disconnect();
            if (sshConnection) {
                sshConnection.shutdown();
            }
        }
        return schema;
    }
    toColumnFromRawField(field) {
        return {
            columnName: field.field,
            description: `${field.field}(Type: ${field.type}, Null: ${field.null}, Default: ${field.default})`,
        };
    }
}
exports.default = AbstractClient;
//# sourceMappingURL=AbstractClient.js.map