"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const bigquery_1 = require("@google-cloud/bigquery");
const log4js_1 = __importDefault(require("log4js"));
const AbstractClient_1 = __importDefault(require("./AbstractClient"));
const logger = log4js_1.default.getLogger();
class BigqueryClient extends AbstractClient_1.default {
    constructor(settings) {
        super(settings);
        this.connection = null;
    }
    get DefaultPort() {
        return 0;
    }
    get DefaultHost() {
        return '';
    }
    get DefaultUser() {
        return '';
    }
    connect() {
        var _a, _b;
        this.connection = new bigquery_1.BigQuery({
            keyFile: (_a = this.settings.keyFile) !== null && _a !== void 0 ? _a : undefined,
            projectId: (_b = this.settings.projectId) !== null && _b !== void 0 ? _b : undefined,
        });
        return true;
    }
    disconnect() {
        this.connection = null;
    }
    async getTables() {
        const ds = this.connection.dataset(this.settings.database);
        const [tables] = await ds.getTables();
        return tables.map((t) => t.id).filter((t) => !!t);
    }
    async getColumns(tableName) {
        try {
            const [meta] = await this.connection.dataset(this.settings.database)
                .table(tableName)
                .getMetadata();
            return meta.schema.fields.map((f) => ({
                field: f.name,
                type: f.type,
                null: f.mode === 'NULLABLE' ? 'Yes' : 'No',
            }));
        }
        catch (e) {
            logger.debug(`Failed to get columns: ${tableName}`);
            logger.error(e);
            throw e;
        }
    }
}
exports.default = BigqueryClient;
//# sourceMappingURL=BigqueryClient.js.map