"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const AbstractClient_1 = __importDefault(require("./AbstractClient"));
// eslint-disable-next-line @typescript-eslint/no-var-requires
const mysql = require('mysql2');
class MysqlClient extends AbstractClient_1.default {
    constructor(settings) {
        super(settings);
        this.connection = null;
    }
    get DefaultPort() {
        return 3306;
    }
    get DefaultHost() {
        return '127.0.0.1';
    }
    get DefaultUser() {
        return 'root';
    }
    async connect() {
        this.connection = mysql.createConnection({
            host: this.settings.host || this.DefaultHost,
            password: this.settings.password || '',
            user: this.settings.user || this.DefaultUser,
            port: this.settings.port || this.DefaultPort,
            database: this.settings.database || '',
        });
        return true;
    }
    disconnect() {
        if (this.connection) {
            this.connection.end();
        }
        this.connection = null;
    }
    getTables() {
        const sql = `
      SELECT table_name 
      FROM information_schema.tables
      WHERE table_schema = '${this.settings.database}'
    `;
        return new Promise((resolve, reject) => {
            if (!this.connection) {
                reject(new Error("Don't have database connection."));
                return;
            }
            this.connection.query(sql, (err, results) => {
                if (err) {
                    reject(new Error(err.message));
                    return;
                }
                const tables = results.map((v) => v['table_name'] || v['TABLE_NAME']);
                resolve(tables);
            });
        });
    }
    getColumns(tableName) {
        const sql = `SHOW FULL FIELDS FROM ${tableName}`;
        return new Promise((resolve, reject) => {
            if (!this.connection) {
                reject(new Error("Don't have database connection."));
                return;
            }
            this.connection.query(sql, (err, results) => {
                if (err) {
                    reject(new Error(err.message));
                    return;
                }
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                const columns = results.map((v) => ({
                    field: v.Field,
                    type: v.Type,
                    null: v.Null,
                    default: v.Default,
                    comment: v.Comment,
                }));
                resolve(columns);
            });
        });
    }
}
exports.default = MysqlClient;
//# sourceMappingURL=MysqlClient.js.map