import { Database } from 'sqlite3';
import { Connection } from '../SettingStore';
import AbstractClient, { RawField } from './AbstractClient';
export declare class RequireSqlite3Error extends Error {
    constructor(message: string);
}
export default class Sqlite3Client extends AbstractClient {
    connection: Database | null;
    get DefaultPort(): number;
    get DefaultHost(): string;
    get DefaultUser(): string;
    constructor(settings: Connection);
    connect(): boolean;
    disconnect(): void;
    getTables(): Promise<string[]>;
    getColumns(tableName: string): Promise<RawField[]>;
}
