"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const MysqlClient_1 = __importDefault(require("./MysqlClient"));
const PostgresClient_1 = __importDefault(require("./PostgresClient"));
const Sqlite3Client_1 = __importDefault(require("./Sqlite3Client"));
const BigqueryClient_1 = __importDefault(require("./BigqueryClient"));
function getDatabaseClient(settings) {
    switch (settings.adapter) {
        case 'mysql':
            return new MysqlClient_1.default(settings);
        case 'postgres':
            return new PostgresClient_1.default(settings);
        case 'postgresql':
            return new PostgresClient_1.default(settings);
        case 'sqlite3':
            return new Sqlite3Client_1.default(settings);
        case 'bigquery':
            return new BigqueryClient_1.default(settings);
        default:
            throw new Error(`not support ${settings.adapter}`);
    }
}
exports.default = getDatabaseClient;
//# sourceMappingURL=getDatabaseClient.js.map