"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const os = __importStar(require("os"));
const log4js_1 = __importDefault(require("log4js"));
const MAX_LOG_SIZE = 1024 * 1024;
const MAX_LOG_BACKUPS = 10;
const LOG_FILE_PATH = path.join(os.tmpdir(), 'sql-language-server.log');
function initializeLogging(debug = false) {
    log4js_1.default.configure({
        appenders: {
            server: {
                type: 'file',
                filename: LOG_FILE_PATH,
                axLogSize: MAX_LOG_SIZE,
                ackups: MAX_LOG_BACKUPS,
            },
        },
        // TODO: Should accept level
        categories: {
            default: { appenders: ['server'], level: debug ? 'debug' : 'debug' },
        },
    });
    const logger = log4js_1.default.getLogger();
    process.on('uncaughtException', (e) => logger.error('uncaughtException', e));
    process.on('unhandledRejection', (e) => logger.error('unhandledRejection', e));
    return logger;
}
exports.default = initializeLogging;
//# sourceMappingURL=initializeLogging.js.map