"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadConfig = exports.convertToConfig = void 0;
const path_1 = require("path");
const yaml = __importStar(require("js-yaml"));
const ajv_1 = __importDefault(require("ajv"));
const rules_1 = require("../rules");
const schema_conf_1 = __importDefault(require("../../schema.conf"));
const utils_1 = require("./utils");
const configFiles = [
    { name: '.sqlintrc.json' },
    { name: '.sqlintrc.yaml' },
    { name: '.sqlintrc.yml' },
];
const defaultConfig = {
    rules: {
        'align-column-to-the-first': { level: rules_1.ErrorLevel.Error },
        'column-new-line': { level: rules_1.ErrorLevel.Error },
        'linebreak-after-clause-keyword': { level: rules_1.ErrorLevel.Error },
        'reserved-word-case': { level: rules_1.ErrorLevel.Error, option: 'upper' },
        'space-surrounding-operators': { level: rules_1.ErrorLevel.Error },
        'where-clause-new-line': { level: rules_1.ErrorLevel.Error },
        'align-where-clause-to-the-first': { level: rules_1.ErrorLevel.Error },
        'require-as-to-rename-column': { level: rules_1.ErrorLevel.Error },
    },
};
function formatErrors(errors) {
    return errors
        .map((error) => {
        if (error.keyword === 'additionalProperties') {
            return `Unexpected property "${error.data.invalidProp}"`;
        }
    })
        .map((message) => `\t- ${message}.\n`)
        .join('');
}
function validateSchema(config) {
    const ajv = new ajv_1.default({
        verbose: true,
        schemaId: 'auto',
        missingRefs: 'ignore',
    });
    const validate = ajv.compile(schema_conf_1.default);
    if (!validate(config)) {
        throw new Error(`SQLint configuration is invalid:\n${formatErrors(validate.errors || [])}`);
    }
    return true;
}
function convertToConfig(rawConfig) {
    return Object.entries(rawConfig.rules).reduce((p, c) => {
        let level = 0;
        let option = null;
        const getLevel = (v) => {
            if (typeof v === 'number') {
                return v;
            }
            if (typeof v === 'string') {
                switch (v) {
                    case 'error':
                        return 2;
                    case 'warning':
                        return 1;
                    case 'off':
                        return 0;
                    default:
                        throw new Error(`unknown error type: ${c[1]}`);
                }
            }
            return 0;
        };
        if (Array.isArray(c[1])) {
            level = getLevel(c[1][0]);
            option = c[1][1];
        }
        else {
            level = getLevel(c[1]);
        }
        p.rules[c[0]] = { level, option };
        return p;
    }, { rules: {} });
}
exports.convertToConfig = convertToConfig;
function loadConfig(directoryOrFile) {
    let filePath = '';
    if ((0, utils_1.fileExists)(directoryOrFile)) {
        filePath = directoryOrFile;
    }
    else if ((0, utils_1.directoryExists)(directoryOrFile)) {
        const file = configFiles.find((v) => (0, utils_1.fileExists)(`${directoryOrFile}/${v.name}`));
        if (file)
            filePath = `${directoryOrFile}/${file.name}`;
    }
    if (!filePath) {
        // try to lookup personal config file
        const file = configFiles.find((v) => (0, utils_1.fileExists)(`${process.env.HOME}/.config/sql-language-server/${v.name}`));
        if (file)
            filePath = `${process.env.HOME}/.config/sql-language-server/${file.name}`;
    }
    if (!filePath) {
        return defaultConfig;
    }
    const fileContent = (0, utils_1.readFile)(filePath);
    let config;
    switch ((0, path_1.extname)(filePath)) {
        case '.json':
            config = JSON.parse(fileContent);
            break;
        case '.yaml':
        case '.yml':
            config = yaml.safeLoad(fileContent);
            break;
        default:
            config = JSON.parse(fileContent);
    }
    validateSchema(config);
    return convertToConfig(config);
}
exports.loadConfig = loadConfig;
//# sourceMappingURL=loadConfig.js.map