"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeFile = exports.readFile = exports.getFileList = exports.directoryExists = exports.fileExists = void 0;
const fs = __importStar(require("fs"));
function fileExists(path) {
    try {
        return fs.statSync(path).isFile();
    }
    catch (error) {
        if (error && error.code === 'ENOENT') {
            return false;
        }
        throw error;
    }
}
exports.fileExists = fileExists;
function directoryExists(path) {
    try {
        return fs.statSync(path).isDirectory();
    }
    catch (error) {
        if (error && error.code === 'ENOENT') {
            return false;
        }
        throw error;
    }
}
exports.directoryExists = directoryExists;
function readdirSafeSync(path) {
    try {
        return fs.readdirSync(path, { withFileTypes: true });
    }
    catch (error) {
        if (error && error.code !== 'ENOENT') {
            throw error;
        }
        return [];
    }
}
function getFileList(path) {
    if (!directoryExists(path)) {
        return fileExists(path) ? [path] : [];
    }
    return readdirSafeSync(path)
        .map((v) => {
        if (v.isDirectory()) {
            const files = getFileList(`${path}/${v.name}`);
            return files;
        }
        return [`${path}/${v.name}`];
    })
        .flat()
        .filter((v) => {
        return v.match(/.sql$/);
    });
}
exports.getFileList = getFileList;
function readFile(filePath) {
    return fs.readFileSync(filePath, 'utf8').replace(/^\ufeff/u, '');
}
exports.readFile = readFile;
function writeFile(filePath, content) {
    return fs.writeFileSync(filePath, content, 'utf8');
}
exports.writeFile = writeFile;
//# sourceMappingURL=utils.js.map