export declare type FixDescription = {
    range: {
        startOffset: number;
        endOffset: number;
    };
    text: string;
};
export declare type Fixer = {
    insertText(offset: number, text: string): FixDescription;
    replaceText(startOffset: number, endOffset: number, text: string): FixDescription;
};
export declare function createFixer(): Fixer;
export declare function applyFixes(sql: string, fixes: FixDescription | FixDescription[]): string;
