"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyFixes = exports.createFixer = void 0;
function createFixer() {
    return {
        insertText(offset, text) {
            return {
                range: { startOffset: offset, endOffset: offset },
                text: text,
            };
        },
        replaceText(startOffset, endOffset, text) {
            return {
                range: { startOffset, endOffset },
                text,
            };
        },
    };
}
exports.createFixer = createFixer;
function applyFixes(sql, fixes) {
    const _fixes = Array.isArray(fixes) ? fixes : [fixes];
    if (_fixes.length === 0) {
        return sql;
    }
    const sortedFixes = _fixes
        .concat([])
        .sort((a, b) => b.range.startOffset - a.range.startOffset ||
        b.range.endOffset - a.range.endOffset);
    return sortedFixes.reduce((p, c) => {
        const before = p.slice(0, c.range.startOffset);
        const after = p.slice(c.range.endOffset);
        return before + c.text + after;
    }, sql);
}
exports.applyFixes = applyFixes;
//# sourceMappingURL=fixer.js.map