"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.alignWhereClauseToTheFirst = void 0;
const META = {
    name: 'align-where-clause-to-the-first',
    type: 'select',
};
exports.alignWhereClauseToTheFirst = {
    meta: META,
    create: (context) => {
        if (!context.node.where) {
            return;
        }
        const where = context.node.where;
        function findInvalidClauses(expr, invalidClauses = []) {
            if (['AND', 'OR', 'and', 'or'].includes(expr.operator)) {
                if (expr.left.location.start.line !== expr.right.location.start.line &&
                    where.expression.location.start.column !==
                        expr.right.location.start.column &&
                    expr.right.type === 'binary_expr') {
                    invalidClauses.push(expr.right);
                }
            }
            if (expr.left.type === 'binary_expr') {
                return findInvalidClauses(expr.left, invalidClauses);
            }
            if (expr.right.type === 'binary_expr') {
                return findInvalidClauses(expr.right, invalidClauses);
            }
            return invalidClauses;
        }
        const invalidClauses = where.expression.type === 'binary_expr'
            ? findInvalidClauses(where.expression)
            : [];
        if (invalidClauses.length === 0) {
            return;
        }
        return invalidClauses.map((v) => {
            return {
                message: 'Where clauses must align to the first clause',
                location: v.location,
                fix: (fixer) => {
                    const spaceNumber = where.expression.location.start.column - v.location.start.column;
                    if (spaceNumber > 0) {
                        return fixer.insertText(v.location.start.offset, ''.padStart(spaceNumber, ' '));
                    }
                    else {
                        return fixer.replaceText(v.location.start.offset + spaceNumber, v.location.start.offset, '');
                    }
                },
            };
        });
    },
};
//# sourceMappingURL=alignWhereClauseToTheFirst.js.map