import { NodeRange, Node, BaseNode } from '@joe-re/sql-parser';
import { Fixer, FixDescription } from '../fixer';
export declare type Diagnostic = {
    message: string;
    location: NodeRange;
    rulename: string;
    errorLevel: ErrorLevel;
    fix: FixDescription | FixDescription[];
};
export declare type RuleResult = {
    message: string;
    location: NodeRange;
    fix?: (fixer: Fixer) => FixDescription | FixDescription[];
};
export declare type Rule<N extends BaseNode, RC = RuleConfig> = {
    meta: {
        name: string;
        type: string;
    };
    create: (c: Context<N, RC>) => RuleResult | RuleResult[] | undefined;
};
export declare enum ErrorLevel {
    Off = 0,
    Warn = 1,
    Error = 2
}
export declare type Config = {
    rules: {
        [key: string]: RuleConfig;
    };
};
export declare type RuleConfig<T = unknown> = {
    level: ErrorLevel;
    option?: T;
};
declare type OffsetRange = {
    start: {
        offset: number;
    };
    end: {
        offset: number;
    };
};
export declare type Context<N = Node, C = RuleConfig> = {
    getSQL(range?: OffsetRange, option?: {
        before?: number;
        after?: number;
    }): string;
    getAfterSQL(range: OffsetRange): string;
    getBeforeSQL(range: OffsetRange): string;
    node: N;
    config: C;
};
export declare function execute(sql: string, config: Config): Diagnostic[];
export declare function createContext(sql: string, node: Node, ruleConfig: RuleConfig): Context;
export {};
